#include <iostream>
#include <SDL_image.h>
#include <libxml/parser.h>
#include "polygon.h"
#include "TaskManager.h"
using namespace std;


#define redMask   0x00ff0000
#define greenMask 0x0000ff00
#define blueMask  0x000000ff
#define alphaMask 0
#define width     128
#define height    128
#define bpp       32


extern int get_fbdev_addr();

extern int decode(char *cont, FILE *outfile);

#define LOAD_TEXTURE_SIZE 128*128*3

void Polygon::set_data(char *file_name)
{
	xmlDocPtr doc;
	xmlNodePtr cur;
	Polygon *tmp;

	doc = xmlParseFile(file_name);

	cur = xmlDocGetRootElement(doc);

	xmlStrcmp(cur->name,(xmlChar*)"OBJECT-3D");

	tmp = this;

	for (cur=cur->children; cur; cur=cur->next) {
		if (!xmlStrcmp(cur->name,(xmlChar*)"surface")) {
			tmp->create_data(cur);
			if(cur->next->next) {
				tmp->add_next();
				tmp = tmp->next;
			}
		}
	}
	xmlFreeDoc(doc);
}

void Polygon::create_data(xmlNodePtr cur)
{
	size = atoi((char *)xmlGetProp(cur,(xmlChar *)"size"));
	name = (char *)xmlGetProp(cur,(xmlChar *)"name");
	parent_name = (char *)xmlGetProp(cur,(xmlChar *)"parent");
	next = NULL;

	data = new float[size*3*3];

	get_data(cur->children);
}

void Polygon::add_next()
{
	Polygon *p;
	p = new Polygon;

	next = p;
}


void Polygon::get_data(xmlNodePtr cur)
{
	char *cont;
	HTaskPtr task_load_texture = NULL;
	unsigned int fbdev_addr;
	for(;cur;cur=cur->next) {
		if(!xmlStrcmp(cur->name,(xmlChar*)"image")) {
			char image_name[20] = "/tmp/image_XXXXXX";
			int fd = mkstemp(image_name);
			FILE *outfile = fdopen(fd, "wb");
			if(NULL == outfile) {
				cout << "error open file\n";
			}
			cont = (char *)xmlNodeGetContent(cur);
			decode(cont, outfile);
			fclose(outfile);

			texture_image = IMG_Load(image_name);
			//texture_image = SDL_LoadBMP(image_name);
			if(unlink(image_name)) {
				cout << "unlink error\n";
			}
			
		}
	}

	//void *_pixels = new Uint32[width*height*32/8];
	void *_pixels;
	posix_memalign((void**)&_pixels, 16, 3*128*128);
	
	memcpy(_pixels, texture_image->pixels, 3*128*128);

	// screen を返すけど、いつか free して
	//screen = SDL_CreateRGBSurfaceFrom(_pixels, width, height, 32,
	//width*4, redMask, greenMask,
	//			  blueMask,alphaMask);

	fbdev_addr = get_fbdev_addr();
	task_load_texture
	    = manager->create_task(0,LOAD_TEXTURE_SIZE, 
				   //(unsigned int)texture_image->pixels 
				   (unsigned int)_pixels ,fbdev_addr,NULL); 
	task_load_texture->set_cpu(CPU_SPE);
	task_load_texture->spawn();
}
	
