#include "SDL.h"
#include "polygon.h"
#include "viewer.h"
#include "SpanPack.h"

#define YTOP(y) (y & ~(TEXTURE_SPLIT_PIXEL-1))
#define YOFF(y) (y & (TEXTURE_SPLIT_PIXEL-1))

#define FRAMEBUFFER_X Viewer::width
#define FRAMEBUFFER_Y Viewer::height
#define IMG_MAX_X Viewer::width

int *linebuf;
float *zRow;

static char *
get_pixel(int tx, int ty, void *texture_image)
{
    return (char*)texture_image+(3*((128)*ty+tx));
}

static void
linebuf_init(int rgb)
{
    int y = TEXTURE_SPLIT_PIXEL;
    int x = Viewer::width;

    linebuf = (int*)malloc(sizeof(int)*x*y);
    memset(linebuf, rgb, sizeof(int)*x*y);
}

static void
zRow_init(void)
{
    int y = TEXTURE_SPLIT_PIXEL;
    int x = Viewer::width;
    float z = 65535.0f;
    int length = x*y;

    zRow = (float*)malloc(sizeof(float)*length);

    for (int i = 0; i < length; i++) {
	zRow[i] = z;
    }
}

static Uint32
get_rgb(int tx, int ty, SDL_Surface *texture_image)
{
    Uint8 red, green, blue, alpha;

    if (tx<0) tx = 0;
    if (texture_image->w-1< tx) tx = texture_image->w-1 ;
    if (ty<0) ty = 0;
    if (texture_image->h-1< ty) ty = texture_image->h-1 ;

    char *p = get_pixel(tx,ty,texture_image->pixels);
    blue  = (Uint8) p[0];
    green = (Uint8) p[1];
    red   = (Uint8) p[2];
    alpha = 255;

    
    return (red & 0xff) * 0x10000 + (green & 0xff) * 0x100 
	+ (blue & 0xff) + (alpha << 24);
}

static void
write_buffer(unsigned int fbdev_addr, int y)
{
    int end_y;
    int start_y;

    // 画面上の領域に描き込まないように
    // ・・・なんか変だな。
    // とりあえず if 文どうにかしようぜ俺
    if (y < 0) {
	if (y + TEXTURE_SPLIT_PIXEL < 0) {
            return;
        } else {
            start_y = -y;
	}
    } else {
        start_y = 0;
    }

    // 画面下の領域に書き込まないように
    // ってことは start_y も必要か。
    end_y = FRAMEBUFFER_Y - y + TEXTURE_SPLIT_PIXEL;
    end_y = (end_y < 0) ? TEXTURE_SPLIT_PIXEL + end_y : TEXTURE_SPLIT_PIXEL;
    
    // 本家 write_pixel では、 y を y = height -y にしている。
    // こうすると、画面的に、 y++ すると 上に進むようになる。
    // でも、framebuffer は上から下で y++ になるから、混乱しそう
    for (int i = start_y; i < end_y; i++) {
	memcpy((void*)(fbdev_addr + (4*FRAMEBUFFER_X*(y+i))),
	       &linebuf[i*IMG_MAX_X], sizeof(int)*IMG_MAX_X);
    }
}


int
span_pack_draw(SpanPack *sp, unsigned int fbdev_addr)
{
    SpanPack *spack = sp;
    SpanPack *next_spack;
    Span *span;

    zRow = NULL;

    int render_y = 0;
    int linebuf_rgb;

    render_y = sp->span[0].y;
    render_y = YTOP(render_y);
    //render_y += Viewer::height/2;

    if (sp->info.size < 0) {
	linebuf_rgb = 0xffffff;
	linebuf_init(linebuf_rgb);
	goto WRITE;
    } else {
	linebuf_rgb = 0x000000;
	linebuf_init(linebuf_rgb);
    }
    zRow_init();

    do {
	// 次の pack があれば
	// 現在の pack の処理をしている間に
	// DMA でロードしておく。入るかな・・・
	if (spack->next != NULL) {
	    // Cell ではこんな感じ？
	    // dma_load(next_spack, spack->next, sizeof(SpanPack));
	    next_spack = spack->next;
	} else {
	    next_spack = NULL;
	}

	for (int n = 0; n < spack->info.size; n++) {
	    span = &spack->span[n];

	    //int x = span->x + Viewer::width/2;
	    //int y = span->y + Viewer::height/2;
	    int x = span->x;
	    int y = span->y;
	    float z = span->start_z;
	    int end = span->length_x;
	    float zpos = span->end_z;
	    float tex1 = span->tex_x1;
	    float tex2 = span->tex_x2;
	    float tey1 = span->tex_y1;
	    float tey2 = span->tex_y2;
	    Uint32 rgb;
	    int tex_xpos;
	    int tex_ypos;
	    int tex_zpos;
	    float tex_x, tex_y, tex_z;

	    if (end == 1) {
		tex_xpos = (int)((span->tex_height-1) * tex1);
		tex_ypos = (int)((span->tex_width-1) * tey1);
		tex_zpos = (int)z;

		if (zpos < zRow[x + (Viewer::width * YOFF(y))]) {
		    rgb = get_rgb(tex_xpos, tex_ypos, Polygon::texture_image);
		    zRow[x + (Viewer::width * YOFF(y))] = zpos;
		    linebuf[x + (Viewer::width * YOFF(y))] = rgb;
		}
	    } else {
		for (int j = 0; j < end; j++) {
		    tex_x = tex1*(end-1-j)/(end-1) + tex2*j/(end-1);
		    tex_y = tey1*(end-1-j)/(end-1) + tey2*j/(end-1);
		    tex_z = z*(end-1-j)/(end-1) + zpos*j/(end-1);
		    if (tex_x > 1) tex_x = 1;
		    if (tex_y > 1) tex_y = 1;
		    tex_xpos = (int)((span->tex_height-1) * tex_x);
		    tex_ypos = (int)((span->tex_width-1) * tex_y);

		    if (tex_z < zRow[x + j + (Viewer::width * YOFF(y))]) {
			rgb = get_rgb(tex_xpos, tex_ypos, Polygon::texture_image);
			zRow[x + j + (Viewer::width * YOFF(y))] = tex_z;
			linebuf[x + j + (Viewer::width * YOFF(y))] = rgb;
		    }
		}
	    }
	}

	// Cell ではこんな感じ？
	// dma_wait(SPAN_PACK_LOAD);
	spack = next_spack;
    } while (spack);

WRITE:
    write_buffer(fbdev_addr, render_y);

    if (zRow != NULL) free(zRow);
    free(linebuf);

    return 0;
}
