#ifndef INCLUDED_TASK_SPU_DRAW
#define INCLUDED_TASK_SPU_DRAW

#ifndef INCLUDED_SCHED_TASK
#  include "SchedTask.h"
#endif

//#define IMG_MAX_X 1920
//#define IMG_MAX_X 640

typedef int8_t          Sint8;
typedef uint8_t         Uint8;
typedef int16_t         Sint16;
typedef uint16_t        Uint16;
typedef int32_t         Sint32;
typedef uint32_t        Uint32;
typedef unsigned short  GLushort;

class SpuDraw : public SchedTask {
public:
    SpuDraw(TaskListPtr _tlist, TaskPtr _task,
	    void* _rbuf, void* _wbuf, DmaManager* _con)
	:SchedTask(_tlist, _task, _rbuf, _wbuf, _con) {}

    ~SpuDraw(void);

    int *linebuf;
    float *zRow;
    unsigned int dma_tags;

    int run(void *readbuf, void *writebuf);
    void write(void);

private:
    void zRow_init(void);
    void linebuf_init(int rgb = 0xffffff);
    void writebuffer(unsigned int fbdev_addr, int y);

    char* get_pixel(int tx, int ty, void *texture_image);
    Uint32 get_rgb(int tx, int ty, void *texture);
};

#endif
