#include <libxml/parser.h>

#ifndef INCLUDED_POLYGON
#define INCLUDED_POLYGON

#ifndef INCLUDED_VIEWER
#include "viewer.h"
#endif

#ifndef INCLUDED_SCENE_GRAPH_PACK
#include "scene_graph_pack.h"
#endif

#ifndef INCLUDED_POLYGON_PACK
#include "polygon_pack.h"
#endif


#ifndef INCLUDED_SPAN_PACK
#include "SpanPack.h"
#endif


class Polygon{
 public:
  int size;
  char *name;
  char *parent_name;
  float *data;        //"vertex" and "normal" and "texture"
  float xyz[4];          // position
  float angle[4];        // angle
  float c_xyz[4];        // center of rotation
  float matrix[16];
  float *anim;
  int frame;         // anime frame num
  //int *texture;         // pointer of this surface's texture
  static SDL_Surface* texture_image;      // pointer of this surface's texture
  //SDL_Surface *screen;
  //char image_name[20];     // texture image name
  Polygon *next;
  Polygon *child;
  Polygon *parent;
  Polygon *brother;
  Viewer *viewer;
  //SceneGraphPack *sgp;

  Polygon();
  void tree_check();
  void print_member();
  void parameter_change(char *name, float x, float y, float z, float ax, float ay, float az);
  //void load_texture(char *image_name);
  void draw(float *stack);
  void draw(SceneGraphPack *sgp);
  void draw(PolygonPack *pp);
  void draw(SpanPack *sp);
  void draw(SpanPackList *sp);
  void delete_data();
  void tree_draw();
  void get_data(xmlNodePtr cur);
  void pickup_coordinate(char *cont);
  void pickup_normal(char *cont);
  void pickup_model(char *cont);
  void pickup_texture(char *cont);
  Uint32 get_rgb(int tx, int ty);
  //void sgp_update();
  //void sgp_draw();
  //void create_scene_graph_pack();
  void create_data(xmlNodePtr doc);
  void set_data(char *file_name);
  void add_next();
  void create_tree();

  /* added by kent. */
  Polygon(xmlNodePtr);
  Polygon *addChild(Polygon *);
  Polygon *children;
  Polygon *lastChild;
  Polygon *searchPolygon(char *);
  static Polygon *createFromXMLfile(char *);
};
#endif
