#include <iostream>
#include "viewer.h"
#include "Func.h"
#include "polygon.h"
#include "demonstration.h"
#include "pad.h"
#include "TaskManager.h"
using namespace std;

#include "error.h"

// あとで直す
// 引数からできるように
#define SPENUM 6

/* prototype */
void init(int argc, char *argc[]);
int sdl_init(void*, void*);
int run_init(void*, void*);
int finish(void*, void*);

extern void task_initialize();

TaskManager *manager;
Viewer *screen;

struct init_arg {
    int bpp;
    int w;
    int h;
};

struct init_arg *initArg;


// クラス関数は単純にポインタで扱えないので
// 現状は間接的に呼ぶことに
int run_loop(void *r, void *w)
{
    __debug("[%s] start\n", __FUNCTION__);
    screen->run_loop();
    __debug("[%s] end\n", __FUNCTION__);
    return 0;
}

int run_draw(void *r, void *w)
{
    __debug("[%s] start\n", __FUNCTION__);
    screen->run_draw();
    __debug("[%s] end\n", __FUNCTION__);
    return 0;
}

int run_finish(void *r, void *w)
{
    __debug("[%s]\n", __FUNCTION__);
    screen->run_finish();
    return 0;
}

int finish(void *w, void *r)
{
    __debug("[%s]\n", __FUNCTION__);
    delete screen;
    delete manager;
    return 0;
}

int
main(int argc, char *argv[])
{
    manager = new TaskManager(SPENUM);
    manager->init();

    task_initialize();

    manager->set_func(FINISH,            finish);
    manager->set_func(VIEWER_RUN_LOOP,   run_loop);
    manager->set_func(VIEWER_RUN_DRAW,   run_draw);
    manager->set_func(VIEWER_RUN_FINISH, run_finish);

    init(argc, argv);
    
    manager->run();

    finish(NULL, NULL);
    return 0;
}

void
init(int argc, char *argv[])
{
    int bpp    = 0;
    int width  = 640;
    int height = 480;
    char *xml  = "cube.xml";

    for(int i = 1; argv[i]; ++i)
    {
	if (strcmp(argv[i], "-bpp") == 0) {
	    bpp = atoi(argv[++i]);
	}
	if (strcmp(argv[i], "-width") == 0) {
	    width = atoi(argv[++i]);
	} 
	if (strcmp(argv[i], "-height") == 0) {
	    height = atoi(argv[++i]);
	}
	if (strcmp(argv[i], "-xml") == 0) {
	    xml = argv[++i];
	}
    }

    //screen = new Viewer(bpp, width, height);
    screen = new Viewer(bpp, width, height, SPENUM);

    screen->sdl_init();
    screen->run_init(xml);
}

