#include <iostream>
#include <SDL.h>
#include <SDL_opengl.h>
#include <math.h>
#include <unistd.h>
#include "polygon.h"
#include "viewer.h"
#include "sys.h"
#include "spu_span.h"
using namespace std;

#define redMask   0x00ff0000
#define greenMask 0x0000ff00
#define blueMask  0x000000ff
#define alphaMask 0

extern int create_sgp(Polygon *sg, SceneGraphPack *sgp);
//extern int update_sgp(SceneGraphPack *sgp, SceneGraphPack *_sgp);
//extern int create_pp(SceneGraphPack *sgp, PolygonPack *pp);

Viewer::Viewer(int b, int w, int h)
{
    bpp = b;
    width = w;
    height = h;
}


void Viewer::sdl_init()
{
    if( SDL_Init( SDL_INIT_VIDEO ) < 0 )
    {
	fprintf(stderr,"Couldn't initialize SDL: %s\n",SDL_GetError());
	exit( 1 );
    }
    screen = SDL_SetVideoMode( width, height, bpp, SDL_HWSURFACE );
}


int Viewer::get_ticks()
{
    int time;
    time = SDL_GetTicks();
    return time;
}

bool Viewer::quit_check()
{
    bool quit = false;
    SDL_Event event;
    while(SDL_PollEvent(&event))
    {
	if(event.type==SDL_QUIT)
	{
	    quit = true;
	    return quit;
	}
    }
    return quit;
}

void Viewer::quit()
{
    SDL_Quit();
}


void Viewer::swap_buffers()
{
    SDL_GL_SwapBuffers();
}


void
Viewer::write_pixel(int x, int y,float z, Uint32 rgb)
{
    SDL_PixelFormat *pf;
    pf = screen->format;
    x += width/2;
    y += height/2;

    static int diffz,diffz1;

    diffz1 = diffz;
    diffz = (zRow[x][y]>z);
    if (z < zRow[x][y]) { 
	if (x < width && x > 0 && y > 0 && y < height) {
	    zRow[x][y] = z;
	    y = height - y;
	    pixels[width*y + x] = rgb;
	}
    }
}

void
Viewer::write_line(float x1, float y1, float x2, float y2, Uint32 rgb)
{
    if (x1 > x2) {
	float x=0;
	float y=0;
	x=x1;
	y=y1;
	x1 = x2;
	y1 = y2;
	x2 = x;
	y2 = y;
    }

    float s = y1;

    if ((int)x1 == (int)x2) {
	if (y1 > y2) {
	    float y=0;
	    y = y1;
	    y1 = y2;
	    y2 = y;
	}

	for (float i=y1; i<y2; i++) {
	    //write_pixel((int)x1,(int)i);
	    write_pixel((int)x1,(int)i,0,rgb);
	}
    } else {
	float t = (y2 - y1)/(x2 - x1);
	if (t < -1) {
	    float f = 0;
	    for (float i=x1; i<x2; i++) {
		for (float a=(int)t; a<0; a++) {
		    write_pixel((int)i,(int)s,0,rgb);
		    s--;
		}

		f += t-(int)t;

		if (f <= -1) {
		    write_pixel((int)i,(int)s,0,rgb);
		    f = 0;
		    s--;
		}
	    }
	} else if (t <= 1) {
	    for(float i=x1; i<x2; i++) {
		//write_pixel((int)i,(int)s);
		write_pixel((int)i,(int)s,0,rgb);
		s += t;
	    }
	} else {
	    float f = 0;
	    for (float i=x1; i<x2; i++) {
		for (float a=0; a<(int)t; a++) {
		    write_pixel((int)i,(int)s,0,rgb);
		    s++;
		}

		f += t-(int)t;

		if (f >= 1) {
		    write_pixel((int)i,(int)s,0,rgb);
		    f = 0;
		    s++;
		}
	    }
	}
    }
}

void Viewer::write_triangle(float x1, float y1, float x2, float y2, float x3, float y3, Uint32 rgb)
{
    write_line(x1,y1,x2,y2,rgb);
    write_line(x2,y2,x3,y3,rgb);
    write_line(x3,y3,x1,y1,rgb);
}

void Viewer::clean_pixels()
{
    for(int i=0; i<width*height; i++)
    {
	pixels[i] = 0x00;
    }
}

void Viewer::graph_line()
{
    int xl = width*height/2;
    int yl = width/2;
    for(int i=0; i<width; i++)
    {
	for(int t=0; t<height; t+=20)
	{
	    pixels[width*t+i] = 0x5a;
	}
	pixels[xl +i] = 0xff;
    }
    for(int i=0; i<height; i++)
    {
	for(int t=0; t<width; t+=20)
	{
	    pixels[i*width+t] = 0x5a;
	}
	pixels[i*width+yl] = 0xff;
    }
}


struct run_arg_t {
  int start_time;
  int this_time;
  int frames;
  SDL_Surface *bitmap;
  SDL_PixelFormat *pf;
  Uint32 background;
  Polygon *p;
  SceneGraphPack *sgp;
  PolygonPack *pp;
  //SPANPACKLIST *spl;
  //SPANPACK *sp;
  //SPANPACK sps[135];
  //SPAN s1[250];
  //SPAN s2[250];
  //SPAN s3[250];
  //SPAN s4[250];
  //SPAN s5[250];
  //SPAN s6[250];
  SPUSPANLIST *ssl;
  //SPLSSL *splssl;
};

struct run_arg_t *arg;

void
Viewer::run_init()
{
    arg = new run_arg_t;
    HTaskPtr task;
    int fd;

    arg->start_time = get_ticks();
    arg->this_time  = 0;
    arg->frames     = 0;

    arg->pf         = screen->format;
    arg->background = SDL_MapRGB(screen->format, 0x00, 0x00, 0x00);
    arg->p          = new Polygon;
    arg->p->set_data("cube.xml");
    arg->p->viewer  = this;
    arg->sgp        = new SceneGraphPack;
    //create_sgp(arg->p, arg->sgp);
    arg->pp         = new PolygonPack;
    //arg->sp         = new SPANPACK;
    //arg->spl        = new SPANPACKLIST;
    //arg->spl->size = 60;
    //cout << sizeof(SPANPACKLIST) << endl;
    //cout << "run_init   :spl->size = " << arg->spl->size << endl;
    //arg->spl->dline = arg->sps;
    /*    
    arg->spl->dline[0].span = arg->s1;
    arg->spl->dline[1].span = arg->s2;
    arg->spl->dline[2].span = arg->s3;
    arg->spl->dline[3].span = arg->s4;
    arg->spl->dline[4].span = arg->s5;
    arg->spl->dline[5].span = arg->s6;
    cout << "run_init   :spl->dline[0].span = " << arg->spl->dline[0].span << endl;
    */
    /*
    for(int i=0; i<arg->spl->size; i++)
      {
	arg->spl->dline[i] = new SPANPACK;
      }
    */

    arg->ssl = new SPUSPANLIST;
    //arg->splssl = new SPLSSL;

    create_sgp(arg->p, arg->sgp);
    arg->sgp->ssl = arg->ssl;

    //arg->splssl->spl = arg->spl;
    //arg->splssl->ssl = arg->ssl;

    pixels = new Uint32[width*height];

    graph_line();

    arg->bitmap = SDL_CreateRGBSurfaceFrom((void *)pixels, width, height, 32,
				      width*4, redMask, greenMask,
				      blueMask, alphaMask);

    fd = manager->open("ViewerRunLoop");
    task = manager->create_task(fd, 0, 0, 0, NULL);      
    manager->spawn_task(task);
}

/*
void distribute_polygon_pack(int spu_num, PolygonPackList *ppl, PolygonPack *pp)
{
  ppl->list[0].info.size = 0;
  ppl->list[1].info.size = 0;
  ppl->list[2].info.size = 0;
  ppl->list[3].info.size = 0;
  ppl->list[4].info.size = 0;
  ppl->list[5].info.size = 0;

  for(int i=0; i<pp->info.size; i++)
    {
      int num = i%spu_num;
      int mysize = ppl->list[num].info.size;
      ppl->list[num].tri[mysize] = pp->tri[i];
      ppl->list[num].info.size++;
    }
}
*/

void
Viewer::run_loop(void)
{
    HTaskPtr task_update_sgp = NULL;
    HTaskPtr task_create_pp = NULL;
    HTaskPtr task_create_sp = NULL;
    //HTaskPtr task_spu_sp = NULL;
    HTaskPtr task_finish = NULL;
    int fd_update_sgp;
    int fd_create_pp;
    int fd_create_sp;
    //int fd_spu_sp;
    int fd_finish;

    HTaskPtr task;
    int fd;

    if (quit_check()) {
	arg->this_time = get_ticks();
	fd_finish = manager->open("ViewerRunFinish");
	task_finish = manager->create_task(fd_finish, 0, 0, 0, NULL);
	manager->spawn_task(task_finish);
	return;
    }

    clean_pixels();

    zRow_init();
    graph_line();

    fd_update_sgp = manager->open("UpdateSGP");
    fd_create_pp  = manager->open("CreatePP");
    fd_create_sp  = manager->open("CreateSP");
    //fd_spu_sp  = manager->open("SpuSP");
    fd = manager->open("ViewerRunDraw");
    task_update_sgp = manager->create_task(fd_update_sgp,
					   sizeof(SceneGraphPack),
					   (unsigned int)arg->sgp,
					   (unsigned int)arg->sgp,
					   NULL);      
    task_create_pp = manager->create_task(fd_create_pp,
					  sizeof(SceneGraphPack),
					  (unsigned int)arg->sgp,
					  (unsigned int)arg->pp,
					  NULL);
    //cout << "run_loop   :spl->size = " << arg->spl->size << endl;
    //cout << "run_loop   :spl->dline[0].span = " << arg->spl->dline[0].span << endl;
    task_create_sp = manager->create_task(fd_create_sp,
					  sizeof(PolygonPack),
					  (unsigned int)arg->pp,
					  0,
					  NULL);
    /*
    task_spu_sp = manager->create_task(fd_spu_sp,
				       sizeof(SPLSSL),
				       (unsigned int)arg->splssl,
				       (unsigned int)arg->ssl,
				       NULL);
    */    
    task = manager->create_task(fd, 0, 0, 0, NULL);

    manager->set_task_depend(task_update_sgp, task);
    manager->set_task_depend(task_create_pp, task);
    manager->set_task_depend(task_create_pp, task_create_sp);
    //manager->set_task_depend(task_create_sp, task_spu_sp);
    manager->set_task_depend(task_create_sp, task);
    //manager->set_task_depend(task_spu_sp, task);

    manager->spawn_task(task_update_sgp);
    manager->spawn_task(task_create_pp);
    manager->spawn_task(task_create_sp);
    //manager->spawn_task(task_spu_sp);
    manager->spawn_task(task);
}

void
Viewer::run_draw(void)
{
    HTaskPtr task;
    int fd;

    //arg->p->draw(arg->pp);    // test draw of PolygonPack
    //arg->p->draw(arg->sp);    // test draw of SpanPack

    for(int i=0; i<10; i++)
      {
	arg->p->draw(&arg->ssl->ss[0].spp[i]);    // test draw of SpuSpanPackList
	arg->p->draw(&arg->ssl->ss[1].spp[i]);    // test draw of SpuSpanPackList
	arg->p->draw(&arg->ssl->ss[2].spp[i]);    // test draw of SpuSpanPackList
	arg->p->draw(&arg->ssl->ss[3].spp[i]);    // test draw of SpuSpanPackList
	arg->p->draw(&arg->ssl->ss[4].spp[i]);    // test draw of SpuSpanPackList
	arg->p->draw(&arg->ssl->ss[5].spp[i]);    // test draw of SpuSpanPackList
      }
    
    SDL_BlitSurface(arg->bitmap, NULL, screen, NULL);
    SDL_UpdateRect(screen, 0, 0, 0, 0);    

    arg->frames++;

    fd = manager->open("ViewerRunLoop");
    task = manager->create_task(fd, 0, 0, 0, NULL);
    manager->spawn_task(task);
}

void
Viewer::run_finish(void)
{
    if (arg->this_time != arg->start_time) {
	cout<< (((float)arg->frames)/(arg->this_time-arg->start_time))*1000.0 << " FPS\n";
    }

    SDL_FreeSurface(arg->bitmap);
    delete [] pixels;
    arg->p->delete_data();
    delete arg->p;
    delete arg->sgp;
    delete arg->pp;
    //delete arg->spl;
    //delete arg->sp;
    quit();

    delete arg;
}

void
Viewer::zRow_init()
{
    for (int i = 0; i < width; i++) {
	for (int j = 0; j < height; j++) {
	    zRow[i][j] = 65535;
	}
    }
}
