#ifndef INCLUDED_TASK_MANAGER
#define INCLUDED_TASK_MANAGER

#include "TaskManagerImpl.h"
#include "MemList.h"
#include "HTask.h"

class Scheduler;
class MemList;

class TaskManager {
public:
    /* constructor */
    TaskManager(int num = 1); // The number of threads
    ~TaskManager();

    /* variables */
    TaskManagerImpl *m_impl;
    void (*tm_end)(TaskManager *manager);

    /* user function */
    HTaskPtr create_task(int cmd);
    HTaskPtr create_task(int cmd, memaddr r, long rs, memaddr w, long ws);
    HTaskPtr create_task_array(int id, int num_task, int num_param, int num_inData, int num_outData);

    void run();
    void *allocate(int size);
    void set_TMend(void (*endf)(TaskManager *manager));
    int get_cpuNum();
    int get_random();
    Scheduler *get_scheduler();
    MemList* createMemList(int size, int count);

    void start_profile() { m_impl->start_profile(); }
    void show_profile() { m_impl->show_profile(); }

    SchedTask *get_schedTask() {
	return m_impl->schedTaskManager;
    }

    /* functions */
    void init(int spuIdle);
    void finish();

private:
    int machineNum;
}  ;

#endif

