#ifndef INCLUDED_CPU_THREADS
#define INCLUDED_CPU_THREADS

#include <pthread.h>
#include "Threads.h"
#include "TaskManagerImpl.h"
#include "MainScheduler.h"

typedef struct cpu_arg {
    int cpuid;
    // should be syncrhonized
    MainScheduler *scheduler;
    TaskManagerImpl *manager;
} cpu_thread_arg_t;

class CpuThreads : Threads {
public:
    /* constructor */
    CpuThreads(int num = 1, int start_id = 0);
    virtual ~CpuThreads();
    static void *cpu_thread_run(void *args);

    /* functions */
    void init();
    int get_mail(int speid, int count, memaddr *ret); // BLOCKING
    int has_mail(int speid, int count, memaddr *ret); // NONBLOCK
    void send_mail(int speid, int num, memaddr *data); // BLOCKING

private:
    /* variables */
    pthread_t *threads;
    cpu_thread_arg_t *args;
    int cpu_num;
    int id_offset;
};

#endif
