#ifndef INCLUDED_LIST_DATA
#define INCLUDED_LIST_DATA

#include "base.h"
#include "types.h"

#define MAX_LIST_DMA_SIZE 8

class ListElement {
public:
    BASE_NEW_DELETE(ListElement);

    int size;
#ifdef __CERIUM_CELL__
    uint32 addr;  // Cell の仕様なんでどうしようもない...
    //     PowerPC 64bit だと動かない可能性も高いんだが...
#else
    memaddr addr;
#endif
};

typedef ListElement* ListElementPtr;

class ListData {
public:
    BASE_NEW_DELETE(ListData);

    int length; // The number of data (4)
    int size;   // Total size of data (4)
    int *bound;
    ListElement *element;

    void clear(void) {
	length = 0;
	size = 0;
    }

/*
    void print(Scheduler *s) {
	s->printf("inList length %d size %d\n",length, size);
	for(int i=0;i<length;i++) {
	    s->printf("inList element[%d] size %d addr %lx\n",i, element[i].size, (unsigned long)element[i].addr);
	}
    }
*/
};

typedef ListData* ListDataPtr;

#endif
