#ifndef INCLUDED_TASK
#define INCLUDED_TASK

#include "base.h"
#include "types.h"
#include "ListData.h"
#include "SimpleTask.h"

class SchedTask;
class Scheduler;

class Task {
public: // variables
    int task_size;
    int command;
    int param_count;
    int inData_count;
    int outData_count;
    int inData_offset;
    int outData_offset;
    void *data[] __attribute__ ((aligned (DEFAULT_ALIGNMENT))); 

public: // functions

    void print(Scheduler *s);

    memaddr *param(int index) {
	memaddr p =  (memaddr)data + sizeof(memaddr)*index;
	return (memaddr *)p;
    }

    ListElement *inData(int index) {
	memaddr p = (memaddr)data + inData_offset;
	p += sizeof(ListElement)*index;
	return (ListElement*)p;
    }

    ListElement *outData(int index) {
	memaddr p = (memaddr)data + outData_offset;
	p += sizeof(ListElement)* index;
	return (ListElement*)p;
    }

    static int calc_size(int params, int ins, int outs) {
	int size = round_up16(sizeof(Task))
	   + round_up16(sizeof(memaddr)*params)
           + round_up16(sizeof(ListElement)*ins)
           + round_up16(sizeof(ListElement)*outs);
	return size;
    }

    void init(int task_id, int params, int ins, int outs) {
	set_task_id(task_id);
	param_count = params;
	inData_count = ins;
	outData_count = outs;
	inData_offset = round_up16(sizeof(memaddr)*params);
	outData_offset = round_up16(inData_offset+sizeof(ListElement)*ins);
	//task_size = round_up16(sizeof(Task)+outData_offset+sizeof(ListElement)*outs);

	task_size = round_up16(sizeof(Task))
	   + round_up16(sizeof(memaddr)*params)
           + round_up16(sizeof(ListElement)*ins)
           + round_up16(sizeof(ListElement)*outs);

    }

    int size() {
	return task_size;
    }

    int inData_total_size() {
	int size = 0;
	ListElement *in= inData(0);
	for(int i=0; i< inData_count; i++) {
	    size += in[i].size;
	}
	return size;
    }
    int outData_total_size() {
	int size = 0;
	ListElement *out= outData(0);
	for(int i=0; i< outData_count; i++) {
	    size += out[i].size;
	}
	return size;
    }

    void set_inData_t( int index, memaddr addr, int size) {
	ListElement *list = inData(index);
#ifdef EARLY_TOUCH
        if ((unsigned long)addr&0xf) {
          printf("inData is not aligned. command = %d, index = %d, addr = 0x%lx, size = %d\n",
                 command, index, (unsigned long)addr, size);
        }
        char *p = (char *)addr; int b = *p;
        p = (char *)(addr+size-1); b += *p;
#endif
#ifdef __CERIUM_CELL__
	list->addr = (uint32)addr;
#else
	list->addr = addr;
#endif
	list->size = size;
    }

    void set_outData_t(int index, memaddr addr, int size) {
	ListElement *list = outData(index);
#ifdef EARLY_TOUCH
        if ((unsigned long)addr&0xf) {
          printf("inData is not aligned. command = %d, index = %d, addr = 0x%lx, size = %d\n",
                 command, index, (unsigned long)addr, size);
        }
        char *p = (char *)addr; int b = *p;
        p = (char *)(addr+size-1); b += *p;
#endif
#ifdef __CERIUM_CELL__
	list->addr = (uint32)addr;
#else
	list->addr = addr;
#endif
	list->size = size;
    }
    void set_task_id(int id) { command = id; }
    void set_param_t(int index, memaddr param) {
	memaddr *p = (memaddr*)this->param(index);
	*p = param;
    }

    Task * next()
    {
	char *p = (char*)this;
	p += size();
	return (Task*)p;
    }


#define set_param(index,param) set_param_t(index, (memaddr) (param))

#define set_inData(index, addr, size)			\
    set_inData_t(index, (memaddr)(addr), (size));
#define set_outData(index, addr, size)			\
    set_outData_t(index, (memaddr)(addr), (size));
} __attribute__ ((aligned (DEFAULT_ALIGNMENT))) ;

typedef Task* TaskPtr;

#endif
