#ifndef INCLUDED_MEM_HASH
#define INCLUDED_MEM_HASH

#include "MemorySegment.h"

class MemHash {
public:
    MemHash(void);

private:
    MemorySegmentPtr *table;

public:
    void clear(void);
    unsigned int hash(memaddr data);
    int put(memaddr addr, MemorySegmentPtr ms);
    MemorySegmentPtr get(memaddr addr);
    void remove(memaddr addr);
};

typedef MemHash* MemHashPtr;

const int hashSize = 263;

const int tableSize = sizeof(MemorySegmentPtr)*hashSize;

#endif



