//#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "MemHash.h"

unsigned int
MemHash::hash(memaddr data0)
{
    unsigned long data = (unsigned long)data0;
#if ABIBIT>32
        int i_PeRlHaSh = 8; 
#else
        int i_PeRlHaSh = 4; 
#endif
        uint32 hash_PeRlHaSh = 0; 
        while (i_PeRlHaSh--) { 
            hash_PeRlHaSh += data & 0xff; 
            hash_PeRlHaSh += (hash_PeRlHaSh << 10); 
            hash_PeRlHaSh ^= (hash_PeRlHaSh >> 6); 
	    data >>= 8;
        } 
        hash_PeRlHaSh += (hash_PeRlHaSh << 3); 
        hash_PeRlHaSh ^= (hash_PeRlHaSh >> 11); 
        return (hash_PeRlHaSh + (hash_PeRlHaSh << 15)); 
}

#if 0
static unsigned short PRIME[8] = {
    0x002, 0x065, 0x0c7, 0x133, 0x191, 0x1f3, 0x259, 0x2bd,
};

int
MemHash::hash(memaddr data0)
{
    unsigned long data = (unsigned long)data0;
    int value = 0;
    int n = 0;
    long key;

    for (uint32 i = 0; i < sizeof(memaddr) * 2; i ++) {
        key = data & 0xf;
        value += key * PRIME[n++ & 7];
        data >>= 4;
    }

    return value % hashSize;
}
#endif

MemHash::MemHash()
{
    table = (MemorySegmentPtr*)malloc(tableSize);
    clear();
}

int
MemHash::put(memaddr key, MemorySegmentPtr data)
{
    unsigned int hashval = hash(key);

    for (int i = 0; i < hashSize/2; i++) {
        unsigned int index = (hashval + i)%hashSize;

        if (table[index] == 0) { // 空の table に入れる
            table[index] = data;
            return index;
        }
    }

    return -1;
}


MemorySegmentPtr
MemHash::get(memaddr key)
{
    unsigned int hashval = hash(key);

    for (int i = 0; i < hashSize/2; i++) {
        unsigned int index = (hashval + i)%hashSize;

        if (table[index] != NULL &&
            table[index]->address == key) {
            return table[index];
        }
    }

    return NULL;
}

void
MemHash::remove(memaddr key)
{
    unsigned int hashval = hash(key);

    for (int i = 0; i < hashSize/2; i++) {
        int index = (hashval + i)%hashSize;

        if (table[index] != NULL &&
            table[index]->address == key) {
            table[index] = NULL;
        }
    }
}

void
MemHash::clear(void)
{
    bzero(table, tableSize);
}

/* end */
