/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

// SetFSize.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "bsch.h"
#include "SetFSize.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSetFreeSize _CAO


CSetFreeSize::CSetFreeSize(CWnd* pParent /*=NULL*/)
	: CDialog(CSetFreeSize::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSetFreeSize)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_INIT
}


void CSetFreeSize::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSetFreeSize)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSetFreeSize, CDialog)
	//{{AFX_MSG_MAP(CSetFreeSize)
	ON_BN_CLICKED(IDC_ADD, OnAdd)
	ON_BN_CLICKED(IDC_DEL, OnDel)
	ON_LBN_SELCHANGE(IDC_MYSTDSHEETSIZE, OnSelchangeMystdsheetsize)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSetFreeSize bZ[W nh

void CSetFreeSize::OnOK() 
{
	// TODO: ̈ʒuɂ̑̌ؗp̃R[hǉĂ
	int nX,nY;
	if(!GetXY(&nX,&nY)){
		AfxMessageBox(IDS_INVALID_SHEETSIZE,MB_ICONEXCLAMATION|MB_OK);
		return;
	}
	m_nX = nX;
	m_nY = nY;
	CDialog::OnOK();
}

BOOL CSetFreeSize::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: ̈ʒuɏ̕⑫ǉĂ
	CEdit* pEdit;

	//͉\ȕƒl̐ݒ
	pEdit=(CEdit*)GetDlgItem(IDC_EDIT_X);
	pEdit->SetLimitText(4);
	pEdit=(CEdit*)GetDlgItem(IDC_EDIT_Y);
	pEdit->SetLimitText(4);
	
	SetXY(m_nX,m_nY);

	CListBox* plistbox =(CListBox*)GetDlgItem(IDC_MYSTDSHEETSIZE);
	CString str;
	char szEntry[32];
	int n,x,y;
	for(n = 0; n < MAX_STDSIZE; n++){
		sprintf(szEntry,"Size%d",n);
		str = AfxGetApp()->GetProfileString("MyStdSheetSize",szEntry,"");
		if(!str.IsEmpty()){
			if(SizeStr2Size(str,&x,&y)){
				plistbox->AddString(str);
			}
		}
	}
	
	SetAddDelButtonState();

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

BOOL CSetFreeSize::SizeStr2Size(LPCSTR strSize,int* x,int* y)
{
	char szSize[64];
	strncpy(szSize,strSize,63);
	int n = 0;
	while(szSize[n]){
		if(szSize[n] == 'x'){
			szSize[n]=0;
			n++;
			break;
		}
		n++;
	}
	if(szSize[n] == 0) return FALSE;
	*x = atoi(&(szSize[0]));
	*y = atoi(&(szSize[n]));
	if(*x < XSIZE_MIN || *x > XSIZE_MAX || *y < YSIZE_MIN || *y > YSIZE_MAX){
		return FALSE;
	}else{
		return TRUE;
	}
}

void CSetFreeSize::SetAddDelButtonState()
{
	CListBox* plistbox =(CListBox*)GetDlgItem(IDC_MYSTDSHEETSIZE);
	int nCount = plistbox->GetCount();
	
	CButton* pButton;
	pButton =(CButton*)GetDlgItem(IDC_ADD);
	pButton->EnableWindow(nCount<MAX_STDSIZE);

	pButton =(CButton*)GetDlgItem(IDC_DEL);
	pButton->EnableWindow(nCount>0 && plistbox->GetCurSel()!=LB_ERR);
}

void CSetFreeSize::SaveMyStdSheetInfo()
{
	CListBox* plistbox =(CListBox*)GetDlgItem(IDC_MYSTDSHEETSIZE);

	CString str;
	char szEntry[32];
	int nCount = plistbox->GetCount();
	if(nCount > MAX_STDSIZE) nCount = MAX_STDSIZE;
	int n;
	for(n = 0; n < MAX_STDSIZE; n++){
		if(n < nCount) plistbox->GetText(n,str);
		else str="";
		sprintf(szEntry,"Size%d",n);
		AfxGetApp()->WriteProfileString("MyStdSheetSize",szEntry,str);
	}
}

BOOL CSetFreeSize::SetXY(int x,int y)
{
	CEdit* pEdit;
	char sz[32];
	pEdit=(CEdit*)GetDlgItem(IDC_EDIT_X);
	wsprintf(sz,"%d",x);
	pEdit->SetWindowText(sz);

	pEdit=(CEdit*)GetDlgItem(IDC_EDIT_Y);
	wsprintf(sz,"%d",y);
	pEdit->SetWindowText(sz);
	return TRUE;
}


BOOL CSetFreeSize::GetXY(int* x,int* y)
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	CEdit* pEdit;
	CString str;
	//GfBbg{bNXX̒l̎擾
	pEdit=(CEdit*)GetDlgItem(IDC_EDIT_X);
	pEdit->GetWindowText(str);
	*x=atoi(str);
	//GfBbg{bNXY̒l̎擾
	pEdit=(CEdit*)GetDlgItem(IDC_EDIT_Y);
	pEdit->GetWindowText(str);
	*y=atoi(str);
	//͈͓`FbN
	if(*x<XSIZE_MIN || *x>XSIZE_MAX || *y<YSIZE_MIN || *y>YSIZE_MAX){
		return FALSE;
	}else{
		return TRUE;
	}
}

void CSetFreeSize::OnAdd() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	CListBox* plistbox =(CListBox*)GetDlgItem(IDC_MYSTDSHEETSIZE);
	int nCount = plistbox->GetCount();
	if(nCount >= MAX_STDSIZE) return;
	
	int nX,nY;
	if(!GetXY(&nX,&nY)){
		AfxMessageBox(IDS_INVALID_SHEETSIZE,MB_ICONEXCLAMATION|MB_OK);
		return;
	}
	char sz[64];
	sprintf(sz,"%dx%d",nX,nY);

	//̂o^ȂB
	int n;
	for(n = 0; n < nCount; n++){
		CString str;
		plistbox->GetText(n,str);
		if(strcmp(sz,str) == 0) return;
	}

	n = plistbox->AddString(sz);
	plistbox->SetCurSel(n);
	SetAddDelButtonState();

	SaveMyStdSheetInfo();
}

void CSetFreeSize::OnDel() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	CListBox* plistbox =(CListBox*)GetDlgItem(IDC_MYSTDSHEETSIZE);
	int nIndex = plistbox->GetCurSel();
	if(LB_ERR == nIndex) return;
	else plistbox->DeleteString(nIndex);
	SetAddDelButtonState();

	SaveMyStdSheetInfo();
}

void CSetFreeSize::OnSelchangeMystdsheetsize() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	CListBox* plistbox =(CListBox*)GetDlgItem(IDC_MYSTDSHEETSIZE);
	int nIndex = plistbox->GetCurSel();
	CString str;
	plistbox->GetText(nIndex,str);
	int x,y;
	if(SizeStr2Size(str,&x,&y)){
		SetXY(x,y);
	}
	SetAddDelButtonState();
}
