/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

// BSch.h : BSCH AvP[ṼC wb_[ t@C
//
#ifndef BSCH_H
#define BSCH_H

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"       // C V{

#include "SheetSizeInfo.h"

/////////////////////////////////////////////////////////////////////////////
// BSch ̂߂̃O[oȐl`

//#define MAX_LIB 64	// Cu̍ő吔

#define MAX_SHEETSIZE 5 //V[gTCY0`(MAX_SHEETSIZE-1)


//iPƑÎƂ̃L[̓tH[JX
enum{
	FOCUSED_TO_BODY = 0,
	FOCUSED_TO_NUM = 1,
	FOCUSED_TO_VAL = 2
};


///////////////////////////////////////////////////////////////
// F
#define COL_BG				(RGB(255,255,255))
#define COL_JUNC			(RGB(  0,128,  0))
#define COL_WIRE			(RGB(  0,128,  0))
#define COL_BUS				(RGB(  0,128,192))
#define COL_DASH			(RGB(  0,  0,192))
#define COL_TAG				(RGB(192,  0,  0))
#define COL_TAG_NAME		(RGB(  0,  0,  0))
#define COL_COMMENT			(RGB(  0,  0,  0))
#define COL_LABEL			(RGB(  0,  0,  0))
#define COL_XOR				(RGB(255,  0,  0))
#define COL_PART			(RGB(192,  0,  0))
#define COL_PART_PIN		(RGB(192,  0,  0))
#define COL_PART_PINNAME	(RGB(  0,  0,  0))	
#define COL_PART_PINNUM		(RGB(  0,  0,  0))
#define COL_PART_NAME		(RGB(  0,  0,  0))	
#define COL_PART_NUM		(RGB(  0,  0,  0))
#define COL_PART_FRAME		(RGB(128,128,255))
#define COL_SHEET_FRAME		(RGB(128, 32, 32))
#define COL_SHEET_GRID		(RGB(255, 64, 64))
#define COL_DARK			(RGB(255,192,192))
#define COL_ZLPIN			(RGB(255,192,192))
#define COL_NC_MARK			(RGB(255, 32, 32))
#define COL_QUICKPROPVIEW	(RGB(240,230,200))
#define COL_TEMPFRAME_FOCUSED		(RGB(128,128,128))
#define COL_TEMPFRAME_NOT_FOCUSED	(RGB(160,220,220))
#define COL_FIND_MARK	(RGB(64,64,255))


//`惂[h iȉ̒l̘_aƂĎgj
#define DRAW_ON		1	// ʏ̕`
#define DRAW_OFF	2	// B炭͔wiFł̕`w
#define DRAW_TEMP	4	// XOR[hł̕`
#define DRAW_FAST	8	// [hł̕`B炭͎̂悤Ȃ́j
						//		EiȂsԍAsAiԍAiȗ
						//		E^OȂ當ȗ
						//	 ̑̑̐}ʗvfł͂̃rbg͈ӖȂ
#define DRAW_INVERT	16	// BSch8hbgXORŗLBiԍAi̕`Ŏgp
#define DRAW_PARTFRAME 		32	//ig̕`
#define DRAW_DARK	64	// ÂFł̕`
#define DRAW_NC_MARK 128
#define DRAW_INH_PARTNAME 	256	//i̕`Ȃ
#define DRAW_INH_PARTNUM  	512	//iԍ̕`Ȃ
#define DRAW_INH_PARTBODY  1024	//i{fB̕`Ȃ
#define DRAW_FOR_PRINT	   2048 //p̕`

//#define COMMENT_Y_OFFSET 2


#define SCROLL_TO_MSG (WM_APP+100)



/////////////////////////////////////////////////////////////////////////////
// CBSchApp:
// ̃NX̓̒`ɊւĂ BSch.cpp t@CQƂĂB
//

class CBSchApp : public CWinApp
{
public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	CBSchApp();

	~CBSchApp();

// I[o[Ch
	// ClassWizard ͉z֐𐶐I[o[Ch܂B
	//{{AFX_VIRTUAL(CBSchApp)
	public:
	virtual BOOL InitInstance();
	virtual CDocument* OpenDocumentFile(LPCTSTR lpszFileName);
	//}}AFX_VIRTUAL

// Cve[V

	//{{AFX_MSG(CBSchApp)
	afx_msg void OnAppAbout();
	afx_msg void OnFileNew();
	afx_msg void OnFilePrintSetup();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:
	char m_szIniFileDir[_MAX_PATH];
private:
	char *m_pszIniFileName;
	char m_moduleFileName[_MAX_PATH];

public:
	void UpdatePrinterSelection(BOOL bForceDefaults);
	void IniWritePrinterSetup();
	BOOL ExecBSch(const char* pathname);
	virtual BOOL OnIdle(LONG lCount);
};


/////////////////////////////////////////////////////////////////////////////

#endif
