#include "IntelHEXFile.hpp"
#include "IntelHEXRecord.hpp"

#include <fstream>

using namespace std;

class IntelHEXFileImpl {
public:
	IntelHEXFile::RecordContainer records;

public:
	void initialize(istream& stream) {
		string line;
		while (getline(stream, line)) {
			records.push_back(IntelHEXRecordPtr(new IntelHEXRecord(line)));
		}
	}

public:
	IntelHEXFileImpl() {
	}

	IntelHEXFileImpl(const string& filename) {
		initialize(ifstream(filename, ifstream::in));
	}

	IntelHEXFileImpl(istream& stream) {
		initialize(stream);
	}
};

IntelHEXFile::IntelHEXFile() : impl_(new IntelHEXFileImpl()) {
}

IntelHEXFile::IntelHEXFile(const std::string& filename) : impl_(new IntelHEXFileImpl(filename)) {
}

IntelHEXFile::IntelHEXFile(istream& stream) : impl_(new IntelHEXFileImpl(stream)) {
}

IntelHEXFile::~IntelHEXFile() {
	delete impl_;
}

size_t IntelHEXFile::size() {
	return impl_->records.size();
}

void IntelHEXFile::add(const std::string& record) {
	return impl_->records.push_back(IntelHEXRecordPtr(new IntelHEXRecord(record)));
}

void IntelHEXFile::add(const IntelHEXRecordPtr& record) {
	return impl_->records.push_back(record);
}

IntelHEXFile::iterator IntelHEXFile::begin() {
	return impl_->records.begin();
}

IntelHEXFile::iterator IntelHEXFile::end() {
	return impl_->records.end();
}

IntelHEXFile::const_iterator IntelHEXFile::begin() const {
	return impl_->records.begin();
}

IntelHEXFile::const_iterator IntelHEXFile::end() const {
	return impl_->records.end();
}
