#ifndef __matching_h__
#define __matching_h__

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <float.h>

#define MAX_MAT_LENGTH 2048

/* 許容する傾きの最大値 */
#define GRAD 2.0
/* 変形関数の傾きに対する重み */
#define MAGIC_K 1.5

double  interpolateArray( double x, const double* p );

void    calculateMatching( double* T, double* H, double* src_s, double* dst_s, int length, double *inverse );

void    applyStretching( double *T, double* target, int length );

#endif
