#include "straightSynthesizer.h"

int main( int argc, char *argv[] ){
#ifndef __GNUC__
    _CrtSetDbgFlag( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF );
#endif
    
    straightSynthesizer Synthesizer;

    string sUsqPath = "";
    string sWavPath = "";

    if( argc == 3 ){
        sUsqPath = argv[1];
        sWavPath = argv[2];
    }else{
        cout << "vConnect" << endl;
        cout << "usage:" << endl;
        cout << "    vConnect [vsq_meta_text_path] [out_wave_path]" << endl;
        return 0;
//        cin >> sUsqPath;        //手作業でのデバッグ用。
//        cin >> sWavPath;
    }

    if( sUsqPath.compare( "" ) == 0 ){
        return 0;
    }
    if( sWavPath.compare( "" ) == 0 ){
        return 0;
    }

    if( Synthesizer.Initialize( sUsqPath ) ){
        Synthesizer.Synthesize( sWavPath );
    }

#ifdef _DEBUG
    // デバッグの時コンソールを残したままにしたい時用
    /*int i;
    cout << "type any key and enter...";
    cin >> i;*/
#endif
    return 0;
}
