#ifndef ANALYSISWINDOW_H
#define ANALYSISWINDOW_H

#include <QMainWindow>
#include "QUtauParameters.h"
#include "waveFileEx/waveFileEx.h"
#include "matching/matching.h"

#include <vector>
using namespace std;

namespace Ui {
    class analysisWindow;
}

class analysisWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit analysisWindow(QWidget *parent = 0);
    ~analysisWindow();

    void setParameters(QUtauParameters &src, QUtauParameters &dst, bool visible = true);


    class specgram{
    public:
        explicit specgram();
        ~specgram();

        void create(int timeLength, int fftLength);

        double *f0;
        double *t;
        double **spec;
        double **ap;
        int fftLength;
        int timeLength;
        double framePeriod;
    private:
        void destroy(void);
    };

public slots:
    void saveMelCepstrum();
    void saveMelCepstrum(QString &);

private:
    bool readWaveFiles(void);
    void setVolumeView(void);
    void setTransformView(void);
    void setSpecgramView(void);
    void setSpectrumView(void);
    Ui::analysisWindow *ui;

    double han[2049];
    double *srcVolume;
    double *dstVolume;
    double *dstTransVolume;
    double *transFunction;
    double *transInverse;
    double *transNormal;

    double *srcSpectrum;
    double *dstSpectrum;
    double *morphSpectrum;

    specgram srcSpecgram;
    specgram dstSpecgram;
    specgram dstTransSpecgram;

    int position;

    int volumeLength;
    vector<double> srcWaveBuffer;
    vector<double> dstWaveBuffer;
    QUtauParameters src;
    QUtauParameters dst;
};

#endif // ANALYSISWINDOW_H
