/*
 *
 *    standTexture.cpp
 *                              (c) HAL 2010-           
 *
 *  This file is a part of STAND Library.
 * standTexture is a structure that contains
 * frequency transform functions and spectral filter.
 *
 * These files are distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 */
#include "standTexture.h"

/* 共用関数と共用変数 */
double tmp[MAX_LENGTH];

/*double interpolateArray( double x, double *p )
{
    int t = (int)x;
    double r = x - (double)t;
    return ( p[t] * ( 1.0 - r ) + p[t+1] * r );
}*/

/*void applyStretching( double *T, double *target, int length )
{
    int i;
    for( i = 0; i < length; i++ )
        tmp[i] = interpolateArray( (double)i + T[i], target );
    memcpy( target, tmp, sizeof(double) * length );
}*/

standTexture::standTexture()
{
    f0Base = 0.0;
    length = -1;
    trans = filter = NULL;
}

standTexture::~standTexture()
{
    SAFE_DELETE_ARRAY( filter );
    SAFE_DELETE_ARRAY( trans );
}

bool standTexture::readTexture( string_t input, runtimeOptions& options ){
    bool ret = false;
    string buf;//[LINEBUFF_LEN];
    MB_FILE* fp;

    //Shift_JISはダミー。常にシステムのデフォルトのエンコーディングで読み込む
    // ダミーを一応解除 by HAL
    fp = mb_fopen( input.c_str(), options.encodingVoiceTexture.c_str() );

    if( fp ){
        ret = true;
        ret &= (mb_fgets( buf, fp ));
        sscanf( buf.c_str(), "%d", &length );
        ret &= (mb_fgets( buf, fp ));
        sscanf( buf.c_str(), "%lf", &f0Base );
        filter = new double[length];
        trans = new double[length];

        for( int i = 0; i < length; i++ ){
            ret &= (mb_fgets( buf, fp ));
            sscanf( buf.c_str(), "%lf", &trans[i] );
        }
        for( int i = 0; i < length; i++ ){
            ret &= (mb_fgets( buf, fp ));
            sscanf( buf.c_str(), "%lf", &filter[i] );
        }
    }
    return ret;
}

bool standTexture::setTexture( double* trans_src, double* filter_src, double f0_src, int length_src )
{
    if( length_src < 1 )
        return false;
    SAFE_DELETE_ARRAY( trans );
    SAFE_DELETE_ARRAY( filter );
    length = length_src;
    f0Base = f0_src;
    filter = new double[length];
    trans = new double[length];

    memcpy( filter, filter_src, sizeof(double)*length );
    memcpy( trans, trans_src, sizeof(double)*length );

    return true;
}

bool standTexture::setPlainTexture( int length_src )
{
    if( length_src != length ){
        SAFE_DELETE_ARRAY( trans );
        SAFE_DELETE_ARRAY( filter );
        length = length_src;
        trans = new double[length];
        filter = new double[length];
    }
    f0Base = DEFAULT_F0;
    for( int i = 0; i < length_src; i++ )
        trans[i] = (double)i;
    memset( filter, 0, sizeof(double) * length );

    return true;
}

void standTexture::getTexturePointer( double **t_dst, double** f_dst, double* f0, int* len_dst )
{
    *t_dst = trans;
    *f_dst = filter;
    *f0 = f0Base;
    *len_dst = length;
}

void standTexture::combine( standTexture* tex1, standTexture* tex2, double rate )
{
    if( !tex1 || !tex2 )
        return;
    double f0_tmp, *t_tmp, *f_tmp;
    int len_tmp;
    tex1->getTexturePointer( &t_tmp, &f_tmp, &f0_tmp, &len_tmp );
    if( length != len_tmp )
        setPlainTexture( len_tmp );
    f0Base = f0_tmp * rate;
    for( int i = 0; i < length; i++ ){
        trans[i] = t_tmp[i] * rate;
        filter[i] = f_tmp[i] * rate;
    }
    tex2->getTexturePointer( &t_tmp, &f_tmp, &f0_tmp, &len_tmp );
    rate = 1.0 - rate;
    f0Base += f0_tmp * rate;
    for( int i = 0; i < length; i++ ){
        trans[i] += t_tmp[i] * rate;
        filter[i] += f_tmp[i] * rate;
    }
}
