#ifndef __straightNoteManager_h__
#define __straightNoteManager_h__

#include "vConnect.h"

#include "straightNote.h"

class straightNoteManager{
public:
    /**
     * @brief デストラクタ。開放処理を行う。
     */
    ~straightNoteManager();

    /**
     * @brief 初期化関数。
     */
#ifdef USE_MULTI_SINGER
    void Initialize( vector<string> *file_paths, Straight *straight ){
        this->mFilePaths = file_paths;
        this->mStraight = straight;
    };
#else
    void Initialize( string file_path, Straight *straight ){
        this->mFilePath = file_path;
        this->mStraight = straight;
    };
#endif

    /**
     * @brief 原音の特定フレームから情報を読み出す。
     * @return 成功：true　失敗：false
     */
#ifdef USE_MULTI_SINGER
    bool GetStraightFrame( straightFrame *dst_frame, string lyric, long absolute_frame, int singer_index );
#else
    bool GetStraightFrame( straightFrame *dst_frame, string lyric, long absolute_frame );
#endif

    /**
     * @brief 歌詞データから原音のフレーム長を読み出す。
     * @return 原音のフレーム長
     */
#ifdef USE_MULTI_SINGER
    long GetSrcFrameLength( string lyric, int singer_index );
#else
    long GetSrcFrameLength( string lyric );
#endif

    /**
     * @brief 指定した番号の原音の、指定した歌詞のSTFファイル情報を取得します
     */
#ifdef USE_MULTI_SINGER
    straightNote *GetSTF( string lyric, int singer_index );
#else
    straightNote *GetSTF( string lyric );
#endif

    /**
     * @brief 与えられた歌詞データに該当するデータを開放する。
     */
#ifdef USE_MULTI_SINGER
    void ReleaseSTF( string lyric, int singer_index );
#else
    void ReleaseSTF( string lyric );
#endif

private:
#ifdef USE_MULTI_SINGER
    /**
     * 指定した番号の原音の、指定した歌詞のSTFを取得するための内部名を取得します
     */
    string GetNoteMapKey( string lyric, int singer_index );
#endif

protected:
private:

    MAP_TYPE<string, straightNote *> mNoteMap;   //!< @brief 読み込んだSTFファイル管理用ハッシュマップ
    list<straightNote *>             mNoteList;  //!< @brief メモリ管理用

#ifdef USE_MULTI_SINGER
    vector<string> *mFilePaths;  //!< @brief 音声セットへのファイルパス
#else
    string mFilePath;            //!< @brief 音声セットへのファイルパス
#endif
    Straight *mStraight;         //!< @brief STRAIGHT用
};

#endif // __straightNoteManager_h__
