﻿/*
 * UtauVoiceDB.cs
 * Copyright (C) 2009-2010 kbinani
 *
 * This file is part of Boare.Cadencii.
 *
 * Boare.Cadencii is free software; you can redistribute it and/or
 * modify it under the terms of the GPLv3 License.
 *
 * Boare.Cadencii is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.IO;
using System.Text;
using bocoree;
using bocoree.util;

namespace Boare.Cadencii {

    public class UtauVoiceDB {

        private Vector<OtoArgs> m_configs = new Vector<OtoArgs>();
        private String m_name = "Unknown";

        public UtauVoiceDB( String oto_ini ) {
            if ( !PortUtil.isFileExists( oto_ini ) ) {
                return;
            }

            // STRAIGHT用のoto.iniかどうかを判定
            bool straight_mode = false;
            String check_word = PortUtil.combinePath( "analyzed", "oto.ini" );
            if ( oto_ini.EndsWith( check_word ) ) {
                straight_mode = true;
            }

            // oto.ini読込み
            String dir = PortUtil.getDirectoryName( oto_ini );
            foreach ( String encoding in AppManager.TEXT_ENCODINGS_IN_UTAU ) {
                using ( StreamReader sr = new StreamReader( oto_ini, Encoding.GetEncoding( encoding ) ) ) {
                    String line;
                    while ( sr.Peek() >= 0 ) {
                        try {
                            line = sr.ReadLine();
                            String[] spl = line.Split( '=' );
                            String file_name = spl[0]; // あ.wav
                            String a2 = spl[1]; // ,0,36,64,0,0
                            String a1 = Path.GetFileNameWithoutExtension( file_name );
                            spl = a2.Split( ',' );
                            if ( spl.Length < 6 ) {
                                continue;
                            }

                            String fullpath = PortUtil.combinePath( dir, file_name );
                            if ( !PortUtil.isFileExists( fullpath ) ) {
                                if ( straight_mode ) {
                                    // STRAIGHTモードなら、wavが無くてもstfがあればOKとする。
                                    fullpath = PortUtil.combinePath( dir, PortUtil.getFileNameWithoutExtension( file_name ) + ".stf" );
                                    if ( !PortUtil.isFileExists( fullpath ) ) {
                                        continue;
                                    }
                                } else {
                                    continue;
                                }
                            }

                            OtoArgs oa = new OtoArgs();
                            oa.fileName = file_name;
                            oa.Alias = spl[0];
                            oa.msOffset = float.Parse( spl[1] );
                            oa.msConsonant = float.Parse( spl[2] );
                            oa.msBlank = float.Parse( spl[3] );
                            oa.msPreUtterance = float.Parse( spl[4] );
                            oa.msOverlap = float.Parse( spl[5] );

                            // 重複登録が無いかチェック
                            bool found = false;
                            foreach ( OtoArgs o in m_configs ) {
                                if ( o.equals( oa ) ) {
                                    found = true;
                                    break;
                                }
                            }
                            if ( !found ) {
                                m_configs.add( oa );
                            }
                        } catch {
                        }
                    }
                }
            }

            // character.txt読込み
            String character = Path.Combine( dir, "character.txt" );
            String name = null;
            if ( PortUtil.isFileExists( character ) ) {
                foreach ( String encoding in AppManager.TEXT_ENCODINGS_IN_UTAU ) {
                    using ( StreamReader sr = new StreamReader( character, Encoding.GetEncoding( encoding ) ) ) {
                        String line = "";
                        while ( (line = sr.ReadLine()) != null ) {
                            String[] spl = line.Split( '=' );
                            if ( spl.Length > 1 ) {
                                if ( spl[0].ToLower() == "name" ) {
                                    name = spl[1];
                                    break;
                                }
                            }
                        }
                    }
                    if ( name != null ) {
#if DEBUG
                        PortUtil.println( "UtauVoiceDB#.ctor; name=" + name + "; encoding=" + encoding );
#endif
                        break;
                    }
                }
            }
            if ( name == null ) {
                name = Path.GetFileNameWithoutExtension( Path.GetDirectoryName( oto_ini ) );
            }
            m_name = name;
        }

        /// <summary>
        /// 指定した歌詞に合致する、エイリアスを考慮した原音設定を取得します
        /// </summary>
        /// <param name="lyric"></param>
        /// <returns></returns>
        public OtoArgs attachFileNameFromLyric( String lyric ) {
            int count = m_configs.size();
            for ( Iterator<OtoArgs> itr = m_configs.iterator(); itr.hasNext(); ) {
                OtoArgs item = itr.next();
                if ( Path.GetFileNameWithoutExtension( item.fileName ).Equals( lyric ) ) {
                    return item;
                }
                if ( item.Alias.Equals( lyric ) ) {
                    return item;
                }
            }
            return new OtoArgs();
        }

        public String getName() {
            return m_name;
        }
    }

}
