﻿/*
 * PortUtil.cs
 * Copyright (c) 2009 kbinani
 *
 * This file is part of Boare.Lib.Vsq.
 *
 * Boare.Lib.Vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Lib.Vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Collections.Generic;

namespace Boare.Lib.Vsq {

    public interface Iterator {
        bool hasNext();
        object next();
        void remove();
    }

    public class ListIterator<T> : Iterator {
        private List<T> m_list;
        private int m_pos;

        public ListIterator( List<T> list ) {
            m_list = list;
            m_pos = -1;
        }

        public Boolean hasNext() {
            if ( m_list != null && 0 <= m_pos + 1 && m_pos + 1 < m_list.Count ) {
                return true;
            } else {
                return false;
            }
        }

        public Object next() {
            if ( m_list == null ) {
                return null;
            }
            m_pos++;
            return m_list[m_pos];
        }

        public void remove() {
            m_list.RemoveAt( m_pos );
        }
    }

}
