/*
 * FormMain.cs
 * Copyright (c) 2008-2009 kbinani
 *
 * This file is part of Boare.Cadencii.
 *
 * Boare.Cadencii is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Cadencii is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
//#define MONITOR_FPS
#define AUTHOR_LIST_SAVE_BUTTON_VISIBLE
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.IO;
using System.Media;
using System.Threading;
using System.Windows.Forms;
using System.Xml.Serialization;
using System.Text;

using bocoree;
using Boare.Lib.AppUtil;
using Boare.Lib.Media;
using Boare.Lib.Vsq;

//TODO: アイテムが選択されたときに、イベントを拾ってstripBtnCopy等のEnabledを更新する
namespace Boare.Cadencii {

    partial class FormMain : Form {
        #region Static Readonly Field
        private readonly SolidBrush s_brs_192_192_192 = new SolidBrush( Color.FromArgb( 192, 192, 192 ) );
        private readonly SolidBrush s_brs_a098_000_000_000 = new SolidBrush( Color.FromArgb( 98, 0, 0, 0 ) );
        private readonly SolidBrush s_brs_106_108_108 = new SolidBrush( Color.FromArgb( 106, 108, 108 ) );
        private readonly SolidBrush s_brs_180_180_180 = new SolidBrush( Color.FromArgb( 180, 180, 180 ) );
        private readonly SolidBrush s_brs_212_212_212 = new SolidBrush( Color.FromArgb( 212, 212, 212 ) );
        private readonly SolidBrush s_brs_125_123_124 = new SolidBrush( Color.FromArgb( 125, 123, 124 ) );
        private readonly SolidBrush s_brs_240_240_240 = new SolidBrush( Color.FromArgb( 240, 240, 240 ) );
        private readonly SolidBrush s_brs_011_233_244 = new SolidBrush( Color.FromArgb( 11, 233, 244 ) );
        private readonly SolidBrush s_brs_182_182_182 = new SolidBrush( Color.FromArgb( 182, 182, 182 ) );
        private readonly SolidBrush s_brs_072_077_098 = new SolidBrush( Color.FromArgb( 72, 77, 98 ) );
        private readonly SolidBrush s_brs_153_153_153 = new SolidBrush( Color.FromArgb( 153, 153, 153 ) );
        private readonly SolidBrush s_brs_147_147_147 = new SolidBrush( Color.FromArgb( 147, 147, 147 ) );
        private readonly SolidBrush s_brs_000_255_214 = new SolidBrush( Color.FromArgb( 0, 255, 214 ) );
        private readonly Pen s_pen_112_112_112 = new Pen( Color.FromArgb( 112, 112, 112 ) );
        private readonly Pen s_pen_118_123_138 = new Pen( Color.FromArgb( 118, 123, 138 ) );
        private readonly Pen s_pen_LU = new Pen( Color.FromArgb( 128, 106, 52, 255 ) );
        private readonly Pen s_pen_RD = new Pen( Color.FromArgb( 204, 40, 47, 255 ) );
        private readonly Pen s_pen_161_157_136 = new Pen( Color.FromArgb( 161, 157, 136 ) );
        private readonly Pen s_pen_209_204_172 = new Pen( Color.FromArgb( 209, 204, 172 ) );
        private readonly Pen s_pen_160_160_160 = new Pen( Color.FromArgb( 160, 160, 160 ) );
        private readonly Pen s_pen_105_105_105 = new Pen( Color.FromArgb( 105, 105, 105 ) );
        private readonly Pen s_pen_106_108_108 = new Pen( Color.FromArgb( 106, 108, 108 ) );
        private readonly Pen s_pen_212_212_212 = new Pen( Color.FromArgb( 212, 212, 212 ) );
        private readonly Pen s_pen_051_051_000 = new Pen( Color.FromArgb( 51, 51, 0 ) );
        private readonly Pen s_pen_125_123_124 = new Pen( Color.FromArgb( 125, 123, 124 ) );
        private readonly Pen s_pen_187_187_255 = new Pen( Color.FromArgb( 187, 187, 255 ) );
        private readonly Pen s_pen_007_007_151 = new Pen( Color.FromArgb( 7, 7, 151 ) );
        private readonly Pen s_pen_a136_000_000_000 = new Pen( Color.FromArgb( 136, Color.Black ) );
        private readonly Pen s_pen_dashed_171_171_171 = new Pen( Color.FromArgb( 171, 171, 171 ) );
        private readonly Pen s_pen_dashed_209_204_172 = new Pen( Color.FromArgb( 209, 204, 172 ) );
        private readonly Pen s_pen_065_065_065 = new Pen( Color.FromArgb( 65, 65, 65 ) );
        private readonly Color s_txtbox_backcolor = Color.FromArgb( 128, 128, 128 );
        public readonly Color[] s_HIDDEN = new Color[]{
            Color.FromArgb( 181, 162, 123 ),
            Color.FromArgb( 179, 181, 123 ),
            Color.FromArgb( 157, 181, 123 ),
            Color.FromArgb( 135, 181, 123 ),
            Color.FromArgb( 123, 181, 133 ),
            Color.FromArgb( 123, 181, 154 ),
            Color.FromArgb( 123, 181, 176 ),
            Color.FromArgb( 123, 164, 181 ),
            Color.FromArgb( 123, 142, 181 ),
            Color.FromArgb( 125, 123, 181 ),
            Color.FromArgb( 169, 123, 181 ),
            Color.FromArgb( 181, 123, 171 ),
            Color.FromArgb( 181, 123, 149 ),
            Color.FromArgb( 181, 123, 127 ),
            Color.FromArgb( 181, 140, 123 ),
            Color.FromArgb( 181, 126, 123 ) };
        private readonly AuthorListEntry[] _CREDIT = new AuthorListEntry[]{
            new AuthorListEntry( "is developped by:", FontStyle.Italic ),
            new AuthorListEntry( "kbinani" ),
            new AuthorListEntry(),
            new AuthorListEntry(),
            new AuthorListEntry( "Special Thanks to", FontStyle.Italic| FontStyle.Bold ),
            new AuthorListEntry(),
            new AuthorListEntry( "tool icons designer:", FontStyle.Italic ),
            new AuthorListEntry( "Yusuke Kamiyamane" ),
            new AuthorListEntry(),
            new AuthorListEntry( "developper of UTAU:", FontStyle.Italic ),
            new AuthorListEntry( "飴屋/菖蒲" ),
            new AuthorListEntry(),
            new AuthorListEntry( "promoter:", FontStyle.Italic ),
            new AuthorListEntry( "zhuo" ),
            new AuthorListEntry(),
            new AuthorListEntry( "library tester:", FontStyle.Italic ),
            new AuthorListEntry( "evm" ),
            new AuthorListEntry( "そろそろP" ),
            new AuthorListEntry( "めがね１１０" ),
            new AuthorListEntry( "上総" ),
            new AuthorListEntry( "NOIKE" ),
            new AuthorListEntry( "逃亡者" ),
            new AuthorListEntry(),
            new AuthorListEntry( "translator:", FontStyle.Italic ),
            new AuthorListEntry( "Eji (zh-TW translation)" ),
            new AuthorListEntry( "kankan (zh-TW translation)" ),
            new AuthorListEntry(),
            new AuthorListEntry(),
            new AuthorListEntry( "Thanks to", FontStyle.Italic | FontStyle.Bold ),
            new AuthorListEntry(),
            new AuthorListEntry( "ないしょの人" ),
            new AuthorListEntry( "naquadah" ),
            new AuthorListEntry( "1zo" ),
            new AuthorListEntry( "Amby" ),
            new AuthorListEntry( "ケロッグ" ),
            new AuthorListEntry( "beginner" ),
            new AuthorListEntry( "b2ox" ),
            new AuthorListEntry( "麻太郎" ),
            new AuthorListEntry( "もみじぱん" ),
            new AuthorListEntry( "PEX" ),
            new AuthorListEntry( "やなぎがうら" ),
            new AuthorListEntry( "cocoonP" ),
            new AuthorListEntry( "かつ" ),
            new AuthorListEntry( "ちゃそ" ),
            new AuthorListEntry( "all members of Cadencii bbs", FontStyle.Italic ),
            new AuthorListEntry(),
            new AuthorListEntry( "     ... and you !", FontStyle.Bold | FontStyle.Italic ),
        };
        private readonly Font s_F9PT = new Font( FontFamily.GenericSansSerif, 9f, GraphicsUnit.Point );
        #endregion

        #region Constants and internal enums
        /// <summary>
        /// カーブエディタ画面の編集モード
        /// </summary>
        internal enum CurveEditMode {
            /// <summary>
            /// 何もしていない
            /// </summary>
            None,
            /// <summary>
            /// 鉛筆ツールで編集するモード
            /// </summary>
            Edit,
            /// <summary>
            /// ラインツールで編集するモード
            /// </summary>
            Line,
            /// <summary>
            /// 鉛筆ツールでVELを編集するモード
            /// </summary>
            EditVel,
            /// <summary>
            /// ラインツールでVELを編集するモード
            /// </summary>
            LineVel,
            /// <summary>
            /// 真ん中ボタンでドラッグ中
            /// </summary>
            MiddleDrag,
        }

        internal enum ExtDragXMode {
            Right,
            Left,
            None,
        }

        internal enum ExtDragYMode {
            Up,
            Down,
            None,
        }

        internal enum GameControlMode {
            Disabled,
            Normal,
            Keyboard,
            Cursor,
        }

        /// <summary>
        /// スクロールバーの最小サイズ(ピクセル)
        /// </summary>
        private const int MIN_BAR_ACTUAL_LENGTH = 17;
        /// <summary>
        /// エントリの端を移動する時の、ハンドル許容範囲の幅
        /// </summary>
        private const int _EDIT_HANDLE_WIDTH = 7;
        private const int _TOOL_BAR_HEIGHT = 46;
        /// <summary>
        /// 単音プレビュー時に、wave生成完了を待つ最大の秒数
        /// </summary>
        private const double _WAIT_LIMIT = 5.0;
        public const string _APP_NAME = "Cadencii";
        /// <summary>
        /// 表情線の先頭部分のピクセル幅
        /// </summary>
        private const int _PX_ACCENT_HEADER = 21;
        /// <summary>
        /// パフォーマンスカウンタ用バッファの容量
        /// </summary>
        private const int _NUM_PCOUNTER = 50;
        private const string _VERSION_HISTORY_URL = "http://www.ne.jp/asahi/kbinani/home/cadencii/version_history.xml";
        /// <summary>
        /// コントロールカーブが不可視状態における、splitContainer1.Panel2の最小サイズ
        /// </summary>
        private const int _SPL1_PANEL2_MIN_HEIGHT = 34;
        /// <summary>
        /// splitContainer2.Panel2の最小サイズ
        /// </summary>
        private const int _SPL2_PANEL2_MIN_HEIGHT = 25;
        /// <summary>
        /// splitContainer*で使用するSplitterWidthプロパティの値
        /// </summary>
        private const int _SPL_SPLITTER_WIDTH = 4;
        const int _PICT_POSITION_INDICATOR_HEIGHT = 48;
        const int _SCROLL_WIDTH = 16;
        #endregion

        #region Static Field
        /// <summary>
        /// CTRLキー。MacOSXの場合はMenu
        /// </summary>
        private Keys s_modifier_key = Keys.Control;
        #endregion

        #region Fields
        private VersionInfo m_versioninfo = null;
        private Cursor HAND;
        private TextBoxEx m_input_textbox = null;
        /// <summary>
        /// ボタンがDownされた位置。(座標はpictureBox基準)
        /// </summary>
        private Point m_button_initial;
        /// <summary>
        /// 真ん中ボタンがダウンされたときのvscrollのvalue値
        /// </summary>
        private int m_middle_button_vscroll;
        /// <summary>
        /// 真ん中ボタンがダウンされたときのhscrollのvalue値
        /// </summary>
        private int m_middle_button_hscroll;
        private bool m_edited = false;
        /// <summary>
        /// パフォーマンスカウンタ
        /// </summary>
        private float[] m_performance = new float[_NUM_PCOUNTER];
        /// <summary>
        /// 最後にpictureBox1_Paintが実行された時刻
        /// </summary>
        private DateTime m_last_ignitted;
        /// <summary>
        /// パフォーマンスカウンタから算出される画面の更新速度
        /// </summary>
        private float m_fps = 0f;
        /// <summary>
        /// カーブエディタの編集モード
        /// </summary>
        private CurveEditMode m_edit_curve_mode = CurveEditMode.None;
        /// <summary>
        /// ピアノロールの右クリックが表示される直前のマウスの位置
        /// </summary>
        private Point m_cMenuOpenedPosition;
#if USE_DOBJ
        /// <summary>
        /// 画面に描かれるエントリのリスト．trackBar.Valueの変更やエントリの編集などのたびに更新される
        /// </summary>
        private List<List<DrawObject>> m_draw_objects;
#endif
#if VER_2_1
        private List<Dictionary<int, ContextProperty>> m_property_windows = new List<Dictionary<int,ContextProperty>>();
#endif
        /// <summary>
        /// m_draw_objectsを描く際の，最初に検索されるインデクス．
        /// </summary>
        private int[] m_draw_start_index = new int[16] { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
        /// <summary>
        /// トラック名の入力に使用するテキストボックス
        /// </summary>
        private TextBoxEx m_txtbox_track_name;
        /// <summary>
        /// ピアノロールの画面外へのドラッグ時、前回自動スクロール操作を行った時刻
        /// </summary>
        private DateTime m_timer_drag_last_ignitted;
        /// <summary>
        /// ミキサーダイアログ
        /// </summary>
        private FormMixer m_mixer_dlg;
        /// <summary>
        /// 画面外への自動スクロールモード
        /// </summary>
        private ExtDragXMode m_ext_dragx = ExtDragXMode.None;
        private ExtDragYMode m_ext_dragy = ExtDragYMode.None;
        /// <summary>
        /// EditMode=MoveEntryで，移動を開始する直前のマウスの仮想スクリーン上の位置
        /// </summary>
        private Point m_mouse_move_init;
        /// <summary>
        /// EditMode=MoveEntryで，移動を開始する直前のマウスの位置と，音符の先頭との距離(ピクセル)
        /// </summary>
        private int m_mouse_move_offset;
        /// <summary>
        /// マウスが降りた仮想スクリーン上の座標(ピクセル)
        /// </summary>
        private Point m_pointer_mouse_down;
        /// <summary>
        /// マウスが降りていて，かつ範囲選択をしているときに立つフラグ
        /// </summary>
        private bool m_pointer_downed = false;
        /// <summary>
        /// マウスが降りているかどうかを表すフラグ．m_pointer_downedとは別なので注意
        /// </summary>
        private bool m_mouse_downed = false;
        private VsqEvent m_adding;
        private int m_adding_length;
        /// <summary>
        /// テンポ変更の位置を、マウスドラッグで移動させているかどうかを表すフラグ
        /// </summary>
        private bool m_tempo_dragging = false;
        private int m_tempo_dragging_deltaclock = 0;
        /// <summary>
        /// 拍子変更の位置を、マウスドラッグで移動させているかどうかを表すフラグ
        /// </summary>
        private bool m_timesig_dragging = false;
        private int m_timesig_dragging_deltaclock = 0;
        private bool m_mouse_downed_trackselector = false;
        private ExtDragXMode m_ext_dragx_trackselector = ExtDragXMode.None;
        private bool m_mouse_moved = false;
        /// <summary>
        /// マウスホバーを発生させるスレッド
        /// </summary>
        private Thread m_mouse_hover_thread = null;
        private ImeMode m_last_imemode = ImeMode.On;
        private bool m_last_symbol_edit_mode = false;
        /// <summary>
        /// 鉛筆のモード
        /// </summary>
        private PencilMode m_pencil_mode = new PencilMode();
        private bool m_startmark_dragging = false;
        private bool m_endmark_dragging = false;
        /// <summary>
        /// ビブラート範囲を編集中の音符のInternalID
        /// </summary>
        private int m_vibrato_editing_id = -1;
        private EditorManager m_manager = null;
        private TrackSelector trackSelector;
        /// <summary>
        /// このフォームがアクティブ化されているかどうか
        /// </summary>
        private bool m_form_activated = true;
        private GameControlMode m_game_mode = GameControlMode.Disabled;
        /// <summary>
        /// 直接再生モード時の、再生開始した位置の曲頭からの秒数
        /// </summary>
        private float m_direct_play_shift = 0.0f;
        /// <summary>
        /// プレビュー再生の長さ
        /// </summary>
        private double m_preview_ending_time;
        private System.Windows.Forms.Timer m_timer;
        private bool m_last_pov_r = false;
        private bool m_last_pov_l = false;
        private bool m_last_pov_u = false;
        private bool m_last_pov_d = false;
        private bool m_last_btn_x = false;
        private bool m_last_btn_o = false;
        private bool m_last_btn_re = false;
        private bool m_last_btn_tr = false;
        private bool m_last_select = false;
        /// <summary>
        /// 前回ゲームコントローラのイベントを処理した時刻
        /// </summary>
        private DateTime m_last_event_processed;
        /// <summary>
        /// splitContainer2.Panel2を最小化する直前の、splitContainer2.SplitterDistance
        /// </summary>
        private int m_last_splitcontainer2_split_distance = -1;
        private bool m_spacekey_downed = false;
        private MidiInDevice m_midi_in = null;
        private FormMidiImExport m_midi_imexport_dialog = null;
        private Dictionary<EditTool, Cursor> m_cursor = new Dictionary<EditTool, Cursor>();
        private Preference m_preference_dlg;
        //private bool m_rendering_finished = false;
        #endregion

        private delegate void VoidDelegate();

        public FormMain( EditorManager manager ) {
            m_manager = manager;
#if DEBUG
            bocoree.debug.push_log( "FormMain..ctor()" );
            bocoree.debug.push_log( "    " + Environment.OSVersion.ToString() );
            bocoree.debug.push_log( "    FormID=" + m_manager.ID );
            Common.DebugWriteLine( "FormMain..ctor()" );
#endif
            AppManager.BaseFont10Bold = new Font( AppManager.EditorConfig.BaseFontName, 10, FontStyle.Bold );
            AppManager.BaseFont8 = new Font( AppManager.EditorConfig.BaseFontName, 8 );
            AppManager.BaseFont10 = new Font( AppManager.EditorConfig.BaseFontName, 10 );
            AppManager.BaseFont9 = new Font( AppManager.EditorConfig.BaseFontName, 9 );

            s_modifier_key = ((AppManager.EditorConfig.Platform == Platform.Macintosh) ? Keys.Menu : Keys.Control);

            m_manager.SetVsqFile( new VsqFileEx( AppManager.EditorConfig.DefaultSingerName,
                                                 AppManager.EditorConfig.DefaultPreMeasure,
                                                 4,
                                                 4,
                                                 500000 ) );
#if VER_2_1
            InitContextProperty();
#endif

            InitializeComponent();
            trackSelector = new TrackSelector();
            trackSelector.BackColor = Color.FromArgb( 108, 108, 108 );
            trackSelector.CurveVisible = true;
            trackSelector.Location = new Point( 0, 242 );
            trackSelector.Margin = new Padding( 0 );
            trackSelector.Name = "trackSelector";
            trackSelector.SelectedCurve = CurveType.VEL;
            trackSelector.Size = new Size( 446, 250 );
            trackSelector.TabIndex = 0;
            trackSelector.MouseClick += new MouseEventHandler( this.trackSelector_MouseClick );
            trackSelector.SelectedTrackChanged += new BSimpleDelegate<int>( this.trackSelector_SelectedTrackChanged );
            trackSelector.MouseUp += new MouseEventHandler( this.trackSelector_MouseUp );
            trackSelector.MouseDown += new MouseEventHandler( trackSelector_MouseDown );
            trackSelector.SelectedCurveChanged += new BSimpleDelegate<CurveType>( this.trackSelector_SelectedCurveChanged );
            trackSelector.MouseMove += new MouseEventHandler( this.trackSelector_MouseMove );
            trackSelector.RenderRequired += new BSimpleDelegate<int[]>( this.trackSelector_RenderRequired );
            trackSelector.PreviewKeyDown += new PreviewKeyDownEventHandler( this.trackSelector_PreviewKeyDown );
            trackSelector.KeyDown += new KeyEventHandler( anonymousCaptureSpaceKeyDown );
            trackSelector.KeyUp += new KeyEventHandler( anonymousCaptureSpaceKeyUp );
            trackSelector.EditorManager = m_manager;
            UpdateTrackSelectorVisibleCurve();

            stripBtnScroll.Checked = m_manager.AutoScroll;
            ApplySelectedTool();
            ApplyQuantizeMode();

            // Palette Toolの読み込み
            UpdatePaletteTool();

            // toolStipの位置を，前回終了時の位置に戻す
            List<ToolStrip> top = new List<ToolStrip>();
            List<ToolStrip> bottom = new List<ToolStrip>();
            if ( toolStripTool.Parent != null ) {
                if ( toolStripTool.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    toolStripContainer.TopToolStripPanel.Controls.Remove( toolStripTool );
                    top.Add( toolStripTool );
                } else if ( toolStripTool.Parent.Equals( toolStripContainer.BottomToolStripPanel ) ) {
                    toolStripContainer.BottomToolStripPanel.Controls.Remove( toolStripTool );
                    bottom.Add( toolStripTool );
                }
            }
            if ( toolStripMeasure.Parent != null ) {
                if ( toolStripMeasure.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    toolStripContainer.TopToolStripPanel.Controls.Remove( toolStripMeasure );
                    top.Add( toolStripMeasure );
                } else if ( toolStripMeasure.Parent.Equals( toolStripContainer.BottomToolStripPanel ) ) {
                    toolStripContainer.BottomToolStripPanel.Controls.Remove( toolStripMeasure );
                    bottom.Add( toolStripMeasure );
                }
            }
            if ( toolStripPosition.Parent != null ) {
                if ( toolStripPosition.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    toolStripContainer.TopToolStripPanel.Controls.Remove( toolStripPosition );
                    top.Add( toolStripPosition );
                } else if ( toolStripPosition.Parent.Equals( toolStripContainer.BottomToolStripPanel ) ) {
                    toolStripContainer.BottomToolStripPanel.Controls.Remove( toolStripPosition );
                    bottom.Add( toolStripPosition );
                }
            }
            if ( toolStripFile.Parent != null ) {
                if ( toolStripFile.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    toolStripContainer.TopToolStripPanel.Controls.Remove( toolStripFile );
                    top.Add( toolStripFile );
                } else if ( toolStripFile.Parent.Equals( toolStripContainer.BottomToolStripPanel ) ) {
                    toolStripContainer.BottomToolStripPanel.Controls.Remove( toolStripFile );
                    bottom.Add( toolStripFile );
                }
            }
            if ( toolStripPaletteTools.Parent != null ) {
                if ( toolStripPaletteTools.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    toolStripContainer.TopToolStripPanel.Controls.Remove( toolStripPaletteTools );
                    if ( toolStripPaletteTools.Visible ) {
                        top.Add( toolStripPaletteTools );
                    }
                } else if ( toolStripPaletteTools.Parent.Equals( toolStripContainer.BottomToolStripPanel ) ) {
                    toolStripContainer.BottomToolStripPanel.Controls.Remove( toolStripPaletteTools );
                    if ( toolStripPaletteTools.Visible ) {
                        bottom.Add( toolStripPaletteTools );
                    }
                }
            }

            splitContainer1.Panel1.BorderStyle = BorderStyle.None;
            splitContainer1.Panel2.BorderStyle = BorderStyle.None;
            splitContainer1.BackColor = Color.FromArgb( 212, 212, 212 );
            splitContainer2.Panel1.Controls.Add( panel1 );
            panel1.Dock = DockStyle.Fill;
            splitContainer2.Panel2.Controls.Add( panel2 );
            splitContainer2.Panel2.BorderStyle = BorderStyle.FixedSingle;
            splitContainer2.Panel2.BorderColor = Color.FromArgb( 112, 112, 112 );
            splitContainer1.Panel1.Controls.Add( splitContainer2 );
            panel2.Dock = DockStyle.Fill;
            splitContainer2.Dock = DockStyle.Fill;
            splitContainer1.Panel2.Controls.Add( trackSelector );
            trackSelector.Dock = DockStyle.Fill;
            splitContainer1.Dock = DockStyle.Fill;
            splitContainer1.Panel2MinSize = trackSelector.PreferredMinSize;

            // コントロールの位置・サイズを調節
            splitContainer2.Panel1.SuspendLayout();
            panel1.SuspendLayout();
            pictPianoRoll.SuspendLayout();
            vScroll.SuspendLayout();
            // panel1の中身は
            // picturePositionIndicator
            picturePositionIndicator.Left = 0;
            picturePositionIndicator.Top = 0;
            picturePositionIndicator.Width = panel1.Width;
            // pictPianoRoll
            pictPianoRoll.Left = 0;
            pictPianoRoll.Top = picturePositionIndicator.Height;
            pictPianoRoll.Width = panel1.Width - vScroll.Width;
            pictPianoRoll.Height = panel1.Height - picturePositionIndicator.Height - hScroll.Height;
            // vScroll
            vScroll.Left = pictPianoRoll.Width;
            vScroll.Top = picturePositionIndicator.Height;
            vScroll.Height = pictPianoRoll.Height;
            // pictureBox3
            pictureBox3.Left = 0;
            pictureBox3.Top = panel1.Height - hScroll.Height;
            pictureBox3.Height = hScroll.Height;
            // hScroll
            hScroll.Left = pictureBox3.Width;
            hScroll.Top = panel1.Height - hScroll.Height;
            hScroll.Width = panel1.Width - pictureBox3.Width - trackBar.Width - pictureBox2.Width;
            // trackBar
            trackBar.Left = pictureBox3.Width + hScroll.Width;
            trackBar.Top = panel1.Height - hScroll.Height;
            // pictureBox2
            pictureBox2.Left = panel1.Width - vScroll.Width;
            pictureBox2.Top = panel1.Height - hScroll.Height;
            vScroll.ResumeLayout();
            pictPianoRoll.ResumeLayout();
            panel1.ResumeLayout();
            splitContainer2.Panel1.ResumeLayout();

            pictPianoRoll.MouseWheel += new MouseEventHandler( pictPianoRoll_MouseWheel );
            trackSelector.MouseWheel += new MouseEventHandler( trackSelector_MouseWheel );
            picturePositionIndicator.MouseWheel += new MouseEventHandler( picturePositionIndicator_MouseWheel );

            hScroll.Maximum = m_manager.VsqFile.TotalClocks + 240;
            hScroll.SmallChange = 240;
            hScroll.LargeChange = 240 * 4;

            vScroll.Maximum = AppManager.EditorConfig.PxTrackHeight * 128;
            vScroll.SmallChange = 24;
            vScroll.LargeChange = 24 * 4;

            trackSelector.CurveVisible = true;

            // 左上のやつから順に登録
            toolStripTool.Location = AppManager.EditorConfig.ToolEditTool.Location;
            toolStripMeasure.Location = AppManager.EditorConfig.ToolMeasureLocation.Location;
            toolStripPosition.Location = AppManager.EditorConfig.ToolPositionLocation.Location;
            toolStripFile.Location = AppManager.EditorConfig.ToolFileLocation.Location;
            toolStripPaletteTools.Location = AppManager.EditorConfig.ToolPaletteLocation.Location;

            AddToolStripInPositionOrder( toolStripContainer.TopToolStripPanel, top );
            AddToolStripInPositionOrder( toolStripContainer.BottomToolStripPanel, bottom );

            toolStripTool.ParentChanged += new System.EventHandler( this.toolStripEdit_ParentChanged );
            toolStripTool.Move += new System.EventHandler( this.toolStripEdit_Move );
            toolStripMeasure.ParentChanged += new System.EventHandler( this.toolStripMeasure_ParentChanged );
            toolStripMeasure.Move += new System.EventHandler( this.toolStripMeasure_Move );
            toolStripPosition.ParentChanged += new System.EventHandler( this.toolStripPosition_ParentChanged );
            toolStripPosition.Move += new System.EventHandler( this.toolStripPosition_Move );
            toolStripFile.ParentChanged += new EventHandler( toolStripFile_ParentChanged );
            toolStripFile.Move += new EventHandler( toolStripFile_Move );
            toolStripPaletteTools.ParentChanged += new EventHandler( toolStripPaletteTools_ParentChanged );
            toolStripPaletteTools.Move += new EventHandler( toolStripPaletteTools_Move );
            
            m_input_textbox = new TextBoxEx();
            m_input_textbox.Visible = false;
            m_input_textbox.BorderStyle = BorderStyle.None;
            m_input_textbox.Width = 80;
            m_input_textbox.BackColor = Color.White;
            m_input_textbox.AcceptsReturn = true;
            m_input_textbox.Font = new Font( AppManager.EditorConfig.BaseFontName, 9 );
            m_input_textbox.Enabled = false;
            panel1.Controls.Add( m_input_textbox );
            m_input_textbox.Parent = pictPianoRoll;

            int fps = 1000 / AppManager.EditorConfig.MaximumFrameRate;
            timer.Interval = (fps <= 0) ? 1 : fps;
#if DEBUG
            menuHelpDebug.Visible = true;
            //menuWindow.Visible = true;
#endif
            const string _HAND = "AAACAAEAICAAABAAEADoAgAAFgAAACgAAAAgAAAAQAAAAAEABAAAAAAAgAIAAAAAAAAAAAAAAAAAAAAAAAAAA" +
                "AAAgAAAAACAAACAgAAAAACAAIAAgAAAgIAAwMDAAICAgAD/AAAAAP8AAP//AAAAAP8A/wD/AAD//wD///8AAAAAAAAAAAAAAAAAAAA" +
                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA/wAAAAAAAAAAAAAAAAAAD" +
                "//wAAAAAAAAAAAAAAAAAA//8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAP8AAAAA/wAAAAAAAAAAA" +
                "A//AAAAAP/wAAAAAAAAAAAP/wAAAAD/8AAAAAAAAAAAAP8AAAAA/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
                "AAAAAAAAA//8AAAAAAAAAAAAAAAAAAP//AAAAAAAAAAAAAAAAAAAP8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD////////////////////////////////////////////+f////" +
                "D////gf///4H////D///8/z//+H4f//B+D//wfg//+H4f//z/P///w////4H///+B////w////+f//////////////////////////" +
                "//////////////////w==";
            using ( MemoryStream ms = new MemoryStream( Convert.FromBase64String( _HAND ) ) ) {
                HAND = new Cursor( ms );
            }

            waveView.SetManager( m_manager );
            ApplyPlatformDependentShortCut();
        }

        private void commonStripPaletteTool_Clicked( object sender, EventArgs e ) {
            string id = "";  //選択されたツールのID
            if ( sender is ToolStripButton ) {
                ToolStripButton tsb = (ToolStripButton)sender;
                if ( tsb.Tag != null && tsb.Tag is string ) {
                    id = (string)tsb.Tag;
                    m_manager.SelectedPaletteTool = id;
                    m_manager.SelectedTool = EditTool.PaletteTool;
                    tsb.Checked = true;
                }
            } else if ( sender is ToolStripMenuItem ) {
                ToolStripMenuItem tsmi = (ToolStripMenuItem)sender;
                if ( tsmi.Tag != null && tsmi.Tag is string ) {
                    id = (string)tsmi.Tag;
                    m_manager.SelectedPaletteTool = id;
                    m_manager.SelectedTool = EditTool.PaletteTool;
                    tsmi.Checked = true;
                }
            }

            foreach ( ToolStripItem item in toolStripPaletteTools.Items ) {
                if ( item is ToolStripButton ) {
                    ToolStripButton button = (ToolStripButton)item;
                    if ( button.Tag != null && button.Tag is string && ((string)button.Tag == id) ) {
                        button.Checked = true;
                    } else {
                        button.Checked = false;
                    }
                }
            }
            foreach ( ToolStripItem item in cMenuPianoPaletteTool.DropDownItems ) {
                if ( item is ToolStripMenuItem ) {
                    ToolStripMenuItem menu = (ToolStripMenuItem)item;
                    if ( menu.Tag != null && menu.Tag is string && ((string)menu.Tag == id) ) {
                        menu.Checked = true;
                    } else {
                        menu.Checked = false;
                    }
                }
            }
            foreach ( ToolStripItem item in cMenuTrackSelectorPaletteTool.DropDownItems ) {
                if ( item is ToolStripMenuItem ) {
                    ToolStripMenuItem menu = (ToolStripMenuItem)item;
                    if ( menu.Tag != null && menu.Tag is string && ((string)menu.Tag == id) ) {
                        menu.Checked = true;
                    } else {
                        menu.Checked = false;
                    }
                }
            }
        }

        #region m_input_textbox
        private void m_input_textbox_KeyDown( object sender, KeyEventArgs e ) {
#if DEBUG
            Common.DebugWriteLine( "m_input_textbox_KeyDown" );
            Common.DebugWriteLine( "    e.KeyCode=" + e.KeyCode );
#endif
            if ( e.KeyCode == Keys.Tab || e.KeyCode == Keys.Return ) {
                ExecuteLyricChangeCommand();
                int selected = m_manager.Selected;
                int index = -1;
                VsqTrack track = m_manager.VsqFile.Track[selected];
                track.sortEvent();
                if ( e.KeyCode == Keys.Tab ) {
                    int clock = 0;
                    for ( int i = 0; i < track.getEventCount(); i++ ) {
                        VsqEvent item = track.getEvent( i );
                        if ( item.InternalID == m_manager.SelectedEvent.LastSelectedID ) {
                            index = i;
                            clock = item.Clock;
                            break;
                        }
                    }
                    if ( (e.Modifiers & Keys.Shift) == Keys.Shift ) {
                        // 1個前の音符イベントを検索
                        int tindex = -1;
                        for ( int i = track.getEventCount() - 1; i >= 0; i-- ) {
                            VsqEvent ve = track.getEvent( i );
                            if ( ve.ID.type == VsqIDType.Anote && i != index && ve.Clock <= clock ) {
                                tindex = i;
                                break;
                            }
                        }
                        index = tindex;
                    } else {
                        // 1個後の音符イベントを検索
                        int tindex = -1;
                        for ( int i = 0; i < track.getEventCount(); i++ ) {
                            VsqEvent ve = track.getEvent( i );
                            if ( ve.ID.type == VsqIDType.Anote && i != index && ve.Clock >= clock ) {
                                tindex = i;
                                break;
                            }
                        }
                        index = tindex;
                    }
                }
                if ( 0 <= index && index < track.getEventCount() ) {
                    m_manager.ClearSelectedEvent();
                    VsqEvent item = track.getEvent( index );
                    m_manager.AddSelectedEvent( item.InternalID );
                    int x = XCoordFromClocks( item.Clock );
                    int y = YCoordFromNote( item.ID.Note );
                    bool phonetic_symbol_edit_mode = ((TagLyricTextBox)m_input_textbox.Tag).PhoneticSymbolEditMode;
                    ShowInputTextBox( item.ID.LyricHandle.L0.Phrase, 
                                            item.ID.LyricHandle.L0.getPhoneticSymbol(),
                                            new Point( x, y ),
                                            phonetic_symbol_edit_mode );
                    int clWidth = (int)(m_input_textbox.Width / m_manager.ScaleX);
#if DEBUG
                    System.Diagnostics.Debug.WriteLine( "    clWidth=" + clWidth );
#endif
                    // 画面上にm_input_textboxが見えるように，移動
                    const int SPACE = 20;
                    if ( x < AppManager._KEY_LENGTH || pictPianoRoll.Width < x + m_input_textbox.Width ) {
                        int clock, clock_x;
                        if ( x < AppManager._KEY_LENGTH ) {
                            clock = item.Clock;
                            clock_x = AppManager._KEY_LENGTH + SPACE;
                        } else {
                            clock = item.Clock + clWidth;
                            clock_x = pictPianoRoll.Width - SPACE;
                        }
                        double draft_d = (73 - clock_x) / m_manager.ScaleX + clock;
                        if ( draft_d < 0.0 ) {
                            draft_d = 0.0;
                        }
                        int draft = (int)draft_d;
                        if ( draft < hScroll.Minimum ) {
                            draft = hScroll.Minimum;
                        } else if ( hScroll.Maximum < draft ) {
                            draft = hScroll.Maximum;
                        }
                        hScroll.Value = draft;
                    } else {
                        RefreshScreen();
                    }
                } else {
                    HideInputTextBox();
                }
            }
        }

        private void m_input_textbox_KeyUp( object sender, KeyEventArgs e ) {
            if ( (e.KeyCode == Keys.Up || e.KeyCode == Keys.Down) && (Control.ModifierKeys == Keys.Alt) ) {
                if ( m_input_textbox.Enabled ) {
                    FlipInputTextBoxMode();
                }
            } else if ( e.KeyCode == Keys.Escape ) {
                HideInputTextBox();
            }
        }
        
        private void m_input_textbox_ImeModeChanged( object sender, EventArgs e ) {
            m_last_imemode = m_input_textbox.ImeMode;
        }
        #endregion

        private void stripBtnMoveEnd_Click( object sender, EventArgs e ) {
            if ( m_manager.Playing ) {
                m_manager.Playing = false;
            }
            m_manager.CurrentClock = m_manager.VsqFile.TotalClocks;
            EnsureCursorVisible();
            RefreshScreen();
        }

        private void stripBtnMoveTop_Click( object sender, EventArgs e ) {
            if ( m_manager.Playing ) {
                m_manager.Playing = false;
            }
            m_manager.CurrentClock = 0;
            EnsureCursorVisible();
            RefreshScreen();
        }

        private void stripBtnRewind_Click( object sender, EventArgs e ) {
            Rewind();
        }

        private void stripBtnForward_Click( object sender, EventArgs e ) {
            Forward();
        }

        private void m_toolbar_edit_SelectedToolChanged( EditTool tool ) {
            m_manager.SelectedTool = tool;
        }

        private void m_toolbar_measure_EndMarkerClick( object sender, EventArgs e ) {
            m_manager.EndMarkerEnabled = !m_manager.EndMarkerEnabled;
#if DEBUG
            Common.DebugWriteLine( "m_toolbar_measure_EndMarkerClick" );
            Common.DebugWriteLine( "    m_config.EndMarkerEnabled=" + m_manager.EndMarkerEnabled );
#endif
            RefreshScreen();
        }

        private void m_toolbar_measure_StartMarkerClick( object sender, EventArgs e ) {
            m_manager.StartMarkerEnabled = !m_manager.StartMarkerEnabled;
#if DEBUG
            Common.DebugWriteLine( "m_toolbar_measure_StartMarkerClick" );
            Common.DebugWriteLine( "    m_config.StartMarkerEnabled=" + m_manager.StartMarkerEnabled );
#endif
            RefreshScreen();
        }

        private void itm_Click( object sender, EventArgs e ) {
            if ( sender is ToolStripItem ) {
                ToolStripItem item = (ToolStripItem)sender;
                if ( item.Tag is string ) {
                    string filename = (string)item.Tag;
                    OpenVsqCore( filename );
                    RefreshScreen();
                }
            }
        }

        #region m_manager
        private void m_manager_ApplyEditorConfigRequired( object sender, EventArgs e ) {
            ApplyLanguage();
            UpdateTrackSelectorVisibleCurve();
            UpdateScriptShortcut();
#if USE_DOBJ
            UpdateDrawObjectList();
#endif
            RefreshScreen();
        }
        
        private void m_manager_CurrentClockChanged( object sender, EventArgs e ) {
            stripLblBeat.Text = m_manager.PlayPosition.Numerator + "/" + m_manager.PlayPosition.Denominator;
            stripLblTempo.Text = (60e6 / (float)m_manager.PlayPosition.Tempo).ToString( "#.00" );
            stripLblCursor.Text = m_manager.PlayPosition.BarCount + " : " + m_manager.PlayPosition.Beat + " : " + m_manager.PlayPosition.Clock.ToString( "000" );
        }

        private void m_manager_GridVisibleChanged( object sender, EventArgs e ) {
            menuVisualGridline.Checked = m_manager.GridVisible;
            stripBtnGrid.Checked = m_manager.GridVisible;
            cMenuPianoGrid.Checked = m_manager.GridVisible;
        }

        private void m_manager_PreviewAborted( object sender, EventArgs e ) {
#if DEBUG
            Common.DebugWriteLine( "m_manager_PreviewAborted" );
#endif
            if ( m_manager.EditMode == EditMode.Realtime ) {
                m_manager.EditMode = EditMode.None;
            }
            //timer.Enabled = false;
            VSTiProxy.AbortRendering();
            //VSTiProxy.RenderingFinished -= VSTiProxy_RenderingFinished;
            m_manager.FirstBufferWritten = false;
            if ( m_midi_in != null ) {
                m_midi_in.Stop();
            }

            PlaySound.Reset();
            for ( int i = 0; i < m_draw_start_index.Length; i++ ) {
                m_draw_start_index[i] = 0;
            }
        }

        private void m_manager_PreviewStarted( object sender, EventArgs e ) {
#if DEBUG
            Common.DebugWriteLine( "m_config_PreviewStarted" );
#endif
            PlaySound.Reset();
            string renderer = m_manager.VsqFile.Track[m_manager.Selected].getCommon().Version;
            int clock = m_manager.CurrentClock;
            m_direct_play_shift = (float)m_manager.VsqFile.getSecFromClock( clock );
            if ( m_manager.EditMode != EditMode.Realtime ) {
                int selected = m_manager.Selected;
                string tmppath = m_manager.TempWaveDir;

                double amp_master = VocaloSysUtil.getAmplifyCoeffFromFeder( m_manager.VsqFile.Mixer.MasterFeder );
                double pan_left_master = VocaloSysUtil.getAmplifyCoeffFromPanLeft( m_manager.VsqFile.Mixer.MasterPanpot );
                double pan_right_master = VocaloSysUtil.getAmplifyCoeffFromPanRight( m_manager.VsqFile.Mixer.MasterPanpot );

                // 選択されたトラック以外のレンダリングを行う
                List<int> render_all = new List<int>();
                for ( int track = 1; track < m_manager.VsqFile.Track.Count; track++ ) {
                    if ( track == selected || !(m_manager.VsqFile.Track[track].getCommon().PlayMode >= 0) ) {
                        continue;
                    }
                    string file = Path.Combine( tmppath, track + ".wav" );
                    if ( !File.Exists( file ) ) {
                        render_all.Add( track );
                    }
                }
                if ( render_all.Count > 0 ) {
                    Render( render_all.ToArray() );
                }

                List<string> sounds = new List<string>();
                for ( int track = 1; track < m_manager.VsqFile.Track.Count; track++ ) {
                    if ( track == selected || !(m_manager.VsqFile.Track[track].getCommon().PlayMode >= 0) ) {
                        continue;
                    }

                    string file = Path.Combine( tmppath, track + ".wav" );
                    string tmpfile = Path.Combine( tmppath, "temp.wav" );
                    int t_start = m_manager.VsqFile.Track[track].getEditedStart();
                    int t_end = m_manager.VsqFile.Track[track].getEditedEnd();
                    int start = t_start;
                    int end = t_end;

                    sounds.Add( file );
                    // 編集が施された範囲に存在している音符を探し、（音符の末尾と次の音符の先頭の接続を無視した場合の）最長一致範囲を決める
                    int index_start = -1; //startから始まっている音符のインデックス
                    for ( int i = 0; i < m_manager.VsqFile.Track[track].getEventCount(); i++ ) {
                        VsqEvent item = m_manager.VsqFile.Track[track].getEvent( i );
                        if ( item.Clock <= t_start && t_start <= item.Clock + item.ID.Length ) {
                            start = item.Clock;
                            index_start = i;
                            break;
                        }
                    }
                    int index_end = -1;
                    for ( int i = m_manager.VsqFile.Track[track].getEventCount() - 1; i >= 0; i-- ) {
                        VsqEvent item = m_manager.VsqFile.Track[track].getEvent( i );
                        if ( item.Clock <= t_end && t_end <= item.Clock + item.ID.Length ) {
                            end = item.Clock + item.ID.Length;
                            index_end = i;
                            break;
                        }
                    }

                    // 音符の末尾と次の音符の先頭がつながっている場合、レンダリング範囲を広げる
                    if ( index_start >= 0 ) {
                        for ( int i = index_start - 1; i >= 0; i-- ) {
                            VsqEvent ve = m_manager.VsqFile.Track[track].getEvent( i );
                            if ( ve.ID.type == VsqIDType.Anote ) {
                                int endpoint = ve.Clock + ve.ID.Length;
                                if ( endpoint == start ) {
                                    start = ve.Clock;
                                    index_start = i;
                                } else if ( endpoint < start ) {
                                    break;
                                }
                            }
                        }
                    }
                    if ( index_end >= 0 ) {
                        for ( int i = index_end + 1; i < m_manager.VsqFile.Track[track].getEventCount(); i++ ) {
                            VsqEvent ve = m_manager.VsqFile.Track[track].getEvent( i );
                            if ( ve.ID.type == VsqIDType.Anote ) {
                                int startpoint = ve.Clock;
                                if ( end == ve.Clock ) {
                                    end = ve.Clock + ve.ID.Length;
                                    index_end = i;
                                } else if ( end < startpoint ) {
                                    break;
                                }
                            }
                        }
                    }

                    if ( start < end ) {
#if DEBUG
                        Common.DebugWriteLine( "    partial rendering!" );
#endif
                        int temp_premeasure = m_manager.VsqFile.getPresendClockAt( start, AppManager.EditorConfig.PreSendTime ) * 2;
                        bool successed = false;
                        using ( FormSynthesize dlg = new FormSynthesize( m_manager,
                                                                         m_manager.VsqFile,
                                                                         AppManager.EditorConfig.PreSendTime,
                                                                         track,
                                                                         tmpfile,
                                                                         start,
                                                                         end,
                                                                         temp_premeasure ) ) {
                            if ( dlg.ShowDialog() == DialogResult.OK ) {
                                successed = true;
                            }
                        }
                        if ( successed ) {
                            m_manager.VsqFile.Track[track].resetEditedArea();
                            using ( Wave main = new Wave( file ) )
                            using ( Wave temp = new Wave( tmpfile ) ) {
                                double sec_start = m_manager.VsqFile.getSecFromClock( start );
                                double sec_end = m_manager.VsqFile.getSecFromClock( end );

                                main.Replace( temp,
                                              0,
                                              (uint)(sec_start * main.SampleRate),
                                              (uint)((sec_end - sec_start) * temp.SampleRate) );
                                main.Write( file );
                            }
                        }
                    }
                }

                // リアルタイム再生用のデータを準備
                //m_preview_ending_time = m_manager.VsqFile.getSecFromClock( m_manager.VsqFile.TotalClocks ) + 1.0;
                double amp_track = VocaloSysUtil.getAmplifyCoeffFromFeder( m_manager.VsqFile.Mixer.Slave[selected - 1].Feder );
                double pan_left_track = VocaloSysUtil.getAmplifyCoeffFromPanLeft( m_manager.VsqFile.Mixer.Slave[selected - 1].Panpot );
                double pan_right_track = VocaloSysUtil.getAmplifyCoeffFromPanRight( m_manager.VsqFile.Mixer.Slave[selected - 1].Panpot );
                double amp_left = amp_master * amp_track * pan_left_master * pan_left_track;
                double amp_right = amp_master * amp_track * pan_right_master * pan_right_track;
                m_preview_ending_time = m_manager.VsqFile.getSecFromClock( m_manager.VsqFile.TotalClocks ) + 1.0;

                // clock以降に音符があるかどうかを調べる
                int count = 0;
                for ( Iterator itr = m_manager.VsqFile.Track[m_manager.Selected].getNoteEventIterator(); itr.hasNext(); ) {
                    VsqEvent ve = (VsqEvent)itr.next();
                    if ( ve.Clock >= clock ) {
                        count++;
                        break;
                    }
                }

                if ( m_manager.VsqFile.Track[m_manager.Selected].getCommon().PlayMode >= 0 && count > 0 ) {
                    int ms_presend = AppManager.EditorConfig.PreSendTime;
                    if ( renderer.StartsWith( VSTiProxy.RENDERER_UTU0 ) ) {
                        ms_presend = 0;
                    }
#if DEBUG
                    Common.DebugWriteLine( "m_preview_ending_time=" + m_preview_ending_time );
#endif
                    //VSTiProxy.RenderingFinished += VSTiProxy_RenderingFinished;
                    VSTiProxy.Render( m_manager.VsqFile,
                                      selected,
                                      null,
                                      m_direct_play_shift,
                                      m_preview_ending_time,
                                      amp_left,
                                      amp_right,
                                      ms_presend,
                                      true,
                                      sounds.ToArray(),
                                      m_direct_play_shift,
                                      true,
                                      m_manager.TempWaveDir );

                    for ( int i = 0; i < m_draw_start_index.Length; i++ ) {
                        m_draw_start_index[i] = 0;
                    }
                    int clock_now = m_manager.CurrentClock;
                    double sec_now = m_manager.VsqFile.getSecFromClock( clock_now );
                } else {
                    //VSTiProxy.RenderingFinished += VSTiProxy_RenderingFinished;
                    VSTiProxy.Render( new VsqFileEx( "Miku", m_manager.VsqFile.getPreMeasure(), 4, 4, 500000 ),
                                      1,
                                      null,
                                      0,
                                      m_preview_ending_time,
                                      amp_left,
                                      amp_right,
                                      AppManager.EditorConfig.PreSendTime,
                                      true,
                                      sounds.ToArray(),
                                      m_direct_play_shift,
                                      true,
                                      m_manager.TempWaveDir );
                }
            }

            if ( m_manager.EditMode == EditMode.Realtime ) {
                if ( m_midi_in != null ) {
                    m_midi_in.Start();
                }
                m_manager.RendererAvailable = false;
            } else {
                m_manager.RendererAvailable = VSTiProxy.IsRendererAvailable( renderer );
            }
            m_manager.FirstBufferWritten = true;
            m_last_ignitted = DateTime.Now;
            m_manager.PreviewStartedTime = m_last_ignitted;
#if DEBUG
            Common.DebugWriteLine( "    m_manager.Speed=" + m_manager.Speed );
            Common.DebugWriteLine( "    m_config.VsqFile.TotalClocks=" + m_manager.VsqFile.TotalClocks );
            Common.DebugWriteLine( "    total seconds=" + m_manager.VsqFile.getSecFromClock( (int)m_manager.VsqFile.TotalClocks ) );
#endif
            timer.Enabled = true;
        }

        /*void VSTiProxy_RenderingFinished() {
            m_rendering_finished = true;
        }*/

        private void m_manager_SelectedToolChanged( object sender, EventArgs e ) {
            ApplySelectedTool();
        }

        private void m_manager_SelectedEventChanged( bool selected_event_is_null ) {
            menuEditCut.Enabled = !selected_event_is_null;
            menuEditPaste.Enabled = !selected_event_is_null;
            menuEditDelete.Enabled = !selected_event_is_null;
            cMenuPianoCut.Enabled = !selected_event_is_null;
            cMenuPianoCopy.Enabled = !selected_event_is_null;
            cMenuPianoDelete.Enabled = !selected_event_is_null;
            cMenuPianoExpressionProperty.Enabled = !selected_event_is_null;
            //RefreshScreen();
        }
        #endregion

        #region pictPianoRoll
        private void pictPianoRoll_MouseClick( object sender, MouseEventArgs e ) {
#if DEBUG
            Common.DebugWriteLine( "pictPianoRoll_MouseClick" );
#endif
            Keys modefier = Control.ModifierKeys;
            if ( e.Button == MouseButtons.Left ) {
                if ( m_mouse_hover_thread != null ) {
                    m_mouse_hover_thread.Abort();
                }

                // クリック位置にIDが無いかどうかを検査
                Rectangle id_rect;
                VsqEvent item = GetItemAtClickedPosition( e.Location, out id_rect );
#if DEBUG
                Common.DebugWriteLine( "    (item==null)=" + (item == null) );
#endif
                if ( item != null && m_manager.EditMode != EditMode.MoveEntry && m_manager.EditMode != EditMode.EditLeftEdge && m_manager.EditMode != EditMode.EditRightEdge ) {
                    if ( (modefier & Keys.Shift) != Keys.Shift && (modefier & s_modifier_key) != s_modifier_key ) {
                        m_manager.ClearSelectedEvent();
                    }
                    m_manager.AddSelectedEvent( item.InternalID );
                    int selected = m_manager.Selected;
                    int internal_id = item.InternalID;
                    HideInputTextBox();
                    if ( m_manager.SelectedTool == EditTool.Eraser ) {
                        CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandEventDelete( selected, internal_id ) );
                        m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
                        Edited = true;
                        m_manager.ClearSelectedEvent();
                        return;
                    } else if ( m_manager.SelectedTool == EditTool.PaletteTool ) {
                        List<int> internal_ids = new List<int>();
                        foreach ( SelectedEventEntry see in m_manager.SelectedEvent.GetEnumerator() ) {
                            internal_ids.Add( see.Original.InternalID );
                        }
                        MouseButtons btn = e.Button;
                        if ( m_spacekey_downed ) {
                            btn = MouseButtons.Middle;
                        }
                        if ( PaletteToolServer.InvokePaletteTool( m_manager.SelectedPaletteTool, m_manager, m_manager.Selected, internal_ids.ToArray(), btn ) ) {
                            Edited = true;
                            m_manager.ClearSelectedEvent();
                            return;
                        }
                    }
                } else {
                    if ( m_manager.EditMode != EditMode.MoveEntry && m_manager.EditMode != EditMode.EditLeftEdge && m_manager.EditMode != EditMode.EditRightEdge ) {
                        if ( !m_pointer_downed ) {
                            m_manager.ClearSelectedEvent();
                        }
                        HideInputTextBox();
                    }
                    if ( m_manager.SelectedTool == EditTool.Eraser ) {
                        // マウス位置にビブラートの波波があったら削除する
                        int stdx = m_manager.StartToDrawX;
                        int stdy = StartToDrawY;
#if USE_DOBJ
                        for ( int i = 0; i < m_draw_objects[m_manager.Selected - 1].Count; i++ ) {
                            DrawObject dobj = m_draw_objects[m_manager.Selected - 1][i];
                            if ( dobj.pxRectangle.X + dobj.pxRectangle.Width - stdx < 0 ) {
                                continue;
                            } else if ( pictPianoRoll.Width < dobj.pxRectangle.X - stdx ) {
                                break;
                            }
                            Rectangle rc = new Rectangle( dobj.pxRectangle.X + dobj.pxVibratoDelay - stdx,
                                                          dobj.pxRectangle.Y + AppManager.EditorConfig.PxTrackHeight - stdy,
                                                          dobj.pxRectangle.Width - dobj.pxVibratoDelay,
                                                          AppManager.EditorConfig.PxTrackHeight );
#else
                        VsqTrack vsq_track = m_manager.VsqFile.getTrack( m_manager.Selected );
                        float scalex = m_manager.ScaleX;
                        for( Iterator itr0 = vsq_track.getNoteEventIterator(); itr0.hasNext();){
                            VsqEvent evnt = (VsqEvent)itr0.next();
                            if ( evnt.ID.VibratoHandle == null ){
                                continue;
                            }
                            int event_sx = XCoordFromClocks( evnt.Clock );
                            int event_ex = XCoordFromClocks( evnt.Clock + evnt.ID.Length);
                            int vib_sx = XCoordFromClocks( evnt.Clock + evnt.ID.VibratoDelay);
                            Rectangle rc = new Rectangle( vib_sx,
                                                          YCoordFromNote( evnt.ID.Note, stdy ),
                                                          event_ex - vib_sx,
                                                          AppManager.EditorConfig.PxTrackHeight );
#endif
                            if ( IsInRect( e.Location, rc ) ) {
                                //ビブラートの範囲なのでビブラートを消す
                                VsqID item2 = null;
                                int internal_id = -1;
#if USE_DOBJ
                                internal_id = dobj.InternalID;
                                for ( Iterator itr = m_manager.VsqFile.Track[m_manager.Selected].getNoteEventIterator(); itr.hasNext(); ) {
                                    VsqEvent ve = (VsqEvent)itr.next();
                                    if ( ve.InternalID == dobj.InternalID ) {
                                        item2 = (VsqID)ve.ID.Clone();
                                        break;
                                    }
                                }
#else
                                item2 = evnt.ID;
                                internal_id = evnt.InternalID;
#endif
                                if ( item2 != null ) {
                                    item2.VibratoHandle = null;
                                    CadenciiCommand run = new CadenciiCommand(
                                        VsqCommand.generateCommandEventChangeIDContaints( m_manager.Selected,
                                                                                          internal_id,
                                                                                          item2 ) );
                                    m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
                                    Edited = true;
                                }
                                break;
                            }
                        }
                    }
                }
            } else if ( e.Button == MouseButtons.Right ) {
                bool show_context_menu = (e.X > AppManager._KEY_LENGTH);
                if ( m_mouse_hover_thread != null ) {
                    if ( !m_mouse_hover_thread.IsAlive && AppManager.EditorConfig.PlayPreviewWhenRightClick ) {
                        show_context_menu = false;
                    }
                } else {
                    if ( AppManager.EditorConfig.PlayPreviewWhenRightClick ) {
                        show_context_menu = false;
                    }
                }
                show_context_menu = show_context_menu && !m_mouse_moved;
                if ( show_context_menu ) {
                    if ( m_mouse_hover_thread != null ) {
                        m_mouse_hover_thread.Abort();
                    }
                    Rectangle id_rect;
                    VsqEvent item = GetItemAtClickedPosition( e.Location, out id_rect );
                    if ( item != null ) {
                        if ( !m_manager.SelectedEvent.ContainsKey( m_manager.Selected, item.InternalID ) ) {
                            m_manager.ClearSelectedEvent();
                        }
                        m_manager.AddSelectedEvent( item.InternalID );
                    }
                    bool item_is_null = (item == null);
                    cMenuPianoCopy.Enabled = !item_is_null;
                    cMenuPianoCut.Enabled = !item_is_null;
                    cMenuPianoDelete.Enabled = !item_is_null;
                    cMenuPianoImportLyric.Enabled = !item_is_null;
                    cMenuPianoExpressionProperty.Enabled = !item_is_null;

                    int clock = ClockFromXCoord( e.X );
                    cMenuPianoPaste.Enabled = ((AppManager.GetCopiedEvent().Count != 0) && (clock >= m_manager.VsqFile.getPreMeasureClocks()));
                    RefreshScreen();

                    m_cMenuOpenedPosition = e.Location;
                    cMenuPiano.Show( pictPianoRoll, e.Location );
                } else {
#if VER_2_1
                    Rectangle id_rect;
                    VsqEvent item = GetItemAtClickedPosition( m_button_initial, out id_rect );
#if DEBUG
                    Common.DebugWriteLine( "pitcPianoRoll_MouseClick; button is right; (item==null)=" + (item == null) );
#endif
                    if ( item != null ) {
                        int itemx = XCoordFromClocks( item.Clock );
                        int itemy = YCoordFromNote( item.ID.Note );
                        lock ( m_property_windows ) {
                            int width = 100;
                            int height = 100;
                            if ( !m_property_windows[m_manager.Selected - 1].ContainsKey( item.InternalID ) ) {
                                int dx = e.X - m_button_initial.X;
                                int dy = e.Y - m_button_initial.Y;
                                ContextProperty cp = new ContextProperty( item.InternalID );
                                cp.FormClosing += new BSimpleDelegate<int>( commonContextProperty_FormClosing );
                                cp.Bounds = new Rectangle( e.X - width / 2, e.Y - cp.TitleHeight / 2, width, height );
                                cp.Shift = new Point( e.X - width / 2 - itemx, e.Y - cp.TitleHeight / 2 - itemy );
                                cp.Title = item.ID.LyricHandle.L0.Phrase + " [" + item.ID.LyricHandle.L0.getPhoneticSymbol() + "]";
                                m_property_windows[m_manager.Selected - 1].Add( item.InternalID, cp );
                            } else {
                                ContextProperty cp = m_property_windows[m_manager.Selected - 1][item.InternalID];
                                cp.Bounds = new Rectangle( e.X - width / 2, e.Y - cp.TitleHeight / 2, width, height );
                                cp.Shift = new Point( e.X - width / 2 - itemx, e.Y - cp.TitleHeight / 2 - itemy );
                            }
                        }
                    }
#endif
                }
            } else if ( e.Button == MouseButtons.Middle ) {
                if ( m_manager.SelectedTool == EditTool.PaletteTool ) {
                    Rectangle id_rect;
                    VsqEvent item = GetItemAtClickedPosition( e.Location, out id_rect );
                    if ( item != null ) {
                        if ( m_manager.SelectedTool == EditTool.PaletteTool ) {
                            m_manager.ClearSelectedEvent();
                            m_manager.AddSelectedEvent( item.InternalID );
                            List<int> internal_ids = new List<int>();
                            foreach ( SelectedEventEntry see in m_manager.SelectedEvent.GetEnumerator() ) {
                                internal_ids.Add( see.Original.InternalID );
                            }
                            if ( PaletteToolServer.InvokePaletteTool( m_manager.SelectedPaletteTool, m_manager, m_manager.Selected, internal_ids.ToArray(), e.Button ) ) {
                                Edited = true;
                                m_manager.ClearSelectedEvent();
                                return;
                            }
                        }
                    }
                }
            }
        }

#if VER_2_1
        private void commonContextProperty_FormClosing( int internal_id ) {
            lock ( m_property_windows ) {
                if ( m_property_windows[m_manager.Selected - 1].ContainsKey( internal_id ) ) {
                    m_property_windows[m_manager.Selected - 1].Remove( internal_id );
                }
            }
        }
#endif

        private void pictPianoRoll_MouseDoubleClick( object sender, MouseEventArgs e ) {
#if DEBUG
            Common.DebugWriteLine( "pictureBox1_MouseDoubleClick" );
#endif
            Rectangle rect;
            VsqEvent item = GetItemAtClickedPosition( e.Location, out rect );
            if ( item != null ) {
                if ( m_manager.SelectedTool != EditTool.PaletteTool ) {
                    m_manager.ClearSelectedEvent();
                    m_manager.AddSelectedEvent( item.InternalID );
                    m_mouse_hover_thread.Abort();
                    if ( !AppManager.EditorConfig.KeepLyricInputMode ) {
                        m_last_symbol_edit_mode = false;
                    }
                    ShowInputTextBox( item.ID.LyricHandle.L0.Phrase, item.ID.LyricHandle.L0.getPhoneticSymbol(), rect.Location, m_last_symbol_edit_mode );
                    RefreshScreen();
                    return;
                }
            } else {
                m_manager.ClearSelectedEvent();
                HideInputTextBox();
                if ( AppManager.EditorConfig.ShowExpLine && AppManager._KEY_LENGTH <= e.X ) {
                    int stdx = m_manager.StartToDrawX;
                    int stdy = StartToDrawY;
#if USE_DOBJ
                    foreach ( DrawObject dobj in m_draw_objects[m_manager.Selected - 1] ) {
                        // 表情コントロールプロパティを表示するかどうかを決める
                        rect = new Rectangle(
                            dobj.pxRectangle.X - stdx,
                            dobj.pxRectangle.Y - stdy + AppManager.EditorConfig.PxTrackHeight,
                            21,
                            AppManager.EditorConfig.PxTrackHeight );
#else
                    for( Iterator itr = m_manager.VsqFile.getTrack( m_manager.Selected ).getNoteEventIterator(); itr.hasNext(); ){
                        VsqEvent evnt = (VsqEvent)itr.next();
                        int event_ex = XCoordFromClocks( evnt.Clock + evnt.ID.Length );
                        if ( event_ex < 0 ) {
                            continue;
                        }
                        int event_sx = XCoordFromClocks( evnt.Clock );
                        if ( pictPianoRoll.Width < event_sx ) {
                            break;
                        }
                        int vib_sx = XCoordFromClocks( evnt.Clock + evnt.ID.VibratoDelay);
                        int event_sy = YCoordFromNote( evnt.ID.Note, stdy );
                        rect = new Rectangle( event_sx, event_sy, 21, AppManager.EditorConfig.PxTrackHeight );
#endif
                        if ( IsInRect( e.Location, rect ) ) {
                            VsqEvent selected = null;
#if USE_DOBJ
                            for ( Iterator itr = m_manager.VsqFile.Track[m_manager.Selected].getEventIterator(); itr.hasNext(); ) {
                                VsqEvent ev = (VsqEvent)itr.next();
                                if ( ev.InternalID == dobj.InternalID ) {
                                    selected = ev;
                                    break;
                                }
                            }
#else
                            selected = evnt;
#endif
                            if ( selected != null ) {
                                if ( m_mouse_hover_thread != null ) {
                                    m_mouse_hover_thread.Abort();
                                }
                                using ( FormSingerStyleConfig dlg = new FormSingerStyleConfig( _( "Expression control property" ), false ) ) {
                                    dlg.PMBendDepth = selected.ID.PMBendDepth;
                                    dlg.PMBendLength = selected.ID.PMBendLength;
                                    dlg.PMbPortamentoUse = selected.ID.PMbPortamentoUse;
                                    dlg.DEMdecGainRate = selected.ID.DEMdecGainRate;
                                    dlg.DEMaccent = selected.ID.DEMaccent;
                                    dlg.Location = GetFormPreferedLocation( dlg );
                                    if ( dlg.ShowDialog() == DialogResult.OK ) {
                                        VsqID id = (VsqID)selected.ID.Clone();
                                        id.PMBendDepth = dlg.PMBendDepth;
                                        id.PMBendLength = dlg.PMBendLength;
                                        id.PMbPortamentoUse = dlg.PMbPortamentoUse;
                                        id.DEMdecGainRate = dlg.DEMdecGainRate;
                                        id.DEMaccent = dlg.DEMaccent;
                                        CadenciiCommand run = new CadenciiCommand(
                                            VsqCommand.generateCommandEventChangeIDContaints( m_manager.Selected, selected.InternalID, id ) );
                                        m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
                                        Edited = true;
                                        RefreshScreen();
                                    }
                                }
                                return;
                            }
                            break;
                        }

                        // ビブラートプロパティダイアログを表示するかどうかを決める
#if USE_DOBJ
                        rect = new Rectangle( dobj.pxRectangle.X - stdx + 21,
                                              dobj.pxRectangle.Y - stdy + AppManager.EditorConfig.PxTrackHeight,
                                              dobj.pxRectangle.Width - 21,
                                              AppManager.EditorConfig.PxTrackHeight );
#else
                        if ( evnt.ID.VibratoHandle == null ){
                            continue;
                        }
                        rect = new Rectangle( event_sx + 21, 
                                              event_sy + AppManager.EditorConfig.PxTrackHeight,
                                              event_ex - event_sx - 21,
                                              AppManager.EditorConfig.PxTrackHeight );
#endif
                        if ( IsInRect( e.Location, rect ) ) {
                            VsqEvent selected = null;
#if USE_DOBJ
                            for ( Iterator itr = m_manager.VsqFile.Track[m_manager.Selected].getEventIterator(); itr.hasNext(); ) {
                                VsqEvent ev = (VsqEvent)itr.next();
                                if ( ev.InternalID == dobj.InternalID ) {
                                    selected = ev;
                                    break;
                                }
                            }
#else
                            selected = evnt;
#endif
                            if ( selected != null ) {
                                if ( m_mouse_hover_thread != null ) {
                                    m_mouse_hover_thread.Abort();
                                }
                                using ( FormVibratoConfig dlg = new FormVibratoConfig( selected.ID.VibratoHandle, selected.ID.Length, AppManager.EditorConfig.DefaultVibratoLength ) ) {
                                    dlg.Location = GetFormPreferedLocation( dlg );
                                    if ( dlg.ShowDialog() == DialogResult.OK ) {
                                        VsqID t = (VsqID)selected.ID.Clone();
                                        t.VibratoHandle = dlg.VibratoHandle;
                                        if ( t.VibratoHandle != null ) {
                                            int vibrato_length = t.VibratoHandle.Length;
                                            int note_length = selected.ID.Length;
                                            t.VibratoDelay = note_length - vibrato_length;
                                        }
                                        CadenciiCommand run = new CadenciiCommand( 
                                            VsqCommand.generateCommandEventChangeIDContaints( m_manager.Selected,
                                                                                    selected.InternalID,
                                                                                    t ) );
                                        m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
                                        Edited = true;
                                        RefreshScreen();
                                    }
                                }
                                return;
                            }
                            break;
                        }

                    }
                }
            }

            // 必要な操作が何も無ければ，クリック位置にソングポジションを移動
            if ( e.Button == MouseButtons.Left ) {
                int unit = AppManager.GetPositionQuantizeClock();
                int clock = ClockFromXCoord( e.X );
                int odd = clock % unit;
                clock -= odd;
                if ( odd > unit / 2 ) {
                    clock += unit;
                }
                m_manager.CurrentClock = clock;
            }
        }

        private void pictPianoRoll_MouseDown( object sender, MouseEventArgs e ) {
#if DEBUG
            Common.DebugWriteLine( "pictPianoRoll_MouseDown" );
#endif
            if ( m_manager.EditMode == EditMode.Realtime ) {
                return;
            }

#if VER_2_1
            // message passing
            foreach ( ContextProperty cp in m_property_windows[m_manager.Selected - 1].Values ) {
                if ( cp.MouseDown( pictPianoRoll, e ) ) {
                    RefreshScreen();
                    return;
                }
            }
#endif

            m_mouse_moved = false;
            if ( !m_manager.Playing ) {
                int note = NoteFromYCoord( e.Y );
                if ( 0 <= note && note <= 126 && 0 <= e.X && e.X <= AppManager._KEY_LENGTH ) {
                    if ( e.Button == MouseButtons.Left ) {
                        KeySoundPlayer.Play( note );
                    }
                    return;
                }
            }

            m_manager.ClearSelectedTempo();
            m_manager.ClearSelectedTimesig();
            trackSelector.DisableSelectedRegion();
            if ( e.Button == MouseButtons.Left ) {
                m_manager.SelectedRegionEnabled = false;
            }

            m_mouse_downed = true;
            m_button_initial = e.Location;
            Keys modefier = Control.ModifierKeys;
            if ( m_txtbox_track_name != null ) {
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
                m_txtbox_track_name = null;
            }

            Rectangle rect;
            VsqEvent item = GetItemAtClickedPosition( e.Location, out rect );

            if ( item == null && (e.Button == MouseButtons.Middle || m_spacekey_downed) ) {
                m_manager.EditMode = EditMode.MiddleDrag;
                m_middle_button_vscroll = vScroll.Value;
                m_middle_button_hscroll = hScroll.Value;
                //this.Cursor = HAND;
                return;
            }

            EditTool selected_tool = m_manager.SelectedTool;

            // マウス位置にある音符を検索
            if ( item == null ) {   // 音符がなかった時
#if DEBUG
                Common.DebugWriteLine( "    No Event" );
#endif
                if ( m_manager.SelectedEvent.LastSelected != null ) {
                    ExecuteLyricChangeCommand();
                }
                bool start_mouse_hover_generator = true;
                if ( (modefier & s_modifier_key) == s_modifier_key ) {
                    m_manager.SelectedRegionEnabled = true;
                    int stdx = m_manager.StartToDrawX;
                    int x = e.X + stdx;
                    if ( AppManager.EditorConfig.CurveSelectingQuantized ) {
                        int clock = ClockFromXCoord( e.X );
                        int unit = AppManager.GetPositionQuantizeClock();
                        int odd = clock % unit;
                        int nclock = clock;
                        nclock -= odd;
                        if ( odd > unit / 2 ) {
                            nclock += unit;
                        }
                        x = XCoordFromClocks( nclock ) + stdx;
                    }
                    m_manager.SelectedRegion = new SelectedRegion( x );
                    m_manager.SelectedRegion.SetEnd( x );
                    m_pointer_downed = true;
                } else {
                    bool vibrato_found = false;
                    if ( selected_tool == EditTool.Line || selected_tool == EditTool.Pencil ) {
                        // ビブラート範囲の編集
                        int px_vibrato_length = 0;
                        int stdx = m_manager.StartToDrawX;
                        int stdy = StartToDrawY;
                        m_vibrato_editing_id = -1;
#if USE_DOBJ
                        Rectangle pxFound = new Rectangle();
                        for ( int i = 0; i < m_draw_objects[m_manager.Selected - 1].Count; i++ ) {
                            DrawObject dobj = m_draw_objects[m_manager.Selected - 1][i];
                            if ( dobj.pxRectangle.Width <= dobj.pxVibratoDelay ) {
                                continue;
                            }
                            if ( dobj.pxRectangle.X + dobj.pxRectangle.Width - stdx < 0 ) {
                                continue;
                            } else if ( pictPianoRoll.Width < dobj.pxRectangle.X - stdx ) {
                                break;
                            }
                            Rectangle rc = new Rectangle( dobj.pxRectangle.X + dobj.pxVibratoDelay - stdx - _EDIT_HANDLE_WIDTH / 2,
                                                dobj.pxRectangle.Y + AppManager.EditorConfig.PxTrackHeight - stdy,
                                                _EDIT_HANDLE_WIDTH,
                                                AppManager.EditorConfig.PxTrackHeight );
#else
                        int clock = 0;
                        int note = 0;
                        int length = 0;
                        for ( Iterator itr = m_manager.VsqFile.getTrack( m_manager.Selected ).getNoteEventIterator(); itr.hasNext(); ){
                            VsqEvent evnt = (VsqEvent)itr.next();
                            if ( evnt.ID.VibratoHandle == null ){
                                continue;
                            }
                            int event_ex = XCoordFromClocks( evnt.Clock + evnt.ID.Length );
                            if ( event_ex < 0 ) {
                                continue;
                            }
                            int event_sx = XCoordFromClocks( evnt.Clock );
                            if ( pictPianoRoll.Width < event_sx ) {
                                break;
                            }
                            int vib_sx = XCoordFromClocks( evnt.Clock + evnt.ID.VibratoDelay );
                            Rectangle rc = new Rectangle( event_sx - _EDIT_HANDLE_WIDTH / 2,
                                                          YCoordFromNote( evnt.ID.Note ) + AppManager.EditorConfig.PxTrackHeight,
                                                          _EDIT_HANDLE_WIDTH,
                                                          AppManager.EditorConfig.PxTrackHeight );
#endif
                            if ( IsInRect( e.Location, rc ) ) {
                                vibrato_found = true;
#if USE_DOBJ
                                m_vibrato_editing_id = dobj.InternalID;
                                pxFound = dobj.pxRectangle;
                                px_vibrato_length = dobj.pxRectangle.Width - dobj.pxVibratoDelay;
#else
                                m_vibrato_editing_id = evnt.InternalID;
                                clock = evnt.Clock + evnt.ID.VibratoDelay;
                                note = evnt.ID.Note - 1;
                                length = evnt.ID.Length;
                                px_vibrato_length = event_ex - vib_sx;
#endif
                                break;
                            }
                        }
                        if ( vibrato_found ) {
#if USE_DOBJ
                            int clock = ClockFromXCoord( pxFound.X + pxFound.Width - px_vibrato_length - stdx );
                            int note = NoteFromYCoord( pxFound.Y + AppManager.EditorConfig.PxTrackHeight - stdy );
                            int length = (int)(pxFound.Width / m_manager.ScaleX);
#endif
                            m_adding = new VsqEvent( clock, new VsqID( 0 ) );
                            m_adding.ID.type = VsqIDType.Anote;
                            m_adding.ID.Note = note;
                            m_adding.ID.Length = (int)(px_vibrato_length / m_manager.ScaleX);
                            //m_adding.ID.value = length; // 邪道だが、まあいいか
                            m_adding_length = length;
                            m_adding.ID.VibratoDelay = length - (int)(px_vibrato_length / m_manager.ScaleX);
                            m_manager.EditMode = EditMode.EditVibratoDelay;
                            start_mouse_hover_generator = false;
                        }
                    }
                    if ( !vibrato_found ) {
                        if ( (selected_tool == EditTool.Pencil || selected_tool == EditTool.Line) &&
                            e.Button == MouseButtons.Left &&
                            e.X >= AppManager._KEY_LENGTH ) {
                            int clock = ClockFromXCoord( e.X );
                            if ( m_manager.VsqFile.getPreMeasureClocks() - AppManager.EditorConfig.PxTolerance / m_manager.ScaleX <= clock ) { //10ピクセルまでは許容範囲
                                if ( m_manager.VsqFile.getPreMeasureClocks() > clock ) { //だけど矯正するよ。
                                    clock = m_manager.VsqFile.getPreMeasureClocks();
                                }
                                int note = NoteFromYCoord( e.Y );
                                m_manager.ClearSelectedEvent();
                                int unit = AppManager.GetPositionQuantizeClock();
                                int odd = clock % unit;
                                int new_clock = clock - odd;
                                if ( odd > unit / 2 ) {
                                    new_clock += unit;
                                }
                                m_adding = new VsqEvent( new_clock, new VsqID( 0 ) );
                                m_adding.ID.PMBendDepth = AppManager.EditorConfig.DefaultPMBendDepth;
                                m_adding.ID.PMBendLength = AppManager.EditorConfig.DefaultPMBendLength;
                                m_adding.ID.PMbPortamentoUse = AppManager.EditorConfig.DefaultPMbPortamentoUse;
                                m_adding.ID.DEMdecGainRate = AppManager.EditorConfig.DefaultDEMdecGainRate;
                                m_adding.ID.DEMaccent = AppManager.EditorConfig.DefaultDEMaccent;
                                if ( m_pencil_mode.Mode == PencilModeEnum.Off ) {
                                    m_manager.EditMode = EditMode.AddEntry;
                                    m_button_initial = e.Location;
                                    m_adding.ID.Length = 0;
                                    m_adding.ID.Note = note;
                                    Cursor = Cursors.Arrow;
#if DEBUG
                                    Common.DebugWriteLine( "    EditMode=" + m_manager.EditMode );
#endif
                                } else {
                                    m_manager.EditMode = EditMode.AddFixedLengthEntry;
                                    m_adding.ID.Length = m_pencil_mode.GetUnitLength();
                                    m_adding.ID.Note = note;
                                    Cursor = Cursors.Arrow;
                                }
                            } else {
                                SystemSounds.Asterisk.Play();
                            }
                        } else if ( (selected_tool == EditTool.Arrow || selected_tool == EditTool.PaletteTool) && e.Button == MouseButtons.Left ) {
                            m_manager.SelectedRegionEnabled = false;
                            m_manager.ClearSelectedEvent();
                            m_pointer_mouse_down = new Point( e.X + m_manager.StartToDrawX, e.Y + StartToDrawY );
                            m_pointer_downed = true;
#if DEBUG
                            Common.DebugWriteLine( "    EditMode=" + m_manager.EditMode );
#endif
                        }
                    }
                }
                if ( e.Button == MouseButtons.Right && !AppManager.EditorConfig.PlayPreviewWhenRightClick ) {
                    start_mouse_hover_generator = false;
                }
                if ( start_mouse_hover_generator ) {
                    m_mouse_hover_thread = new Thread( new ParameterizedThreadStart( MouseHoverEventGenerator ) );
                    m_mouse_hover_thread.Start( NoteFromYCoord( e.Y ) );
                }
            } else {                // 音符があった時
#if DEBUG
                Common.DebugWriteLine( "    Event Found" );
#endif
                if ( selected_tool != EditTool.Eraser ) {
                    m_mouse_hover_thread = new Thread( new ParameterizedThreadStart( MouseHoverEventGenerator ) );
                    m_mouse_hover_thread.Start( item.ID.Note );
                }
                // まず、両端の編集モードに移行可能かどうか調べる
                if ( selected_tool != EditTool.Eraser && selected_tool != EditTool.PaletteTool && e.Button == MouseButtons.Left ) {
                    int stdx = m_manager.StartToDrawX;
                    int stdy = StartToDrawY;
#if USE_DOBJ
                    foreach ( DrawObject dobj in m_draw_objects[m_manager.Selected - 1] ) {
                        Rectangle rc = new Rectangle( dobj.pxRectangle.X - stdx, dobj.pxRectangle.Y - stdy, _EDIT_HANDLE_WIDTH, dobj.pxRectangle.Height );
#else
                    for( Iterator itr = m_manager.VsqFile.getTrack( m_manager.Selected ).getNoteEventIterator(); itr.hasNext(); ){
                        VsqEvent evnt = (VsqEvent)itr.next();
                        int event_ex = XCoordFromClocks( evnt.Clock + evnt.ID.Length );
                        if ( event_ex < 0 ) {
                            continue;
                        }
                        int event_sx = XCoordFromClocks( evnt.Clock );
                        if ( pictPianoRoll.Width < event_sx ) {
                            break;
                        }
                        int event_sy = YCoordFromNote( evnt.ID.Note, stdy );

                        // 左端
                        Rectangle rc = new Rectangle( event_sx - _EDIT_HANDLE_WIDTH / 2, 
                                                      event_sy,
                                                      _EDIT_HANDLE_WIDTH,
                                                      AppManager.EditorConfig.PxTrackHeight );
#endif
                        if ( IsInRect( e.Location, rc ) ) {
                            m_manager.EditMode = EditMode.EditLeftEdge;
                            if ( !m_manager.SelectedEvent.ContainsKey( m_manager.Selected, item.InternalID ) ) {
                                m_manager.ClearSelectedEvent();
                            }
                            m_manager.AddSelectedEvent( item.InternalID );
                            this.Cursor = Cursors.VSplit;
                            RefreshScreen();
#if DEBUG
                            Common.DebugWriteLine( "    EditMode=" + m_manager.EditMode );
#endif
                            return;
                        }
#if USE_DOBJ
                        rc = new Rectangle( dobj.pxRectangle.X + dobj.pxRectangle.Width - stdx - _EDIT_HANDLE_WIDTH, dobj.pxRectangle.Y - stdy, _EDIT_HANDLE_WIDTH, dobj.pxRectangle.Height );
#else
                        rect = new Rectangle( event_ex - _EDIT_HANDLE_WIDTH / 2,
                                              event_sy,
                                              _EDIT_HANDLE_WIDTH,
                                              AppManager.EditorConfig.PxTrackHeight );
#endif
                        if ( IsInRect( e.Location, rc ) ) {
                            m_manager.EditMode = EditMode.EditRightEdge;
                            if ( !m_manager.SelectedEvent.ContainsKey( m_manager.Selected, item.InternalID ) ) {
                                m_manager.ClearSelectedEvent();
                            }
                            m_manager.AddSelectedEvent( item.InternalID );
                            this.Cursor = Cursors.VSplit;
                            RefreshScreen();
#if DEBUG
                            Common.DebugWriteLine( "    EditMode=" + m_manager.EditMode );
#endif
                            return;
                        }
                    }
                }
                if ( e.Button == MouseButtons.Left || e.Button == MouseButtons.Middle ) {
                    if ( selected_tool == EditTool.PaletteTool ) {
                        m_manager.EditMode = EditMode.None;
                        m_manager.ClearSelectedEvent();
                        m_manager.AddSelectedEvent( item.InternalID );
                    } else if ( selected_tool != EditTool.Eraser ) {
                        m_manager.EditMode = EditMode.MoveEntry;
                        m_mouse_move_init = new Point( e.X + m_manager.StartToDrawX, e.Y + StartToDrawY );
                        int head_x = XCoordFromClocks( item.Clock );
                        m_mouse_move_offset = e.X - head_x;
                        if ( (modefier & Keys.Shift) == Keys.Shift ) {
                            // 範囲選択
                            int last_id = m_manager.SelectedEvent.LastSelectedID;
                            int last_clock = 0;
                            int this_clock = 0;
                            bool this_found = false, last_found = false;
                            for ( Iterator itr = m_manager.VsqFile.Track[m_manager.Selected].getEventIterator(); itr.hasNext(); ) {
                                VsqEvent ev = (VsqEvent)itr.next();
                                if ( ev.InternalID == last_id ) {
                                    last_clock = ev.Clock;
                                    last_found = true;
                                } else if ( ev.InternalID == item.InternalID ) {
                                    this_clock = ev.Clock;
                                    this_found = true;
                                }
                                if ( last_found && this_found ) {
                                    break;
                                }
                            }
                            int start = Math.Min( last_clock, this_clock );
                            int end = Math.Max( last_clock, this_clock );
                            for ( Iterator itr = m_manager.VsqFile.Track[m_manager.Selected].getEventIterator(); itr.hasNext(); ) {
                                VsqEvent ev = (VsqEvent)itr.next();
                                if ( start <= ev.Clock && ev.Clock <= end ) {
                                    m_manager.AddSelectedEvent( ev.InternalID );
                                }
                            }
                            m_manager.AddSelectedEvent( item.InternalID );
                        } else if ( (modefier & s_modifier_key) == s_modifier_key ) {
                            // CTRLキーを押しながら選択／選択解除
                            if ( m_manager.SelectedEvent.ContainsKey( m_manager.Selected, item.InternalID ) ) {
                                m_manager.SelectedEvent.Remove( item.InternalID );
                            } else {
                                m_manager.AddSelectedEvent( item.InternalID );
                            }
                        } else {
                            if ( !m_manager.SelectedEvent.ContainsKey( m_manager.Selected, item.InternalID ) ) {
                                // MouseDownしたアイテムが、まだ選択されていなかった場合。当該アイテム単独に選択しなおす
                                m_manager.ClearSelectedEvent();
                            }
                            m_manager.AddSelectedEvent( item.InternalID );
                        }
                        this.Cursor = Cursors.Hand;
#if DEBUG
                        Common.DebugWriteLine( "    EditMode=" + m_manager.EditMode );
                        Common.DebugWriteLine( "    m_config.SelectedEvent.Count=" + m_manager.SelectedEvent.Count );
#endif
                    }
                }
            }
            RefreshScreen();
        }

        private void pictPianoRoll_MouseMove( object sender, MouseEventArgs e ) {
            if ( !m_mouse_moved && m_manager.EditMode == EditMode.MiddleDrag ) {
                this.Cursor = HAND;
            }
            m_mouse_moved = true;
            if ( !(m_manager.EditMode == EditMode.MiddleDrag) && m_manager.Playing ) {
                return;
            }

#if VER_2_1
            // message passing
            foreach ( ContextProperty cp in m_property_windows[m_manager.Selected - 1].Values ) {
                if ( cp.MouseMove( pictPianoRoll, e ) ) {
                    RefreshScreen();
                    return;
                }
            }
#endif

            if ( m_mouse_hover_thread != null ) {
                m_mouse_hover_thread.Abort();
            }

            int clock = ClockFromXCoord( e.X );
            if ( m_mouse_downed ) {
                if ( m_ext_dragx == ExtDragXMode.None ) {
                    if ( AppManager._KEY_LENGTH > e.X ) {
                        m_ext_dragx = ExtDragXMode.Left;
                    } else if ( pictPianoRoll.Width < e.X ) {
                        m_ext_dragx = ExtDragXMode.Right;
                    }
                } else {
                    if ( AppManager._KEY_LENGTH <= e.X && e.X <= pictPianoRoll.Width ) {
                        m_ext_dragx = ExtDragXMode.None;
                    }
                }

                if ( m_ext_dragy == ExtDragYMode.None ) {
                    if ( 0 > e.Y ) {
                        m_ext_dragy = ExtDragYMode.Up;
                    } else if ( pictPianoRoll.Height < e.Y ) {
                        m_ext_dragy = ExtDragYMode.Down;
                    }
                } else {
                    if ( 0 <= e.Y && e.Y <= pictPianoRoll.Height ) {
                        m_ext_dragy = ExtDragYMode.None;
                    }
                }
            } else {
                m_ext_dragx = ExtDragXMode.None;
                m_ext_dragy = ExtDragYMode.None;
            }

            if ( m_ext_dragx == ExtDragXMode.Right || m_ext_dragx == ExtDragXMode.Left ) {
                DateTime now = DateTime.Now;
                double dt = now.Subtract( m_timer_drag_last_ignitted ).TotalSeconds;
                m_timer_drag_last_ignitted = now;
                int px_move = AppManager.EditorConfig.MouseDragIncrement;
                if ( px_move / dt > AppManager.EditorConfig.MouseDragMaximumRate ) {
                    px_move = (int)(dt * AppManager.EditorConfig.MouseDragMaximumRate);
                }
                double d_draft;
                if ( m_ext_dragx == ExtDragXMode.Right ) {
                    int right_clock = ClockFromXCoord( pictPianoRoll.Width );
                    int dclock = (int)(px_move / m_manager.ScaleX);
                    d_draft = (73 - pictPianoRoll.Width) / m_manager.ScaleX + right_clock + dclock;
                } else {
                    px_move *= -1;
                    int left_clock = ClockFromXCoord( AppManager._KEY_LENGTH );
                    int dclock = (int)(px_move / m_manager.ScaleX);
                    d_draft = (73 - AppManager._KEY_LENGTH) / m_manager.ScaleX + left_clock + dclock;
                }
                if ( d_draft < 0.0 ) {
                    d_draft = 0.0;
                }
                int draft = (int)d_draft;
                if ( hScroll.Maximum < draft ) {
                    if ( m_manager.EditMode == EditMode.AddEntry || m_manager.EditMode == EditMode.MoveEntry || m_manager.EditMode == EditMode.AddFixedLengthEntry ) {
                        hScroll.Maximum = draft;
                    } else {
                        draft = hScroll.Maximum;
                    }
                }
                if ( draft < hScroll.Minimum ) {
                    draft = hScroll.Minimum;
                }
                hScroll.Value = draft;
            }
            if ( m_ext_dragy == ExtDragYMode.Up || m_ext_dragy == ExtDragYMode.Down ) {
                DateTime now = DateTime.Now;
                double dt = now.Subtract( m_timer_drag_last_ignitted ).TotalSeconds;
                m_timer_drag_last_ignitted = now;
                int px_move = AppManager.EditorConfig.MouseDragIncrement;
                if ( px_move / dt > AppManager.EditorConfig.MouseDragMaximumRate ) {
                    px_move = (int)(dt * AppManager.EditorConfig.MouseDragMaximumRate);
                }
                if ( m_ext_dragy == ExtDragYMode.Up ) {
                    px_move *= -1;
                }
                int draft_stdy = StartToDrawY + px_move;
                int draft = (int)((draft_stdy * (double)vScroll.Maximum) / (128.0 * AppManager.EditorConfig.PxTrackHeight - vScroll.Height));
                if ( draft < 0 ) {
                    draft = 0;
                }
                int df = (int)draft;
                if ( df < vScroll.Minimum ) {
                    df = vScroll.Minimum;
                } else if ( vScroll.Maximum < df ) {
                    df = vScroll.Maximum;
                }
                vScroll.Value = df;
            }

            // 選択範囲にあるイベントを選択．
            //int stdx = m_manager.StartToDrawX;
            int stdy = StartToDrawY;
            if ( m_pointer_downed ) {
                if ( m_manager.SelectedRegionEnabled ) {
                    int x = e.X + m_manager.StartToDrawX;
                    if ( AppManager.EditorConfig.CurveSelectingQuantized ) {
                        int clock1 = ClockFromXCoord( e.X );
                        int unit = AppManager.GetPositionQuantizeClock();
                        int odd = clock1 % unit;
                        int nclock = clock1;
                        nclock -= odd;
                        if ( odd > unit / 2 ) {
                            nclock += unit;
                        }
                        x = XCoordFromClocks( nclock ) + m_manager.StartToDrawX;
                    }
                    m_manager.SelectedRegion.SetEnd( x );
                } else {
                    Point mouse = new Point( e.X + m_manager.StartToDrawX, e.Y + StartToDrawY );
                    int tx, ty, twidth, theight;
                    int lx = m_pointer_mouse_down.X;
                    if ( lx < mouse.X ) {
                        tx = lx;
                        twidth = mouse.X - lx;
                    } else {
                        tx = mouse.X;
                        twidth = lx - mouse.X;
                    }
                    int ly = m_pointer_mouse_down.Y;
                    if ( ly < mouse.Y ) {
                        ty = ly;
                        theight = mouse.Y - ly;
                    } else {
                        ty = mouse.Y;
                        theight = ly - mouse.Y;
                    }

                    Rectangle rect = new Rectangle( tx, ty, twidth, theight );
                    m_manager.SelectedEvent.Clear();
                    int internal_id = -1;
#if USE_DOBJ
                    foreach ( DrawObject dobj in m_draw_objects[m_manager.Selected - 1] ) {
                        int x0 = dobj.pxRectangle.X;
                        int x1 = dobj.pxRectangle.X + dobj.pxRectangle.Width;
                        int y0 = dobj.pxRectangle.Y;
                        int y1 = dobj.pxRectangle.Y + dobj.pxRectangle.Height;
                        internal_id = dobj.InternalID;
#else
                    //int stdy = StartToDrawY;
                    for ( Iterator itr = m_manager.VsqFile.getTrack( m_manager.Selected ).getNoteEventIterator(); itr.hasNext(); ){
                        VsqEvent evnt = (VsqEvent)itr.next();
                        int x0 = XCoordFromClocks( evnt.Clock );
                        int x1 = XCoordFromClocks( evnt.Clock + evnt.ID.Length );
                        int y0 = YCoordFromNote( evnt.ID.Note, stdy );
                        int y1 = y0 + AppManager.EditorConfig.PxTrackHeight;
                        internal_id = evnt.InternalID;
#endif
                        if ( x1 < tx ) {
                            continue;
                        }
                        if ( tx + twidth < x0 ) {
                            break;
                        }
                        bool found = IsInRect( new Point( x0, y0 ), rect ) | IsInRect( new Point( x0, y1 ), rect ) | IsInRect( new Point( x1, y0 ), rect ) | IsInRect( new Point( x1, y1 ), rect );
                        if ( found ) {
                            m_manager.AddSelectedEvent( internal_id );
                        } else {
                            if ( x0 <= tx && tx + twidth <= x1 ) {
                                if ( ty < y0 ) {
                                    if ( y0 <= ty + theight ) {
                                        m_manager.AddSelectedEvent( internal_id );
                                    }
                                } else if ( y0 <= ty && ty < y1 ) {
                                    m_manager.AddSelectedEvent( internal_id );
                                }
                            } else if ( y0 <= ty && ty + theight <= y1 ) {
                                if ( tx < x0 ) {
                                    if ( x0 <= tx + twidth ) {
                                        m_manager.AddSelectedEvent( internal_id );
                                    }
                                } else if ( x0 <= tx && tx < x1 ) {
                                    m_manager.AddSelectedEvent( internal_id );
                                }
                            }
                        }
                    }
                }
            }

            if ( m_manager.EditMode == EditMode.MiddleDrag ) {
                #region MiddleDrag
                int dx = e.X - m_button_initial.X;
                int dy = e.Y - m_button_initial.Y;
                double new_vscroll_value = (double)m_middle_button_vscroll - dy * (double)vScroll.Maximum / (128.0 * AppManager.EditorConfig.PxTrackHeight - (double)vScroll.Height);
                double new_hscroll_value = (double)m_middle_button_hscroll - (double)dx / m_manager.ScaleX;
                if ( new_vscroll_value < vScroll.Minimum ) {
                    vScroll.Value = vScroll.Minimum;
                } else if ( vScroll.Maximum < new_vscroll_value ) {
                    vScroll.Value = vScroll.Maximum;
                } else {
                    vScroll.Value = (int)new_vscroll_value;
                }
                if ( new_hscroll_value < hScroll.Minimum ) {
                    hScroll.Value = hScroll.Minimum;
                } else if ( hScroll.Maximum < new_hscroll_value ) {
                    hScroll.Value = hScroll.Maximum;
                } else {
                    hScroll.Value = (int)new_hscroll_value;
                }
                if ( m_manager.Playing ) {
                    return;
                }
                #endregion
                return;
            } else if ( m_manager.EditMode == EditMode.AddEntry ) {
                #region AddEntry
                int unit = AppManager.GetLengthQuantizeClock();
                int length = clock - m_adding.Clock;
                int odd = length % unit;
                int new_length = length - odd;

                if ( unit * m_manager.ScaleX > 10 ) { //これをしないと、グリッド2個分増えることがある
                    int next_clock = ClockFromXCoord( e.X + 10 );
                    int next_length = next_clock - m_adding.Clock;
                    int next_new_length = next_length - (next_length % unit);
                    if ( next_new_length == new_length + unit ) {
                        new_length = next_new_length;
                    }
                }

                if ( new_length <= 0 ) {
                    new_length = 0;
                }
                m_adding.ID.Length = new_length;
                #endregion
            } else if ( m_manager.EditMode == EditMode.MoveEntry ) {
                #region MoveEntry
                if ( m_manager.SelectedEvent.Count > 0 ) {
                    VsqEvent original = m_manager.SelectedEvent.LastSelected.Original;
                    int note = NoteFromYCoord( e.Y );                           // 現在のマウス位置でのnote
                    int note_init = original.ID.Note;
                    int dnote = note - note_init;

                    int tclock = ClockFromXCoord( e.X - m_mouse_move_offset );
                    int clock_init = original.Clock;
                    int dclock = tclock - clock_init;

                    int unit = AppManager.GetPositionQuantizeClock();
                    foreach ( SelectedEventEntry item in m_manager.SelectedEvent.GetEnumerator() ) {
                        int new_clock = item.Original.Clock + dclock;
                        int odd = new_clock % unit;
                        new_clock -= odd;
                        if ( odd > unit / 2 ) {
                            new_clock += unit;
                        }
                        int new_note = item.Original.ID.Note + dnote;
                        item.Editing.Clock = new_clock;
                        item.Editing.ID.Note = new_note;
                    }
                }
                #endregion
            } else if ( m_manager.EditMode == EditMode.EditLeftEdge ) {
                #region EditLeftEdge
                int unit = AppManager.GetLengthQuantizeClock();
                VsqEvent original = m_manager.SelectedEvent.LastSelected.Original;
                int clock_init = original.Clock;
                int dclock = clock - clock_init;
                foreach ( SelectedEventEntry item in m_manager.SelectedEvent.GetEnumerator() ) {
                    int end_clock = item.Original.Clock + item.Original.ID.Length;
                    int new_clock = item.Original.Clock + dclock;
                    int length = end_clock - new_clock;
                    int odd = length % unit;
                    int new_length = length - odd;
                    if ( odd > unit / 2 ) {
                        new_length += unit;
                    }
                    if ( new_length <= 0 ) {
                        new_length = unit;
                    }
                    item.Editing.Clock = end_clock - new_length;
                    item.Editing.ID.Length = new_length;
                }
                #endregion
            } else if ( m_manager.EditMode == EditMode.EditRightEdge ) {
                #region EditRightEdge
                int unit = AppManager.GetLengthQuantizeClock();

                VsqEvent original = m_manager.SelectedEvent.LastSelected.Original;
                int dlength = clock - (original.Clock + original.ID.Length);
                foreach ( SelectedEventEntry item in m_manager.SelectedEvent.GetEnumerator() ) {
                    int length = item.Original.ID.Length + dlength;
                    int odd = length % unit;
                    int new_length = length - odd;
                    if ( odd > unit / 2 ) {
                        new_length += unit;
                    }
                    if ( new_length <= 0 ) {
                        new_length = unit;
                    }
                    item.Editing.ID.Length = new_length;
                }
                #endregion
            } else if ( m_manager.EditMode == EditMode.AddFixedLengthEntry ) {
                #region AddFixedLengthEntry
                int note = NoteFromYCoord( e.Y );
                int unit = AppManager.GetPositionQuantizeClock();
                int new_clock = ClockFromXCoord( e.X );
                int odd = new_clock % unit;
                new_clock -= odd;
                if ( odd > unit / 2 ) {
                    new_clock += unit;
                }
                m_adding.ID.Note = note;
                m_adding.Clock = new_clock;
                #endregion
            } else if ( m_manager.EditMode == EditMode.EditVibratoDelay ) {
                #region EditVibratoDelay
                int new_vibrato_start = clock;
                int old_vibrato_end = m_adding.Clock + m_adding.ID.Length;
                int new_vibrato_length = old_vibrato_end - new_vibrato_start;
                int max_length = (int)(m_adding_length - _PX_ACCENT_HEADER / m_manager.ScaleX);
                if ( max_length < 0 ) {
                    max_length = 0;
                }
                if ( new_vibrato_length > max_length ) {
                    new_vibrato_start = old_vibrato_end - max_length;
                    new_vibrato_length = max_length;
                }
                if ( new_vibrato_length < 0 ) {
                    new_vibrato_start = old_vibrato_end;
                    new_vibrato_length = 0;
                }
                m_adding.Clock = new_vibrato_start;
                m_adding.ID.Length = new_vibrato_length;
                UpdatePositionViewFromMousePosition( clock );
                if ( !timer.Enabled ) {
                    RefreshScreen();
                }
                #endregion
                return;
            }
            UpdatePositionViewFromMousePosition( clock );

            // カーソルの形を決める
            if ( !m_mouse_downed ) {
                bool split_cursor = false;
                bool hand_cursor = false;
                int stdx = m_manager.StartToDrawX;
#if USE_DOBJ
                foreach ( DrawObject dobj in m_draw_objects[m_manager.Selected - 1] ) {
                    // 音符左側の編集領域
#else
                for ( Iterator itr = m_manager.VsqFile.getTrack( m_manager.Selected ).getNoteEventIterator(); itr.hasNext(); ){

#endif
                    Rectangle rc = new Rectangle(
                                        dobj.pxRectangle.X - stdx,
                                        dobj.pxRectangle.Y - stdy,
                                        _EDIT_HANDLE_WIDTH,
                                        AppManager.EditorConfig.PxTrackHeight );
                    if ( IsInRect( e.Location, rc ) ) {
                        split_cursor = true;
                        break;
                    }

                    // 音符右側の編集領域
                    rc = new Rectangle( dobj.pxRectangle.X + dobj.pxRectangle.Width - stdx - _EDIT_HANDLE_WIDTH,
                                        dobj.pxRectangle.Y - stdy,
                                        _EDIT_HANDLE_WIDTH,
                                        AppManager.EditorConfig.PxTrackHeight );
                    if ( IsInRect( e.Location, rc ) ) {
                        split_cursor = true;
                        break;
                    }

                    // 音符本体
                    rc = new Rectangle( dobj.pxRectangle.X - stdx,
                                        dobj.pxRectangle.Y - stdy,
                                        dobj.pxRectangle.Width,
                                        dobj.pxRectangle.Height );
                    if ( AppManager.EditorConfig.ShowExpLine && !dobj.Overwrapped ) {
                        rc.Height *= 2;
                        if ( IsInRect( e.Location, rc ) ) {
                            // ビブラートの開始位置
                            rc = new Rectangle( dobj.pxRectangle.X + dobj.pxVibratoDelay - stdx - _EDIT_HANDLE_WIDTH / 2,
                                                dobj.pxRectangle.Y + AppManager.EditorConfig.PxTrackHeight - stdy,
                                                _EDIT_HANDLE_WIDTH,
                                                AppManager.EditorConfig.PxTrackHeight );
                            if ( IsInRect( e.Location, rc ) ) {
                                split_cursor = true;
                                break;
                            } else {
                                hand_cursor = true;
                                break;
                            }
                        }
                    } else {
                        if ( IsInRect( e.Location, rc ) ) {
                            hand_cursor = true;
                            break;
                        }
                    }
                }

                if ( split_cursor ) {
                    this.Cursor = Cursors.VSplit;
                } else if ( hand_cursor ) {
                    this.Cursor = Cursors.Hand;
                } else {
                    this.Cursor = Cursors.Default;
                }
            }
            if ( !timer.Enabled ) {
                RefreshScreen();
            }
        }

        private void pictPianoRoll_MouseUp( object sender, MouseEventArgs e ) {
#if DEBUG
            Common.DebugWriteLine( "pictureBox1_MouseUp" );
            Common.DebugWriteLine( "    m_config.EditMode=" + m_manager.EditMode );
#endif
            m_pointer_downed = false;
            m_mouse_downed = false;

#if VER_2_1
            // message passing
            foreach ( ContextProperty cp in m_property_windows[m_manager.Selected - 1].Values ) {
                if ( cp.MouseUp( pictPianoRoll, e ) ) {
                    RefreshScreen();
                    return;
                }
            }
#endif

            Keys modefier = Control.ModifierKeys;
            if ( m_manager.EditMode == EditMode.MiddleDrag ) {
                this.Cursor = Cursors.Default;
            } else if ( m_manager.EditMode == EditMode.AddEntry || m_manager.EditMode == EditMode.AddFixedLengthEntry ) {
                #region AddEntry || AddFixedLengthEntry
                if ( m_manager.Selected >= 0 ) {
                    if ( (m_manager.EditMode == EditMode.AddFixedLengthEntry) ||
                         (m_manager.EditMode == EditMode.AddEntry && (m_button_initial.X != e.X || m_button_initial.Y != e.Y) && m_adding.ID.Length > 0) ) {
                        LyricHandle lyric = new LyricHandle( "a", "a" );
                        VibratoHandle vibrato = null;
                        int vibrato_delay = 0;
                        if ( AppManager.EditorConfig.EnableAutoVibrato ) {
                            int note_length = m_adding.ID.Length;
                            // 音符位置での拍子を調べる
                            int denom, numer;
                            m_manager.VsqFile.getTimesigAt( m_adding.Clock, out numer, out denom );

                            // ビブラートを自動追加するかどうかを決める閾値
                            int threshold = 480 * 4 / denom * (int)AppManager.EditorConfig.AutoVibratoMinimumLength;
                            if ( note_length >= threshold ) {
                                int vibrato_clocks = 0;
                                switch ( AppManager.EditorConfig.DefaultVibratoLength ) {
                                    case DefaultVibratoLength.L100:
                                        vibrato_clocks = note_length;
                                        break;
                                    case DefaultVibratoLength.L50:
                                        vibrato_clocks = note_length / 2;
                                        break;
                                    case DefaultVibratoLength.L66:
                                        vibrato_clocks = note_length * 2 / 3;
                                        break;
                                    case DefaultVibratoLength.L75:
                                        vibrato_clocks = note_length * 3 / 4;
                                        break;
                                }
                                vibrato = VibratoTypeUtil.getDefaultVibratoHandle( AppManager.EditorConfig.AutoVibratoType, vibrato_clocks );
                                vibrato_delay = note_length - vibrato_clocks;
                            }
                        }

                        // 自動ノーマライズのモードで、処理を分岐
                        if ( m_manager.AutoNormalize ) {
                            VsqTrack work = (VsqTrack)m_manager.VsqFile.Track[m_manager.Selected].Clone();
                            m_adding.ID.type = VsqIDType.Anote;
                            m_adding.ID.Dynamics = 64;
                            m_adding.ID.VibratoHandle = vibrato;
                            m_adding.ID.LyricHandle = lyric;
                            m_adding.ID.VibratoDelay = vibrato_delay;
                            //m_adding.InternalID = work.GetNextId( 0 );
                            bool changed = true;
                            while ( changed ) {
                                changed = false;
                                for ( int i = 0; i < work.getEventCount(); i++ ) {
                                    int start_clock = work.getEvent( i ).Clock;
                                    int end_clock = work.getEvent( i ).ID.Length + start_clock;
                                    if ( start_clock < m_adding.Clock && m_adding.Clock < end_clock ) {
                                        work.getEvent( i ).ID.Length = m_adding.Clock - start_clock;
                                        changed = true;
                                    } else if ( start_clock == m_adding.Clock ) {
                                        work.removeEvent( i );
                                        changed = true;
                                        break;
                                    } else if ( m_adding.Clock < start_clock && start_clock < m_adding.Clock + m_adding.ID.Length ) {
                                        m_adding.ID.Length = start_clock - m_adding.Clock;
                                        changed = true;
                                    }
                                }
                            }
                            work.addEvent( (VsqEvent)m_adding.Clone() );
                            CadenciiCommand run = VsqFileEx.generateCommandTrackReplace( m_manager.Selected, 
                                                                                         work,
                                                                                         m_manager.VsqFile.AttachedCurves[m_manager.Selected - 1], 
                                                                                         m_manager.VsqFile.getPitchCurve( m_manager.Selected ) );
                            m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
                            Edited = true;
                        } else {
                            VsqEvent[] items = new VsqEvent[1];
                            m_adding.ID.type = VsqIDType.Anote;
                            m_adding.ID.Dynamics = 64;
                            items[0] = new VsqEvent( 0, m_adding.ID );
                            items[0].Clock = m_adding.Clock;
                            items[0].ID.LyricHandle = lyric;
                            items[0].ID.VibratoDelay = vibrato_delay;
                            items[0].ID.VibratoHandle = vibrato;
#if DEBUG
                            Common.DebugWriteLine( "        items[0].ID.ToString()=" + items[0].ID.ToString() );
#endif
                            CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandEventAddRange( m_manager.Selected, items ) );
                            m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
                            Edited = true;
                        }
                    }
                }
                #endregion
            } else if ( m_manager.EditMode == EditMode.MoveEntry ) {
                #region MoveEntry
#if DEBUG
                Common.DebugWriteLine( "    m_config.SelectedEvent.Count=" + m_manager.SelectedEvent.Count );
#endif
                if ( m_manager.SelectedEvent.Count > 0 ) {
                    VsqEvent original = m_manager.SelectedEvent.LastSelected.Original;
                    if ( original.Clock != m_manager.SelectedEvent.LastSelected.Editing.Clock || original.ID.Note != m_manager.SelectedEvent.LastSelected.Editing.ID.Note ) {
                        int count = m_manager.SelectedEvent.Count;
                        int[] ids = new int[count];
                        int[] clocks = new int[count];
                        VsqID[] values = new VsqID[count];
                        int i = -1;
                        bool out_of_range = false;
                        foreach ( SelectedEventEntry ev in m_manager.SelectedEvent.GetEnumerator() ) {
                            i++;
                            ids[i] = ev.Original.InternalID;
                            clocks[i] = ev.Editing.Clock;
                            if ( clocks[i] < m_manager.VsqFile.getPreMeasureClocks() ) {
                                out_of_range = true;
                            }
                            values[i] = ev.Editing.ID;
                            if ( values[i].Note < 0 || 128 < values[i].Note ) {
                                out_of_range = true;
                            }
                        }
                        if ( !out_of_range ) {
                            CadenciiCommand run = new CadenciiCommand(
                                VsqCommand.generateCommandEventChangeClockAndIDContaintsRange( m_manager.Selected,
                                                                                     ids,
                                                                                     clocks,
                                                                                     values ) );
                            m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
                            Edited = true;
                        } else {
                            SystemSounds.Asterisk.Play();
                        }
                    } else {
                        /*if ( (modefier & Keys.Shift) == Keys.Shift || (modefier & Keys.Control) == Keys.Control ) {
                            Rectangle rc;
                            VsqEvent select = IdOfClickedPosition( e.Location, out rc );
                            if ( select != null ) {
                                m_config.addSelectedEvent( item.InternalID );
                            }
                        }*/
                    }
                }
                #endregion
            } else if ( m_manager.EditMode == EditMode.EditLeftEdge ) {
                #region EditLeftEdge
                VsqEvent original = m_manager.SelectedEvent.LastSelected.Original;
                if ( original.Clock != m_manager.SelectedEvent.LastSelected.Editing.Clock ||
                    original.ID.Length != original.ID.Length ) {
                    int count = m_manager.SelectedEvent.Count;
                    int[] ids = new int[count];
                    int[] clocks = new int[count];
                    VsqID[] values = new VsqID[count];
                    int i = -1;
                    foreach ( SelectedEventEntry ev in m_manager.SelectedEvent.GetEnumerator() ) {
                        i++;
                        if ( ev.Editing.ID.VibratoHandle == null ) {
                            ids[i] = ev.Original.InternalID;
                            clocks[i] = ev.Editing.Clock;
                            values[i] = ev.Editing.ID;
                        } else {
                            int draft_vibrato_length = ev.Editing.ID.Length - ev.Editing.ID.VibratoDelay;
                            if ( draft_vibrato_length <= 0 ) {
                                // ビブラートを削除
                                ev.Editing.ID.VibratoHandle = null;
                                ev.Editing.ID.VibratoDelay = 0;
                            } else {
                                // ビブラートは温存
                                ev.Editing.ID.VibratoHandle.Length = draft_vibrato_length;
                            }
                            ids[i] = ev.Original.InternalID;
                            clocks[i] = ev.Editing.Clock;
                            values[i] = ev.Editing.ID;
                        }
                    }
                    CadenciiCommand run = new CadenciiCommand(
                        VsqCommand.generateCommandEventChangeClockAndIDContaintsRange( m_manager.Selected,
                                                                             ids,
                                                                             clocks,
                                                                             values ) );
                    m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
                    Edited = true;
                }
                #endregion
            } else if ( m_manager.EditMode == EditMode.EditRightEdge ) {
                #region EditRightEdge
                VsqEvent original = m_manager.SelectedEvent.LastSelected.Original;
                if ( original.ID.Length != m_manager.SelectedEvent.LastSelected.Editing.ID.Length ) {
                    int count = m_manager.SelectedEvent.Count;
                    int[] ids = new int[count];
                    int[] clocks = new int[count];
                    VsqID[] values = new VsqID[count];
                    int i = -1;
                    foreach ( SelectedEventEntry ev in m_manager.SelectedEvent.GetEnumerator() ) {
                        i++;
                        if ( ev.Editing.ID.VibratoHandle == null ) {
                            ids[i] = ev.Original.InternalID;
                            clocks[i] = ev.Editing.Clock;
                            values[i] = ev.Editing.ID;
                        } else {
                            int draft_vibrato_length = ev.Editing.ID.Length - ev.Editing.ID.VibratoDelay;
                            if ( draft_vibrato_length <= 0 ) {
                                // ビブラートを削除
                                ev.Editing.ID.VibratoHandle = null;
                                ev.Editing.ID.VibratoDelay = 0;
                            } else {
                                // ビブラートは温存
                                ev.Editing.ID.VibratoHandle.Length = draft_vibrato_length;
                            }
                            ids[i] = ev.Original.InternalID;
                            clocks[i] = ev.Editing.Clock;
                            values[i] = ev.Editing.ID;
                        }
                    }
                    CadenciiCommand run = new CadenciiCommand(
                        VsqCommand.generateCommandEventChangeClockAndIDContaintsRange( m_manager.Selected,
                                                                             ids,
                                                                             clocks,
                                                                             values ) );
                    m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
                    Edited = true;
                }
                #endregion
            } else if ( m_manager.EditMode == EditMode.EditVibratoDelay ) {
                #region EditVibratoDelay
                if ( m_mouse_moved ) {
                    double max_length = m_adding_length - _PX_ACCENT_HEADER / m_manager.ScaleX;
                    double rate = m_adding.ID.Length / max_length;
                    if ( rate > 0.99 ) {
                        rate = 1.0;
                    }
                    int vibrato_length = (int)(m_adding_length * rate);
                    VsqEvent item = null;
                    for ( Iterator itr = m_manager.VsqFile.Track[m_manager.Selected].getNoteEventIterator(); itr.hasNext(); ) {
                        VsqEvent ve = (VsqEvent)itr.next();
                        if ( ve.InternalID == m_vibrato_editing_id ) {
                            item = (VsqEvent)ve.Clone();
                            break;
                        }
                    }
                    if ( item != null ) {
                        if ( vibrato_length <= 0 ) {
                            item.ID.VibratoHandle = null;
                            item.ID.VibratoDelay = item.ID.Length;
                        } else {
                            item.ID.VibratoHandle.Length = vibrato_length;
                            item.ID.VibratoDelay = item.ID.Length - vibrato_length;
                        }
                        CadenciiCommand run = new CadenciiCommand(
                            VsqCommand.generateCommandEventChangeIDContaints( m_manager.Selected, m_vibrato_editing_id, item.ID ) );
                        m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
                        Edited = true;
                    }
                }
                #endregion
            } else if ( m_manager.SelectedRegionEnabled ) {
                int stdx = m_manager.StartToDrawX;
                int start = ClockFromXCoord( m_manager.SelectedRegion.Start - stdx );
                int end = ClockFromXCoord( m_manager.SelectedRegion.End - stdx );
                m_manager.ClearSelectedEvent();
                for ( Iterator itr = m_manager.VsqFile.Track[m_manager.Selected].getEventIterator(); itr.hasNext(); ) {
                    VsqEvent ve = (VsqEvent)itr.next();
                    if ( start <= ve.Clock && ve.Clock <= end ) {
                        m_manager.AddSelectedEvent( ve.InternalID );
                    }
                }
            }
            RefreshScreen();
            if ( m_manager.EditMode != EditMode.Realtime ) {
                m_manager.EditMode = EditMode.None;
            }
        }

        private void pictPianoRoll_MouseWheel( object sender, MouseEventArgs e ) {
            bool horizontal = (Control.ModifierKeys & Keys.Shift) == Keys.Shift;
            if( AppManager.EditorConfig.ScrollHorizontalOnWheel ){
                horizontal = !horizontal;
            }
            if ( horizontal ) {
                hScroll.Value = NewHScrollValueFromWheelDelta( e.Delta );
            } else {
                double new_val = (double)vScroll.Value - e.Delta;
                if ( new_val > vScroll.Maximum ) {
                    vScroll.Value = vScroll.Maximum;
                } else if ( new_val < vScroll.Minimum ) {
                    vScroll.Value = vScroll.Minimum;
                } else {
                    vScroll.Value = (int)new_val;
                }
            }
            RefreshScreen();
        }

        private void pictPianoRoll_Paint( object sender, PaintEventArgs e ) {
            DrawTo( e.Graphics, pictPianoRoll.Size, pictPianoRoll.PointToClient( Control.MousePosition ) );

            // マーカー
            int marker_x = (int)(m_manager.CurrentClock * m_manager.ScaleX + 6 + AppManager._KEY_LENGTH - m_manager.StartToDrawX);
            if ( AppManager._KEY_LENGTH <= marker_x && marker_x <= pictPianoRoll.Width ) {
                e.Graphics.DrawLine( new Pen( Color.White, 2f ),
                                     new Point( marker_x, 0 ),
                                     new Point( marker_x, pictPianoRoll.Height ) );
            }


            DateTime dnow = DateTime.Now;
            for ( int i = 0; i < _NUM_PCOUNTER - 1; i++ ) {
                m_performance[i] = m_performance[i + 1];
            }
            m_performance[_NUM_PCOUNTER - 1] = (float)dnow.Subtract( m_last_ignitted ).TotalSeconds;
            m_last_ignitted = dnow;
            float sum = 0f;
            for ( int i = 0; i < _NUM_PCOUNTER; i++ ) {
                sum += m_performance[i];
            }
            m_fps = _NUM_PCOUNTER / sum;

            if ( m_manager.SelectedRegionEnabled ) {
                int stdx = m_manager.StartToDrawX;
                int start = m_manager.SelectedRegion.Start - stdx;
                int end = m_manager.SelectedRegion.End - stdx;
                e.Graphics.FillRectangle(
                    s_brs_a098_000_000_000,
                    new Rectangle( start, 0, end - start, pictPianoRoll.Height ) );
            } else if ( m_pointer_downed ) {
                Point mouse = pictPianoRoll.PointToClient( Control.MousePosition );
                int tx, ty, twidth, theight;
                int lx = m_pointer_mouse_down.X - m_manager.StartToDrawX;
                if ( lx < mouse.X ) {
                    tx = lx;
                    twidth = mouse.X - lx;
                } else {
                    tx = mouse.X;
                    twidth = lx - mouse.X;
                }
                int ly = m_pointer_mouse_down.Y - StartToDrawY;
                if ( ly < mouse.Y ) {
                    ty = ly;
                    theight = mouse.Y - ly;
                } else {
                    ty = mouse.Y;
                    theight = ly - mouse.Y;
                }
                if ( tx < AppManager._KEY_LENGTH ) {
                    int txold = tx;
                    tx = AppManager._KEY_LENGTH;
                    twidth -= (tx - txold);
                }
                Rectangle rc = new Rectangle( tx, ty, twidth, theight );
                Pen pen = new Pen( Color.FromArgb( 200, Color.Black ) );
                pen.LineJoin = System.Drawing.Drawing2D.LineJoin.Round;
                e.Graphics.FillRectangle( new SolidBrush( Color.FromArgb( 100, Color.Black ) ), rc );
                e.Graphics.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.AntiAlias;
                e.Graphics.DrawRectangle( pen, rc );
            }
#if MONITOR_FPS
            e.Graphics.DrawString(
                m_fps.ToString( "000.000" ),
                new Font( "Verdana", 40, FontStyle.Bold ),
                Brushes.Red,
                new PointF( 0, 0 ) );
#endif
        }

        private void pictPianoRoll_PreviewKeyDown( object sender, PreviewKeyDownEventArgs e ) {
#if DEBUG
            System.Diagnostics.Debug.WriteLine( "pictureBox1_PreviewKeyDown" );
            System.Diagnostics.Debug.WriteLine( "    e.KeyCode=" + e.KeyCode );
#endif
            if ( e.KeyCode == Keys.Tab && m_manager.SelectedEvent.Count > 0 ) {
                VsqEvent original = m_manager.SelectedEvent.LastSelected.Original;
                if ( original == null ) {
                    return;
                }
                int x = XCoordFromClocks( original.Clock );
                int y = YCoordFromNote( original.ID.Note );
                if ( !AppManager.EditorConfig.KeepLyricInputMode ) {
                    m_last_symbol_edit_mode = false;
                }
                ShowInputTextBox( original.ID.LyricHandle.L0.Phrase, original.ID.LyricHandle.L0.getPhoneticSymbol(), new Point( x, y ), m_last_symbol_edit_mode );
                e.IsInputKey = true;
                RefreshScreen();
            }
            ProcessSpecialShortcutKey( e );
        }
        #endregion

        #region menuVisual*
        private void menuVisualMixer_Click( object sender, EventArgs e ) {
            menuVisualMixer.Checked = !menuVisualMixer.Checked;
            AppManager.EditorConfig.MixerVisible = menuVisualMixer.Checked;
            m_mixer_dlg.Visible = AppManager.EditorConfig.MixerVisible;
            this.Focus();
        }

        private void menuVisualGridline_CheckedChanged( object sender, EventArgs e ) {
            m_manager.GridVisible = menuVisualGridline.Checked;
            RefreshScreen();
        }

        private void menuVisualLyrics_CheckedChanged( object sender, EventArgs e ) {
            AppManager.EditorConfig.ShowLyric = menuVisualLyrics.Checked;
        }

        private void menuVisualNoteProperty_CheckedChanged( object sender, EventArgs e ) {
            AppManager.EditorConfig.ShowExpLine = menuVisualNoteProperty.Checked;
        }

        private void menuVisualControlTrack_CheckedChanged( object sender, EventArgs e ) {
            trackSelector.CurveVisible = menuVisualControlTrack.Checked;
            if ( menuVisualControlTrack.Checked ) {
                splitContainer1.IsSplitterFixed = false;
                splitContainer1.SplitterDistance = splitContainer1.Height - trackSelector.PreferredMinSize - splitContainer1.SplitterWidth;
                splitContainer1.Panel2MinSize = trackSelector.PreferredMinSize;
            } else {
                splitContainer1.IsSplitterFixed = true;
                splitContainer1.Panel2MinSize = _SPL1_PANEL2_MIN_HEIGHT;
                splitContainer1.SplitterDistance = splitContainer1.Height - _SPL1_PANEL2_MIN_HEIGHT - splitContainer1.SplitterWidth;
            }
            RefreshScreen();
        }

        private void menuHiddenVisualForwardParameter_Click( object sender, EventArgs e ) {
            trackSelector.SelectNextCurve();
        }

        private void menuHiddenVisualBackwardParameter_Click( object sender, EventArgs e ) {
            trackSelector.SelectPreviousCurve();
        }

        private void menuVisualWaveform_CheckedChanged( object sender, EventArgs e ) {
            AppManager.EditorConfig.ViewWaveform = menuVisualWaveform.Checked;
            UpdateSplitContainer2Size();
        }
        #endregion

        #region m_mixer_dlg
        private void m_mixer_dlg_SoloChanged( int track, bool solo ) {
#if DEBUG
            Common.DebugWriteLine( "m_mixer_dlg_SoloChanged" );
            Common.DebugWriteLine( "    track=" + track );
            Common.DebugWriteLine( "    solo=" + solo );
#endif
            if ( track > 0 ) {
                m_manager.VsqFile.Mixer.Slave[track - 1].Solo = solo ? 1 : 0;
            }
        }

        private void m_mixer_dlg_MuteChanged( int track, bool mute ) {
#if DEBUG
            Common.DebugWriteLine( "m_mixer_dlg_MuteChanged" );
            Common.DebugWriteLine( "    track=" + track );
            Common.DebugWriteLine( "    mute=" + mute );
#endif
            if ( track > 0 ) {
                m_manager.VsqFile.Mixer.Slave[track - 1].Mute = mute ? 1 : 0;
            } else {
                m_manager.VsqFile.Mixer.MasterMute = mute ? 1 : 0;
            }
        }

        private void m_mixer_dlg_PanpotChanged( int track, int panpot ) {
            if ( track > 0 ) {
                // slave
                m_manager.VsqFile.Mixer.Slave[track - 1].Panpot = panpot;
            } else {
                // master
                m_manager.VsqFile.Mixer.MasterPanpot = panpot;
            }
        }

        private void m_mixer_dlg_FederChanged( int track, int feder ) {
            if ( track > 0 ) {
                m_manager.VsqFile.Mixer.Slave[track - 1].Feder = feder;
            } else {
                m_manager.VsqFile.Mixer.MasterFeder = feder;
            }
        }

        private void m_mixer_dlg_TopMostChanged( bool arg ) {
            AppManager.EditorConfig.MixerTopMost = arg;
        }
        #endregion

        #region FormMain
        private void FormMain_FormClosed( object sender, FormClosedEventArgs e ) {
            ClearTempWave();
            string tempdir = m_manager.TempWaveDir;
            string log = Path.Combine( tempdir, "run.log" );
            bocoree.debug.close();
            try {
                if ( File.Exists( log ) ) {
                    File.Delete( log );
                }
                Directory.Delete( tempdir, true );
            } catch ( Exception ex ) {
            }
            VSTiProxy.AbortRendering();
            VSTiProxy.Terminate();
            m_manager.SendWindowClosedMessage();
        }

        private void FormMain_FormClosing( object sender, FormClosingEventArgs e ) {
            if ( Edited ) {
                string file = m_manager.FileName;
                if ( file == "" ) {
                    file = "Untitled";
                } else {
                    file = Path.GetFileName( file );
                }
                DialogResult ret = MessageBox.Show( _( "Save this sequence?" ),
                                                    _( "Affirmation" ),
                                                    MessageBoxButtons.YesNoCancel,
                                                    MessageBoxIcon.Question );
                switch ( ret ) {
                    case DialogResult.Yes:
                        if ( m_manager.FileName == "" ) {
                            DialogResult dr = DialogResult.Cancel;
                            if ( AppManager.EditorConfig.UseCustomFileDialog ) {
                                using ( FileDialog fd = new FileDialog( FileDialog.DialogMode.Save ) ) {
                                    if ( saveXmlVsqDialog.FileName != "" ) {
                                        fd.FileName = saveXmlVsqDialog.FileName;
                                    }
                                    fd.Filter = saveXmlVsqDialog.Filter;
                                    dr = fd.ShowDialog();
                                    if ( dr == DialogResult.OK ) {
                                        saveXmlVsqDialog.FileName = fd.FileName;
                                    }
                                }
                            } else {
                                dr = saveXmlVsqDialog.ShowDialog();
                            }
                            if ( dr == DialogResult.OK ) {
                                m_manager.SaveTo( saveXmlVsqDialog.FileName );
                            } else {
                                e.Cancel = true;
                                return;
                            }
                        } else {
                            m_manager.SaveTo( m_manager.FileName );
                        }
                        break;
                    case DialogResult.Cancel:
                        e.Cancel = true;
                        return;
                }
            }
            AppManager.EditorConfig.WindowMaximized = (this.WindowState == FormWindowState.Maximized);
            AppManager.SaveConfig();
            RenderUtau.ClearCache();
            if ( m_midi_in != null ) {
                m_midi_in.Dispose();
            }
            e.Cancel = false;
        }

        private void FormMain_Load( object sender, EventArgs e ) {
            ApplyLanguage();
            trackBar.Value = AppManager.EditorConfig.DefaultXScale;
            m_manager.CurrentClock = 0;
            Edited = false;

            m_manager.PreviewStarted += new EventHandler( m_manager_PreviewStarted );
            m_manager.PreviewAborted += new EventHandler( m_manager_PreviewAborted );
            m_manager.GridVisibleChanged += new EventHandler( m_manager_GridVisibleChanged );
            m_manager.SelectedEventChanged += new BSimpleDelegate<bool>( m_manager_SelectedEventChanged );
            m_manager.CurrentClockChanged += new EventHandler( m_manager_CurrentClockChanged );
            m_manager.SelectedToolChanged += new EventHandler( m_manager_SelectedToolChanged );
            m_manager.ApplyEditorConfigRequired += new EventHandler( m_manager_ApplyEditorConfigRequired );
            EditorConfig.QuantizeModeChanged += new EventHandler( EditorConfig_QuantizeModeChanged );

            UpdateRecentFileMenu();

            // C3が画面中央に来るように調整
            int draft_start_to_draw_y = AppManager._KEY_LENGTH * AppManager.EditorConfig.PxTrackHeight - pictPianoRoll.Height / 2;
            int draft_vscroll_value = (int)((draft_start_to_draw_y * (double)vScroll.Maximum) / (128 * AppManager.EditorConfig.PxTrackHeight - vScroll.Height));
            try {
                vScroll.Value = draft_vscroll_value;
            } catch {
            }

            // x=97がプリメジャークロックになるように調整
            int cp = m_manager.VsqFile.getPreMeasureClocks();
            int draft_hscroll_value = (int)(cp - 24.0 / m_manager.ScaleX);
            try {
                hScroll.Value = draft_hscroll_value;
            } catch {
            }

            s_pen_dashed_171_171_171.DashPattern = new float[] { 3, 3 };
            s_pen_dashed_209_204_172.DashPattern = new float[] { 3, 3 };

            menuVisualNoteProperty.Checked = AppManager.EditorConfig.ShowExpLine;
            menuVisualLyrics.Checked = AppManager.EditorConfig.ShowLyric;
            menuVisualMixer.Checked = AppManager.EditorConfig.MixerVisible;
            menuVisualPitchLine.Checked = AppManager.EditorConfig.ViewAtcualPitch;

            m_mixer_dlg = new FormMixer( this, m_manager );

            UpdateMenuFonts();

            m_mixer_dlg.FederChanged += new FormMixer.FederChangedEventHandler( m_mixer_dlg_FederChanged );
            m_mixer_dlg.PanpotChanged += new FormMixer.PanpotChangedEventHandler( m_mixer_dlg_PanpotChanged );
            m_mixer_dlg.MuteChanged += new FormMixer.MuteChangedEventHandler( m_mixer_dlg_MuteChanged );
            m_mixer_dlg.SoloChanged += new FormMixer.SoloChangedEventHandler( m_mixer_dlg_SoloChanged );
            m_mixer_dlg.TopMostChanged += new BSimpleDelegate<bool>( m_mixer_dlg_TopMostChanged );
            m_mixer_dlg.ShowTopMost = AppManager.EditorConfig.MixerTopMost;
            m_mixer_dlg.UpdateStatus();
            if ( AppManager.EditorConfig.MixerVisible ) {
                m_mixer_dlg.Show();
            }

            trackSelector.CommandExecuted += new TrackSelector.CommandExecutedEventHandler( trackSelector_CommandExecuted );

            UpdateScriptShortcut();

            ClearTempWave();
            SetHScrollRange( hScroll.Maximum );
            SetVScrollRange( vScroll.Maximum );
            m_pencil_mode.Mode = PencilModeEnum.Off;
            UpdateCMenuPianoFixed();
            ReloadGameControler();
            ReloadMidiIn();
            menuVisualWaveform.Checked = AppManager.EditorConfig.ViewWaveform;
            UpdateSplitContainer2Size();

            UpdateRendererMenu();

            if ( AppManager.EditorConfig.WindowMaximized ) {
                this.WindowState = FormWindowState.Maximized;
            } else {
                this.WindowState = FormWindowState.Normal;
            }
            this.Bounds = AppManager.EditorConfig.WindowRect;
            UpdateLayout();

            this.SizeChanged += new System.EventHandler( this.FormMain_SizeChanged );
            this.LocationChanged += new System.EventHandler( this.FormMain_LocationChanged );
            Refresh();
#if DEBUG
            /*OpenFileDialog ofd = new OpenFileDialog();
            XmlSerializer xs = new XmlSerializer( typeof( VsqFileEx ) );
            while ( ofd.ShowDialog() == DialogResult.OK ) {
                VsqFileEx vsq = new VsqFileEx( ofd.FileName );
                vsq.Track[1].getEvent( 1 ).UstEvent = new UstEvent();
                using ( FileStream fs = new FileStream( ofd.FileName + "_regen.xml", FileMode.Create ) ) {
                    xs.Serialize( fs, vsq );
                }
            }*/
            /*Cursor c = SynthCursor( Properties.Resources.arrow_135 );
            if ( c != null ) {
                HAND = c;
            }*/
            /*MessageBody mb = new MessageBody( "en", @"C:\en.po" );
            mb.Write( @"C:\foo.po" );*/
            /*OpenFileDialog ofd = new OpenFileDialog();
            Wave.TestEnabled = true;
            while ( ofd.ShowDialog() == DialogResult.OK ) {
                string file = Path.Combine( Path.GetDirectoryName( ofd.FileName ), Path.GetFileNameWithoutExtension( ofd.FileName ) + ".txt" );
                using ( StreamWriter sw = new StreamWriter( file ) )
                using ( Wave w = new Wave( ofd.FileName ) ) {
                    w.TrimSilence();
                    int WID = 2048;
                    double[] wind = new double[WID];
                    for ( int j = 0; j < WID; j++ ) {
                        wind[j] = bocoree.math.window_func( bocoree.math.WindowFunctionType.Hamming, (double)j / (double)WID );
                    }
                    uint i = w.SampleRate;
                    //for ( uint i = 0; i < w.TotalSamples; i+=10 ) {
                        double f0 = w.TEST_GetF0( i, wind );
                        double n = 12.0 * Math.Log( f0 / 440.0, 2.0 ) + 69.0;
                        sw.WriteLine( i / (double)w.SampleRate + "\t" + n + "\t" + f0 );
                    //}
                }
            }*/
            /*bocoree.debug.push_log( "installed singers 1" );
            SingerConfig[] s1 = VocaloSysUtil.getInstalledSingers1();
            foreach ( SingerConfig sc in s1 ) {
                bocoree.debug.push_log( "    " + sc );
            }
            bocoree.debug.push_log( "installed singers 2" );
            SingerConfig[] s2 = VocaloSysUtil.getInstalledSingers2();
            foreach ( SingerConfig sc in s2 ) {
                bocoree.debug.push_log( "    " + sc );
            }
            if ( AppManager.EditorConfig.PathUtauVSTi != "" ) {
                bocoree.debug.push_log( "installed singers utau" );
                UtauSingerConfigSys uscs = new UtauSingerConfigSys( Path.GetDirectoryName( AppManager.EditorConfig.PathUtauVSTi ) );
                s2 = uscs.getInstalledSingers();
                foreach ( SingerConfig sc in s2 ) {
                    bocoree.debug.push_log( "    " + sc );
                }
            }
            Console.WriteLine( VocaloSysUtil.getLanguage2( 0 ) );*/

            /*OpenFileDialog ofd = new OpenFileDialog();
                const string format = "    {0,8} 0x{1:X4} {2,-32} 0x{3:X2} 0x{4:X2}";
                const string format0 = "    {0,8} 0x{1:X4} {2,-32} 0x{3:X2}";
            while ( ofd.ShowDialog() == DialogResult.OK ) {
                VsqFile vf = new VsqFile( ofd.FileName );
                vf.getTrack( 1 ).getCommon().Version = "UTU000";
                VsqNrpn[] nrpns = VsqFile.generateNRPN( vf, 1, 500 );
                string file = Path.Combine( Path.GetDirectoryName( ofd.FileName ), Path.GetFileNameWithoutExtension( ofd.FileName ) + "_regen.txt" );
                using ( StreamWriter sw = new StreamWriter( file ) ) {
                    for ( int i = 0; i < nrpns.Length; i++ ) {
                        VsqNrpn vn = nrpns[i];
                        if ( vn.DataLsbSpecified ) {
                            sw.WriteLine( string.Format( format, vn.Clock, vn.Nrpn, NRPN.getName( vn.Nrpn ), vn.DataMsb, vn.DataLsb ) );
                        } else {
                            sw.WriteLine( string.Format( format0, vn.Clock, vn.Nrpn, NRPN.getName( vn.Nrpn ), vn.DataMsb ) );
                        }
                    }
                }
            }*/
            /*unsafe {
                WavePlay w = new WavePlay( 44100, 44100 );
                w.on_your_mark( new string[] { }, 0 );
                float* left = (float*)System.Runtime.InteropServices.Marshal.AllocHGlobal( sizeof( float ) * 10000 );
                float* right = (float*)System.Runtime.InteropServices.Marshal.AllocHGlobal( sizeof( float ) * 10000 );
                float** buf = (float**)System.Runtime.InteropServices.Marshal.AllocHGlobal( sizeof( float* ) * 2 );
                buf[0] = left;
                buf[1] = right;
                float wv = 0.0f;
                for ( int i = 0; i < 10000; i++ ) {
                    wv += 0.002f;
                    if ( wv > 0.2f ) {
                        wv = -0.2f;
                    }
                    left[i] = wv;
                    right[i] = -wv;
                }
                for ( int i = 0; i < 100; i++ ) {
                    w.append( buf, 10000, 0.2, 0.2 );
                }
                w.flush_and_exit( 0.2, 0.2 );
                while ( w.is_alive() ) {
                }
            }*/
#endif
        }

        private void FormMain_LocationChanged( object sender, EventArgs e ) {
            if ( this.WindowState == FormWindowState.Normal ) {
                AppManager.EditorConfig.WindowRect = this.Bounds;
            }
        }

        private void FormMain_SizeChanged( object sender, EventArgs e ) {
            if ( this.WindowState == FormWindowState.Normal ) {
                AppManager.EditorConfig.WindowRect = this.Bounds;
                UpdateLayout();
            }
        }

        private void FormMain_MouseWheel( object sender, MouseEventArgs e ) {
            if ( (Control.ModifierKeys & Keys.Shift) == Keys.Shift ) {
                hScroll.Value = NewHScrollValueFromWheelDelta( e.Delta );
            } else {
                double new_val = (double)vScroll.Value - e.Delta;
                if ( new_val > vScroll.Maximum ) {
                    vScroll.Value = vScroll.Maximum;
                } else if ( new_val < vScroll.Minimum ) {
                    vScroll.Value = vScroll.Minimum;
                } else {
                    vScroll.Value = (int)new_val;
                }
            }
            RefreshScreen();
        }

        private void FormMain_PreviewKeyDown( object sender, PreviewKeyDownEventArgs e ) {
            ProcessSpecialShortcutKey( e );
        }

        private void FormMain_Deactivate( object sender, EventArgs e ) {
            m_form_activated = false;
        }

        private void FormMain_Activated( object sender, EventArgs e ) {
            m_form_activated = true;
        }
        #endregion

        private void m_timer_Tick( object sender, EventArgs e ) {
            if ( !m_form_activated ) {
                return;
            }
            try {
                DateTime now = DateTime.Now;
                byte[] buttons;
                int pov0;
                winmmhelp.JoyGetStatus( 0, out buttons, out pov0 );
                bool event_processed = false;
                double dt_ms = now.Subtract( m_last_event_processed ).TotalMilliseconds;

                EditorConfig m = AppManager.EditorConfig;
                bool btn_x = (0 <= m.GameControlerCross && m.GameControlerCross < buttons.Length && buttons[m.GameControlerCross] > 0x00);
                bool btn_o = (0 <= m.GameControlerCircle && m.GameControlerCircle < buttons.Length && buttons[m.GameControlerCircle] > 0x00);
                bool btn_tr = (0 <= m.GameControlerTriangle && m.GameControlerTriangle < buttons.Length && buttons[m.GameControlerTriangle] > 0x00);
                bool btn_re = (0 <= m.GameControlerRectangle && m.GameControlerRectangle < buttons.Length && buttons[m.GameControlerRectangle] > 0x00);
                bool pov_r = pov0 == m.GameControlPovRight;
                bool pov_l = pov0 == m.GameControlPovLeft;
                bool pov_u = pov0 == m.GameControlPovUp;
                bool pov_d = pov0 == m.GameControlPovDown;
                bool L1 = (0 <= m.GameControlL1 && m.GameControlL1 < buttons.Length && buttons[m.GameControlL1] > 0x00);
                bool R1 = (0 <= m.GameControlL2 && m.GameControlL2 < buttons.Length && buttons[m.GameControlR1] > 0x00);
                bool L2 = (0 <= m.GameControlR1 && m.GameControlR1 < buttons.Length && buttons[m.GameControlL2] > 0x00);
                bool R2 = (0 <= m.GameControlR2 && m.GameControlR2 < buttons.Length && buttons[m.GameControlR2] > 0x00);
                bool SELECT = (0 <= m.GameControlSelect && m.GameControlSelect <= buttons.Length && buttons[m.GameControlSelect] > 0x00);
                if ( m_game_mode == GameControlMode.Normal ) {
                    m_last_btn_x = btn_x;

                    if ( !event_processed && !btn_o && m_last_btn_o ) {
                        if ( m_manager.Playing ) {
                            timer.Stop();
                        }
                        m_manager.Playing = !m_manager.Playing;
                        m_last_event_processed = now;
                        event_processed = true;
                    }
                    m_last_btn_o = btn_o;

                    if ( !event_processed && pov_r && dt_ms > AppManager.EditorConfig.GameControlerMinimumEventInterval ) {
                        Forward();
                        m_last_event_processed = now;
                        event_processed = true;
                    }
                    m_last_pov_r = pov_r;

                    if ( !event_processed && pov_l && dt_ms > AppManager.EditorConfig.GameControlerMinimumEventInterval ) {
                        Rewind();
                        m_last_event_processed = now;
                        event_processed = true;
                    }
                    m_last_pov_l = pov_l;

                    if ( !event_processed && pov_u && dt_ms > AppManager.EditorConfig.GameControlerMinimumEventInterval ) {
                        int draft_vscroll = vScroll.Value - AppManager.EditorConfig.PxTrackHeight * 3;
                        if ( draft_vscroll < vScroll.Minimum ) {
                            draft_vscroll = vScroll.Minimum;
                        }
                        vScroll.Value = draft_vscroll;
                        RefreshScreen();
                        m_last_event_processed = now;
                        event_processed = true;
                    }

                    if ( !event_processed && pov_d && dt_ms > AppManager.EditorConfig.GameControlerMinimumEventInterval ) {
                        int draft_vscroll = vScroll.Value + AppManager.EditorConfig.PxTrackHeight * 3;
                        if ( draft_vscroll > vScroll.Maximum ) {
                            draft_vscroll = vScroll.Maximum;
                        }
                        vScroll.Value = draft_vscroll;
                        RefreshScreen();
                        m_last_event_processed = now;
                        event_processed = true;
                    }

                    if ( !event_processed && !SELECT && m_last_select ) {
                        event_processed = true;
                        m_game_mode = GameControlMode.Keyboard;
                        stripLblGameCtrlMode.Text = m_game_mode.ToString();
                        stripLblGameCtrlMode.Image = Properties.Resources.piano;
                    }
                    m_last_select = SELECT;
                } else if ( m_game_mode == GameControlMode.Keyboard ) {
                    if ( !event_processed && !SELECT && m_last_select ) {
                        event_processed = true;
                        m_game_mode = GameControlMode.Normal;
                        UpdateGameStatus();
                        m_last_select = SELECT;
                        return;
                    }
                    m_last_select = SELECT;
                    if ( L1 && R1 && L2 && R2 && dt_ms > AppManager.EditorConfig.GameControlerMinimumEventInterval ) {
                        if ( m_manager.Playing ) {
                            m_manager.EditMode = EditMode.None;
                            m_manager.Playing = false;
                            timer.Stop();
                        } else {
                            m_timer.Enabled = false;
                            using ( FormRealtimeConfig frc = new FormRealtimeConfig() ) {
                                if ( frc.ShowDialog() == DialogResult.OK ) {
                                    m_adding = null;
                                    m_manager.EditMode = EditMode.Realtime;
                                    m_manager.Speed = frc.Speed;
                                    m_manager.Playing = true;
                                }
                            }
                            m_timer.Enabled = true;
                        }
                        m_last_btn_o = btn_o;
                        m_last_btn_x = btn_x;
                        m_last_btn_re = btn_re;
                        m_last_btn_tr = btn_tr;
                        m_last_pov_l = pov_l;
                        m_last_pov_d = pov_d;
                        m_last_pov_r = pov_r;
                        m_last_pov_u = pov_u;
                        return;
                    }

                    int note = -1;
                    if ( pov_r && !m_last_pov_r ) {
                        note = 60;
                    } else if ( btn_re && !m_last_btn_re ) {
                        note = 62;
                    } else if ( btn_tr && !m_last_btn_tr ) {
                        note = 64;
                    } else if ( btn_o && !m_last_btn_o ) {
                        note = 65;
                    } else if ( btn_x && !m_last_btn_x ) {
                        note = 67;
                    } else if ( pov_u && !m_last_pov_u ) {
                        note = 59;
                    } else if ( pov_l && !m_last_pov_l ) {
                        note = 57;
                    } else if ( pov_d && !m_last_pov_d ) {
                        note = 55;
                    }
                    if ( note >= 0 ) {
                        if ( L1 ) {
                            note += 12;
                        } else if ( L2 ) {
                            note -= 12;
                        }
                        if ( R1 ) {
                            note += 1;
                        } else if ( R2 ) {
                            note -= 1;
                        }
                    }
                    m_last_btn_o = btn_o;
                    m_last_btn_x = btn_x;
                    m_last_btn_re = btn_re;
                    m_last_btn_tr = btn_tr;
                    m_last_pov_l = pov_l;
                    m_last_pov_d = pov_d;
                    m_last_pov_r = pov_r;
                    m_last_pov_u = pov_u;
                    if ( note >= 0 ) {
#if DEBUG
                        Common.DebugWriteLine( "FormMain+m_timer_Tick" );
                        Common.DebugWriteLine( "    note=" + note );
#endif
                        if ( m_manager.Playing ) {
                            int clock = m_manager.CurrentClock;
                            if ( m_adding != null ) {
                                m_adding.ID.Length = clock - m_adding.Clock;
                                CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandEventAdd( m_manager.Selected,
                                                                                                        m_adding ) );
                                m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
                                if ( !Edited ) {
                                    Edited = true;
                                }
#if USE_DOBJ
                                UpdateDrawObjectList();
#endif
                            }
                            m_adding = new VsqEvent( clock, new VsqID( 0 ) );
                            m_adding.ID.type = VsqIDType.Anote;
                            m_adding.ID.Dynamics = 64;
                            m_adding.ID.VibratoHandle = null;
                            m_adding.ID.LyricHandle = new LyricHandle( "a", "a" );
                            m_adding.ID.Note = note;
                        }
                        KeySoundPlayer.Play( note );
                    } else {
                        if ( m_manager.Playing && m_adding != null ) {
                            m_adding.ID.Length = m_manager.CurrentClock - m_adding.Clock;
                        }
                    }
                }
            } catch ( Exception ex ) {
#if DEBUG
                Common.DebugWriteLine( "    ex=" + ex );
#endif
                m_game_mode = GameControlMode.Disabled;
                UpdateGameStatus();
                if ( m_manager.EditMode == EditMode.Realtime ) {
                    m_manager.Playing = false;
                    m_manager.EditMode = EditMode.None;
                    m_adding = null;
                }
                m_timer.Stop();
            }
        }

        private void EditorConfig_QuantizeModeChanged( object sender, EventArgs e ) {
            ApplyQuantizeMode();
        }

        #region menuFile*
        private void menuFileSaveNamed_Click( object sender, EventArgs e ) {
            for ( int track = 1; track < m_manager.VsqFile.Track.Count; track++ ) {
                if ( m_manager.VsqFile.Track[track].getEventCount() == 0 ) {
                    MessageBox.Show(
                        String.Format(
                            _( "Invalid note data.\nTrack {0} : {1}\n\n-> Piano roll : Blank sequence." ), track, m_manager.VsqFile.Track[track].Name
                        ),
                        _APP_NAME,
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Exclamation );
                    return;
                }
            }
            DialogResult dr = DialogResult.Cancel;
            if ( AppManager.EditorConfig.UseCustomFileDialog ) {
                using ( FileDialog fd = new FileDialog( FileDialog.DialogMode.Open ) ) {
                    if ( saveXmlVsqDialog.FileName != "" ) {
                        fd.FileName = saveXmlVsqDialog.FileName;
                    }
                    fd.Filter = saveXmlVsqDialog.Filter;
                    dr = fd.ShowDialog();
                    if ( dr == DialogResult.OK ) {
                        saveXmlVsqDialog.FileName = fd.FileName;
                    }
                }
            } else {
                dr = saveXmlVsqDialog.ShowDialog();
            }

            if ( dr == DialogResult.OK ) {
                string file = saveXmlVsqDialog.FileName;
                m_manager.SaveTo( file );
                Edited = false;
            }
        }

        private void commonFileSave_Click( object sender, EventArgs e ) {
            for ( int track = 1; track < m_manager.VsqFile.Track.Count; track++ ) {
                if ( m_manager.VsqFile.Track[track].getEventCount() == 0 ) {
                    MessageBox.Show(
                        String.Format(
                            _( "Invalid note data.\nTrack {0} : {1}\n\n-> Piano roll : Blank sequence." ), track, m_manager.VsqFile.Track[track].Name
                        ),
                        _APP_NAME,
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Exclamation );
                    return;
                }
            }
            string file = m_manager.FileName;
            if ( m_manager.FileName == "" ) {
                DialogResult dr = DialogResult.Cancel;
                if ( AppManager.EditorConfig.UseCustomFileDialog ) {
                    using ( FileDialog fd = new FileDialog( FileDialog.DialogMode.Open ) ) {
                        if ( saveXmlVsqDialog.FileName != "" ) {
                            fd.FileName = saveXmlVsqDialog.FileName;
                        }
                        fd.Filter = saveXmlVsqDialog.Filter;
                        dr = fd.ShowDialog();
                        if ( dr == DialogResult.OK ) {
                            saveXmlVsqDialog.FileName = fd.FileName;
                        }
                    }
                } else {
                    dr = saveXmlVsqDialog.ShowDialog();
                }

                if ( dr == DialogResult.OK ) {
                    file = saveXmlVsqDialog.FileName;
                }
            }
            if ( file != "" ) {
                m_manager.SaveTo( file );
                Edited = false;
            }
        }

        private void menuFileQuit_Click( object sender, EventArgs e ) {
            this.Close();
        }

        private void menuFileExportWave_Click( object sender, EventArgs e ) {
            DialogResult dr = DialogResult.Cancel;
            string filename = "";
            if ( AppManager.EditorConfig.UseCustomFileDialog ) {
                using ( FileDialog fd = new FileDialog( FileDialog.DialogMode.Save ) ) {
                    fd.Title = _( "Wave Export" );
                    try {
                        fd.Filter = _( "Wave File(*.wav)|*.wav" ) + "|" + _( "All Files(*.*)|*.*" );
                    } catch {
                        fd.Filter = "Wave File(*.wav)|*.wav|All Files(*.*)|*.*";
                    }
                    dr = fd.ShowDialog();
                    filename = fd.FileName;
                }
            } else {
                using ( SaveFileDialog sfd = new SaveFileDialog() ) {
                    sfd.Title = _( "Wave Export" );
                    try {
                        sfd.Filter = _( "Wave File(*.wav)|*.wav" ) + "|" + _( "All Files(*.*)|*.*" );
                    } catch {
                        sfd.Filter = "Wave File(*.wav)|*.wav|All Files(*.*)|*.*";
                    }
                    dr = sfd.ShowDialog();
                    filename = sfd.FileName;
                }
            }

            if ( dr == DialogResult.OK ) {
                using ( FormSynthesize fs = new FormSynthesize(
                    m_manager,
                    m_manager.VsqFile,
                    AppManager.EditorConfig.PreSendTime,
                    new int[] { m_manager.Selected },
                    new string[] { filename },
                    m_manager.VsqFile.TotalClocks + 240 ) ) {

                    DateTime started = DateTime.Now;
                    fs.ShowDialog();
#if DEBUG
                    bocoree.debug.push_log( "elapsed time=" + DateTime.Now.Subtract( started ).TotalSeconds + "sec" );
#endif
                }
            }
        }

        private void menuFileExport_DropDownOpening( object sender, EventArgs e ) {
            menuFileExportWave.Enabled = (m_manager.VsqFile.Track[m_manager.Selected].getEventCount() > 0) && VSTiProxy.CurrentUser == "";
        }

        private void menuFileImportMidi_Click( object sender, EventArgs e ) {
            if ( m_midi_imexport_dialog == null ) {
                m_midi_imexport_dialog = new FormMidiImExport();
            }
            m_midi_imexport_dialog.ListTrack.Items.Clear();
            m_midi_imexport_dialog.Mode = FormMidiImExport.FormMidiMode.Import;

            DialogResult dr = DialogResult.Cancel;
            if ( AppManager.EditorConfig.UseCustomFileDialog ) {
                using ( FileDialog fd = new FileDialog( FileDialog.DialogMode.Open ) ) {
                    if ( openMidiDialog.FileName != "" ) {
                        fd.FileName = openMidiDialog.FileName;
                    }
                    fd.Filter = openMidiDialog.Filter;
                    dr = fd.ShowDialog();
                    if ( dr == DialogResult.OK ) {
                        openMidiDialog.FileName = fd.FileName;
                    }
                }
            } else {
                dr = openMidiDialog.ShowDialog();
            }
            
            if ( dr == DialogResult.OK ) {
                MidiFile mf = new MidiFile( openMidiDialog.FileName );
                int count = mf.getTrackCount();
                Encoding def_enc = Encoding.GetEncoding( 0 );
                for ( int i = 0; i < count; i++ ) {
                    string track_name = "";
                    int notes = 0;
                    List<MidiEvent> events = mf.getMidiEventList( i );
                    
                    // トラック名を取得
                    for ( int j = 0; j < events.Count; j++ ) {
                        if ( events[j].FirstByte == 0xff && events[j].Data.Length >= 2 && events[j].Data[0] == 0x03 ) {
                            track_name = def_enc.GetString( events[j].Data, 1, events[j].Data.Length - 1 );
                            break;
                        }
                    }

                    // イベント数を数える
                    for ( int j = 0; j < events.Count; j++ ) {
                        if ( (events[j].FirstByte & 0xf0) == 0x90 && events[j].Data.Length > 1 && events[j].Data[1] > 0x00 ) {
                            notes++;
                        }
                    }
                    m_midi_imexport_dialog.ListTrack.Items.Add( new ListViewItem( new string[] { i.ToString(), track_name, notes.ToString() } ) );
                    m_midi_imexport_dialog.ListTrack.Items[i].Checked = true;
                }

                if ( m_midi_imexport_dialog.ShowDialog() == DialogResult.OK ) {
                    // インポートするしないにかかわらずテンポと拍子を取得
                    VsqFile tempo = new VsqFile( "Miku", 2, 4, 4, 500000 ); //テンポリスト用のVsqFile。テンポの部分のみ使用
                    bool tempo_added = false;
                    bool timesig_added = false;
                    tempo.getTempoList().Clear();
                    tempo.getTimeSigList().Clear();
                    for ( int i = 0; i < mf.getTrackCount(); i++ ) {
                        List<MidiEvent> events = mf.getMidiEventList( i );
                        for ( int j = 0; j < events.Count; j++ ) {
                            if ( !tempo_added && events[j].FirstByte == 0xff && events[j].Data.Length >= 4 && events[j].Data[0] == 0x51 ) {
                                int vtempo = events[j].Data[1] << 16 | events[j].Data[2] << 8 | events[j].Data[3];
                                tempo.getTempoList().Add( new TempoTableEntry( (int)events[j].Clock, vtempo, 0.0 ) );
                                tempo_added = true;
                            }
                            if ( !timesig_added && events[j].FirstByte == 0xff && events[j].Data.Length >= 5 && events[j].Data[0] == 0x58 ) {
                                int num = events[j].Data[1];
                                int den = 1;
                                for ( int k = 0; k < events[j].Data[2]; k++ ) {
                                    den = den * 2;
                                }
                                tempo.getTimeSigList().Add( new TimeSigTableEntry( (int)events[j].Clock, num, den, 0 ) );
                                timesig_added = true;
                            }
                        }
                    }
                    bool contains_zero = false;
                    for ( int i = 0; i < tempo.getTempoList().Count; i++ ) {
                        if ( tempo.getTempoList()[i].Clock == 0 ) {
                            contains_zero = true;
                            break;
                        }
                    }
                    if ( !contains_zero ) {
                        tempo.getTempoList().Add( new TempoTableEntry( 0, 500000, 0.0 ) );
                    }
                    contains_zero = false;
                    for ( int i = 0; i < tempo.getTimeSigList().Count; i++ ) {
                        if ( tempo.getTimeSigList()[i].Clock == 0 ) {
                            contains_zero = true;
                            break;
                        }
                    }
                    if ( !contains_zero ) {
                        tempo.getTimeSigList().Add( new TimeSigTableEntry( 0, 4, 4, 0 ) );
                    }
                    tempo.updateTempoInfo();
                    tempo.updateTimesigInfo();

                    VsqFileEx work = (VsqFileEx)m_manager.VsqFile.Clone(); //後でReplaceコマンドを発行するための作業用

                    // tempo
                    bool import_tempo = m_midi_imexport_dialog.Tempo;
                    if ( import_tempo ) {
                        work.getTempoList().Clear();
                        List<TempoTableEntry> list = tempo.getTempoList();
                        for ( int i = 0; i < list.Count; i++ ) {
                            work.getTempoList().Add( new TempoTableEntry( list[i].Clock, list[i].Tempo, list[i].Time ) );
                        }
                        work.getTempoList().Sort();
                        work.updateTempoInfo();
                    }

                    // timesig
                    if ( m_midi_imexport_dialog.Timesig ) {
                        work.getTimeSigList().Clear();
                        List<TimeSigTableEntry> list = tempo.getTimeSigList();
                        for ( int i = 0; i < list.Count; i++ ) {
                            work.getTimeSigList().Add( new TimeSigTableEntry( list[i].Clock, 
                                                                              list[i].Numerator,
                                                                              list[i].Denominator,
                                                                              list[i].BarCount ) );
                        }
                        work.getTimeSigList().Sort();
                        work.updateTimesigInfo();
                    }

                    for ( int i = 0; i < m_midi_imexport_dialog.ListTrack.Items.Count; i++ ) {
                        if ( m_midi_imexport_dialog.ListTrack.Items[i].Checked ) {
                            if ( work.Track.Count + 1 > 16 ) {
                                break;
                            }
                            VsqTrack work_track = new VsqTrack( m_midi_imexport_dialog.ListTrack.Items[i].SubItems[1].Text, "Miku" );
                            List<MidiEvent> events = mf.getMidiEventList( i );

                            // note
                            if ( m_midi_imexport_dialog.Notes ) {
                                int clock_on = -1;
                                for ( int j = 0; j < events.Count; j++ ) {
                                    if ( (events[j].FirstByte & 0xf0) == 0x90 && events[j].Data.Length >= 2 && events[j].Data[1] > 0 ) {
                                        clock_on = (int)events[j].Clock;
                                    }
                                    if ( ((events[j].FirstByte & 0xf0) == 0x90 && events[j].Data.Length >= 2 && events[j].Data[1] == 0 ) || 
                                         ((events[j].FirstByte & 0xf0) == 0x80 && events[j].Data.Length >= 2 ) ) {
                                        int clock_off = (int)events[j].Clock;
                                        if ( clock_on >= 0 ) {
                                            int add_clock_on = clock_on;
                                            int add_clock_off = clock_off;
                                            if ( !import_tempo ) {
                                                double time_clock_on = tempo.getSecFromClock( clock_on );
                                                double time_clock_off = tempo.getSecFromClock( clock_off );
                                                add_clock_on = (int)work.getClockFromSec( time_clock_on );
                                                add_clock_off = (int)work.getClockFromSec( time_clock_off );
                                            }
                                            VsqID vid = new VsqID( 0 );
                                            vid.type = VsqIDType.Anote;
                                            vid.Length = add_clock_off - add_clock_on;
                                            string phrase = "a";
                                            if ( m_midi_imexport_dialog.Lyric ){
                                                for ( int k = 0; k < events.Count; k++ ){
                                                    if ( clock_on <= (int)events[k].Clock && (int)events[k].Clock <= clock_off ){
                                                        if ( events[k].FirstByte == 0xff && events[k].Data.Length >= 2 ){
                                                            phrase = def_enc.GetString( events[k].Data, 1, events[k].Data.Length - 1 );
                                                            break;
                                                        }
                                                    }
                                                }
                                            }
                                            vid.LyricHandle = new LyricHandle( phrase, "a" );
                                            vid.Note = events[j].Data[0];
                                            VsqEvent ve = new VsqEvent( (int)events[j].Clock, vid );
                                            work_track.addEvent( ve );
                                        }
                                    }
                                }

                                CurveType ct = CurveType.Pitch;
                                CadenciiCommand run_add = VsqFileEx.generateCommandAddTrack( work_track,
                                                                                             new VsqMixerEntry( 0, 0, 0, 0 ),
                                                                                             work.Track.Count,
                                                                                             new BezierCurves(), 
                                                                                             new VsqBPList( ct.Default, ct.Minimum, ct.Maximum ) );
                                work.executeCommand( run_add );
                            }
                        }
                    }

                    CadenciiCommand lastrun = VsqFileEx.generateCommandReplace( work );
                    m_manager.Register( m_manager.VsqFile.executeCommand( lastrun ) );
                    Edited = true;
                    RefreshScreen();
                }
            }
        }

        private void menuFileExportMidi_Click( object sender, EventArgs e ) {
            if ( m_midi_imexport_dialog == null ) {
                m_midi_imexport_dialog = new FormMidiImExport();
            }
            m_midi_imexport_dialog.ListTrack.Items.Clear();
            for ( int i = 0; i < m_manager.VsqFile.Track.Count; i++ ) {
                VsqTrack track = m_manager.VsqFile.Track[i];
                int notes = 0;
                for ( Iterator itr = track.getNoteEventIterator(); itr.hasNext(); ) {
                    object obj = itr.next();
                    notes++;
                }
                m_midi_imexport_dialog.ListTrack.Items.Add( new ListViewItem( new string[] { i.ToString(), track.Name, notes.ToString() } ) );
                m_midi_imexport_dialog.ListTrack.Items[i].Checked = i != 0;
            }
            m_midi_imexport_dialog.Mode = FormMidiImExport.FormMidiMode.Export;
            m_midi_imexport_dialog.Location = GetFormPreferedLocation( m_midi_imexport_dialog );
            if ( m_midi_imexport_dialog.ShowDialog() == DialogResult.OK ) {
                int track_count = 0;
                for ( int i = 0; i < m_midi_imexport_dialog.ListTrack.Items.Count; i++ ) {
                    if ( m_midi_imexport_dialog.ListTrack.Items[i].Checked ) {
                        track_count++;
                    }
                }
                if ( track_count == 0 ) {
                    return;
                }

                DialogResult dr = DialogResult.Cancel;
                if ( AppManager.EditorConfig.UseCustomFileDialog ) {
                    using ( FileDialog fd = new FileDialog( FileDialog.DialogMode.Save ) ) {
                        if ( saveMidiDialog.FileName != "" ) {
                            fd.FileName = saveMidiDialog.FileName;
                        }
                        fd.Filter = saveMidiDialog.Filter;
                        dr = fd.ShowDialog();
                        if ( dr == DialogResult.OK ) {
                            saveMidiDialog.FileName = fd.FileName;
                        }
                    }
                } else {
                    dr = saveMidiDialog.ShowDialog();
                }

                if ( dr == DialogResult.OK ) {
                    System.Text.Encoding def_enc = System.Text.Encoding.GetEncoding( 0 ); // システムのデフォルトエンコーディング
                    using ( FileStream fs = new FileStream( saveMidiDialog.FileName, FileMode.Create ) ) {
                        // ヘッダー
                        fs.Write( new byte[] { 0x4d, 0x54, 0x68, 0x64 }, 0, 4 );
                        //データ長
                        fs.WriteByte( 0x00 );
                        fs.WriteByte( 0x00 );
                        fs.WriteByte( 0x00 );
                        fs.WriteByte( 0x06 );
                        //フォーマット
                        fs.WriteByte( 0x00 );
                        fs.WriteByte( 0x01 );
                        //トラック数
                        VsqFile.writeUnsignedShort( fs, (ushort)track_count );
                        //時間単位
                        fs.WriteByte( 0x01 );
                        fs.WriteByte( 0xe0 );
                        int count = -1;
                        for ( int i = 0; i < m_midi_imexport_dialog.ListTrack.Items.Count; i++ ) {
                            if ( !m_midi_imexport_dialog.ListTrack.Items[i].Checked ) {
                                continue;
                            }
                            VsqTrack track = m_manager.VsqFile.Track[i];
                            count++;
                            fs.Write( new byte[] { 0x4d, 0x54, 0x72, 0x6b }, 0, 4 );
                            //データ長。とりあえず0を入れておく
                            fs.Write( new byte[] { 0x00, 0x00, 0x00, 0x00 }, 0, 4 );
                            long first_position = fs.Position;
                            //トラック名
                            VsqFile.writeFlexibleLengthUnsignedLong( fs, 0 );//デルタタイム
                            fs.WriteByte( 0xff );//ステータスタイプ
                            fs.WriteByte( 0x03 );//イベントタイプSequence/Track Name
                            byte[] track_name = def_enc.GetBytes( track.Name );
                            fs.WriteByte( (byte)track_name.Length );
                            fs.Write( track_name, 0, track_name.Length );

                            List<MidiEvent> events = new List<MidiEvent>();

                            // tempo
                            bool print_tempo = m_midi_imexport_dialog.Tempo;
                            if ( print_tempo && count == 0 ) {
                                List<MidiEvent> tempo_events = m_manager.VsqFile.generateTempoChange();
                                for ( int j = 0; j < tempo_events.Count; j++ ) {
                                    events.Add( tempo_events[j] );
                                }
                            }

                            // timesig
                            if ( m_midi_imexport_dialog.Timesig && count == 0 ) {
                                List<MidiEvent> timesig_events = m_manager.VsqFile.generateTimeSig();
                                for ( int j = 0; j < timesig_events.Count; j++ ) {
                                    events.Add( timesig_events[j] );
                                }
                            }

                            // Notes
                            if ( m_midi_imexport_dialog.Notes ) {
                                for ( Iterator itr = track.getNoteEventIterator(); itr.hasNext(); ) {
                                    VsqEvent ve = (VsqEvent)itr.next();
                                    int clock_on = ve.Clock;
                                    int clock_off = ve.Clock + ve.ID.Length;
                                    if ( !print_tempo ) {
                                        // テンポを出力しない場合、テンポを500000（120）と見なしてクロックを再計算
                                        double time_on = m_manager.VsqFile.getSecFromClock( clock_on );
                                        double time_off = m_manager.VsqFile.getSecFromClock( clock_off );
                                        clock_on = (int)(960.0 * time_on);
                                        clock_off = (int)(960.0 * time_off);
                                    }
                                    MidiEvent noteon = new MidiEvent();
                                    noteon.Clock = clock_on;
                                    noteon.FirstByte = 0x90;
                                    noteon.Data = new byte[2];
                                    noteon.Data[0] = (byte)ve.ID.Note;
                                    noteon.Data[1] = 0x7f;
                                    events.Add( noteon );
                                    MidiEvent noteoff = new MidiEvent();
                                    noteoff.Clock = clock_off;
                                    noteoff.FirstByte = 0x80;
                                    noteoff.Data = new byte[2];
                                    noteoff.Data[0] = (byte)ve.ID.Note;
                                    noteoff.Data[1] = 0x7f;
                                    events.Add( noteoff );
                                }
                            }

                            // lyric
                            if ( m_midi_imexport_dialog.Lyric ) {
                                for ( Iterator itr = track.getNoteEventIterator(); itr.hasNext(); ) {
                                    VsqEvent ve = (VsqEvent)itr.next();
                                    int clock_on = ve.Clock;
                                    if ( !print_tempo ) {
                                        double time_on = m_manager.VsqFile.getSecFromClock( clock_on );
                                        clock_on = (int)(960.0 * time_on);
                                    }
                                    MidiEvent add = new MidiEvent();
                                    add.Clock = clock_on;
                                    add.FirstByte = 0xff;
                                    byte[] lyric = def_enc.GetBytes( ve.ID.LyricHandle.L0.Phrase );
                                    add.Data = new byte[lyric.Length + 1];
                                    add.Data[0] = 0x05;
                                    for ( int j = 0; j < lyric.Length; j++ ) {
                                        add.Data[j + 1] = lyric[j];
                                    }
                                    events.Add( add );
                                }
                            }

                            // vocaloid metatext
                            List<MidiEvent> meta;
                            if ( m_midi_imexport_dialog.VocaloidMetatext && i > 0 ) {
                                meta = m_manager.VsqFile.generateMetaTextEvent( i );
#if DEBUG
                                using ( FileStream fs2 = new FileStream( "metatext_event" + i + ".txt", FileMode.Create, FileAccess.Write ) ) {
                                    for ( int j = 0; j < meta.Count; j++ ) {
                                        meta[j].writeData( fs2 );
                                    }
                                }
#endif
                                //for ( int j = 0; j < meta.Count; j++ ) {
                                //events.Add( meta[j] );
                                //}
                            } else {
                                meta = new List<MidiEvent>();
                            }

                            // vocaloid nrpn
                            if ( m_midi_imexport_dialog.VocaloidNrpn && i > 0 ) {
                                VsqNrpn[] vsqnrpn = VsqFileEx.generateNRPN( (VsqFile)m_manager.VsqFile, i, AppManager.EditorConfig.PreSendTime );
                                NrpnData[] nrpn = VsqNrpn.convert( vsqnrpn );
                                List<MidiEvent> vnrpn = new List<MidiEvent>();
                                for ( int j = 0; j < nrpn.Length; j++ ) {
                                    MidiEvent me = new MidiEvent();
                                    me.Clock = nrpn[j].getClock();
                                    me.FirstByte = 0xb0;
                                    me.Data = new byte[2];
                                    me.Data[0] = nrpn[j].getParameter();
                                    me.Data[1] = nrpn[j].Value;
                                    vnrpn.Add( me );
                                }
                                for ( int j = 0; j < vnrpn.Count; j++ ) {
                                    events.Add( vnrpn[j] );
                                }
                            }

                            // midi eventを出力
                            events.Sort();
                            long last_clock = 0;
                            for ( int j = 0; j < events.Count; j++ ) {
                                if ( events[j].Clock > 0 && meta.Count > 0 ) {
                                    for ( int k = 0; k < meta.Count; k++ ) {
                                        VsqFile.writeFlexibleLengthUnsignedLong( fs, 0 );
                                        meta[k].writeData( fs );
                                    }
                                    meta.Clear();
                                    last_clock = 0;
                                }
                                VsqFile.writeFlexibleLengthUnsignedLong( fs, (ulong)(events[j].Clock - last_clock) );
                                events[j].writeData( fs );
                                last_clock = events[j].Clock;
                            }

                            // トラックエンドを記入し、
                            VsqFile.writeFlexibleLengthUnsignedLong( fs, (ulong)0 );
                            fs.WriteByte( 0xff );
                            fs.WriteByte( 0x2f );
                            fs.WriteByte( 0x00 );
                            // チャンクの先頭に戻ってチャンクのサイズを記入
                            long pos = fs.Position;
                            fs.Seek( first_position - 4, SeekOrigin.Begin );
                            VsqFile.writeUnsignedInt( fs, (uint)(pos - first_position) );
                            // ファイルを元の位置にseek
                            fs.Seek( pos, SeekOrigin.Begin );
                        }
                    }
                }
            }
        }

        private void menuFileImportUst_Click( object sender, EventArgs e ) {
            if ( !DirtyCheck() ) {
                return;
            }
            DialogResult dr = DialogResult.Cancel;
            if ( AppManager.EditorConfig.UseCustomFileDialog ) {
                using ( FileDialog fd = new FileDialog( FileDialog.DialogMode.Open ) ) {
                    if ( openUstDialog.FileName != "" ) {
                        fd.FileName = openUstDialog.FileName;
                    }
                    fd.Filter = openUstDialog.Filter;
                    dr = fd.ShowDialog();
                    if ( dr == DialogResult.OK ) {
                        openUstDialog.FileName = fd.FileName;
                    }
                }
            } else {
                dr = openUstDialog.ShowDialog();
            }

            if ( dr == DialogResult.OK ) {
                try {
                    UstFile ust = new UstFile( openUstDialog.FileName );
                    VsqFileEx vsq = new VsqFileEx( ust );
                    ClearExistingData();
                    m_manager.SetVsqFile( vsq );
                    Edited = false;
                    m_mixer_dlg.UpdateStatus();
                    ClearTempWave();
#if USE_DOBJ
                    UpdateDrawObjectList();
#endif
#if VER_2_1
                    InitContextProperty();
#endif
                    RefreshScreen();
                } catch {
                }
            }
        }

        private void commonFileOpen_Click( object sender, EventArgs e ) {
            if ( !DirtyCheck() ) {
                return;
            }
            DialogResult dr = DialogResult.Cancel;
            if ( AppManager.EditorConfig.UseCustomFileDialog ) {
                using ( FileDialog fd = new FileDialog( FileDialog.DialogMode.Open ) ) {
                    if ( openXmlVsqDialog.FileName != "" ) {
                        fd.FileName = openXmlVsqDialog.FileName;
                    }
                    fd.Filter = openXmlVsqDialog.Filter;
                    dr = fd.ShowDialog();
                    if ( dr == DialogResult.OK ) {
                        openXmlVsqDialog.FileName = fd.FileName;
                    }
                }
            } else {
                //openXmlVsqDialog
                dr = openXmlVsqDialog.ShowDialog();
            }
            if ( dr == DialogResult.OK ) {
                if ( m_manager.Playing ) {
                    m_manager.Playing = false;
                }
                OpenVsqCore( openXmlVsqDialog.FileName );
                ClearExistingData();
                Edited = false;
                m_mixer_dlg.UpdateStatus();
                ClearTempWave();
#if USE_DOBJ
                UpdateDrawObjectList();
#endif
                RefreshScreen();
            }
        }

        private void commonFileNew_Click( object sender, EventArgs e ) {
            if ( !DirtyCheck() ) {
                return;
            }
            m_manager.Selected = 1;
            m_manager.SetVsqFile( new VsqFileEx( AppManager.EditorConfig.DefaultSingerName, AppManager.EditorConfig.DefaultPreMeasure, 4, 4, 500000 ) );
            ClearExistingData();
            Edited = false;
            m_mixer_dlg.UpdateStatus();
            ClearTempWave();
#if USE_DOBJ
            UpdateDrawObjectList();
#endif
#if VER_2_1
            InitContextProperty();
#endif
            RefreshScreen();
        }
        #endregion

        #region menuSetting*
        private void menuSettingDefaultSingerStyle_Click( object sender, EventArgs e ) {
            using ( FormSingerStyleConfig dlg = new FormSingerStyleConfig( _( "Default Singer Style" ), true ) ) {
                dlg.PMBendDepth = AppManager.EditorConfig.DefaultPMBendDepth;
                dlg.PMBendLength = AppManager.EditorConfig.DefaultPMBendLength;
                dlg.PMbPortamentoUse = AppManager.EditorConfig.DefaultPMbPortamentoUse;
                dlg.DEMdecGainRate = AppManager.EditorConfig.DefaultDEMdecGainRate;
                dlg.DEMaccent = AppManager.EditorConfig.DefaultDEMaccent;

                dlg.Location = GetFormPreferedLocation( dlg );
                if ( dlg.ShowDialog() == DialogResult.OK ) {
                    if ( dlg.ApplyCurrentTrack ) {
                        VsqTrack copy = (VsqTrack)m_manager.VsqFile.Track[m_manager.Selected].Clone();
                        bool changed = false;
                        for ( int i = 0; i < copy.getEventCount(); i++ ) {
                            if ( copy.getEvent( i ).ID.type == VsqIDType.Anote ) {
                                copy.getEvent( i ).ID.PMBendDepth = dlg.PMBendDepth;
                                copy.getEvent( i ).ID.PMBendLength = dlg.PMBendLength;
                                copy.getEvent( i ).ID.PMbPortamentoUse = dlg.PMbPortamentoUse;
                                copy.getEvent( i ).ID.DEMdecGainRate = dlg.DEMdecGainRate;
                                copy.getEvent( i ).ID.DEMaccent = dlg.DEMaccent;
                                changed = true;
                            }
                        }
                        if ( changed ) {
                            CadenciiCommand run = VsqFileEx.generateCommandTrackReplace( m_manager.Selected, 
                                                                                         copy,
                                                                                         m_manager.VsqFile.AttachedCurves[m_manager.Selected - 1],
                                                                                         m_manager.VsqFile.getPitchCurve( m_manager.Selected ) );
                            m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
#if USE_DOBJ
                            UpdateDrawObjectList();
#endif
                            RefreshScreen();
                        }
                    }
                    AppManager.EditorConfig.DefaultPMBendDepth = dlg.PMBendDepth;
                    AppManager.EditorConfig.DefaultPMBendLength = dlg.PMBendLength;
                    AppManager.EditorConfig.DefaultPMbPortamentoUse = dlg.PMbPortamentoUse;
                    AppManager.EditorConfig.DefaultDEMdecGainRate = dlg.DEMdecGainRate;
                    AppManager.EditorConfig.DefaultDEMaccent = dlg.DEMaccent;
                }
            }
        }

        private void menuSettingPreference_Click( object sender, EventArgs e ) {
            if ( m_preference_dlg == null ) {
                m_preference_dlg = new Preference();
            }
            m_preference_dlg.BaseFont = new Font( AppManager.EditorConfig.BaseFontName, 9 );
            m_preference_dlg.ScreenFont = new Font( AppManager.EditorConfig.ScreenFontName, 9 );
            m_preference_dlg.CounterFont = new Font( AppManager.EditorConfig.CounterFontName, 9 );
            m_preference_dlg.WheelOrder = AppManager.EditorConfig.WheelOrder;
            m_preference_dlg.CursorFixed = AppManager.EditorConfig.CursorFixed;
            m_preference_dlg.DefaultVibratoLength = AppManager.EditorConfig.DefaultVibratoLength;
            m_preference_dlg.AutoVibratoMinimumLength = AppManager.EditorConfig.AutoVibratoMinimumLength;
            m_preference_dlg.AutoVibratoType = AppManager.EditorConfig.AutoVibratoType;
            m_preference_dlg.EnableAutoVibrato = AppManager.EditorConfig.EnableAutoVibrato;
            m_preference_dlg.PreMeasure = m_manager.VsqFile.getPreMeasure();
            m_preference_dlg.PreSendTime = AppManager.EditorConfig.PreSendTime;
            m_preference_dlg.ControlCurveResolution = AppManager.EditorConfig.ControlCurveResolution;
            m_preference_dlg.DefaultSingerName = AppManager.EditorConfig.DefaultSingerName;
            m_preference_dlg.ScrollHorizontalOnWheel = AppManager.EditorConfig.ScrollHorizontalOnWheel;
            m_preference_dlg.MaximumFrameRate = AppManager.EditorConfig.MaximumFrameRate;
            m_preference_dlg.Platform = AppManager.EditorConfig.Platform;
            m_preference_dlg.KeepLyricInputMode = AppManager.EditorConfig.KeepLyricInputMode;
            m_preference_dlg.PxTrackHeight = AppManager.EditorConfig.PxTrackHeight;
            m_preference_dlg.MouseHoverTime = AppManager.EditorConfig.MouseHoverTime;
            m_preference_dlg.PlayPreviewWhenRightClick = AppManager.EditorConfig.PlayPreviewWhenRightClick;
            m_preference_dlg.CurveSelectingQuantized = AppManager.EditorConfig.CurveSelectingQuantized;
            m_preference_dlg.CurveVisibleAccent = AppManager.EditorConfig.CurveVisibleAccent;
            m_preference_dlg.CurveVisibleBre = AppManager.EditorConfig.CurveVisibleBreathiness;
            m_preference_dlg.CurveVisibleBri = AppManager.EditorConfig.CurveVisibleBrightness;
            m_preference_dlg.CurveVisibleCle = AppManager.EditorConfig.CurveVisibleClearness;
            m_preference_dlg.CurveVisibleDecay = AppManager.EditorConfig.CurveVisibleDecay;
            m_preference_dlg.CurveVisibleDyn = AppManager.EditorConfig.CurveVisibleDynamics;
            m_preference_dlg.CurveVisibleGen = AppManager.EditorConfig.CurveVisibleGendorfactor;
            m_preference_dlg.CurveVisibleOpe = AppManager.EditorConfig.CurveVisibleOpening;
            m_preference_dlg.CurveVisiblePitch = AppManager.EditorConfig.CurveVisiblePitch;
            m_preference_dlg.CurveVisiblePor = AppManager.EditorConfig.CurveVisiblePortamento;
            m_preference_dlg.CurveVisibleVel = AppManager.EditorConfig.CurveVisibleVelocity;
            m_preference_dlg.CurveVisibleVibratoDepth = AppManager.EditorConfig.CurveVisibleVibratoDepth;
            m_preference_dlg.CurveVisibleVibratoRate = AppManager.EditorConfig.CurveVisibleVibratoRate;
            m_preference_dlg.CurveVisibleFx2Depth = AppManager.EditorConfig.CurveVisibleFx2Depth;
            m_preference_dlg.CurveVisibleHarmonics = AppManager.EditorConfig.CurveVisibleHarmonics;
            m_preference_dlg.CurveVisibleReso1 = AppManager.EditorConfig.CurveVisibleReso1;
            m_preference_dlg.CurveVisibleReso2 = AppManager.EditorConfig.CurveVisibleReso2;
            m_preference_dlg.CurveVisibleReso3 = AppManager.EditorConfig.CurveVisibleReso3;
            m_preference_dlg.CurveVisibleReso4 = AppManager.EditorConfig.CurveVisibleReso4;
            m_preference_dlg.MidiInPort = AppManager.EditorConfig.MidiInPort;
            m_preference_dlg.InvokeWithWine = AppManager.EditorConfig.InvokeUtauCoreWithWine;
            m_preference_dlg.PathResampler = AppManager.EditorConfig.PathResampler;
            m_preference_dlg.PathWavtool = AppManager.EditorConfig.PathWavtool;
            m_preference_dlg.UtauSingers = AppManager.EditorConfig.UtauSingers;
            m_preference_dlg.UseCustomFileDialog = AppManager.EditorConfig.UseCustomFileDialog;
            m_preference_dlg.SelfDeRomantization = AppManager.EditorConfig.SelfDeRomanization;

            m_preference_dlg.Location = GetFormPreferedLocation( m_preference_dlg );
            
            if ( m_preference_dlg.ShowDialog() == DialogResult.OK ) {
                AppManager.EditorConfig.BaseFontName = m_preference_dlg.BaseFont.Name;
                AppManager.EditorConfig.BaseFontSize = m_preference_dlg.BaseFont.SizeInPoints;
                UpdateMenuFonts();

                AppManager.EditorConfig.ScreenFontName = m_preference_dlg.ScreenFont.Name;
                AppManager.EditorConfig.CounterFontName = m_preference_dlg.CounterFont.Name;
                AppManager.EditorConfig.WheelOrder = m_preference_dlg.WheelOrder;
                AppManager.EditorConfig.CursorFixed = m_preference_dlg.CursorFixed;

                AppManager.EditorConfig.DefaultVibratoLength = m_preference_dlg.DefaultVibratoLength;
                AppManager.EditorConfig.AutoVibratoMinimumLength = m_preference_dlg.AutoVibratoMinimumLength;
                AppManager.EditorConfig.AutoVibratoType = m_preference_dlg.AutoVibratoType;

                AppManager.EditorConfig.EnableAutoVibrato = m_preference_dlg.EnableAutoVibrato;
                AppManager.EditorConfig.PreSendTime = m_preference_dlg.PreSendTime;
                AppManager.EditorConfig.DefaultPreMeasure = m_preference_dlg.PreMeasure;
                if ( m_preference_dlg.PreMeasure != m_manager.VsqFile.getPreMeasure() ) {
                    CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandChangePreMeasure( m_preference_dlg.PreMeasure ) );
                    m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
                    Edited = true;
                }
                AppManager.EditorConfig.Language = m_preference_dlg.Language;
                if ( Messaging.Language != AppManager.EditorConfig.Language ) {
                    Messaging.Language = AppManager.EditorConfig.Language;
                    ApplyLanguage();
                    m_preference_dlg.ApplyLanguage();
                    m_mixer_dlg.ApplyLanguage();
                    if ( m_versioninfo != null && !m_versioninfo.IsDisposed ) {
                        m_versioninfo.ApplyLanguage();
                    }
                }

                AppManager.EditorConfig.ControlCurveResolution = m_preference_dlg.ControlCurveResolution;
                AppManager.EditorConfig.DefaultSingerName = m_preference_dlg.DefaultSingerName;
                AppManager.EditorConfig.ScrollHorizontalOnWheel = m_preference_dlg.ScrollHorizontalOnWheel;
                AppManager.EditorConfig.MaximumFrameRate = m_preference_dlg.MaximumFrameRate;
                int fps = 1000 / AppManager.EditorConfig.MaximumFrameRate;
                timer.Interval = (fps <= 0) ? 1 : fps;
                AppManager.EditorConfig.Platform = m_preference_dlg.Platform;
                s_modifier_key = ((AppManager.EditorConfig.Platform == Platform.Macintosh) ? Keys.Menu : Keys.Control);
                ApplyPlatformDependentShortCut();
                AppManager.EditorConfig.KeepLyricInputMode = m_preference_dlg.KeepLyricInputMode;
                if ( AppManager.EditorConfig.PxTrackHeight != m_preference_dlg.PxTrackHeight ) {
                    AppManager.EditorConfig.PxTrackHeight = m_preference_dlg.PxTrackHeight;
#if USE_DOBJ
                    UpdateDrawObjectList();
#endif
                }
                AppManager.EditorConfig.MouseHoverTime = m_preference_dlg.MouseHoverTime;
                AppManager.EditorConfig.PlayPreviewWhenRightClick = m_preference_dlg.PlayPreviewWhenRightClick;
                AppManager.EditorConfig.CurveSelectingQuantized = m_preference_dlg.CurveSelectingQuantized;

                AppManager.EditorConfig.CurveVisibleAccent = m_preference_dlg.CurveVisibleAccent;
                AppManager.EditorConfig.CurveVisibleBreathiness = m_preference_dlg.CurveVisibleBre;
                AppManager.EditorConfig.CurveVisibleBrightness = m_preference_dlg.CurveVisibleBri;
                AppManager.EditorConfig.CurveVisibleClearness = m_preference_dlg.CurveVisibleCle;
                AppManager.EditorConfig.CurveVisibleDecay = m_preference_dlg.CurveVisibleDecay;
                AppManager.EditorConfig.CurveVisibleDynamics = m_preference_dlg.CurveVisibleDyn;
                AppManager.EditorConfig.CurveVisibleGendorfactor = m_preference_dlg.CurveVisibleGen;
                AppManager.EditorConfig.CurveVisibleOpening = m_preference_dlg.CurveVisibleOpe;
                AppManager.EditorConfig.CurveVisiblePitch = m_preference_dlg.CurveVisiblePitch;
                AppManager.EditorConfig.CurveVisiblePortamento = m_preference_dlg.CurveVisiblePor;
                AppManager.EditorConfig.CurveVisibleVelocity = m_preference_dlg.CurveVisibleVel;
                AppManager.EditorConfig.CurveVisibleVibratoDepth = m_preference_dlg.CurveVisibleVibratoDepth;
                AppManager.EditorConfig.CurveVisibleVibratoRate = m_preference_dlg.CurveVisibleVibratoRate;
                AppManager.EditorConfig.CurveVisibleFx2Depth = m_preference_dlg.CurveVisibleFx2Depth;
                AppManager.EditorConfig.CurveVisibleHarmonics = m_preference_dlg.CurveVisibleHarmonics;
                AppManager.EditorConfig.CurveVisibleReso1 = m_preference_dlg.CurveVisibleReso1;
                AppManager.EditorConfig.CurveVisibleReso2 = m_preference_dlg.CurveVisibleReso2;
                AppManager.EditorConfig.CurveVisibleReso3 = m_preference_dlg.CurveVisibleReso3;
                AppManager.EditorConfig.CurveVisibleReso4 = m_preference_dlg.CurveVisibleReso4;

                AppManager.EditorConfig.MidiInPort = m_preference_dlg.MidiInPort;
                UpdateMidiInStatus();
                ReloadMidiIn();

                AppManager.EditorConfig.InvokeUtauCoreWithWine = m_preference_dlg.InvokeWithWine;
                AppManager.EditorConfig.PathResampler = m_preference_dlg.PathResampler;
                AppManager.EditorConfig.PathWavtool = m_preference_dlg.PathWavtool;
                AppManager.EditorConfig.UtauSingers.Clear();
                foreach ( SingerConfig sc in m_preference_dlg.UtauSingers ) {
                    AppManager.EditorConfig.UtauSingers.Add( (SingerConfig)sc.Clone() );
                }
                AppManager.EditorConfig.UseCustomFileDialog = m_preference_dlg.UseCustomFileDialog;
                AppManager.EditorConfig.SelfDeRomanization = m_preference_dlg.SelfDeRomantization;

                List<CurveType> visible_curves = new List<CurveType>();
                trackSelector.ClearViewingCurve();

                UpdateTrackSelectorVisibleCurve();
                UpdateRendererMenu();

                m_manager.SendEditorConfigChangedMessage();
                AppManager.SaveConfig();
                m_manager_ApplyEditorConfigRequired( this, new EventArgs() );
            }
        }

        private void menuSettingBgmSetSound_Click( object sender, EventArgs e ) {
            if ( m_manager.Playing ) {
                return;
            }
            using ( OpenFileDialog ofd = new OpenFileDialog() ) {
                ofd.Filter = _( "MP3 File(*.mp3)|*.mp3" ) + "|" + _( "Wave File(*.wav)|*.wav" ) + "|" + _( "All Files(*.*)|*.*" );
                if ( ofd.ShowDialog() == DialogResult.OK ) {
                    //m_manager.BgmPlayer.Load( ofd.FileName );
                }
            }
        }

        private void menuSettingGameControlerReload_Click( object sender, EventArgs e ) {
            ReloadGameControler();
        }
        #endregion

        #region menuEdit*
        private void menuEditDelete_Click( object sender, EventArgs e ) {
            DeleteEvent();
        }

        private void commonEditPaste_Click( object sender, EventArgs e ) {
            PasteEvent();
        }

        private void commonEditCopy_Click( object sender, EventArgs e ) {
#if DEBUG
            Common.DebugWriteLine( "menuEditCopy_Click" );
            Common.DebugWriteLine( "    trackSelector.SelectedRegionEnabled=" + trackSelector.SelectedRegionEnabled );
#endif
            CopyEvent();
        }

        private void commonEditCut_Click( object sender, EventArgs e ) {
            CutEvent();
        }

        private void menuEdit_DropDownOpening( object sender, EventArgs e ) {
            UpdateCopyAndPasteButtonStatus();
        }

        private void commonEditUndo_Click( object sender, EventArgs e ) {
#if DEBUG
            Common.DebugWriteLine( "menuEditUndo_Click" );
#endif
            Undo();
            RefreshScreen();
        }


        private void commonEditRedo_Click( object sender, EventArgs e ) {
#if DEBUG
            Common.DebugWriteLine( "menuEditRedo_Click" );
#endif
            Redo();
            RefreshScreen();
        }

        private void menuEditSelectAllEvents_Click( object sender, EventArgs e ) {
            SelectAllEvent();
        }

        private void menuEditSelectAll_Click( object sender, EventArgs e ) {
            SelectAll();
        }

        private void menuEditAutoNormalizeMode_Click( object sender, EventArgs e ) {
            m_manager.AutoNormalize = !m_manager.AutoNormalize;
            menuEditAutoNormalizeMode.Checked = m_manager.AutoNormalize;
        }
        #endregion

        #region menuLyric*
        private void menuLyric_DropDownOpening( object sender, EventArgs e ) {
            menuLyricExpressionProperty.Enabled = (m_manager.SelectedEvent.LastSelected != null);
        }

        private void menuLyricProperty_Click( object sender, EventArgs e ) {
            NoteExpressionProperty();
        }

        private void menuLyricDictionary_Click( object sender, EventArgs e ) {
            using ( FormWordDictionary dlg = new FormWordDictionary() ) {
                dlg.Location = GetFormPreferedLocation( dlg );
                if ( dlg.ShowDialog() == DialogResult.OK ) {
                    List<KeyValuePair<string, bool>> result = dlg.Result;
                    SymbolTable.changeOrder( result.ToArray() );
                }
            }
        }

        private void menuLyricVibratoProperty_Click( object sender, EventArgs e ) {
            NoteVibratoProperty();
        }
        #endregion

        #region menuJob
        private void menuJobRealTime_Click( object sender, EventArgs e ) {
            if ( !m_manager.Playing ) {
                m_adding = null;
                m_manager.EditMode = EditMode.Realtime;
                m_manager.Playing = true;
            }
        }

        private void menuJobReloadVsti_Click( object sender, EventArgs e ) {
            //VSTiProxy.ReloadPlugin(); //todo: FormMain+menuJobReloadVsti_Click
        }
        
        private void menuJob_DropDownOpening( object sender, EventArgs e ) {
#if DEBUG
            Common.DebugWriteLine( "menuJob_DropDownOpening" );
            Common.DebugWriteLine( "    menuJob.Bounds=" + menuJob.Bounds );
#endif
            if ( m_manager.SelectedEvent.Count <= 1 ) {
                menuJobConnect.Enabled = false;
            } else {
                // menuJobConnect(音符の結合)がEnableされるかどうかは、選択されている音符がピアノロール上で連続かどうかで決まる
                int[] list = new int[m_manager.SelectedEvent.Count];
                for ( int i = 0; i < m_manager.VsqFile.Track[m_manager.Selected].getEventCount(); i++ ) {
                    int count = -1;
                    foreach ( SelectedEventEntry item in m_manager.SelectedEvent.GetEnumerator() ) {
                        int key = item.Original.InternalID;
                        count++;
                        if ( key == m_manager.VsqFile.Track[m_manager.Selected].getEvent( i ).InternalID ) {
                            list[count] = i;
                            break;
                        }
                    }
                }
                bool changed = true;
                while ( changed ) {
                    changed = false;
                    for ( int i = 0; i < list.Length - 1; i++ ) {
                        if ( list[i] > list[i + 1] ) {
                            int b = list[i];
                            list[i] = list[i + 1];
                            list[i + 1] = b;
                            changed = true;
                        }
                    }
                }
                bool continued = true;
                for ( int i = 0; i < list.Length - 1; i++ ) {
                    if ( list[i] + 1 != list[i + 1] ) {
                        continued = false;
                        break;
                    }
                }
                menuJobConnect.Enabled = continued;
            }

            menuJobLyric.Enabled = m_manager.SelectedEvent.LastSelected != null;
        }

        private void menuJobLyric_Click( object sender, EventArgs e ) {
            ImportLyric();
        }

        private void menuJobConnect_Click( object sender, EventArgs e ) {
            int count = m_manager.SelectedEvent.Count;
            int[] clocks = new int[count];
            VsqID[] ids = new VsqID[count];
            int[] internalids = new int[count];
            int i = -1;
            foreach ( SelectedEventEntry item in m_manager.SelectedEvent.GetEnumerator() ) {
                i++;
                clocks[i] = item.Original.Clock;
                ids[i] = (VsqID)item.Original.ID.Clone();
                internalids[i] = item.Original.InternalID;
            }
            bool changed = true;
            while ( changed ) {
                changed = false;
                for ( int j = 0; j < clocks.Length - 1; j++ ) {
                    if ( clocks[j] > clocks[j + 1] ) {
                        int b = clocks[j];
                        clocks[j] = clocks[j + 1];
                        clocks[j + 1] = b;
                        VsqID a = ids[j];
                        ids[j] = ids[j + 1];
                        ids[j + 1] = a;
                        changed = true;
                        b = internalids[j];
                        internalids[j] = internalids[j + 1];
                        internalids[j + 1] = b;
                    }
                }
            }

            for ( int j = 0; j < ids.Length - 1; j++ ) {
                ids[j].Length = clocks[j + 1] - clocks[j];
            }
            CadenciiCommand run = new CadenciiCommand( 
                VsqCommand.generateCommandEventChangeIDContaintsRange( m_manager.Selected, internalids, ids ) );
            m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
            Edited = true;
            this.Refresh();
        }

        private void menuJobInsertBar_Click( object sender, EventArgs e ) {
            int total_clock = m_manager.VsqFile.TotalClocks;
            int total_barcount = m_manager.VsqFile.getBarCountFromClock( total_clock ) + 1;
            using ( FormInsertBar dlg = new FormInsertBar( total_barcount ) ) {
                int current_clock = m_manager.CurrentClock;
                int barcount = m_manager.VsqFile.getBarCountFromClock( current_clock );
                int draft = barcount - m_manager.VsqFile.getPreMeasure() + 1;
                if ( draft <= 0 ) {
                    draft = 1;
                }
                dlg.Position = draft;

                dlg.Location = GetFormPreferedLocation( dlg );
                if ( dlg.ShowDialog() == DialogResult.OK ) {
                    int pos = dlg.Position + m_manager.VsqFile.getPreMeasure() - 1;
                    int length = dlg.Length;

                    int clock_start = m_manager.VsqFile.getClockFromBarCount( pos );
                    int clock_end = m_manager.VsqFile.getClockFromBarCount( pos + length );
                    int dclock = clock_end - clock_start;
                    VsqFileEx temp = (VsqFileEx)m_manager.VsqFile.Clone();

                    for ( int track = 1; track < temp.Track.Count; track++ ) {
                        BezierCurves newbc = new BezierCurves();
                        foreach ( CurveType ct in BezierCurves.CURVE_USAGE ) {
                            int index = ct.Index;
                            if ( index < 0 ) {
                                continue;
                            }

                            List<BezierChain> list = new List<BezierChain>();
                            foreach ( BezierChain bc in temp.AttachedCurves[track -1][ct] ) {
                            //foreach ( int key in temp.AttachedCurves[track - 1][ct].Keys ) {
                                //BezierChain bc = temp.AttachedCurves[track - 1][ct][key];
                                if ( bc.Count < 2 ) {
                                    continue;
                                }
                                int chain_start = (int)bc.points[0].Base.X;
                                int chain_end = (int)bc.points[bc.points.Count - 1].Base.X;

                                if ( clock_start <= chain_start ) {
                                    for ( int i = 0; i < bc.points.Count; i++ ) {
                                        PointD t = bc.points[i].Base;
                                        bc.points[i].Base = new PointD( t.X + dclock, t.Y );
                                    }
                                    list.Add( bc );
                                } else if ( chain_start < clock_start && clock_start < chain_end ) {
                                    BezierChain adding1 = bc.ExtractPartialBezier( chain_start, clock_start );
                                    BezierChain adding2 = bc.ExtractPartialBezier( clock_start, chain_end );
                                    for ( int i = 0; i < adding2.points.Count; i++ ) {
                                        PointD t = adding2.points[i].Base;
                                        adding2.points[i].Base = new PointD( t.X + dclock, t.Y );
                                    }
                                    //PointD t2 = adding1.points[adding1.points.Count - 1].Base;
                                    adding1.points[adding1.points.Count - 1].ControlRightType = BezierControlType.None;
                                    /*BezierPoint bp = new BezierPoint( t2.X + dclock, t2.Y );
                                    bp.ControlLeftType = BezierControlType.None;
                                    bp.ControlRightType = BezierControlType.None;
                                    adding1.points.Add( bp );*/
                                    adding2.points[0].ControlLeftType = BezierControlType.None;
                                    for ( int i = 0; i < adding2.points.Count; i++ ) {
                                        adding1.points.Add( adding2.points[i] );
                                    }
                                    adding1.ID = bc.ID;
                                    list.Add( adding1 );
                                } else {
                                    list.Add( (BezierChain)bc.Clone() );
                                }
                            }

                            newbc[ct] = list;
                        }
                        temp.AttachedCurves[track - 1] = newbc;
                    }

                    for ( int track = 1; track < m_manager.VsqFile.Track.Count; track++ ) {
                        for ( int i = 0; i < temp.Track[track].getEventCount(); i++ ) {
                            if ( temp.Track[track].getEvent( i ).Clock >= clock_start ) {
                                temp.Track[track].getEvent( i ).Clock += dclock;
                            }
                        }
                        foreach ( CurveType curve in BezierCurves.CURVE_USAGE ) {
                            if ( curve.IsScalar || curve.IsAttachNote ) {
                                continue;
                            }
                            VsqBPList target;
                            VsqBPList src;
                            if ( curve == CurveType.Pitch ) {
                                target = temp.getPitchCurve( track );
                                src = m_manager.VsqFile.getPitchCurve( track );
                            } else {
                                target = temp.Track[track].getCurve( curve.Name );
                                src = m_manager.VsqFile.Track[track].getCurve( curve.Name );
                            }
                            target.clear();
                            for ( Iterator itr = src.keyClockIterator(); itr.hasNext(); ) {
                                int key = (int)itr.next();
                                if ( key >= clock_start ) {
                                    target.add( key + dclock, src.getValue( key ) );
                                } else {
                                    target.add( key, src.getValue( key ) );
                                }
                            }
                        }
                    }
                    for ( int i = 0; i < temp.getTempoList().Count; i++ ) {
                        if ( temp.getTempoList()[i].Clock >= clock_start ) {
                            temp.getTempoList()[i].Clock = temp.getTempoList()[i].Clock + dclock;
                        }
                    }
                    for ( int i = 0; i < temp.getTimeSigList().Count; i++ ) {
                        if ( temp.getTimeSigList()[i].Clock >= clock_start ) {
                            temp.getTimeSigList()[i].Clock = temp.getTimeSigList()[i].Clock + dclock;
                        }
                    }
                    temp.updateTempoInfo();
                    temp.updateTimesigInfo();

                    CadenciiCommand run = VsqFileEx.generateCommandReplace( temp );
                    m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
                    Edited = true;
                    this.Refresh();
                }
            }
        }

        private void menuJobDeleteBar_Click( object sender, EventArgs e ) {
            int total_clock = m_manager.VsqFile.TotalClocks;
            int total_barcount = m_manager.VsqFile.getBarCountFromClock( total_clock ) + 1;
            int clock = m_manager.CurrentClock;
            int barcount = m_manager.VsqFile.getBarCountFromClock( clock );
            using ( FormDeleteBar dlg = new FormDeleteBar( total_barcount ) ) {
                int draft = barcount - m_manager.VsqFile.getPreMeasure() + 1;
                if ( draft <= 0 ) {
                    draft = 1;
                }
                dlg.Start = draft;
                dlg.End = draft + 1;

                dlg.Location = GetFormPreferedLocation( dlg );
                if ( dlg.ShowDialog() == DialogResult.OK ) {
                    VsqFileEx temp = (VsqFileEx)m_manager.VsqFile.Clone();
                    int start = dlg.Start + m_manager.VsqFile.getPreMeasure() - 1;
                    int end = dlg.End + m_manager.VsqFile.getPreMeasure() - 1;
#if DEBUG
                    Common.DebugWriteLine( "FormMain+menuJobDeleteBar_Click" );
                    Common.DebugWriteLine( "    start,end=" + start + "," + end );
#endif
                    int clock_start = temp.getClockFromBarCount( start );
                    int clock_end = temp.getClockFromBarCount( end );
                    int dclock = clock_end - clock_start;
                    for ( int track = 1; track < temp.Track.Count; track++ ) {
                        BezierCurves newbc = new BezierCurves();
                        foreach ( CurveType ct in BezierCurves.CURVE_USAGE ) {
                            int index = ct.Index;
                            if ( index < 0 ) {
                                continue;
                            }

                            List<BezierChain> list = new List<BezierChain>();
                            foreach ( BezierChain bc in temp.AttachedCurves[track - 1][ct] ) {
                                if ( bc.Count < 2 ) {
                                    continue;
                                }
                                int chain_start = (int)bc.points[0].Base.X;
                                int chain_end = (int)bc.points[bc.points.Count - 1].Base.X;

                                if ( clock_start < chain_start && chain_start < clock_end && clock_end < chain_end ) {
                                    BezierChain adding = bc.ExtractPartialBezier( clock_end, chain_end );
                                    adding.ID = bc.ID;
                                    for ( int i = 0; i < adding.points.Count; i++ ) {
                                        PointD t = adding.points[i].Base;
                                        adding.points[i].Base = new PointD( t.X - dclock, t.Y );
                                    }
                                    list.Add( adding );
                                } else if ( chain_start < clock_start && clock_end < chain_end ) {
                                    BezierChain adding1 = bc.ExtractPartialBezier( chain_start, clock_start );
                                    adding1.ID = bc.ID;
                                    adding1.points[adding1.points.Count - 1].ControlRightType = BezierControlType.None;
                                    BezierChain adding2 = bc.ExtractPartialBezier( clock_end, chain_end );
                                    adding2.points[0].ControlLeftType = BezierControlType.None;
                                    PointD t = adding2.points[0].Base;
                                    adding2.points[0].Base = new PointD( t.X - dclock, t.Y );
                                    adding1.points.Add( adding2.points[0] );
                                    for ( int i = 1; i < adding2.points.Count; i++ ) {
                                        t = adding2.points[i].Base;
                                        adding2.points[i].Base = new PointD( t.X - dclock, t.Y );
                                        adding1.points.Add( adding2.points[i] );
                                    }
                                    list.Add( adding1 );
                                } else if ( chain_start < clock_start && clock_start < chain_end && chain_end < clock_end ) {
                                    BezierChain adding = bc.ExtractPartialBezier( chain_start, clock_start );
                                    adding.ID = bc.ID;
                                    list.Add( adding );
                                } else if ( clock_end <= chain_start || chain_end <= clock_start ) {
                                    if ( clock_end <= chain_start ) {
                                        for ( int i = 0; i < bc.points.Count; i++ ) {
                                            PointD t = bc.points[i].Base;
                                            bc.points[i].Base = new PointD( t.X - dclock, t.Y );
                                        }
                                    }
                                    list.Add( (BezierChain)bc.Clone() );
                                }
                            }

                            newbc[ct] = list;
                        }
                        temp.AttachedCurves[track - 1] = newbc;
                    }

                    temp.removePart( clock_start, clock_end );
                    CadenciiCommand run = VsqFileEx.generateCommandReplace( temp );
                    m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
                    Edited = true;
                    this.Refresh();
                }
            }
        }

        private void menuJobNormalize_Click( object sender, EventArgs e ) {
            VsqFile work = (VsqFile)m_manager.VsqFile.Clone();
            int track = m_manager.Selected;
            bool changed = true;
            bool total_changed = false;

            // 最初、開始時刻が同じになっている奴を削除
            while ( changed ) {
                changed = false;
                for ( int i = 0; i < work.Track[track].getEventCount() - 1; i++ ) {
                    int clock = work.Track[track].getEvent( i ).Clock;
                    int id = work.Track[track].getEvent( i ).InternalID;
                    for ( int j = i + 1; j < work.Track[track].getEventCount(); j++ ) {
                        if ( clock == work.Track[track].getEvent( j ).Clock ) {
                            if ( id < work.Track[track].getEvent( j ).InternalID ) { //内部IDが小さい＝より高年齢（音符追加時刻が古い）
                                work.Track[track].removeEvent( i );
                            } else {
                                work.Track[track].removeEvent( j );
                            }
                            changed = true;
                            total_changed = true;
                            break;
                        }
                    }
                    if ( changed ) {
                        break;
                    }
                }
            }

            changed = true;
            while ( changed ) {
                changed = false;
                for ( int i = 0; i < work.Track[track].getEventCount() - 1; i++ ) {
                    int start_clock = work.Track[track].getEvent( i ).Clock;
                    int end_clock = work.Track[track].getEvent( i ).ID.Length + start_clock;
                    for ( int j = i + 1; j < work.Track[track].getEventCount(); j++ ) {
                        int this_start_clock = work.Track[track].getEvent( j ).Clock;
                        if ( this_start_clock < end_clock ) {
                            work.Track[track].getEvent( i ).ID.Length = this_start_clock - start_clock;
                            changed = true;
                            total_changed = true;
                        }
                    }
                }
            }

            if ( total_changed ) {
                CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandReplace( work ) );
                m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
                Edited = true;
                RefreshScreen();
            }
        }
        #endregion

        #region menuScript
        private void menuScriptUpdate_Click( object sender, EventArgs e ) {
            UpdateScriptShortcut();
        }
        #endregion

        #region vScroll
        private void vScroll_Enter( object sender, EventArgs e ) {
            pictPianoRoll.Select();
        }

        private void vScroll_Resize( object sender, EventArgs e ) {
            SetVScrollRange( vScroll.Maximum );
        }

        private void vScroll_ValueChanged( object sender, EventArgs e ) {
            if ( m_txtbox_track_name != null ) {
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
                m_txtbox_track_name = null;
            }
            RefreshScreen();
        }
        #endregion

        #region hScroll
        private void hScroll_Enter( object sender, EventArgs e ) {
            pictPianoRoll.Select();
        }

        private void hScroll_Resize( object sender, EventArgs e ) {
            SetHScrollRange( hScroll.Maximum );
        }

        private void hScroll_ValueChanged( object sender, EventArgs e ) {
#if DEBUG
            //Console.WriteLine( "hScroll_ValueChanged" );
            //Console.WriteLine( "    Value/Maximum=" + hScroll.Value + "/" + hScroll.Maximum );
            //Console.WriteLine( "    LargeChange=" + hScroll.LargeChange );
#endif
            m_manager.StartToDrawX = (int)(hScroll.Value * m_manager.ScaleX);
            if ( m_txtbox_track_name != null ) {
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
                m_txtbox_track_name = null;
            }
            RefreshScreen();
        }
        #endregion

        #region picturePositionIndicator
        private void picturePositionIndicator_MouseWheel( object sender, MouseEventArgs e ) {
            hScroll.Value = NewHScrollValueFromWheelDelta( e.Delta );
        }

        private void picturePositionIndicator_MouseDoubleClick( object sender, MouseEventArgs e ) {
            if ( e.X < AppManager._KEY_LENGTH || Width - 3 < e.X ) {
                return;
            }
            if ( e.Button == MouseButtons.Left ) {
                if ( 18 < e.Y && e.Y <= 32 ) {
                    #region テンポの変更
                    int index = -1;
                    for ( int i = 0; i < m_manager.VsqFile.getTempoList().Count; i++ ) {
                        int clock = m_manager.VsqFile.getTempoList()[i].Clock;
                        int x = XCoordFromClocks( clock );
                        if ( x < 0 ) {
                            continue;
                        } else if ( Width < x ) {
                            break;
                        }
                        string s = (60e6 / (float)m_manager.VsqFile.getTempoList()[i].Tempo).ToString( "#.00" );
                        SizeF size = Common.MeasureString( s, new Font( AppManager.EditorConfig.ScreenFontName, 8 ) );
                        if ( IsInRect( e.Location, new Rectangle( x, 14, (int)size.Width, 14 ) ) ) {
                            index = i;
                            break;
                        }
                    }

                    if ( index < 0 ) {
                        return;
                    }

                    TempoTableEntry tte = m_manager.VsqFile.getTempoList()[index];
                    m_manager.ClearSelectedTempo();
                    m_manager.AddSelectedTempo( tte.Clock );
                    int bar_count = m_manager.VsqFile.getBarCountFromClock( tte.Clock );
                    int bar_top_clock = m_manager.VsqFile.getClockFromBarCount( bar_count );
                    int local_denominator, local_numerator;
                    m_manager.VsqFile.getTimesigAt( tte.Clock, out local_numerator, out local_denominator );
                    int clock_per_beat = 480 * 4 / local_denominator;
                    int clocks_in_bar = tte.Clock - bar_top_clock;
                    int beat_in_bar = clocks_in_bar / clock_per_beat + 1;
                    int clocks_in_beat = clocks_in_bar - (beat_in_bar - 1) * clock_per_beat;
                    using ( FormTempoConfig dlg = new FormTempoConfig( bar_count, beat_in_bar, local_numerator, clocks_in_beat, clock_per_beat, (decimal)(6e7 / tte.Tempo) ) ) {
                        dlg.Location = GetFormPreferedLocation( dlg );
                        if ( dlg.ShowDialog() == DialogResult.OK ) {
                            int new_beat = dlg.BeatCount;
                            int new_clocks_in_beat = dlg.Clock;
                            int new_clock = bar_top_clock + (new_beat - 1) * clock_per_beat + new_clocks_in_beat;
                            CadenciiCommand run = new CadenciiCommand( 
                                VsqCommand.generateCommandUpdateTempo( new_clock, new_clock, (int)(6e7 / (double)dlg.Tempo) ) );
                            m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
                            Edited = true;
                            RefreshScreen();
                        }
                    }

                    #endregion
                } else if ( 32 < e.Y && e.Y <= picturePositionIndicator.Height - 1 ) {
                    #region 拍子の変更
                    int index = -1;
                    // クリック位置に拍子が表示されているかどうか検査
                    for ( int i = 0; i < m_manager.VsqFile.getTimeSigList().Count; i++ ) {
                        string s = m_manager.VsqFile.getTimeSigList()[i].Numerator + "/" + m_manager.VsqFile.getTimeSigList()[i].Denominator;
                        int x = XCoordFromClocks( m_manager.VsqFile.getTimeSigList()[i].Clock );
                        SizeF size = Common.MeasureString( s, new Font( AppManager.EditorConfig.ScreenFontName, 8 ) );
                        if ( IsInRect( e.Location, new Rectangle( x, 28, (int)size.Width, 14 ) ) ) {
                            index = i;
                            break;
                        }
                    }

                    if ( index < 0 ) {
                        return;
                    }

                    int pre_measure = m_manager.VsqFile.getPreMeasure();
                    int clock = ClockFromXCoord( e.X );
                    int bar_count = m_manager.VsqFile.getBarCountFromClock( clock );
                    int numerator, denominator;
                    int total_clock = m_manager.VsqFile.TotalClocks;
                    //int max_barcount = m_manager.VsqFile.getBarCountFromClock( total_clock );
                    //int min_barcount = 1 - pre_measure;
                    m_manager.VsqFile.getTimesigAt( clock, out numerator, out denominator );
                    bool num_enabled = !(bar_count == 0);
                    using ( FormBeatConfig dlg = new FormBeatConfig( bar_count - pre_measure + 1, numerator, denominator, num_enabled ) ) {
                        dlg.Location = GetFormPreferedLocation( dlg );
                        if ( dlg.ShowDialog() == DialogResult.OK ) {
                            if ( dlg.EndSpecified ) {
                                int[] new_barcounts = new int[2];
                                int[] numerators = new int[2];
                                int[] denominators = new int[2];
                                int[] barcounts = new int[2];
                                new_barcounts[0] = dlg.Start + pre_measure - 1;
                                new_barcounts[1] = dlg.End + pre_measure - 1;
                                numerators[0] = dlg.Numerator;
                                denominators[0] = dlg.Denominator;
                                numerators[1] = numerator;
                                denominators[1] = denominator;
                                barcounts[0] = bar_count;
                                barcounts[1] = dlg.End + pre_measure - 1;
                                CadenciiCommand run = new CadenciiCommand( 
                                    VsqCommand.generateCommandUpdateTimesigRange( barcounts, new_barcounts, numerators, denominators ) );
                                m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
                                Edited = true;
                            } else {
                                CadenciiCommand run = new CadenciiCommand(
                                    VsqCommand.generateCommandUpdateTimesig( bar_count, dlg.Start + pre_measure - 1, dlg.Numerator, dlg.Denominator ) );
                                m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
                                Edited = true;
                            }
                        }
                    }
                    #endregion
                }
                picturePositionIndicator.Refresh();
                pictPianoRoll.Refresh();
            }
        }

        private void picturePositionIndicator_MouseDown( object sender, MouseEventArgs e ) {
            if ( m_txtbox_track_name != null ) {
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
                m_txtbox_track_name = null;
            }

            if ( e.X < AppManager._KEY_LENGTH || Width - 3 < e.X ) {
                return;
            }

            m_startmark_dragging = false;
            m_endmark_dragging = false;
            Keys modifier = Control.ModifierKeys;
            if ( e.Button == MouseButtons.Left ) {
                if ( 0 <= e.Y && e.Y <= 18 ) {
                    #region スタート/エンドマーク
                    if ( m_manager.StartMarkerEnabled ) {
                        int startx = XCoordFromClocks( m_manager.StartMarker ) - AppManager.EditorConfig.PxTolerance;
                        if ( startx <= e.X && e.X <= startx + AppManager.EditorConfig.PxTolerance * 2 + Properties.Resources.start_marker.Width ) {
                            m_startmark_dragging = true;
                        }
                    }
                    if ( m_manager.EndMarkerEnabled && !m_startmark_dragging ) {
                        int endx = XCoordFromClocks( m_manager.EndMarker ) - Properties.Resources.end_marker.Width - AppManager.EditorConfig.PxTolerance;
                        if ( endx <= e.X && e.X <= endx + AppManager.EditorConfig.PxTolerance * 2 + Properties.Resources.end_marker.Width ) {
                            m_endmark_dragging = true;
                        }
                    }
                    #endregion
                } else if ( 18 < e.Y && e.Y <= 32 ) {
                    #region テンポ
                    int index = -1;
                    for ( int i = 0; i < m_manager.VsqFile.getTempoList().Count; i++ ) {
                        int clock = m_manager.VsqFile.getTempoList()[i].Clock;
                        int x = XCoordFromClocks( clock );
                        if ( x < 0 ) {
                            continue;
                        } else if ( Width < x ) {
                            break;
                        }
                        string s = (60e6 / (float)m_manager.VsqFile.getTempoList()[i].Tempo).ToString( "#.00" );
                        SizeF size = Common.MeasureString( s, new Font( AppManager.EditorConfig.ScreenFontName, 8 ) );
                        if ( IsInRect( e.Location, new Rectangle( x, 14, (int)size.Width, 14 ) ) ) {
                            index = i;
                            break;
                        }
                    }

                    if ( index >= 0 ) {
                        int clock = m_manager.VsqFile.getTempoList()[index].Clock;
                        if ( m_manager.SelectedTool != EditTool.Eraser ) {
                            int mouse_clock = ClockFromXCoord( e.X );
                            m_tempo_dragging_deltaclock = mouse_clock - clock;
                            m_tempo_dragging = true;
                        }
                        if ( (modifier & Keys.Shift) == Keys.Shift ) {
                            if ( m_manager.SelectedTempo.Count > 0 ) {
                                int last_clock = m_manager.LastSelectedTempoClock;
                                int start = Math.Min( last_clock, clock );
                                int end = Math.Max( last_clock, clock );
                                for ( int i = 0; i < m_manager.VsqFile.getTempoList().Count; i++ ) {
                                    int tclock = m_manager.VsqFile.getTempoList()[i].Clock;
                                    if ( tclock < start ) {
                                        continue;
                                    } else if ( end < tclock ) {
                                        break;
                                    }
                                    if ( start <= tclock && tclock <= end ) {
                                        m_manager.AddSelectedTempo( tclock );
                                    }
                                }
                            } else {
                                m_manager.AddSelectedTempo( clock );
                            }
                        } else if ( (modifier & s_modifier_key) == s_modifier_key ) {
                            if ( m_manager.SelectedTempo.ContainsKey( clock ) ) {
                                m_manager.SelectedTempo.Remove( clock );
                            } else {
                                m_manager.AddSelectedTempo( clock );
                            }
                        } else {
                            if ( !m_manager.SelectedTempo.ContainsKey( clock ) ) {
                                m_manager.ClearSelectedTempo();
                            }
                            m_manager.AddSelectedTempo( clock );
                        }
                    } else {
                        m_manager.ClearSelectedEvent();
                        m_manager.ClearSelectedTempo();
                        m_manager.ClearSelectedTimesig();
                    }
                    #endregion
                } else if ( 32 < e.Y && e.Y <= picturePositionIndicator.Height - 1 ) {
                    #region 拍子
                    // クリック位置に拍子が表示されているかどうか検査
                    int index = -1;
                    for ( int i = 0; i < m_manager.VsqFile.getTimeSigList().Count; i++ ) {
                        string s = m_manager.VsqFile.getTimeSigList()[i].Numerator + "/" + m_manager.VsqFile.getTimeSigList()[i].Denominator;
                        int x = XCoordFromClocks( m_manager.VsqFile.getTimeSigList()[i].Clock );
                        SizeF size = Common.MeasureString( s, new Font( AppManager.EditorConfig.ScreenFontName, 8 ) );
                        if ( IsInRect( e.Location, new Rectangle( x, 28, (int)size.Width, 14 ) ) ) {
                            index = i;
                            break;
                        }
                    }

                    if ( index >= 0 ) {
                        int barcount = m_manager.VsqFile.getTimeSigList()[index].BarCount;
                        if ( m_manager.SelectedTool != EditTool.Eraser ) {
                            int barcount_clock = m_manager.VsqFile.getClockFromBarCount( barcount );
                            int mouse_clock = ClockFromXCoord( e.X );
                            m_timesig_dragging_deltaclock = mouse_clock - barcount_clock;
                            m_timesig_dragging = true;
                        }
                        if ( (modifier & Keys.Shift) == Keys.Shift ) {
                            if ( m_manager.SelectedTimesig.Count > 0 ) {
                                int last_barcount = m_manager.LastSelectedTimesigBarcount;
                                int start = Math.Min( last_barcount, barcount );
                                int end = Math.Max( last_barcount, barcount );
                                for ( int i = 0; i < m_manager.VsqFile.getTimeSigList().Count; i++ ) {
                                    int tbarcount = m_manager.VsqFile.getTimeSigList()[i].BarCount;
                                    if ( tbarcount < start ) {
                                        continue;
                                    } else if ( end < tbarcount ) {
                                        break;
                                    }
                                    if ( start <= tbarcount && tbarcount <= end ) {
                                        m_manager.AddSelectedTimesig( m_manager.VsqFile.getTimeSigList()[i].BarCount );
                                    }
                                }
                            } else {
                                m_manager.AddSelectedTimesig( barcount );
                            }
                        } else if ( (modifier & s_modifier_key) == s_modifier_key ) {
                            if ( m_manager.SelectedTimesig.ContainsKey( barcount ) ) {
                                m_manager.SelectedTimesig.Remove( barcount );
                            } else {
                                m_manager.AddSelectedTimesig( barcount );
                            }
                        } else {
                            if ( !m_manager.SelectedTimesig.ContainsKey( barcount ) ) {
                                m_manager.ClearSelectedTimesig();
                            }
                            m_manager.AddSelectedTimesig( barcount );
                        }
                    } else {
                        m_manager.ClearSelectedEvent();
                        m_manager.ClearSelectedTempo();
                        m_manager.ClearSelectedTimesig();
                    }
                    #endregion
                }
            }
            RefreshScreen();
        }

        private void picturePositionIndicator_MouseClick( object sender, MouseEventArgs e ) {
            if ( e.X < AppManager._KEY_LENGTH || Width - 3 < e.X ) {
                return;
            }

            Keys modifier = Control.ModifierKeys;
#if DEBUG
            Common.DebugWriteLine( "picturePositionIndicator_MouseClick" );
#endif
            if ( e.Button == MouseButtons.Left ) {
                if ( 4 <= e.Y && e.Y <= 18 ) {
                    #region マーカー位置の変更
                    if ( !m_startmark_dragging && !m_endmark_dragging ) {

                        int clock = ClockFromXCoord( e.X );
                        if ( AppManager.EditorConfig.PositionQuantize != QuantizeMode.off ) {
                            int unit = AppManager.GetPositionQuantizeClock();
                            int odd = clock % unit;
                            clock -= odd;
                            if ( odd > unit / 2 ) {
                                clock += unit;
                            }
                        }
                        m_manager.CurrentClock = clock;
                        RefreshScreen();
                    } else {
                        m_startmark_dragging = false;
                        m_endmark_dragging = false;
                    }
                    #endregion
                } else if ( 18 < e.Y && e.Y <= 32 ) {
                    if ( m_tempo_dragging ) {
                        int count = m_manager.SelectedTempo.Count;
                        int[] clocks = new int[count];
                        int[] new_clocks = new int[count];
                        int[] tempos = new int[count];
                        int i = -1;
                        bool contains_first_tempo = false;
                        foreach( int clock in m_manager.SelectedTempo.Keys ){
                            i++;
                            clocks[i] = clock;
                            if ( clock == 0 ) {
                                contains_first_tempo = true;
                                break;
                            }
                            new_clocks[i] = m_manager.SelectedTempo[clock].Editing.Clock;
                            tempos[i] = m_manager.SelectedTempo[clock].Editing.Tempo;
                        }
                        if ( contains_first_tempo ) {
                            System.Media.SystemSounds.Asterisk.Play();
                        } else {
                            CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandUpdateTempoRange( clocks, new_clocks, tempos ) );
                            m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
                            Edited = true;
                        }
                        m_tempo_dragging = false;
                    } else if( !m_startmark_dragging && !m_endmark_dragging ) {
                        #region テンポの変更
#if DEBUG
                        Common.DebugWriteLine( "TempoChange" );
#endif
                        m_manager.ClearSelectedEvent();
                        m_manager.ClearSelectedTimesig();
                        if ( m_manager.SelectedTempo.Count > 0 ) {
                            #region テンポ変更があった場合
                            int index = -1;
                            int clock = m_manager.LastSelectedTempoClock;
                            for ( int i = 0; i < m_manager.VsqFile.getTempoList().Count; i++ ) {
                                if ( clock == m_manager.VsqFile.getTempoList()[i].Clock ) {
                                    index = i;
                                    break;
                                }
                            }
                            if ( index >= 0 && m_manager.SelectedTool == EditTool.Eraser ) {
                                #region ツールがEraser
                                if ( m_manager.VsqFile.getTempoList()[index].Clock == 0 ) {
                                    MessageBox.Show( _( "Cannot remove first symbol of track!" ), _APP_NAME, MessageBoxButtons.OK, MessageBoxIcon.Information );
                                    return;
                                }
                                CadenciiCommand run = new CadenciiCommand(
                                    VsqCommand.generateCommandUpdateTempo( m_manager.VsqFile.getTempoList()[index].Clock,
                                                                 m_manager.VsqFile.getTempoList()[index].Clock,
                                                                 -1 ) );
                                m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
                                Edited = true;
                                #endregion
                            }
                            #endregion
                        } else {
                            #region テンポ変更がなかった場合
                            m_manager.ClearSelectedEvent();
                            m_manager.ClearSelectedTempo();
                            m_manager.ClearSelectedTimesig();
                            switch ( m_manager.SelectedTool ) {
                                case EditTool.Arrow:
                                case EditTool.Eraser:
                                    break;
                                case EditTool.Pencil:
                                case EditTool.Line:
                                    int changing_clock = ClockFromXCoord( e.X );
                                    int changing_tempo = m_manager.VsqFile.getTempoAt( changing_clock );
                                    int bar_count;
                                    int bar_top_clock;
                                    int local_denominator, local_numerator;
                                    bar_count = m_manager.VsqFile.getBarCountFromClock( changing_clock );
                                    bar_top_clock = m_manager.VsqFile.getClockFromBarCount( bar_count );
                                    int index2 = -1;
                                    for ( int i = 0; i < m_manager.VsqFile.getTimeSigList().Count; i++ ) {
                                        if ( m_manager.VsqFile.getTimeSigList()[i].BarCount > bar_count ) {
                                            index2 = i;
                                            break;
                                        }
                                    }
                                    if ( index2 >= 1 ) {
                                        local_denominator = m_manager.VsqFile.getTimeSigList()[index2 - 1].Denominator;
                                        local_numerator = m_manager.VsqFile.getTimeSigList()[index2 - 1].Numerator;
                                    } else {
                                        local_denominator = m_manager.VsqFile.getTimeSigList()[0].Denominator;
                                        local_numerator = m_manager.VsqFile.getTimeSigList()[0].Numerator;
                                    }
                                    int clock_per_beat = 480 * 4 / local_denominator;
                                    int clocks_in_bar = changing_clock - bar_top_clock;
                                    int beat_in_bar = clocks_in_bar / clock_per_beat + 1;
                                    int clocks_in_beat = clocks_in_bar - (beat_in_bar - 1) * clock_per_beat;
                                    using ( FormTempoConfig dlg = new FormTempoConfig(
                                        bar_count - m_manager.VsqFile.getPreMeasure() + 1,
                                        beat_in_bar,
                                        local_numerator,
                                        clocks_in_beat,
                                        clock_per_beat,
                                        (decimal)(6e7 / changing_tempo) ) ) {
                                        dlg.Location = GetFormPreferedLocation( dlg );
                                        if ( dlg.ShowDialog() == DialogResult.OK ) {
                                            int new_beat = dlg.BeatCount;
                                            int new_clocks_in_beat = dlg.Clock;
                                            int new_clock = bar_top_clock + (new_beat - 1) * clock_per_beat + new_clocks_in_beat;
#if DEBUG
                                            Common.DebugWriteLine( "    new_beat=" + new_beat );
                                            Common.DebugWriteLine( "    new_clocks_in_beat=" + new_clocks_in_beat );
                                            Common.DebugWriteLine( "    changing_clock=" + changing_clock );
                                            Common.DebugWriteLine( "    new_clock=" + new_clock );
#endif
                                            CadenciiCommand run = new CadenciiCommand(
                                                VsqCommand.generateCommandUpdateTempo( new_clock, new_clock, (int)(6e7 / (double)dlg.Tempo) ) );
                                            m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
                                            Edited = true;
                                            RefreshScreen();
                                        }
                                    }
                                    break;
                            }
                            #endregion
                        }
                        m_startmark_dragging = false;
                        m_endmark_dragging = false;
                        #endregion
                    }
                } else if ( 32 < e.Y && e.Y <= picturePositionIndicator.Height - 1 ) {
                    if ( m_timesig_dragging ) {
                        int count = m_manager.SelectedTimesig.Count;
                        int[] barcounts = new int[count];
                        int[] new_barcounts = new int[count];
                        int[] numerators = new int[count];
                        int[] denominators = new int[count];
                        int i = -1;
                        bool contains_first_bar = false;
                        foreach( int bar in m_manager.SelectedTimesig.Keys ){
                            i++;
                            barcounts[i] = bar;
                            if ( bar == 0 ) {
                                contains_first_bar = true;
                                break;
                            }
                            new_barcounts[i] = m_manager.SelectedTimesig[bar].Editing.BarCount;
                            numerators[i] = m_manager.SelectedTimesig[bar].Editing.Numerator;
                            denominators[i] = m_manager.SelectedTimesig[bar].Editing.Denominator;
                        }
                        if ( contains_first_bar ) {
                            System.Media.SystemSounds.Asterisk.Play();
                        } else {
                            CadenciiCommand run = new CadenciiCommand(
                                VsqCommand.generateCommandUpdateTimesigRange( barcounts, new_barcounts, numerators, denominators ) );
                            m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
                            Edited = true;
                        }
                        m_timesig_dragging = false;
                    } else if ( !m_startmark_dragging && !m_endmark_dragging ) {
                        #region 拍子の変更
                        m_manager.ClearSelectedEvent();
                        m_manager.ClearSelectedTempo();
                        if ( m_manager.SelectedTimesig.Count > 0 ) {
                            #region 拍子変更があった場合
                            int index = 0;
                            int clock = m_manager.LastSelectedTimesigBarcount;
                            for ( int i = 0; i < m_manager.VsqFile.getTimeSigList().Count; i++ ) {
                                if ( m_manager.VsqFile.getTimeSigList()[i].Clock == clock ) {
                                    index = i;
                                    break;
                                }
                            }
                            if ( m_manager.SelectedTool == EditTool.Eraser ) {
                                #region ツールがEraser
                                if ( m_manager.VsqFile.getTimeSigList()[index].Clock == 0 ) {
                                    MessageBox.Show( _( "Cannot remove first symbol of track!" ), _APP_NAME, MessageBoxButtons.OK, MessageBoxIcon.Information );
                                    return;
                                }
                                int barcount = m_manager.VsqFile.getTimeSigList()[index].BarCount;
                                CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandUpdateTimesig( barcount, barcount, -1, -1 ) );
                                m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
                                Edited = true;
                                #endregion
                            }
                            #endregion
                        } else {
                            #region 拍子変更がなかった場合
                            m_manager.ClearSelectedEvent();
                            m_manager.ClearSelectedTempo();
                            m_manager.ClearSelectedTimesig();
                            switch ( m_manager.SelectedTool ) {
                                case EditTool.Eraser:
                                case EditTool.Arrow:
                                    break;
                                case EditTool.Pencil:
                                case EditTool.Line:
                                    int pre_measure = m_manager.VsqFile.getPreMeasure();
                                    int clock = ClockFromXCoord( e.X );
                                    int bar_count = m_manager.VsqFile.getBarCountFromClock( clock );
                                    int numerator, denominator;
                                    m_manager.VsqFile.getTimesigAt( clock, out numerator, out denominator );
                                    int total_clock = m_manager.VsqFile.TotalClocks;
                                    //int max_barcount = m_manager.VsqFile.getBarCountFromClock( total_clock );
                                    //int min_barcount = 1 - pre_measure;
                                    using ( FormBeatConfig dlg = new FormBeatConfig( bar_count - pre_measure + 1, numerator, denominator, true ) ) {
                                        dlg.Location = GetFormPreferedLocation( dlg );
                                        if ( dlg.ShowDialog() == DialogResult.OK ) {
                                            if ( dlg.EndSpecified ) {
                                                int[] new_barcounts = new int[2];
                                                int[] numerators = new int[2];
                                                int[] denominators = new int[2];
                                                int[] barcounts = new int[2];
                                                new_barcounts[0] = dlg.Start + pre_measure - 1;
                                                new_barcounts[1] = dlg.End + pre_measure - 1 + 1;
                                                numerators[0] = dlg.Numerator;
                                                denominators[0] = dlg.Denominator;
                                                numerators[1] = numerator;
                                                denominators[1] = denominator;
                                                barcounts[0] = dlg.Start + pre_measure - 1;
                                                barcounts[1] = dlg.End + pre_measure - 1 + 1;
                                                CadenciiCommand run = new CadenciiCommand(
                                                    VsqCommand.generateCommandUpdateTimesigRange( barcounts, new_barcounts, numerators, denominators ) );
                                                m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
                                                Edited = true;
                                            } else {
                                                CadenciiCommand run = new CadenciiCommand( 
                                                    VsqCommand.generateCommandUpdateTimesig( bar_count, 
                                                                                   dlg.Start + pre_measure - 1, 
                                                                                   dlg.Numerator, 
                                                                                   dlg.Denominator ) );
                                                m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
                                                Edited = true;
                                            }
                                        }
                                    }
                                    break;
                            }
                            #endregion
                        }
                        m_startmark_dragging = false;
                        m_endmark_dragging = false;
                        #endregion
                    }
                }
            }
            pictPianoRoll.Refresh();
            picturePositionIndicator.Refresh();
        }

        private void picturePositionIndicator_MouseMove( object sender, MouseEventArgs e ) {
            if ( m_tempo_dragging ) {
                int clock = ClockFromXCoord( e.X ) - m_tempo_dragging_deltaclock;
                int step = AppManager.GetPositionQuantizeClock();
                int odd = clock % step;
                clock -= odd;
                if ( odd > step / 2 ) {
                    clock += step;
                }
                int last_clock = m_manager.LastSelectedTempoClock;
                int dclock = clock - last_clock;
                foreach ( int key in m_manager.SelectedTempo.Keys ) {
                    m_manager.SelectedTempo[key].Editing.Clock = m_manager.SelectedTempo[key].Original.Clock + dclock;
                }
                picturePositionIndicator.Refresh();
            } else if ( m_timesig_dragging ) {
                int clock = ClockFromXCoord( e.X ) - m_timesig_dragging_deltaclock;
                int barcount = m_manager.VsqFile.getBarCountFromClock( clock );
                int last_barcount = m_manager.LastSelectedTimesigBarcount;
                int dbarcount = barcount - last_barcount;
                foreach ( int bar in m_manager.SelectedTimesig.Keys ) {
                    m_manager.SelectedTimesig[bar].Editing.BarCount = m_manager.SelectedTimesig[bar].Original.BarCount + dbarcount;
                }
                picturePositionIndicator.Refresh();
            } else if ( m_startmark_dragging ) {
                int clock = ClockFromXCoord( e.X );
                int unit = AppManager.GetPositionQuantizeClock();
                int odd = clock % unit;
                clock -= odd;
                if ( odd > unit / 2 ) {
                    clock += unit;
                }
                int draft_start = Math.Min( clock, m_manager.EndMarker );
                int draft_end = Math.Max( clock, m_manager.EndMarker );
                if ( draft_start != m_manager.StartMarker ) {
                    m_manager.StartMarker = draft_start;
                }
                if ( draft_end != m_manager.EndMarker ) {
                    m_manager.EndMarker = draft_end;
                }
                RefreshScreen();
            } else if ( m_endmark_dragging ) {
                int clock = ClockFromXCoord( e.X );
                int unit = AppManager.GetPositionQuantizeClock();
                int odd = clock % unit;
                clock -= odd;
                if ( odd > unit / 2 ) {
                    clock += unit;
                }
                int draft_start = Math.Min( clock, m_manager.StartMarker );
                int draft_end = Math.Max( clock, m_manager.StartMarker );
                if ( draft_start != m_manager.StartMarker ) {
                    m_manager.StartMarker = draft_start;
                }
                if ( draft_end != m_manager.EndMarker ) {
                    m_manager.EndMarker = draft_end;
                }
                RefreshScreen();
            }
        }

        private void picturePositionIndicator_MouseLeave( object sender, EventArgs e ) {
            m_startmark_dragging = false;
            m_endmark_dragging = false;
            m_tempo_dragging = false;
            m_timesig_dragging = false;
        }

        private void picturePositionIndicator_Paint( object sender, PaintEventArgs e ) {
            picturePositionIndicatorDrawTo( e.Graphics );
        }

        private void picturePositionIndicator_PreviewKeyDown( object sender, PreviewKeyDownEventArgs e ) {
            ProcessSpecialShortcutKey( e );
        }
        #endregion

        #region trackBar
        private void trackBar_Enter( object sender, EventArgs e ) {
            pictPianoRoll.Select();
        }

        private void trackBar_MouseDown( object sender, MouseEventArgs e ) {
            if ( m_txtbox_track_name != null ) {
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
                m_txtbox_track_name = null;
            }
        }

        private void trackBar_ValueChanged( object sender, EventArgs e ) {
            m_manager.ScaleX = trackBar.Value / 480f;
            m_manager.StartToDrawX = (int)(hScroll.Value * m_manager.ScaleX);
#if USE_DOBJ
            UpdateDrawObjectList();
#endif
            this.Refresh();
        }
        #endregion

        #region menuHelp
        private void menuHelpAbout_Click( object sender, EventArgs e ) {
            string version_str = AppManager._VERSION + "\n\n" +
                                 AppManager.GetAssemblyNameAndFileVersion( typeof( Boare.Lib.AppUtil.Misc ) ) + "\n" +
                                 AppManager.GetAssemblyNameAndFileVersion( typeof( Boare.Lib.Media.Wave ) ) + "\n" +
                                 AppManager.GetAssemblyNameAndFileVersion( typeof( Boare.Lib.Vsq.VsqFile ) ) + "\n" +
                                 AppManager.GetAssemblyNameAndFileVersion( typeof( bocoree.math ) /*) + "\n" +
                                 AppManager.GetAssemblyNameAndFileVersion( typeof( Boare.Cadencii.vstidrv )*/ );
            if ( m_versioninfo == null ) {
                m_versioninfo = new Boare.Cadencii.VersionInfo( _APP_NAME, version_str );
                m_versioninfo.Credit = Boare.Cadencii.Properties.Resources.author_list;
                m_versioninfo.AuthorList = _CREDIT;
#if DEBUG
#if AUTHOR_LIST_SAVE_BUTTON_VISIBLE
                m_versioninfo.SaveAuthorListVisible = true;
#else
                m_versioninfo.SaveAuthorListVisible = false;
#endif
#else
                m_versioninfo.SaveAuthorListVisible = false;
#endif
                m_versioninfo.Show();
            } else {
                if ( m_versioninfo.IsDisposed ) {
                    m_versioninfo = new Boare.Cadencii.VersionInfo( _APP_NAME, version_str );
                    m_versioninfo.Credit = Boare.Cadencii.Properties.Resources.author_list;
                    m_versioninfo.AuthorList = _CREDIT;
#if DEBUG
#if AUTHOR_LIST_SAVE_BUTTON_VISIBLE
                    m_versioninfo.SaveAuthorListVisible = true;
#else
                    m_versioninfo.SaveAuthorListVisible = false;
#endif
#else
                    m_versioninfo.SaveAuthorListVisible = false;
#endif
                }
                m_versioninfo.Show();
            }
        }

        private void menuHelpDebug_Click( object sender, EventArgs e ) {
            Console.WriteLine( "menuHelpDebug_Click" );
#if DEBUG
            DialogResult dr = DialogResult.OK;
            while ( dr == DialogResult.OK ) {
                FileDialog fd = new FileDialog( FileDialog.DialogMode.Open );
                fd.Filter = "All Files(*.*)|*.*|VSQ Format(*.vsq)|*.vsq";
                dr = fd.ShowDialog();
                Common.DebugWriteLine( "fd.FileName=" + fd.FileName );
            }
            using ( OpenFileDialog ofd = new OpenFileDialog() ) {
                if ( ofd.ShowDialog() == DialogResult.OK ) {
                    using ( SaveFileDialog sfd = new SaveFileDialog() ) {
                        sfd.InitialDirectory = Path.GetDirectoryName( ofd.FileName );
                        sfd.FileName = Path.GetFileNameWithoutExtension( ofd.FileName ) + ".txt";
                        if ( sfd.ShowDialog() == DialogResult.OK ) {
                            using ( Wave w = new Wave( ofd.FileName ) ) {
                                w.PrintToText( sfd.FileName );
                            }
                        }
                    }
                }
            }

            using ( OpenFileDialog ofd = new OpenFileDialog() ) {
                if ( ofd.ShowDialog() == DialogResult.OK ) {
                    string file = ofd.FileName;
                    using ( Wave wv = new Wave( file ) ) {
                        const double sec_dt = 0.0025;
                        uint samples = wv.TotalSamples;
                        const int _WINDOW_WIDTH = 2048;
                        uint spl_dt = (uint)(sec_dt * wv.SampleRate);
                        double[] window_func = new double[_WINDOW_WIDTH];
                        for ( int i = 0; i < _WINDOW_WIDTH; i++ ) {
                            window_func[i] = bocoree.math.window_func( bocoree.math.WindowFunctionType.Hamming, i / (double)_WINDOW_WIDTH );
                        }
                        Wave.TestEnabled = false;

                        InputBox ib = new InputBox( "input clock count" );
                        if ( ib.ShowDialog() == DialogResult.OK ) {
                            int count = 0;
                            if ( int.TryParse( ib.Result, out count ) ) {
                                Wave.TestEnabled = true;
                                double f0 = wv.GetF0( (uint)count, window_func );
                                MessageBox.Show( "f0=" + f0 + " at sample=" + count );
                                Wave.TestEnabled = false;
                            }
                        }
                        if ( MessageBox.Show( "calculate all formant profile?", "Cadencii", MessageBoxButtons.YesNo ) == DialogResult.Yes ) {
                            using ( StreamWriter sw = new StreamWriter( ofd.FileName + "_formanto.txt" ) ) {
                                FormantoDetectionArguments fda = new FormantoDetectionArguments();
                                fda.PeakDetectionThreshold = 0.05;
                                for ( uint spl_i = 0; spl_i < samples; spl_i += spl_dt ) {
                                    double f0 = wv.GetF0( spl_i, window_func, fda );
                                    double note;
                                    if ( f0 > 0.0 ) {
                                        note = 12.0 * Math.Log( f0 / 440.0, 2.0 ) + 69;
                                    } else {
                                        note = 0.0;
                                    }
                                    sw.WriteLine( spl_i + "\t" + (spl_i / (double)wv.SampleRate) + "\t" + f0 + "\t" + note + "\t" + Math.Round( note, 0, MidpointRounding.AwayFromZero ) );
                                }
                            }
                        }
                        if ( MessageBox.Show( "calculate volume profile?", "Cadencii", MessageBoxButtons.YesNo ) == DialogResult.Yes ) {
                            using ( StreamWriter sw = new StreamWriter( ofd.FileName + "_volume.txt" ) ) {
                                for ( uint spl_i = 0; spl_i < samples; spl_i += spl_dt ) {
                                    double volume = wv.GetVolume( (int)spl_i, window_func );
                                    sw.WriteLine( spl_i + "\t" + (spl_i / (double)wv.SampleRate) + "\t" + volume );
                                }
                            }
                        }
                    }
                }
            }
#endif
#if FOO
            using ( OpenFileDialog ofd = new OpenFileDialog() ) {
                if ( ofd.ShowDialog() == DialogResult.OK ) {
                    using ( Wave wv = new Wave( ofd.FileName ) ) {
                        wv.TrimSilence();
                        const int _WIN_LEN = 441;
                        double[] window = new double[_WIN_LEN];
                        for ( int i = 0; i < _WIN_LEN; i++ ) {
                            window[i] = bocoree.math.window_func( bocoree.math.WindowFunctionType.Hamming, (double)i / (double)_WIN_LEN );
                        }
                        using ( StreamWriter sw = new StreamWriter( ofd.FileName + ".txt" ) ) {
                            for ( int i = 0; i < wv.TotalSamples - _WIN_LEN / 10; i += _WIN_LEN / 10 ) {
                                sw.WriteLine( i / (double)wv.SampleRate + "\t" + wv.GetVolume( i, window ) );
                            }
                        }
                        /*using ( StreamWriter sw = new StreamWriter( ofd.FileName + ".txt" ) ) {
                            double to = 7000.0 * 2.0 / (double)wv.SampleRate;
                            int jmax = (int)(to * _WIN_LEN);
                            double resolution = 1e-3;
                            uint di = (uint)(resolution * wv.SampleRate);
                            for ( uint i = 0; i < wv.TotalSamples; i += di ) {
                                double[] formanto = wv.GetFormanto( i, window );
                                for ( int j = 1; j < _WIN_LEN && j < jmax; j++ ) {
                                    //double f = (double)j / (double)_WIN_LEN * (double)wv.SampleRate / 2.0;
                                    sw.Write( "{0:f4}\t", Math.Abs( formanto[j] ) );
                                }
                                sw.WriteLine();
                            }
                        }*/
                    }
                }
            }
#endif
        }
        #endregion

        #region trackSelector
        private void trackSelector_CommandExecuted() {
            Edited = true;
            RefreshScreen();
        }

        private void trackSelector_MouseClick( object sender, MouseEventArgs e ) {
            if ( e.Button == MouseButtons.Right ) {
                if ( AppManager._KEY_LENGTH < e.X && e.X < trackSelector.Width - AppManager._KEY_LENGTH ) {
                    if ( trackSelector.Height - TrackSelector._OFFSET_TRACK_TAB <= e.Y && e.Y <= trackSelector.Height ) {
                        cMenuTrackTab.Show( trackSelector, e.Location );
                    } else {
                        cMenuTrackSelector.Show( trackSelector, e.Location );
                    }
                }
            }
            if ( m_txtbox_track_name != null ) {
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
                m_txtbox_track_name = null;
            }
        }

        private void trackSelector_MouseDown( object sender, MouseEventArgs e ) {
            if ( AppManager._KEY_LENGTH < e.X ) {
                m_mouse_downed_trackselector = true;
                if ( e.Button == MouseButtons.Middle || m_spacekey_downed ) {
                    m_edit_curve_mode = CurveEditMode.MiddleDrag;
                    m_button_initial = e.Location;
                    m_middle_button_hscroll = hScroll.Value;
                    this.Cursor = HAND;
                }
            }
        }

        private void trackSelector_MouseMove( object sender, MouseEventArgs e ) {
            if ( e.Button == MouseButtons.None ) {
                int cl = ClockFromXCoord( e.X );
                UpdatePositionViewFromMousePosition( cl );
                return;
            }
            int parent_width = ((TrackSelector)sender).Width;
            if ( m_edit_curve_mode == CurveEditMode.MiddleDrag ) {
                int dx = e.X - m_button_initial.X;
                int dy = e.Y - m_button_initial.Y;
                double new_hscroll_value = (double)m_middle_button_hscroll - (double)dx / m_manager.ScaleX;
                int draft;
                if ( new_hscroll_value < hScroll.Minimum ) {
                    draft = hScroll.Minimum;
                } else if ( hScroll.Maximum < new_hscroll_value ) {
                    draft = hScroll.Maximum;
                } else {
                    draft = (int)new_hscroll_value;
                }
                if ( m_manager.Playing ) {
                    return;
                }
                if ( hScroll.Value != draft ) {
                    hScroll.Value = draft;
                }
            } else {
                if ( m_mouse_downed_trackselector ) {
                    if ( m_ext_dragx_trackselector == ExtDragXMode.None ) {
                        if ( AppManager._KEY_LENGTH > e.X ) {
                            m_ext_dragx_trackselector = ExtDragXMode.Left;
                        } else if ( parent_width < e.X ) {
                            m_ext_dragx_trackselector = ExtDragXMode.Right;
                        }
                    } else {
                        if ( AppManager._KEY_LENGTH <= e.X && e.X <= parent_width ) {
                            m_ext_dragx_trackselector = ExtDragXMode.None;
                        }
                    }
                } else {
                    m_ext_dragx_trackselector = ExtDragXMode.None;
                }

                if ( m_ext_dragx_trackselector != ExtDragXMode.None ) {
                    DateTime now = DateTime.Now;
                    double dt = now.Subtract( m_timer_drag_last_ignitted ).TotalSeconds;
                    m_timer_drag_last_ignitted = now;
                    int px_move = AppManager.EditorConfig.MouseDragIncrement;
                    if ( px_move / dt > AppManager.EditorConfig.MouseDragMaximumRate ) {
                        px_move = (int)(dt * AppManager.EditorConfig.MouseDragMaximumRate);
                    }
                    double d_draft;
                    if ( m_ext_dragx_trackselector == ExtDragXMode.Right ) {
                        int right_clock = ClockFromXCoord( parent_width + 5 );
                        int dclock = (int)(px_move / m_manager.ScaleX);
                        d_draft = (73 - trackSelector.Width) / m_manager.ScaleX + right_clock + dclock;
                    } else {
                        px_move *= -1;
                        int left_clock = ClockFromXCoord( AppManager._KEY_LENGTH );
                        int dclock = (int)(px_move / m_manager.ScaleX);
                        d_draft = (73 - AppManager._KEY_LENGTH) / m_manager.ScaleX + left_clock + dclock;
                    }
                    if ( d_draft < 0.0 ) {
                        d_draft = 0.0;
                    }
                    int draft = (int)d_draft;
                    if ( hScroll.Maximum < draft ) {
                        hScroll.Maximum = draft;
                    }
                    if ( draft < hScroll.Minimum ) {
                        draft = hScroll.Minimum;
                    }
                    hScroll.Value = draft;
                }
            }
            int clock = ClockFromXCoord( e.X );
            UpdatePositionViewFromMousePosition( clock );
            RefreshScreen();
        }

        private void trackSelector_MouseUp( object sender, MouseEventArgs e ) {
            m_mouse_downed_trackselector = false;
            if ( m_edit_curve_mode == CurveEditMode.MiddleDrag ) {
                m_edit_curve_mode = CurveEditMode.None;
                this.Cursor = Cursors.Default;
            }
        }

        private void trackSelector_MouseWheel( object sender, MouseEventArgs e ) {
            if ( (Control.ModifierKeys & Keys.Shift) == Keys.Shift ) {
                double new_val = (double)vScroll.Value - e.Delta;
                if ( new_val > vScroll.Maximum ) {
                    vScroll.Value = vScroll.Maximum;
                } else if ( new_val < vScroll.Minimum ) {
                    vScroll.Value = vScroll.Minimum;
                } else {
                    vScroll.Value = (int)new_val;
                }
            } else {
                hScroll.Value = NewHScrollValueFromWheelDelta( e.Delta );
            }
            RefreshScreen();
        }

        private void trackSelector_PreviewKeyDown( object sender, PreviewKeyDownEventArgs e ) {
            ProcessSpecialShortcutKey( e );
        }

        private void trackSelector_RenderRequired( int[] tracks ) {
            Render( tracks );
            List<int> t = new List<int>( tracks );
            if ( t.Contains( m_manager.Selected ) ) {
                string file = Path.Combine( m_manager.TempWaveDir, m_manager.Selected + ".wav" );
                if ( File.Exists( file ) ) {
                    Thread loadwave_thread = new Thread( new ParameterizedThreadStart( this.LoadWaveThreadProc ) );
                    loadwave_thread.IsBackground = true;
                    loadwave_thread.Start( file );
                }
            }
        }

        private void trackSelector_SelectedCurveChanged( CurveType type ) {
#if DEBUG
            Common.DebugWriteLine( "trackSelector_SelectedCurveChanged(VsqCurveType)" );
#endif
            RefreshScreen();
        }        
        
        private void trackSelector_SelectedTrackChanged( int selected ) {
            if ( menuVisualWaveform.Checked ) {
                waveView.Clear();
                string file = Path.Combine( m_manager.TempWaveDir, selected + ".wav" );
                if ( File.Exists( file ) ) {
                    Thread load_wave = new Thread( new ParameterizedThreadStart( this.LoadWaveThreadProc ) );
                    load_wave.IsBackground = true;
                    load_wave.Start( (object)file );
                }
            }
#if USE_DOBJ
            UpdateDrawObjectList();
#endif
            RefreshScreen();
        }
        #endregion

        #region cMenuPiano*
        private void cMenuPianoDelete_Click( object sender, EventArgs e ) {
            DeleteEvent();
        }

        private void cMenuPianoVibratoProperty_Click( object sender, EventArgs e ) {
            NoteVibratoProperty();
        }

        private void cMenuPianoPaste_Click( object sender, EventArgs e ) {
            PasteEvent();
        }

        private void cMenuPianoCopy_Click( object sender, EventArgs e ) {
            CopyEvent();
        }

        private void cMenuPianoCut_Click( object sender, EventArgs e ) {
            CutEvent();
        }
        
        private void cMenuPianoExpression_Click( object sender, EventArgs e ) {
            if ( m_manager.SelectedEvent.Count > 0 ) {
                using ( FormSingerStyleConfig dlg = new FormSingerStyleConfig( _( "Expression control property" ), false ) ) {
                    VsqEvent original = m_manager.SelectedEvent.LastSelected.Original;
                    int id = m_manager.SelectedEvent.LastSelectedID;
                    dlg.PMBendDepth = original.ID.PMBendDepth;
                    dlg.PMBendLength = original.ID.PMBendLength;
                    dlg.PMbPortamentoUse = original.ID.PMbPortamentoUse;
                    dlg.DEMdecGainRate = original.ID.DEMdecGainRate;
                    dlg.DEMaccent = original.ID.DEMaccent;
                    if ( dlg.ShowDialog() == DialogResult.OK ) {
                        VsqID copy = (VsqID)original.ID.Clone();
                        copy.PMBendDepth = dlg.PMBendDepth;
                        copy.PMBendLength = dlg.PMBendLength;
                        copy.PMbPortamentoUse = dlg.PMbPortamentoUse;
                        copy.DEMdecGainRate = dlg.DEMdecGainRate;
                        copy.DEMaccent = dlg.DEMaccent;
                        CadenciiCommand run = new CadenciiCommand(
                            VsqCommand.generateCommandEventChangeIDContaints( m_manager.Selected, id, copy ) );
                        m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
                        Edited = true;
                    }
                }
            }
        }

        private void cMenuPianoPointer_Click( object sender, EventArgs e ) {
            m_manager.SelectedTool = EditTool.Arrow;
        }

        private void cMenuPianoPencil_Click( object sender, EventArgs e ) {
            m_manager.SelectedTool = EditTool.Pencil;
        }

        private void cMenuPianoEraser_Click( object sender, EventArgs e ) {
            m_manager.SelectedTool = EditTool.Eraser;
        }

        private void h_positionQuantize04( object sender, EventArgs e ) {
            AppManager.EditorConfig.PositionQuantize = QuantizeMode.p4;
        }

        private void h_positionQuantize08( object sender, EventArgs e ) {
            AppManager.EditorConfig.PositionQuantize = QuantizeMode.p8;
        }

        private void h_positionQuantize16( object sender, EventArgs e ) {
            AppManager.EditorConfig.PositionQuantize = QuantizeMode.p16;
        }

        private void h_positionQuantize32( object sender, EventArgs e ) {
            AppManager.EditorConfig.PositionQuantize = QuantizeMode.p32;
        }

        private void h_positionQuantize64( object sender, EventArgs e ) {
            AppManager.EditorConfig.PositionQuantize = QuantizeMode.p64;
        }

        private void h_positionQuantize128( object sender, EventArgs e ) {
            AppManager.EditorConfig.PositionQuantize = QuantizeMode.p128;
        }

        private void h_positionQuantizeOff( object sender, EventArgs e ) {
            AppManager.EditorConfig.PositionQuantize = QuantizeMode.off;
        }

        private void h_positionQuantizeTriplet( object sender, EventArgs e ) {
            AppManager.EditorConfig.PositionQuantizeTriplet = !AppManager.EditorConfig.PositionQuantizeTriplet;
        }

        private void h_lengthQuantize04( object sender, EventArgs e ) {
            AppManager.EditorConfig.LengthQuantize = QuantizeMode.p4;
        }

        private void h_lengthQuantize08( object sender, EventArgs e ) {
            AppManager.EditorConfig.LengthQuantize = QuantizeMode.p8;
        }

        private void h_lengthQuantize16( object sender, EventArgs e ) {
            AppManager.EditorConfig.LengthQuantize = QuantizeMode.p16;
        }

        private void h_lengthQuantize32( object sender, EventArgs e ) {
            AppManager.EditorConfig.LengthQuantize = QuantizeMode.p32;
        }

        private void h_lengthQuantize64( object sender, EventArgs e ) {
            AppManager.EditorConfig.LengthQuantize = QuantizeMode.p64;
        }

        private void h_lengthQuantize128( object sender, EventArgs e ) {
            AppManager.EditorConfig.LengthQuantize = QuantizeMode.p128;
        }

        private void h_lengthQuantizeOff( object sender, EventArgs e ) {
            AppManager.EditorConfig.LengthQuantize = QuantizeMode.off;
        }

        private void h_lengthQuantizeTriplet( object sender, EventArgs e ) {
            AppManager.EditorConfig.LengthQuantizeTriplet = !AppManager.EditorConfig.LengthQuantizeTriplet;
        }

        private void cMenuPianoGrid_Click( object sender, EventArgs e ) {
            cMenuPianoGrid.Checked = !cMenuPianoGrid.Checked;
            m_manager.GridVisible = cMenuPianoGrid.Checked;
        }

        private void cMenuPianoUndo_Click( object sender, EventArgs e ) {
#if DEBUG
            Common.DebugWriteLine( "cMenuPianoUndo_Click" );
#endif
            Undo();
        }

        private void cMenuPianoRedo_Click( object sender, EventArgs e ) {
#if DEBUG
            Common.DebugWriteLine( "cMenuPianoRedo_Click" );
#endif
            Redo();
        }

        private void cMenuPianoSelectAllEvents_Click( object sender, EventArgs e ) {
            SelectAllEvent();
        }       
        
        private void cMenuPianoProperty_Click( object sender, EventArgs e ) {
            NoteExpressionProperty();
        }
        
        private void cMenuPianoImportLyric_Click( object sender, EventArgs e ) {
            ImportLyric();
        }

        private void cMenuPianoSelectAll_Click( object sender, EventArgs e ) {
            SelectAll();
        }

        private void cMenuPianoFixed01_Click( object sender, EventArgs e ) {
            m_pencil_mode.Mode = PencilModeEnum.L1;
            UpdateCMenuPianoFixed();
        }
        
        private void cMenuPianoFixed02_Click( object sender, EventArgs e ) {
            m_pencil_mode.Mode = PencilModeEnum.L2;
            UpdateCMenuPianoFixed();
        }
        
        private void cMenuPianoFixed04_Click( object sender, EventArgs e ) {
            m_pencil_mode.Mode = PencilModeEnum.L4;
            UpdateCMenuPianoFixed();
        }

        private void cMenuPianoFixed08_Click( object sender, EventArgs e ) {
            m_pencil_mode.Mode = PencilModeEnum.L8;
            UpdateCMenuPianoFixed();
        }
        
        private void cMenuPianoFixed16_Click( object sender, EventArgs e ) {
            m_pencil_mode.Mode = PencilModeEnum.L16;
            UpdateCMenuPianoFixed();
        }
        
        private void cMenuPianoFixed32_Click( object sender, EventArgs e ) {
            m_pencil_mode.Mode = PencilModeEnum.L32;
            UpdateCMenuPianoFixed();
        }

        private void cMenuPianoFixed64_Click( object sender, EventArgs e ) {
            m_pencil_mode.Mode = PencilModeEnum.L64;
            UpdateCMenuPianoFixed();
        }

        private void cMenuPianoFixed128_Click( object sender, EventArgs e ) {
            m_pencil_mode.Mode = PencilModeEnum.L128;
            UpdateCMenuPianoFixed();
        }

        private void cMenuPianoFixedOff_Click( object sender, EventArgs e ) {
            m_pencil_mode.Mode = PencilModeEnum.Off;
            UpdateCMenuPianoFixed();
        }

        private void cMenuPianoFixedTriplet_Click( object sender, EventArgs e ) {
            m_pencil_mode.Triplet = !m_pencil_mode.Triplet;
            UpdateCMenuPianoFixed();
        }
        
        private void cMenuPianoFixedDotted_Click( object sender, EventArgs e ) {
            m_pencil_mode.Dot = !m_pencil_mode.Dot;
            UpdateCMenuPianoFixed();
        }

        private void cMenuPianoCurve_Click( object sender, EventArgs e ) {
            m_manager.IsCurveMode = !m_manager.IsCurveMode;
            ApplySelectedTool();
        }
        #endregion

        #region menuTrack*
        private void menuTrack_DropDownOpening( object sender, EventArgs e ) {
            UpdateTrackMenuStatus();
        }

        private void menuTrackCopy_Click( object sender, EventArgs e ) {
            CopyTrackCore();
        }

        private void menuTrackChangeName_Click( object sender, EventArgs e ) {
            ChangeTrackNameCore();
        }

        private void menuTrackDelete_Click( object sender, EventArgs e ) {
            DeleteTrackCore();
        }

        private void menuTrackOn_Click( object sender, EventArgs e ) {
            menuTrackOn.Checked = !menuTrackOn.Checked;
            CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandTrackChangePlayMode( m_manager.Selected,
                                                                                                      menuTrackOn.Checked ? 1 : -1 ) );
            m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
            Edited = true;
            RefreshScreen();
        }

        private void menuTrackAdd_Click( object sender, EventArgs e ) {
            AddTrackCore();
        }

        private void menuTrackOverlay_Click( object sender, EventArgs e ) {
            m_manager.Overlay = !m_manager.Overlay;
            RefreshScreen();
        }

        private void menuTrackRenderCurrent_Click( object sender, EventArgs e ) {
            Render( new int[] { m_manager.Selected } );
        }
        #endregion

        #region menuHidden*
        private void menuHiddenTrackNext_Click( object sender, EventArgs e ) {
            if ( m_manager.Selected == m_manager.VsqFile.Track.Count - 1 ) {
                m_manager.Selected = 1;
            } else {
                m_manager.Selected++;
            }
            RefreshScreen();
        }

        private void menuHiddenTrackBack_Click( object sender, EventArgs e ) {
            if ( m_manager.Selected == 1 ) {
                m_manager.Selected = m_manager.VsqFile.Track.Count - 1;
            } else {
                m_manager.Selected--;
            }
            RefreshScreen();
        }

        private void menuHiddenEditPaste_Click( object sender, EventArgs e ) {
            PasteEvent();
        }

        private void menuHiddenEditFlipToolPointerPencil_Click( object sender, EventArgs e ) {
            if ( m_manager.SelectedTool == EditTool.Arrow ) {
                m_manager.SelectedTool = EditTool.Pencil;
            } else {
                m_manager.SelectedTool = EditTool.Arrow;
            }
            RefreshScreen();
        }

        private void menuHiddenEditFlipToolPointerEraser_Click( object sender, EventArgs e ) {
            if ( m_manager.SelectedTool == EditTool.Arrow ) {
                m_manager.SelectedTool = EditTool.Eraser;
            } else {
                m_manager.SelectedTool = EditTool.Arrow;
            }
            RefreshScreen();
        }
        
        private void menuHiddenEditLyric_Click( object sender, EventArgs e ) {
            if ( !m_input_textbox.Enabled && m_manager.SelectedEvent.Count > 0 ) {
                VsqEvent original = m_manager.SelectedEvent.LastSelected.Original;
                int clock = original.Clock;
                int note = original.ID.Note;
                Point pos = new Point( XCoordFromClocks( clock ), YCoordFromNote( note ) );
                if ( !AppManager.EditorConfig.KeepLyricInputMode ) {
                    m_last_symbol_edit_mode = false;
                }
                ShowInputTextBox( original.ID.LyricHandle.L0.Phrase, original.ID.LyricHandle.L0.getPhoneticSymbol(), pos, m_last_symbol_edit_mode );
            } else if ( m_input_textbox.Enabled ) {
                TagLyricTextBox tltb = (TagLyricTextBox)m_input_textbox.Tag;
                if ( tltb.PhoneticSymbolEditMode ) {
                    FlipInputTextBoxMode();
                }
            }
        }
        #endregion

        #region cMenuTrackTab
        private void cMenuTrackTabCopy_Click( object sender, EventArgs e ) {
            CopyTrackCore();
        }

        private void cMenuTrackTabChangeName_Click( object sender, EventArgs e ) {
            ChangeTrackNameCore();
        }

        private void cMenuTrackTabTrackOn_Click( object sender, EventArgs e ) {
            cMenuTrackTabTrackOn.Checked = !cMenuTrackTabTrackOn.Checked;
            CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandTrackChangePlayMode( m_manager.Selected,
                                                                                                      cMenuTrackTabTrackOn.Checked ? 1 : -1 ) );
            m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
            Edited = true;
            RefreshScreen();
        }

        private void cMenuTrackTabDelete_Click( object sender, EventArgs e ) {
            DeleteTrackCore();
        }

        private void cMenuTrackTabAdd_Click( object sender, EventArgs e ) {
            AddTrackCore();
        }

        private void cMenuTrackTab_Opening( object sender, CancelEventArgs e ) {
            UpdateTrackMenuStatus();
        }

        private void UpdateTrackMenuStatus() {
            cMenuTrackTabDelete.Enabled = menuTrackDelete.Enabled = (m_manager.VsqFile.Track.Count >= 3);
            cMenuTrackTabAdd.Enabled = menuTrackAdd.Enabled = (m_manager.VsqFile.Track.Count <= 16);
            cMenuTrackTabCopy.Enabled = menuTrackCopy.Enabled = (m_manager.VsqFile.Track.Count <= 16);
            cMenuTrackTabTrackOn.Checked = menuTrackOn.Checked = m_manager.VsqFile.Track[m_manager.Selected].getCommon().PlayMode >= 0;
            if ( m_manager.VsqFile.Track.Count > 2 ) {
                cMenuTrackTabOverlay.Enabled = menuTrackOverlay.Enabled = true;
                cMenuTrackTabOverlay.Checked = menuTrackOverlay.Checked = m_manager.Overlay;
            } else {
                cMenuTrackTabOverlay.Enabled = menuTrackOverlay.Enabled = false;
                cMenuTrackTabOverlay.Checked = menuTrackOverlay.Checked = false;
            }
            cMenuTrackTabRenderCurrent.Enabled = menuTrackRenderCurrent.Enabled = !m_manager.Playing;
            cMenuTrackTabRenderAll.Enabled = menuTrackRenderAll.Enabled = !m_manager.Playing;
            cMenuTrackTabRendererVOCALOID1.Checked = menuTrackRendererVOCALOID1.Checked = false;
            cMenuTrackTabRendererVOCALOID2.Checked = menuTrackRendererVOCALOID2.Checked = false;
            cMenuTrackTabRendererUtau.Checked = menuTrackRendererUtau.Checked = false;

            string version = m_manager.VsqFile.Track[m_manager.Selected].getCommon().Version;
            if ( version.StartsWith( VSTiProxy.RENDERER_DSB2 ) ) {
                cMenuTrackTabRendererVOCALOID1.Checked = menuTrackRendererVOCALOID1.Checked = true;
            } else if ( version.StartsWith( VSTiProxy.RENDERER_DSB3 ) ) {
                cMenuTrackTabRendererVOCALOID2.Checked = menuTrackRendererVOCALOID2.Checked = true;
            } else if ( version.StartsWith( VSTiProxy.RENDERER_UTU0 ) ) {
                cMenuTrackTabRendererUtau.Checked = menuTrackRendererUtau.Checked = true;
            }
        }

        private void cMenuTrackTabOverlay_Click( object sender, EventArgs e ) {
            m_manager.Overlay = !m_manager.Overlay;
            RefreshScreen();
        }

        private void cMenuTrackTabRenderCurrent_Click( object sender, EventArgs e ) {
            Render( new int[] { m_manager.Selected } );
        }
        #endregion

        #region m_txtbox_track_name
        private void m_txtbox_track_name_KeyUp( object sender, KeyEventArgs e ) {
            if ( e.KeyCode == Keys.Enter ) {
                CadenciiCommand run = new CadenciiCommand(
                    VsqCommand.generateCommandTrackChangeName( m_manager.Selected, m_txtbox_track_name.Text ) );
                m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
                Edited = true;
                m_txtbox_track_name.Dispose();
                m_txtbox_track_name = null;
                RefreshScreen();
            } else if ( e.KeyCode == Keys.Escape ) {
                m_txtbox_track_name.Dispose();
                m_txtbox_track_name = null;
            }
        }
        #endregion

        #region cMenuTrackSelector
        private void cMenuTrackSelector_Opening( object sender, CancelEventArgs e ) {
            UpdateCopyAndPasteButtonStatus();

            // 選択ツールの状態に合わせて表示を更新
            cMenuTrackSelectorPointer.CheckState = CheckState.Unchecked;
            cMenuTrackSelectorPencil.CheckState = CheckState.Unchecked;
            cMenuTrackSelectorLine.CheckState = CheckState.Unchecked;
            cMenuTrackSelectorEraser.CheckState = CheckState.Unchecked;
            switch ( m_manager.SelectedTool ) {
                case EditTool.Arrow:
                    cMenuTrackSelectorPointer.CheckState = CheckState.Indeterminate;
                    break;
                case EditTool.Pencil:
                    cMenuTrackSelectorPencil.CheckState = CheckState.Indeterminate;
                    break;
                case EditTool.Line:
                    cMenuTrackSelectorLine.CheckState = CheckState.Indeterminate;
                    break;
                case EditTool.Eraser:
                    cMenuTrackSelectorEraser.CheckState = CheckState.Indeterminate;
                    break;
            }
            cMenuTrackSelectorCurve.Checked = m_manager.IsCurveMode;
        }

        private void cMenuTrackSelectorPointer_Click( object sender, EventArgs e ) {
            m_manager.SelectedTool = EditTool.Arrow;
            RefreshScreen();
        }

        private void cMenuTrackSelectorPencil_Click( object sender, EventArgs e ) {
            m_manager.SelectedTool = EditTool.Pencil;
            RefreshScreen();
        }

        private void cMenuTrackSelectorLine_Click( object sender, EventArgs e ) {
            m_manager.SelectedTool = EditTool.Line;
        }

        private void cMenuTrackSelectorEraser_Click( object sender, EventArgs e ) {
            m_manager.SelectedTool = EditTool.Eraser;
        }

        private void cMenuTrackSelectorCurve_Click( object sender, EventArgs e ) {
            m_manager.IsCurveMode = !m_manager.IsCurveMode;
        }

        private void cMenuTrackSelectorSelectAll_Click( object sender, EventArgs e ) {
            SelectAllEvent();
        }

        private void cMenuTrackSelectorCut_Click( object sender, EventArgs e ) {
            CutEvent();
        }
        
        private void cMenuTrackSelectorCopy_Click( object sender, EventArgs e ) {
            CopyEvent();
        }

        private void cMenuTrackSelectorDelete_Click( object sender, EventArgs e ) {
            DeleteEvent();
        }

        private void cMenuTrackSelectorDeleteBezier_Click( object sender, EventArgs e ) {
            foreach ( SelectedBezierPoint sbp in m_manager.GetSelectedBezierEnumerator() ) {
                int chain_id = sbp.ChainID;
                int point_id = sbp.PointID;
                BezierChain chain = (BezierChain)m_manager.VsqFile.AttachedCurves[m_manager.Selected - 1].GetBezierChain( trackSelector.SelectedCurve, chain_id ).Clone();
                int index = -1;
                for ( int i = 0; i < chain.points.Count; i++ ) {
                    if ( chain.points[i].ID == point_id ) {
                        index = i;
                        break;
                    }
                }
                if ( index >= 0 ) {
                    chain.points.RemoveAt( index );
                    if ( chain.points.Count == 0 ) {
                        CadenciiCommand run = VsqFileEx.generateCommandDeleteBezierChain( m_manager.Selected,
                                                                                   trackSelector.SelectedCurve,
                                                                                   chain_id,
                                                                                   AppManager.EditorConfig.ControlCurveResolution.Value );
                        m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
                    } else {
                        CadenciiCommand run = VsqFileEx.generateCommandReplaceBezierChain( m_manager.Selected,
                                                                                    trackSelector.SelectedCurve,
                                                                                    chain_id,
                                                                                    chain,
                                                                                    AppManager.EditorConfig.ControlCurveResolution.Value );
                        m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
                    }
                    Edited = true;
                    RefreshScreen();
                    break;
                }
            }
        }

        private void cMenuTrackSelectorPaste_Click( object sender, EventArgs e ) {
            PasteEvent();
        }
                
        private void cMenuTrackSelectorUndo_Click( object sender, EventArgs e ) {
#if DEBUG
            Common.DebugWriteLine( "cMenuTrackSelectorUndo_Click" );
#endif
            Undo();
            RefreshScreen();
        }

        private void cMenuTrackSelectorRedo_Click( object sender, EventArgs e ) {
#if DEBUG
            Common.DebugWriteLine( "cMenuTrackSelectorRedo_Click" );
#endif
            Redo();
            RefreshScreen();
        }
        #endregion
        
        private void pictureBox3_MouseDown( object sender, MouseEventArgs e ) {
            if ( m_txtbox_track_name != null ) {
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
                m_txtbox_track_name = null;
            }
        }

        private void pictureBox2_MouseDown( object sender, MouseEventArgs e ) {
            if ( m_txtbox_track_name != null ) {
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
                m_txtbox_track_name = null;
            }
        }
        
        private void menuStrip1_MouseDown( object sender, MouseEventArgs e ) {
            if ( m_txtbox_track_name != null ) {
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
                m_txtbox_track_name = null;
            }
        }

        private void timer_Tick( object sender, EventArgs e ) {
#if DEBUG
            Common.DebugWriteLine( "timer_Tick" );
#endif
            float play_time = -1.0f;
            if ( m_manager.RendererAvailable ) {
                // レンダリング用VSTiが利用可能な状態でAppManager_PreviewStartedした場合
                if ( !m_manager.FirstBufferWritten ) {
                    return;
                }
                play_time = VSTiProxy.GetPlayTime();
            } else {
                play_time = (float)DateTime.Now.Subtract( m_manager.PreviewStartedTime ).TotalSeconds;
            }
            float now = (float)(play_time + m_direct_play_shift);

            if ( (play_time < 0.0 || m_preview_ending_time < now) && m_manager.EditMode != EditMode.Realtime ) {
                m_manager.Playing = false;
                timer.Stop();
                m_manager.CurrentClock = (m_manager.StartMarkerEnabled) ? m_manager.StartMarker : 0;
                EnsureCursorVisible();
                return;
            }
            int clock = (int)m_manager.VsqFile.getClockFromSec( now );
            if ( clock > hScroll.Maximum ) {
                if ( m_manager.EditMode == EditMode.Realtime ) {
                    hScroll.Maximum = clock + (int)((pictPianoRoll.Width - AppManager._KEY_LENGTH) / 2.0f / m_manager.ScaleX);
                } else {
                    m_manager.CurrentClock = 0;
                    EnsureCursorVisible();
                    if ( !m_manager.IsRepeatMode ) {
                        timer.Stop();
                        m_manager.Playing = false;
                    }
                }
            } else if ( m_manager.EndMarkerEnabled && clock > (int)m_manager.EndMarker && m_manager.EditMode != EditMode.Realtime ) {
                m_manager.CurrentClock = (m_manager.StartMarkerEnabled) ? m_manager.StartMarker : 0;
                EnsureCursorVisible();
                m_manager.Playing = false;
                if ( m_manager.IsRepeatMode ) {
                    m_manager.Playing = true;
                } else {
                    timer.Stop();
                }
            } else {
                m_manager.CurrentClock = (int)clock;
                if ( m_manager.AutoScroll ) {
                    if ( AppManager.EditorConfig.CursorFixed ) {
                        float f_draft = clock - (pictPianoRoll.Width / 2 + 34 - 70) / m_manager.ScaleX;
                        if ( f_draft < 0f ) {
                            f_draft = 0;
                        }
                        int draft = (int)(f_draft);
                        if ( draft < hScroll.Minimum ) {
                            draft = hScroll.Minimum;
                        } else if ( hScroll.Maximum < draft ) {
                            draft = hScroll.Maximum;
                        }
                        if ( hScroll.Value != draft ) {
                            hScroll.Value = draft;
                        }
                    } else {
                        EnsureCursorVisible();
                    }
                }
            }
            RefreshScreen();
        }

        private void bgWorkScreen_DoWork( object sender, DoWorkEventArgs e ) {
            this.Invoke( new VoidDelegate( this.RefreshScreenCore ) );
        }

        private void stripBtnArrow_Click( object sender, EventArgs e ) {
            m_manager.SelectedTool = EditTool.Arrow;
        }

        private void stripBtnPencil_Click( object sender, EventArgs e ) {
            m_manager.SelectedTool = EditTool.Pencil;
        }

        private void stripBtnLine_Click( object sender, EventArgs e ) {
            m_manager.SelectedTool = EditTool.Line;
        }

        private void stripBtnEraser_Click( object sender, EventArgs e ) {
            m_manager.SelectedTool = EditTool.Eraser;
        }

        private void stripBtnCurve_CheckedChanged( object sender, EventArgs e ) {
            m_manager.IsCurveMode = stripBtnCurve.Checked;
        }

        private void cMenuPiano_Opening( object sender, CancelEventArgs e ) {
            UpdateCopyAndPasteButtonStatus();
            cMenuPianoImportLyric.Enabled = m_manager.SelectedEvent.LastSelected != null;
        }

        private void stripBtnGrid_CheckedChanged( object sender, EventArgs e ) {
            m_manager.GridVisible = stripBtnGrid.Checked;
        }

        private void toolStripEdit_Move( object sender, EventArgs e ) {
            AppManager.EditorConfig.ToolEditTool.Location = toolStripTool.Location;
        }

        private void toolStripEdit_ParentChanged( object sender, EventArgs e ) {
            if ( toolStripTool.Parent != null ) {
                if ( toolStripTool.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    AppManager.EditorConfig.ToolEditTool.Parent = ToolStripLocation.ParentPanel.Top;
                } else {
                    AppManager.EditorConfig.ToolEditTool.Parent = ToolStripLocation.ParentPanel.Bottom;
                }
            }
        }

        private void toolStripPosition_Move( object sender, EventArgs e ) {
            AppManager.EditorConfig.ToolPositionLocation.Location = toolStripPosition.Location;
        }

        private void toolStripPosition_ParentChanged( object sender, EventArgs e ) {
            if ( toolStripPosition.Parent != null ) {
                if ( toolStripPosition.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    AppManager.EditorConfig.ToolPositionLocation.Parent = ToolStripLocation.ParentPanel.Top;
                } else {
                    AppManager.EditorConfig.ToolPositionLocation.Parent = ToolStripLocation.ParentPanel.Bottom;
                }
            }
        }

        private void toolStripMeasure_Move( object sender, EventArgs e ) {
            AppManager.EditorConfig.ToolMeasureLocation.Location = toolStripMeasure.Location;
        }

        private void toolStripMeasure_ParentChanged( object sender, EventArgs e ) {
            if ( toolStripMeasure.Parent != null ) {
                if ( toolStripMeasure.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    AppManager.EditorConfig.ToolMeasureLocation.Parent = ToolStripLocation.ParentPanel.Top;
                } else {
                    AppManager.EditorConfig.ToolMeasureLocation.Parent = ToolStripLocation.ParentPanel.Bottom;
                }
            }
        }

        void toolStripPaletteTools_Move( object sender, EventArgs e ) {
#if DEBUG
            Common.DebugWriteLine( "toolStripPaletteTools_Move" );
#endif
            AppManager.EditorConfig.ToolPaletteLocation.Location = toolStripPaletteTools.Location;
        }

        void toolStripPaletteTools_ParentChanged( object sender, EventArgs e ) {
            if ( toolStripPaletteTools.Parent != null ) {
                if ( toolStripPaletteTools.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    AppManager.EditorConfig.ToolPaletteLocation.Parent = ToolStripLocation.ParentPanel.Top;
                } else {
                    AppManager.EditorConfig.ToolPaletteLocation.Parent = ToolStripLocation.ParentPanel.Bottom;
                }
            }
        }

        void toolStripFile_Move( object sender, EventArgs e ) {
            AppManager.EditorConfig.ToolFileLocation.Location = toolStripFile.Location;
        }

        void toolStripFile_ParentChanged( object sender, EventArgs e ) {
            if ( toolStripFile.Parent != null ) {
                if ( toolStripFile.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    AppManager.EditorConfig.ToolFileLocation.Parent = ToolStripLocation.ParentPanel.Top;
                } else {
                    AppManager.EditorConfig.ToolFileLocation.Parent = ToolStripLocation.ParentPanel.Bottom;
                }
            }
        }

        private void stripBtnPlay_Click( object sender, EventArgs e ) {
            if ( !m_manager.Playing ) {
                m_manager.Playing = true;
            }
            pictPianoRoll.Focus();
        }

        private void stripBtnScroll_Click( object sender, EventArgs e ) {
            stripBtnScroll.Checked = !stripBtnScroll.Checked;
            m_manager.AutoScroll = stripBtnScroll.Checked;
            pictPianoRoll.Focus();
        }

        private void stripBtnLoop_Click( object sender, EventArgs e ) {
            stripBtnLoop.Checked = !stripBtnLoop.Checked;
            m_manager.IsRepeatMode = stripBtnLoop.Checked;
            pictPianoRoll.Focus();
        }

        private void stripBtnStop_Click( object sender, EventArgs e ) {
            m_manager.Playing = false;
            timer.Stop();
            pictPianoRoll.Focus();
        }

        private void stripBtnStartMarker_Click( object sender, EventArgs e ) {
            stripBtnStartMarker.Checked = !stripBtnStartMarker.Checked;
            m_manager.StartMarkerEnabled = stripBtnStartMarker.Checked;
            pictPianoRoll.Focus();
            RefreshScreen();
        }

        private void stripBtnEndMarker_Click( object sender, EventArgs e ) {
            stripBtnEndMarker.Checked = !stripBtnEndMarker.Checked;
            m_manager.EndMarkerEnabled = stripBtnEndMarker.Checked;
            pictPianoRoll.Focus();
            RefreshScreen();
        }

        private void menuSettingGameControlerSetting_Click( object sender, EventArgs e ) {
            using ( FormGameControlerConfig dlg = new FormGameControlerConfig() ) {
                dlg.Location = GetFormPreferedLocation( dlg );
                if ( dlg.ShowDialog() == DialogResult.OK ) {
                    AppManager.EditorConfig.GameControlerRectangle = dlg.Rectangle;
                    AppManager.EditorConfig.GameControlerTriangle = dlg.Triangle;
                    AppManager.EditorConfig.GameControlerCircle = dlg.Circle;
                    AppManager.EditorConfig.GameControlerCross = dlg.Cross;
                    AppManager.EditorConfig.GameControlL1 = dlg.L1;
                    AppManager.EditorConfig.GameControlL2 = dlg.L2;
                    AppManager.EditorConfig.GameControlR1 = dlg.R1;
                    AppManager.EditorConfig.GameControlR2 = dlg.R2;
                    AppManager.EditorConfig.GameControlSelect = dlg.Select;
                    AppManager.EditorConfig.GameControlStart = dlg.Start;
                    AppManager.EditorConfig.GameControlPovDown = dlg.PovDown;
                    AppManager.EditorConfig.GameControlPovLeft = dlg.PovLeft;
                    AppManager.EditorConfig.GameControlPovUp = dlg.PovUp;
                    AppManager.EditorConfig.GameControlPovRight = dlg.PovRight;
                }
            }
        }

        private void anonymousCaptureSpaceKeyDown( object sender, KeyEventArgs e ) {
            if ( (e.KeyCode & Keys.Space) == Keys.Space ) {
                m_spacekey_downed = true;
            }
        }

        private void anonymousCaptureSpaceKeyUp( object sender, KeyEventArgs e ) {
            if ( (e.KeyCode & Keys.Space) == Keys.Space ) {
                m_spacekey_downed = false;
            }
        }

        private void commonRendererVOCALOID1_Click( object sender, EventArgs e ) {
            string old = m_manager.VsqFile.Track[m_manager.Selected].getCommon().Version;
            if ( !old.StartsWith( VSTiProxy.RENDERER_DSB2 ) ) {
                VsqTrack item = (VsqTrack)m_manager.VsqFile.Track[m_manager.Selected].Clone();
                List<VsqID> singers = new List<VsqID>();
                foreach ( SingerConfig sc in VocaloSysUtil.getSingerConfigs1() ) {
                    singers.Add( VocaloSysUtil.getSingerID1( sc.VOICENAME ) );
                }
                item.changeRenderer( "DSB202", singers );
                CadenciiCommand run = VsqFileEx.generateCommandTrackReplace( m_manager.Selected, 
                                                                             item,
                                                                             m_manager.VsqFile.AttachedCurves[m_manager.Selected - 1],
                                                                             m_manager.VsqFile.getPitchCurve( m_manager.Selected ) );
                m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
                m_manager.VsqFile.Track[m_manager.Selected].setEditedStart( 0 );
                m_manager.VsqFile.Track[m_manager.Selected].setEditedEnd( m_manager.VsqFile.TotalClocks );
                cMenuTrackTabRendererVOCALOID1.Checked = true;
                cMenuTrackTabRendererVOCALOID2.Checked = false;
                cMenuTrackTabRendererUtau.Checked = false;
                menuTrackRendererVOCALOID1.Checked = true;
                menuTrackRendererVOCALOID2.Checked = false;
                menuTrackRendererUtau.Checked = false;
                Edited = true;
                RefreshScreen();
            }
        }

        private void commonRendererVOCALOID2_Click( object sender, EventArgs e ) {
            string old = m_manager.VsqFile.Track[m_manager.Selected].getCommon().Version;
            if ( !old.StartsWith( VSTiProxy.RENDERER_DSB3 ) ) {
                VsqTrack item = (VsqTrack)m_manager.VsqFile.Track[m_manager.Selected].Clone();
                List<VsqID> singers = new List<VsqID>();
                foreach ( SingerConfig sc in VocaloSysUtil.getSingerConfigs2() ) {
                    singers.Add( VocaloSysUtil.getSingerID2( sc.VOICENAME ) );
                }
                item.changeRenderer( "DSB301", singers );
                CadenciiCommand run = VsqFileEx.generateCommandTrackReplace( m_manager.Selected, 
                                                                             item,
                                                                             m_manager.VsqFile.AttachedCurves[m_manager.Selected - 1],
                                                                             m_manager.VsqFile.getPitchCurve( m_manager.Selected ) );
                m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
                m_manager.VsqFile.Track[m_manager.Selected].setEditedStart( 0 );
                m_manager.VsqFile.Track[m_manager.Selected].setEditedEnd( m_manager.VsqFile.TotalClocks );
                cMenuTrackTabRendererVOCALOID1.Checked = false;
                cMenuTrackTabRendererVOCALOID2.Checked = true;
                cMenuTrackTabRendererUtau.Checked = false;
                menuTrackRendererVOCALOID1.Checked = false;
                menuTrackRendererVOCALOID2.Checked = true;
                menuTrackRendererUtau.Checked = false;
                Edited = true;
                RefreshScreen();
            }
        }

        private void commonRendererUtau_Click( object sender, EventArgs e ) {
            string old = m_manager.VsqFile.Track[m_manager.Selected].getCommon().Version;
            if ( !old.StartsWith( VSTiProxy.RENDERER_UTU0 ) ) {
                VsqTrack item = (VsqTrack)m_manager.VsqFile.Track[m_manager.Selected].Clone();
                List<SingerConfig> list = AppManager.EditorConfig.UtauSingers;
                List<VsqID> singers = new List<VsqID>();
                foreach ( SingerConfig sc in list ) {
                    singers.Add( AppManager.getSingerIDUtau( sc.VOICENAME ) );
                }
                item.changeRenderer( "UTU000", singers );
                CadenciiCommand run = VsqFileEx.generateCommandTrackReplace( m_manager.Selected, 
                                                                             item,
                                                                             m_manager.VsqFile.AttachedCurves[m_manager.Selected - 1],
                                                                             m_manager.VsqFile.getPitchCurve( m_manager.Selected ) );
                m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
                m_manager.VsqFile.Track[m_manager.Selected].setEditedStart( 0 );
                m_manager.VsqFile.Track[m_manager.Selected].setEditedEnd( m_manager.VsqFile.TotalClocks );
                cMenuTrackTabRendererVOCALOID1.Checked = false;
                cMenuTrackTabRendererVOCALOID2.Checked = false;
                cMenuTrackTabRendererUtau.Checked = true;
                menuTrackRendererVOCALOID1.Checked = false;
                menuTrackRendererVOCALOID2.Checked = false;
                menuTrackRendererUtau.Checked = true;
                Edited = true;
                RefreshScreen();
            }
        }

        private void menuVisualPitchLine_CheckedChanged( object sender, EventArgs e ) {
            AppManager.EditorConfig.ViewAtcualPitch = menuVisualPitchLine.Checked;
        }

        private void commonMasterTuning_Click( object sender, EventArgs e ) {
            using ( FormTrackProperty dlg = new FormTrackProperty( m_manager.VsqFile.AttachedCurves[m_manager.Selected - 1].MasterTuningInCent ) ) {
                dlg.Location = GetFormPreferedLocation( dlg );
                if ( dlg.ShowDialog() == DialogResult.OK ) {
                    CadenciiCommand run = VsqFileEx.generateCommandTrackChangeMasterTune( m_manager.Selected, dlg.MasterTuningInCent );
                    m_manager.Register( m_manager.VsqFile.executeCommand( run ) );
                    Edited = true;
                }
            }
        }

        private void menuFileImportVsq_Click( object sender, EventArgs e ) {
            if ( !DirtyCheck() ) {
                return;
            }

            DialogResult dr = DialogResult.Cancel;
            int filterindex = 1;
            if ( AppManager.EditorConfig.LastUsedExtension == ".vsq" ) {
                filterindex = 2;
            }
            if ( AppManager.EditorConfig.UseCustomFileDialog ) {
                using ( FileDialog fd = new FileDialog( FileDialog.DialogMode.Open ) ) {
                    if ( openMidiDialog.FileName != "" ) {
                        fd.FileName = openMidiDialog.FileName;
                    }
                    fd.Filter = openMidiDialog.Filter;
                    fd.FilterIndex = filterindex;
                    dr = fd.ShowDialog();
                    if ( dr == DialogResult.OK ) {
                        openMidiDialog.FileName = fd.FileName;
                        if ( fd.FilterIndex == 1 ) {
                            AppManager.EditorConfig.LastUsedExtension = ".mid";
                        } else if ( fd.FilterIndex == 2 ) {
                            AppManager.EditorConfig.LastUsedExtension = ".vsq";
                        }
                    }
                }
            } else {
                openMidiDialog.FilterIndex = filterindex;
                dr = openMidiDialog.ShowDialog();
                if ( dr == DialogResult.OK ) {
#if DEBUG
                    Common.DebugWriteLine( "openMidiDialog.FilterIndex=" + openMidiDialog.FilterIndex );
#endif
                    if ( openMidiDialog.FilterIndex == 1 ) {
                        AppManager.EditorConfig.LastUsedExtension = ".mid";
                    } else if ( openMidiDialog.FilterIndex == 2 ) {
                        AppManager.EditorConfig.LastUsedExtension = ".vsq";
                    }
                }
            }
            if ( dr != DialogResult.OK ) {
                return;
            }
            m_manager.Selected = 1;
            m_manager.SetVsqFile( new VsqFileEx( openMidiDialog.FileName ) );
            ClearExistingData();
            Edited = false;
            m_mixer_dlg.UpdateStatus();
            ClearTempWave();
#if USE_DOBJ
            UpdateDrawObjectList();
#endif
            RefreshScreen();
        }

        private void toolStripContainer_TopToolStripPanel_SizeChanged( object sender, EventArgs e ) {
            if ( this.WindowState == FormWindowState.Minimized ) {
                return;
            }
            Size minsize = GetWindowMinimumSize();
            int wid = this.Width;
            int hei = this.Height;
            bool change_size_required = false;
            if ( minsize.Width > wid ) {
                wid = minsize.Width;
                change_size_required = true;
            }
            if ( minsize.Height > hei ) {
                hei = minsize.Height;
                change_size_required = true;
            }
            this.MinimumSize = GetWindowMinimumSize();
            if ( change_size_required ) {
                this.Size = new Size( wid, hei );
            }
        }
    }

}
