#ifndef __NoteEvent_h__
#define __NoteEvent_h__

#include <string>
#include "VSQEventManager.h"
#include "UTAUManager.h"

using namespace std;

struct NoteEvent{
    string        mType;           //!< @brief イベントの種類。Anote、またはSinger
    string        mLyric;          //!< @brief 発音
    unsigned char mNote;          //!< @brief 音高
    long          mTick;           //!< @brief 位置(Tick指定)
    long          mLength;         //!< @brief 長さ(Tick指定)
    long          mBeginFrame;
    long          mEndFrame;
    unsigned char mVelocity;      //!< @brief Consonant領域の長さの比
    unsigned char mDecay;         //!< @brief Consonant領域以降の減衰具合
    unsigned char mAccent;        //!< @brief Consonant領域の音の強さ
    unsigned char mBendDepth;     //!< @brief
    unsigned char mBendLength;    //!< @brief
    unsigned char mPortamentoUse;
    long          mVibratoDelay;   //!< @brief Vibratoの開始位置(Tick指定)

    bool        mIsContinuousFront;   //!< @brief 前に音符があるかどうか
    bool        mIsContinuousBack;    //!< @brief 後ろに音符があるかどうか

    UTAUSetting  mSetting;         //!< @brief UTAUの設定を格納する構造体

    NoteEvent    *mPreviousNote;  //!< @brief 連続する場合前の音符データを格納
    NoteEvent    *mNextNote;      //!< @brief 連続する場合次の音符データを格納
    int          mID;

    EventManager mVibratoDepth;  //!< @brief Vibratoの深さを記録する
    EventManager mVibratoRate;   //!< @brief Vibratoの速さを記録する

    // うーん．．．
    string       mIconID;         //!< @brief 歌手を特定するためのID文字列(ex.$07010002)

#ifdef USE_MULTI_SINGER
    int          mSingerIndex;    //!< @brief 音符の歌手設定
#endif
};

#endif // __NoteEvent_h__
