﻿#include "hook_vst.h"

audioMasterCallback g_master;
AEffect*            g_slave;
string              g_dll_name;
int                 g_num_programs;
int                 g_num_params;
std::ofstream       g_logger;
AudioEffect*        g_slave_audio_effect;

AudioEffect* createEffectInstance( audioMasterCallback audioMaster ){
    g_logger.open( "log.txt" );
    g_logger << "createEffectInstance" << std::endl;
    std::ifstream sr;
    try {
        sr.open( "hook_vst.ini" );
        char line[256];
        sr.getline( line, sizeof(line) );
        g_dll_name = line;
    } catch( char* ex ){
        g_logger << ex << std::endl;
        sr.close();
        return NULL;
    }
    sr.close();
    g_logger << "createEffectInstance: g_dll_name=" << g_dll_name << std::endl;
    WCHAR *str = new WCHAR[g_dll_name.length()];
    for( unsigned int i = 0; i < g_dll_name.length(); i++ ){
        str[i] = g_dll_name[i];
    }

    HMODULE dll_handle = LoadLibraryW( str );
    g_logger << "createEffectInstance: dll_handle=" << (int)dll_handle << std::endl;
    delete [] str;
    PVSTMAIN main = (PVSTMAIN)GetProcAddress( dll_handle, "main" );
    g_logger << "createEffectInstance: main=" << (int)main << std::endl;

    g_master = audioMaster;

    g_slave = main( AudioMaster );
    g_slave_audio_effect = (AudioEffect*)g_slave->object;
    g_logger << "createEffectInstance: g_slave=" << (int)g_slave << std::endl;
    g_logger.flush();

    g_num_programs = g_slave->numPrograms;
    g_num_params = g_slave->numParams;

    return new hook_vst( audioMaster );
}

hook_vst::hook_vst( audioMasterCallback audioMaster ) : AudioEffectX( audioMaster, g_num_programs, g_num_params ){
    g_logger << "hook_vst..ctor()" << std::endl;
    setEditor( g_slave_audio_effect->getEditor() );
};

hook_vst::~hook_vst(){
    g_logger << "hook_vst..dtor()" << std::endl;
    g_slave_audio_effect->~AudioEffect();
};

VstIntPtr hook_vst::dispatcher (VstInt32 opcode, VstInt32 index, VstIntPtr value, void* ptr, float opt){
    g_logger << "H>>>P dispatcher: opcode=" << hook_vst::get_aeffect_opcode_string( opcode ) << std::endl;
    return g_slave->dispatcher( g_slave, opcode, index, value, ptr, opt );
};

void hook_vst::processReplacing (float** inputs, float** outputs, VstInt32 sampleFrames){
    g_logger << "H>>>P processReplacing" << std::endl;
    g_slave->processReplacing( g_slave, inputs, outputs, sampleFrames );
};

void hook_vst::setProgram( VstInt32 program ){
    g_logger << "H>>>P setProgram"  << std::endl;
    g_slave->dispatcher( g_slave, effSetProgram, program, 0, 0, 0 );
};

void hook_vst::setProgramName( char* name ){
    g_logger << "H>>>P setProgramName" << std::endl;
    g_slave->dispatcher( g_slave, effSetProgramName, 0, 0, name, 0 );
};

void hook_vst::getProgramName( char* name ){
    g_logger << "H>>>P getProgramName" << std::endl;
    g_slave->dispatcher( g_slave, effGetProgramName, 0, 0, name, 0 );
};

bool hook_vst::getProgramNameIndexed(VstInt32 category, VstInt32 index, char *text) {
    g_logger << "H>>>P getProgramNameIndexed" << std::endl;
    return g_slave->dispatcher( g_slave, effGetProgramNameIndexed, category, index, text, 0 );
};

void hook_vst::setParameter( VstInt32 index, float value ){
    g_logger << "H>>>P setParameter" << std::endl;
    g_slave->setParameter( g_slave, index, value );
};

float hook_vst::getParameter( VstInt32 index ){
    g_logger << "H>>>P getParameter" << std::endl;
    return g_slave->getParameter( g_slave, index );
};

void hook_vst::getParameterLabel( VstInt32 index, char* label ){
    g_logger << "H>>>P getParameterLabel" << std::endl;
    g_slave->dispatcher( g_slave, effGetParamLabel, index, 0, label, 0 );
};

void hook_vst::getParameterDisplay( VstInt32 index, char* text ){
    g_logger << "H>>>P getParameterDisplay" << std::endl;
    g_slave->dispatcher( g_slave, effGetParamDisplay, index, 0, text, 0 );
};

void hook_vst::getParameterName( VstInt32 index, char* text ){
    g_logger << "H>>>P getParameterName" << std::endl;
    g_slave->dispatcher( g_slave, effGetParamName, index, 0, text, 0 );
};

VstInt32 hook_vst::getChunk (void** data, bool isPreset ){
    g_logger << "H>>>P getChunk" << std::endl;
    return g_slave->dispatcher( g_slave, effGetChunk, 0, 0, data, 0 );
};

VstInt32 hook_vst::setChunk (void* data, VstInt32 byteSize, bool isPreset ){
    g_logger << "H>>>P setChunk" << std::endl;
    return g_slave->dispatcher( g_slave, effSetChunk, 0, byteSize, data, 0 );
};

bool hook_vst::getEffectName( char* name ){
    g_logger << "H>>>P getEffectName" << std::endl;
    return g_slave->dispatcher( g_slave, effGetEffectName, 0, 0, name, 0 );
};

bool hook_vst::getVendorString( char* text ){
    g_logger << "H>>>P getVendorString" << std::endl;
    return g_slave->dispatcher( g_slave, effGetVendorString, 0, 0, text, 0 );
};

bool hook_vst::getProductString( char* text ){
    g_logger << "H>>>P getProductString" << std::endl;
    return g_slave->dispatcher( g_slave, effGetProductString, 0, 0, text, 0 );
};

VstInt32 hook_vst::getVendorVersion () {
    g_logger << "H>>>P getVendorVersion" << std::endl;
    return g_slave->dispatcher( g_slave, effGetVendorVersion, 0, 0, 0, 0 );
};
	
VstPlugCategory hook_vst::getPlugCategory() {
    g_logger << "H>>>P getPlugCategory" << std::endl;
    return (VstPlugCategory)g_slave->dispatcher( g_slave, effGetPlugCategory, 0, 0, 0, 0 );
};

//-----------------------------------------------------------------------------------------------
// AudioEffect extension
AEffEditor* hook_vst::getEditor(){
    g_logger << "H>>>P getEditor" << std::endl;
    return ((AudioEffect*)g_slave->object)->getEditor();
};

VstIntPtr AudioMaster( AEffect* effect, VstInt32 opcode, VstInt32 index, VstIntPtr value, void* ptr, float opt ){
    VstIntPtr result = 0;
    g_logger << "H<<<P AudioMaster: opcode=" << hook_vst::get_audio_master_opcode_string( opcode ) << std::endl;
    result = g_master( effect, opcode, index, value, ptr, opt );
    return result;
};
