﻿/*
 * VibratoBPList.cs
 * Copyright (c) 2009 kbinani
 *
 * This file is part of Boare.Lib.Vsq.
 *
 * Boare.Lib.Vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Lib.Vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Collections.Generic;

namespace Boare.Lib.Vsq {

    public class VibratoBPList : ICloneable {
        private List<VibratoBPPair> m_list;

        public VibratoBPList() {
            m_list = new List<VibratoBPPair>();
        }

        public VibratoBPList( float[] x, int[] y ){
            if ( x == null ){
                throw new ArgumentNullException( "x" );
            }
            if ( y == null ){
                throw new ArgumentNullException( "y" );
            }
            int len = Math.Min( x.Length, y.Length );
            m_list = new List<VibratoBPPair>( len );
            for ( int i = 0; i < len; i++ ) {
                m_list.Add( new VibratoBPPair( x[i], y[i] ) );
            }
            m_list.Sort();
        }

        public object Clone() {
            VibratoBPList ret = new VibratoBPList();
            for ( int i = 0; i < m_list.Count; i++ ) {
                ret.m_list.Add( new VibratoBPPair( m_list[i].X, m_list[i].Y ) );
            }
            return ret;
        }

        public int Num {
            get {
                return m_list.Count;
            }
        }

        public VibratoBPPair this[int index] {
            get {
                return m_list[index];
            }
            set {
                m_list[index] = value;
            }
        }
    }

}