//UTAU原音設定管理用クラス

#include "UTAUManager.h"
#include "straightFrame.h"

/*    static map<string,UTAUSetting*> SettingMap;    //!< @brief 原音設定表
    static list<UTAUSetting*>    SettingList;            //!< @brief メモリ管理用リスト
*/
MAP_TYPE<string,UTAUSetting*> UTAUManager::SettingMap;
std::list<UTAUSetting*> UTAUManager::SettingList;

bool    UTAUManager::Initialize(string sOtoName){
    const int BUF_LEN = 256;
    char    cBuffer[BUF_LEN];
    string    sBuffer;
    FILE *ifs;
#ifdef __GNUC__
    ifs = fopen( sOtoName.c_str(), "rb" );
#else
    fopen_s( &ifs, sOtoName.c_str(), "rb" );
#endif

    if( NULL == ifs ){
        cout << "error; sOtoName=" << sOtoName << endl;
        cout << "error; io-error on UtauManager::Initialize; bail-out" << endl;
        return false;
    }

    SettingMap.clear();

    while( NULL != c_getline( cBuffer, BUF_LEN, ifs ) ){
        sBuffer = cBuffer;
        string    sPronounce;
        long index;

        //オブジェクトにデータを追加
        UTAUSetting* pTarget=new UTAUSetting;

        if( ( index = sBuffer.find( ".wav" ) ) == string::npos )
            if( ( index = sBuffer.find( ".stf" ) ) == string::npos )
                index = sBuffer.find( "." );
        pTarget->sName = sBuffer.substr( 0, index );

        /* When no lyric symbol exists, voiceDB will use fileName instead. */
        if( sBuffer.find( "=" ) + 1 == sBuffer.find( "," ) )
            sPronounce = pTarget->sName;
        else{
            sPronounce = sBuffer.substr( sBuffer.find( "=" ) + 1 );
            sPronounce = sPronounce.substr( 0, sPronounce.find( "," ) );
        }

        sBuffer=sBuffer.substr(sBuffer.find(",")+1,256);
        pTarget->iLeftBlank=atoi(sBuffer.substr(0,sBuffer.find(",")).c_str());
        sBuffer=sBuffer.substr(sBuffer.find(",")+1,256);
        pTarget->iConsonant=atoi(sBuffer.substr(0,sBuffer.find(",")).c_str());
        sBuffer=sBuffer.substr(sBuffer.find(",")+1,256);
        pTarget->iRightblank=atoi(sBuffer.substr(0,sBuffer.find(",")).c_str());
        sBuffer=sBuffer.substr(sBuffer.find(",")+1,256);
        pTarget->iPreUtterance=atoi(sBuffer.substr(0,sBuffer.find(",")).c_str());
        sBuffer=sBuffer.substr(sBuffer.find(",")+1,256);
        pTarget->iVoiceOverlap=atoi(sBuffer.substr(0,sBuffer.find(",")).c_str());
        sBuffer=sBuffer.substr(sBuffer.find(",")+1,256);
        pTarget->dBaseFrequency=atof(sBuffer.c_str());                                //平均周波数、UTAU原音設定を拡張している。

        //ハッシュマップに突っ込む
        SettingMap.insert(make_pair(pTarget->sName,pTarget));
        if(sPronounce.compare("")!=0 && sPronounce.compare(pTarget->sName)!=0)        //発音記号とWave名が異なる場合は別に登録。
            SettingMap.insert(make_pair(sPronounce,pTarget));
        //管理用リストにも登録
        SettingList.push_back(pTarget);

    }

    return true;
}

void UTAUManager::Uninitialize(){
    for( list<UTAUSetting *>::iterator i = SettingList.begin(); i != SettingList.end(); i++ ){
        SAFE_DELETE( (*i) );
    }
}

UTAUSetting*    UTAUManager::GetDefaultSetting(string sLyric)
{
    MAP_TYPE<string,UTAUSetting*>::iterator i;
    i=SettingMap.find(sLyric);

    //末尾と一緒の場合はキーに一致しないのでNULLを返す。
    if(i!=SettingMap.end())
        return i->second;
    else
        return NULL;
}
