﻿/*
 * PropertyPanel.cs
 * Copyright (c) 2009 kbinani
 *
 * This file is part of Boare.Cadencii.
 *
 * Boare.Cadencii is free software; you can redistribute it and/or
 * modify it under the terms of the GPLv3 License.
 *
 * Boare.Cadencii is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Collections.Generic;
using System.Windows.Forms;

using Boare.Lib.AppUtil;
using Boare.Lib.Vsq;

namespace Boare.Cadencii {

    public delegate void CommandExecuteRequiredEventHandler( CadenciiCommand command );

    public partial class PropertyPanel : UserControl {
        public event CommandExecuteRequiredEventHandler CommandExecuteRequired;
        private List<VsqEventItemProxy> m_items;
        private int m_track;

        public PropertyPanel() {
            InitializeComponent();
            m_items = new List<VsqEventItemProxy>();
            Misc.ApplyFontRecurse( this, AppManager.EditorConfig.BaseFont );
        }

        public void UpdateValue( int track ) {
            m_track = track;
            m_items.Clear();
            foreach ( SelectedEventEntry item in AppManager.SelectedEvent.GetEnumerator() ) {
                if ( item.Track == track ) {
                    m_items.Add( new VsqEventItemProxy( item.Original ) );
                }
            }
            object[] objs = new object[m_items.Count];
            for ( int i = 0; i < m_items.Count; i++ ) {
                objs[i] = m_items[i];
            }
            propertyGrid.SelectedObjects = objs;
        }

        private void propertyGrid_PropertyValueChanged( object s, PropertyValueChangedEventArgs e ) {
            string name = e.ChangedItem.PropertyDescriptor.Name;
            object old_value = e.OldValue;
            int len = propertyGrid.SelectedObjects.Length;
            VsqEvent[] items = new VsqEvent[len];
            for ( int i = 0; i < len; i++ ) {
                VsqEventItemProxy proxy = (VsqEventItemProxy)propertyGrid.SelectedObjects[i];

                items[i] = proxy.GetItemDifference();

                m_items[i].Original.Clock = proxy.Clock;
                m_items[i].Original.ID.DEMaccent = proxy.Accent;
                m_items[i].Original.ID.DEMdecGainRate = proxy.Decay;
                m_items[i].Original.ID.Dynamics = proxy.Velocity;
                m_items[i].Original.ID.Length = proxy.Length;
                m_items[i].Original.ID.LyricHandle.L0.setPhoneticSymbol( proxy.PhoneticSymbol );
                m_items[i].Original.ID.LyricHandle.L0.Phrase = proxy.Phrase;
                m_items[i].Original.ID.Note = proxy.Note;
                m_items[i].Original.ID.PMBendDepth = proxy.BendDepth;
                m_items[i].Original.ID.PMBendLength = proxy.BendLength;
                m_items[i].Original.ID.PMbPortamentoUse = proxy.GetPortamentoUsage();
                m_items[i].Original.ID.VibratoDelay = proxy.GetVibratoDelay();
                m_items[i].Original.UstEvent.PreUtterance = proxy.PreUtterance;
                m_items[i].Original.UstEvent.VoiceOverlap = proxy.Overlap;
                m_items[i].Original.UstEvent.Moduration = proxy.Moduration;
            }
            if ( CommandExecuteRequired != null ) {
                CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandEventReplaceRange( m_track, items ) );
                CommandExecuteRequired( run );
            }
        }
    }

}
