﻿/*
 * VsqNrpn.cs
 * Copyright (c) 2008-2009 kbinani
 *
 * This file is part of Boare.Lib.Vsq.
 *
 * Boare.Lib.Vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Lib.Vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Collections.Generic;

namespace Boare.Lib.Vsq {

    public class VsqNrpn : IComparable<VsqNrpn> {
        private int m_clock;
        private ushort m_nrpn;
        private byte m_datamsb;
        private byte m_datalsb;
        private bool m_datalsb_specified = false;
        private List<VsqNrpn> m_list;

        public VsqNrpn( int clock, ushort nrpn, byte data_msb ) {
            m_clock = clock;
            m_nrpn = nrpn;
            m_datamsb = data_msb;
            m_datalsb_specified = false;
            m_list = new List<VsqNrpn>();
        }

        public VsqNrpn( int clock, ushort nrpn, byte data_msb, byte data_lsb ) {
            m_clock = clock;
            m_nrpn = nrpn;
            m_datamsb = data_msb;
            m_datalsb = data_lsb;
            m_datalsb_specified = true;
            m_list = new List<VsqNrpn>();
        }

        private VsqNrpn() {
        }

        public VsqNrpn[] Expand_() {
            List<VsqNrpn> ret = new List<VsqNrpn>();
            if ( m_datalsb_specified ) {
                ret.Add( new VsqNrpn( m_clock, m_nrpn, m_datamsb, m_datalsb ) );
            } else {
                ret.Add( new VsqNrpn( m_clock, m_nrpn, m_datamsb ) );
            }
            for ( int i = 0; i < m_list.Count; i++ ) {
                if ( m_list[i].m_datalsb_specified ) {
                    ret.Add( new VsqNrpn( m_list[i].m_clock, m_list[i].m_nrpn, m_list[i].m_datamsb, m_list[i].m_datalsb ) );
                } else {
                    ret.Add( new VsqNrpn( m_list[i].m_clock, m_list[i].m_nrpn, m_list[i].m_datamsb ) );
                }
            }
            return ret.ToArray();
        }

        public VsqNrpn[] Expand() {
            List<VsqNrpn> ret = new List<VsqNrpn>();
            if ( m_datalsb_specified ) {
                ret.Add( new VsqNrpn( m_clock, m_nrpn, m_datamsb, m_datalsb ) );
            } else {
                ret.Add( new VsqNrpn( m_clock, m_nrpn, m_datamsb ) );
            }
            for ( int i = 0; i < m_list.Count; i++ ) {
                ret.AddRange( m_list[i].Expand() );
            }
            return ret.ToArray();
        }

        public static VsqNrpn[] Merge( VsqNrpn[] src1, VsqNrpn[] src2 ) {
            List<VsqNrpn> ret = new List<VsqNrpn>();
            for ( int i = 0; i < src1.Length; i++ ) {
                ret.Add( src1[i] );
            }
            for ( int i = 0; i < src2.Length; i++ ) {
                ret.Add( src2[i] );
            }
            ret.Sort();
            return ret.ToArray();
        }

        public static NrpnData[] Convert( VsqNrpn[] source ) {
            ushort nrpn = (ushort)source[0].Nrpn;
            byte msb = (byte)(nrpn >> 8);
            byte lsb = (byte)(nrpn - (nrpn << 8));
            List<NrpnData> ret = new List<NrpnData>();
            ret.Add( new NrpnData( source[0].Clock, 0x63, msb ) );
            ret.Add( new NrpnData( source[0].Clock, 0x62, lsb ) );
            ret.Add( new NrpnData( source[0].Clock, 0x06, source[0].DataMsb ) );
            if ( source[0].DataLsbSpecified ) {
                ret.Add( new NrpnData( source[0].Clock, 0x26, source[0].DataLsb ) );
            }
            byte last_msb = msb;
            for ( int i = 1; i < source.Length; i++ ) {
                ushort tnrpn = (ushort)source[i].Nrpn;
                msb = (byte)(tnrpn >> 8);
                lsb = (byte)(tnrpn - (tnrpn << 8));
                //if ( msb != last_msb ) {
                ret.Add( new NrpnData( source[i].Clock, 0x63, msb ) );
                //} else if ( msb == 0x63 ) {
                //    ret.Add( new NrpnData( source[i].Clock, 0x63, msb ) );
                //}
                last_msb = msb;
                ret.Add( new NrpnData( source[i].Clock, 0x62, lsb ) );
                ret.Add( new NrpnData( source[i].Clock, 0x06, source[i].DataMsb ) );
                if ( source[i].DataLsbSpecified ) {
                    ret.Add( new NrpnData( source[i].Clock, 0x26, source[i].DataLsb ) );
                }
            }
            return ret.ToArray();
        }

        public int CompareTo( VsqNrpn item ) {
            return m_clock - item.Clock;
        }

        public void Append( NRPN nrpn, byte data_msb ) {
            m_list.Add( new VsqNrpn( m_clock, (ushort)nrpn, data_msb ) );
        }

        public void Append( NRPN nrpn, byte data_msb, byte data_lsb ) {
            m_list.Add( new VsqNrpn( m_clock, (ushort)nrpn, data_msb, data_lsb ) );
        }

        public int Clock {
            get {
                return m_clock;
            }
            set {
                m_clock = value;
            }
        }

        public ushort Nrpn {
            get {
                return m_nrpn;
            }
        }

        public byte DataMsb {
            get {
                return m_datamsb;
            }
        }

        public byte DataLsb {
            get {
                return m_datalsb;
            }
        }

        private bool DataLsbSpecified {
            get {
                return m_datalsb_specified;
            }
        }
    }

}
