﻿/*
 * ScriptInvoker.cs
 * Copyright (c) 2009 kbinani
 *
 * This file is part of Boare.Cadencii.
 *
 * Boare.Cadencii is free software; you can redistribute it and/or
 * modify it under the terms of the GPLv3 License.
 *
 * Boare.Cadencii is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;

using Boare.Lib.AppUtil;
using Boare.Lib.Vsq;

namespace Boare.Cadencii {

    using boolean = System.Boolean;

    public delegate boolean EditVsqScriptDelegate( VsqFile vsq );
    public delegate boolean EditVsqScriptDelegate2( VsqFileEx vsq );

    /// <summary>
    /// スクリプトの起動とスクリプト設定の保存を行うためのオブジェクトの纏まり．
    /// FormMain.menuScript.DropDownItems[*].DropDownItems[0]のTagに代入される．
    /// </summary>
    public class ScriptInvoker {
        /// <summary>
        /// スクリプトを起動するためのデリゲート
        /// </summary>
        public EditVsqScriptDelegate EditVsqDelegate;
        /// <summary>
        /// スクリプトを起動するためのデリゲートその2
        /// </summary>
        public EditVsqScriptDelegate2 EditVsqDelegate2;
        /// <summary>
        /// スクリプト本体の型
        /// </summary>
        public Type ScriptType;
        /// <summary>
        /// スクリプトが記述されたファイルのパス
        /// </summary>
        public String ScriptFile;
        /// <summary>
        /// スクリプトをコンパイルしたときのエラーメッセージ
        /// </summary>
        public String ErrorMessage;
        /// <summary>
        /// スクリプト設定を保存し/読み込むためのXMLシリアライザ
        /// </summary>
        public XmlStaticMemberSerializer Serializer;
        /// <summary>
        /// 最後にスクリプトをコンパイルしたときの，スクリプトが記述されたファイルのタイムスタンプ
        /// </summary>
        public DateTime FileTimestamp;
    }

}
