﻿/*
 * BPPair.cs
 * Copyright (c) 2008-2009 kbinani
 *
 * This file is part of Boare.Lib.Vsq.
 *
 * Boare.Lib.Vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Lib.Vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;

namespace Boare.Lib.Vsq {

    /// <summary>
    /// Stores the paired value of "Clock" and integer. Mainly used in VsqBPList
    /// </summary>
    [Serializable]
    public class BPPair : IComparable<BPPair> {
        public int Clock;
        public int Value;

        /// <summary>
        /// このインスタンスと、指定したオブジェクトを比較します
        /// </summary>
        /// <param name="item"></param>
        /// <returns></returns>
        public int CompareTo( BPPair item ) {
            if ( Clock > item.Clock ) {
                return 1;
            } else if ( Clock < item.Clock ) {
                return -1;
            } else {
                return 0;
            }
        }

        public BPPair( int clock_, int value_ ) {
            Clock = clock_;
            Value = value_;
        }
    }

}
