﻿#pragma once
#include <windows.h>
#include "pluginterfaces/vst2.x/audioeffectx.h"
#include <fstream>
#include <string>

using namespace std;

typedef AEffect* (*PVSTMAIN)( audioMasterCallback audioMaster );
VstIntPtr AudioMaster( AEffect* effect, VstInt32 opcode, VstInt32 index, VstIntPtr value, void* ptr, float opt );

class hook_vst : public AudioEffectX {
public:
	hook_vst( audioMasterCallback audioMaster );
	~hook_vst();

    //-----------------------------------------------------------------------------------------------
    // AEffect
    virtual VstIntPtr dispatcher (VstInt32 opcode, VstInt32 index, VstIntPtr value, void* ptr, float opt);

	virtual void processReplacing (float** inputs, float** outputs, VstInt32 sampleFrames);

	virtual void setProgram (VstInt32 program);
	virtual void setProgramName (char* name);
	virtual void getProgramName (char* name);
	virtual bool getProgramNameIndexed (VstInt32 category, VstInt32 index, char* text);
	
	virtual void setParameter (VstInt32 index, float value);
	virtual float getParameter (VstInt32 index);
	virtual void getParameterLabel (VstInt32 index, char* label);
	virtual void getParameterDisplay (VstInt32 index, char* text);
	virtual void getParameterName (VstInt32 index, char* text);

	virtual VstInt32 getChunk (void** data, bool isPreset = false);
	virtual VstInt32 setChunk (void* data, VstInt32 byteSize, bool isPreset = false);

	virtual bool getEffectName( char* name );
	virtual bool getVendorString( char* text );
	virtual bool getProductString( char* text );
	virtual VstInt32 getVendorVersion();
	
	virtual VstPlugCategory getPlugCategory();

    //-----------------------------------------------------------------------------------------------
    // AudioEffect extension
    virtual AEffEditor* getEditor();

    //-----------------------------------------------------------------------------------------------
    // utility
    static string get_aeffect_opcode_string( int opcode ){
        switch( opcode ){
            case 0:
                return "effOpen";
            case 1:
                return "effClose";
            case 2:
                return "effSetProgram";
            case 3:
                return "effGetProgram";
            case 4:
                return "effSetProgramName";
            case 5:
                return "effGetProgramName";
            case 6:
                return "effGetParamLabel";
            case 7:
                return "effGetParamDisplay";
            case 8:
                return "effGetParamName";
            case 9:
                return "__effGetVuDeprecated";
            case 10:
                return "effSetSampleRate";
            case 11:
                return "effSetBlockSize";
            case 12:
                return "effMainsChanged";
            case 13:
                return "effEditGetRect";
            case 14:
                return "effEditOpen";
            case 15:
                return "effEditClose";
            case 16:
                return "__effEditDrawDeprecated";
            case 17:
                return "__effEditMouseDeprecated";
            case 18:
                return "__effEditKeyDeprecated";
            case 19:
                return "effEditIdle";
            case 20:
                return "__effEditTopDeprecated";
            case 21:
                return "__effEditSleepDeprecated";
            case 22:
                return "__effIdentifyDeprecated";
            case 23:
                return "effGetChunk";
            case 24:
                return "effSetChunk";
            case 25:
                return "effProcessEvents";
            case 26:
                return "effCanBeAutomated";
            case 27:
                return "effString2Parameter";
            case 28:
                return "__effGetNumProgramCategoriesDeprecated";
            case 29:
                return "effGetProgramNameIndexed";
            case 30:
                return "__effCopyProgramDeprecated";
            case 31:
                return "__effConnectInputDeprecated";
            case 32:
                return "__effConnectOutputDeprecated";
            case 33:
                return "effGetInputProperties";
            case 34:
                return "effGetOutputProperties";
            case 35:
                return "effGetPlugCategory";
            case 36:
                return "__effGetCurrentPositionDeprecated";
            case 37:
                return "__effGetDestinationBufferDeprecated";
            case 38:
                return "effOfflineNotify";
            case 39:
                return "effOfflinePrepare";
            case 40:
                return "effOfflineRun";
            case 41:
                return "effProcessVarIo";
            case 42:
                return "effSetSpeakerArrangement";
            case 43:
                return "__effSetBlockSizeAndSampleRateDeprecated";
            case 44:
                return "effSetBypass";
            case 45:
                return "effGetEffectName";
            case 46:
                return "__effGetErrorTextDeprecated";
            case 47:
                return "effGetVendorString";
            case 48:
                return "effGetProductString";
            case 49:
                return "effGetVendorVersion";
            case 50:
                return "effVendorSpecific";
            case 51:
                return "effCanDo";
            case 52:
                return "effGetTailSize";
            case 53:
                return "__effIdleDeprecated";
            case 54:
                return "__effGetIconDeprecated";
            case 55:
                return "__effSetViewPositionDeprecated";
            case 56:
                return "effGetParameterProperties";
            case 57:
                return "__effKeysRequiredDeprecated";
            case 58:
                return "effGetVstVersion";
            case 59:
                return "effEditKeyDown";
            case 60:
                return "effEditKeyUp";
            case 61:
                return "effSetEditKnobMode";
            case 62:
                return "effGetMidiProgramName";
            case 63:
                return "effGetCurrentMidiProgram";
            case 64:
                return "effGetMidiProgramCategory";
            case 65:
                return "effHasMidiProgramsChanged";
            case 66:
                return "effGetMidiKeyName";
            case 67:
                return "effBeginSetProgram";
            case 68:
                return "effEndSetProgram";
            case 69:
                return "effGetSpeakerArrangement";
            case 70:
                return "effShellGetNextPlugin";
            case 71:
                return "effStartProcess";
            case 72:
                return "effStopProcess";
            case 73:
                return "effSetTotalSampleToProcess";
            case 74:
                return "effSetPanLaw";
            case 75:
                return "effBeginLoadBank";
            case 76:
                return "effBeginLoadProgram";
            case 77:
                return "effSetProcessPrecision";
            case 78:
                return "effGetNumMidiInputChannels";
            case 79:
                return "effGetNumMidiOutputChannels";
        }
        return "";
    };

    static string get_audio_master_opcode_string( int opcode ){
        switch( opcode ){
            case 0:
                return "audioMasterAutomate";
            case 1:
                return "audioMasterVersion";
            case 2:
                return "audioMasterCurrentId";
            case 3:
                return "audioMasterIdle";
            case 4:
                return "__audioMasterPinConnectedDeprecated";
            case 6:
                return "__audioMasterWantMidiDeprecated";
            case 7:
                return "audioMasterGetTime";
            case 8:
                return "audioMasterProcessEvents";
            case 9:
                return "__audioMasterSetTimeDeprecated";
            case 10:
                return "__audioMasterTempoAtDeprecated";
            case 11:
                return "__audioMasterGetNumAutomatableParametersDeprecated";
            case 12:
                return "__audioMasterGetParameterQuantizationDeprecated";
            case 13:
                return "audioMasterIOChanged";
            case 14:
                return "__audioMasterNeedIdleDeprecated";
            case 15:
                return "audioMasterSizeWindow";
            case 16:
                return "audioMasterGetSampleRate";
            case 17:
                return "audioMasterGetBlockSize";
            case 18:
                return "audioMasterGetInputLatency";
            case 19:
                return "audioMasterGetOutputLatency";
            case 20:
                return "__audioMasterGetPreviousPlugDeprecated";
            case 21:
                return "__audioMasterGetNextPlugDeprecated";
            case 22:
                return "__audioMasterWillReplaceOrAccumulateDeprecated";
            case 23:
                return "audioMasterGetCurrentProcessLevel";
            case 24:
                return "audioMasterGetAutomationState";
            case 25:
                return "audioMasterOfflineStart";
            case 26:
                return "audioMasterOfflineRead";
            case 27:
                return "audioMasterOfflineWrite";
            case 28:
                return "audioMasterOfflineGetCurrentPass";
            case 29:
                return "audioMasterOfflineGetCurrentMetaPass";
            case 30:
                return "__audioMasterSetOutputSampleRateDeprecated";
            case 31:
                return "__audioMasterGetOutputSpeakerArrangementDeprecated";
            case 32:
                return "audioMasterGetVendorString";
            case 33:
                return "audioMasterGetProductString";
            case 34:
                return "audioMasterGetVendorVersion";
            case 35:
                return "audioMasterVendorSpecific";
            case 36:
                return "__audioMasterSetIconDeprecated";
            case 37:
                return "audioMasterCanDo";
            case 38:
                return "audioMasterGetLanguage";
            case 39:
                return "__audioMasterOpenWindowDeprecated";
            case 40:
                return "__audioMasterCloseWindowDeprecated";
            case 41:
                return "audioMasterGetDirectory";
            case 42:
                return "audioMasterUpdateDisplay";
            case 43:
                return "audioMasterBeginEdit";
            case 44:
                return "audioMasterEndEdit";
            case 45:
                return "audioMasterOpenFileSelector";
            case 46:
                return "audioMasterCloseFileSelector";
            case 47:
                return "__audioMasterEditFileDeprecated";
            case 48:
                return "__audioMasterGetChunkFileDeprecated";
            case 49:
                return "__audioMasterGetInputSpeakerArrangementDeprecated";
        }
        return "";
    };
};
