﻿/*
 * misc.cs
 * Copyright (c) 2009 kbinani
 *
 * This file is part of bocoree.
 *
 * bocoree is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * bocoree is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.IO;
using System.Security.Cryptography;
using System.Text;
using System.Collections.Generic;

namespace bocoree {

    public static class misc {
        public static string getmd5( string s ) {
            MD5 md5 = MD5.Create();
            byte[] data = Encoding.Unicode.GetBytes( s );
            byte[] hash = md5.ComputeHash( data );
            return BitConverter.ToString( hash ).ToLower().Replace( "-", "" );
        }

        /// <summary>
        /// 現在の実行アセンブリで使用されている型のリストを取得します
        /// </summary>
        /// <returns></returns>
        public static Type[] get_executing_types() {
            System.Reflection.Assembly asm = System.Reflection.Assembly.GetExecutingAssembly();
            List<Type> types = new List<Type>( asm.GetTypes() );
            foreach ( System.Reflection.AssemblyName asmname in asm.GetReferencedAssemblies() ) {
                System.Reflection.Assembly asmref = System.Reflection.Assembly.Load( asmname );
                types.AddRange( asmref.GetTypes() );
            }

            asm = System.Reflection.Assembly.GetCallingAssembly();
            types.AddRange( asm.GetTypes() );
            foreach ( System.Reflection.AssemblyName asmname in asm.GetReferencedAssemblies() ) {
                System.Reflection.Assembly asmref = System.Reflection.Assembly.Load( asmname );
                types.AddRange( asmref.GetTypes() );
            }

            asm = System.Reflection.Assembly.GetEntryAssembly();
            types.AddRange( asm.GetTypes() );
            foreach ( System.Reflection.AssemblyName asmname in asm.GetReferencedAssemblies() ) {
                System.Reflection.Assembly asmref = System.Reflection.Assembly.Load( asmname );
                types.AddRange( asmref.GetTypes() );
            }

            List<Type> ret = new List<Type>();
            foreach ( Type t in types ) {
                if ( t.IsPublic && !ret.Contains( t ) ) {
                    ret.Add( t );
                }
            }
            return ret.ToArray();
        }

        /// <summary>
        /// 現在の実行アセンブリで使用されている名前空間のリストを取得します
        /// </summary>
        /// <returns></returns>
        public static string[] get_executing_namespaces() {
            Type[] types = get_executing_types();
            List<string> list = new List<string>();
            foreach ( Type t in types ) {
                if ( !list.Contains( t.Namespace ) ) {
                    list.Add( t.Namespace );
                }
            }
            list.Sort();
            return list.ToArray();
        }
    }

    public static class debug {
        private static StreamWriter s_debug_out = null;
        private static string s_path = "";

        public static void force_logfile_path( string path ) {
            s_path = path;
        }

        public static void push_log( string s ) {
            if ( s_debug_out == null ) {
                if ( s_path == "" ) {
                    s_debug_out = new StreamWriter( Path.Combine( System.Windows.Forms.Application.StartupPath, "run.log" ) );
                } else {
                    s_debug_out = new StreamWriter( s_path );
                }
                s_debug_out.AutoFlush = true;
                s_debug_out.WriteLine( "************************************************************************" );
                s_debug_out.WriteLine( "  Date: " + DateTime.Now.ToString() );
                s_debug_out.WriteLine( "------------------------------------------------------------------------" );
            }
            s_debug_out.WriteLine( s );
        }
    }

}
