/*
 * VsqCommon.h
 * Copyright (c) 2009 kbinani
 *
 * This file is part of Boare.Lib.Vsq.
 *
 * Boare.Lib.Vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Lib.Vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
#ifndef __vsqcommon_h__
#define __vsqcommon_h__
#include <string>
#include <sstream>
#include "common.h"
#include "TextMemoryStream.h"

using namespace std;
using namespace Boare::Lib::Vsq;

namespace Boare{ namespace Lib{ namespace Vsq{

    /// <summary>
    /// vsqファイルのメタテキストの[Common]セクションに記録される内容を取り扱う
    /// </summary>
    class VsqCommon {
    public:
        string Version;
        string Name;
        string Color;
        int DynamicsMode;
        int PlayMode;

        VsqCommon* Clone();

        /// <summary>
        /// 各パラメータを指定したコンストラクタ
        /// </summary>
        /// <param name="name">トラック名</param>
        /// <param name="color">Color値（意味は不明）</param>
        /// <param name="dynamics_mode">DynamicsMode（デフォルトは1）</param>
        /// <param name="play_mode">PlayMode（デフォルトは1）</param>
        VsqCommon( string name, Boare::Lib::Vsq::Color color, int dynamics_mode, int play_mode );

        /// <summary>
        /// MetaTextのテキストファイルからのコンストラクタ
        /// </summary>
        /// <param name="sr">読み込むテキストファイル</param>
        /// <param name="last_line">読み込んだ最後の行が返される</param>
        VsqCommon( TextMemoryStream *sr, string *last_line );

        /// <summary>
        /// インスタンスの内容をテキストファイルに出力します
        /// </summary>
        /// <param name="sw">出力先</param>
        void write( TextMemoryStream *sw );

        /// <summary>
        /// VsqCommon構造体を構築するテストを行います
        /// </summary>
        /// <returns>テストに成功すればtrue、そうでなければfalse</returns>
        static bool test();
    };

} } }

#endif // #define __vsqcommon_h__
