﻿/*
 * NrpnData.cs
 * Copyright (c) 2008-2009 kbinani
 *
 * This file is part of Boare.Lib.Vsq.
 *
 * Boare.Lib.Vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Lib.Vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
#if __cplusplus
namespace Boare{ namespace Lib{ namespace Vsq{
#else
namespace Boare.Lib.Vsq {
#endif

#if __cplusplus
    class NrpnData {
#else
    public class NrpnData {
#endif
        int m_clock;
        byte m_parameter;
        byte m_value;

#if __cplusplus
    public:
        NrpnData( int clock, byte parameter, byte value ) : 
                Clock( this, &NrpnData::getClock ),
                Parameter( this, &NrpnData::getParameter ),
                Value( this, &NrpnData::getValue, &NrpnData::setValue )
        {
#else
        public NrpnData( int clock, byte parameter, byte value ) {
#endif
            m_clock = clock;
            m_parameter = parameter;
            m_value = value;
        }
#if __cplusplus
    public:
        ReadOnlyProperty<NrpnData, int> Clock;
#else
        public int Clock {
            get {
                return getClock();
            }
        }
#endif
        int getClock() {
            return m_clock;
        }

#if __cplusplus
    public:
        ReadOnlyProperty<NrpnData, byte> Parameter;
#else
        public byte Parameter {
            get {
                return getParameter();
            }
        }
#endif
        byte getParameter() {
            return m_parameter;
        }


#if __cplusplus
    public:
        Property<NrpnData, byte> Value;
#else
        public byte Value {
            get {
                return getValue();
            }
            set {
                setValue( value );
            }
        }
#endif
        byte getValue() {
            return m_value;
        }

        void setValue( byte value ) {
            m_value = value;
        }
    };

#if __cplusplus
} } }
#else
}
#endif
