/*
 * BPPair.cs
 * Copyright © 2008-2011 kbinani
 *
 * This file is part of org.kbinani.vsq.
 *
 * org.kbinani.vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * org.kbinani.vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
#if JAVA
package org.kbinani.vsq;

import java.io.*;
#else

namespace org{
    namespace kbinani{
        namespace vsq{
#if CSHARP

using System;

#endif
#endif

    /// <summary>
    /// ゲートタイムと、何らかのパラメータ値とのペアを表します。主にVsqBPListで使用します。
    /// </summary>
#if JAVA
    public class BPPair implements Comparable<BPPair>, Serializable
#elif __cplusplus
    class BPPair
#else
    [Serializable]
    public class BPPair : IComparable<BPPair>
#endif
    {
#if __cplusplus
    public:
#else
        public
#endif
        int Clock;

#if __cplusplus
    public:
#else
        public
#endif
        int Value;

        /// <summary>
        /// このインスタンスと、指定したオブジェクトを比較します
        /// </summary>
        /// <param name="item"></param>
        /// <returns></returns>
#if __cplusplus
    public:
#else
        public
#endif
        int compareTo( BPPair item )
        {
            if ( Clock > item.Clock )
            {
                return 1;
            }
            else if ( Clock < item.Clock )
            {
                return -1;
            }
            else
            {
                return 0;
            }
        }

#if CSHARP
        public int CompareTo( BPPair item )
        {
            return compareTo( item );
        }
#endif

        /// <summary>
        /// 指定されたゲートタイムとパラメータ値を使って、新しいインスタンスを初期化します。
        /// </summary>
        /// <param name="clock_"></param>
        /// <param name="value_"></param>
#if __cplusplus
    public :
            BPPair( int clock_, int value_ )
#else
        public BPPair( int clock_, int value_ )
#endif
        {
            Clock = clock_;
            Value = value_;
        }
    };

#if !JAVA
} } }
#endif
