﻿/*
 * IPaletteTool.cs
 * Copyright (c) 2009 kbinani
 *
 * This file is part of Boare.Cadencii.
 *
 * Boare.Cadencii is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Cadencii is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System.Collections.Generic;
using System.Drawing;
using System.Windows.Forms;

using Boare.Lib.Vsq;

namespace Boare.Cadencii {

    public interface IPaletteTool {
        bool edit( VsqTrack track, EditorManager manager, int[] event_internal_ids, MouseButtons button );
        string getName( string language );
        string getDescription( string language );
        bool hasDialog();
        DialogResult openDialog();
        Bitmap getIcon();
        void applyLanguage( string language );
    }

}
