/*
 * VsqCommon.cpp
 * Copyright (c) 2009 kbinani
 *
 * This file is part of Boare.Lib.Vsq.
 *
 * Boare.Lib.Vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Lib.Vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
#include "VsqCommon.h"

namespace Boare{ namespace Lib{ namespace Vsq{

VsqCommon *VsqCommon::Clone(){
    vector<string> spl = split( this->Color, "," );
    int r = int_parse( spl[0] );
    int g = int_parse( spl[1] );
    int b = int_parse( spl[2] );
    Boare::Lib::Vsq::Color color;
    color.R = r;
    color.G = g;
    color.B = b;
    VsqCommon *res = new VsqCommon( Name, color, DynamicsMode, PlayMode );
    res->Version = Version;
    return res;
}

/// <summary>
/// 各パラメータを指定したコンストラクタ
/// </summary>
/// <param name="name">トラック名</param>
/// <param name="color">Color値（意味は不明）</param>
/// <param name="dynamics_mode">DynamicsMode（デフォルトは1）</param>
/// <param name="play_mode">PlayMode（デフォルトは1）</param>
VsqCommon::VsqCommon( string name, Boare::Lib::Vsq::Color color, int dynamics_mode, int play_mode ){
    this->Version = "DSB301";
    this->Name = name;
    std::ostringstream os;
    os << std::dec << color.R << "," << color.G << "," << color.B;
    this->Color = os.str();
    this->DynamicsMode = dynamics_mode;
    this->PlayMode = play_mode;
}

/// <summary>
/// MetaTextのテキストファイルからのコンストラクタ
/// </summary>
/// <param name="sr">読み込むテキストファイル</param>
/// <param name="last_line">読み込んだ最後の行が返される</param>
VsqCommon::VsqCommon( TextMemoryStream *sr, string *last_line ) {
    Version = "";
    Name = "";
    Color = "0,0,0";
    DynamicsMode = 0;
    PlayMode = 0;
    *last_line = sr->ReadLine();
    int loc = last_line->find( "[" );
    while( loc != string::npos ){
        vector<string> spl = split( *last_line, "=" );
        if( spl[0] == "Version" ){
            this->Version = spl[1];
        }else if( spl[0] == "Name" ){
            this->Name = spl[1];
        }else if( spl[0] == "Color" ){
            this->Color = spl[1];
        }else if( spl[0] == "DynamicsMode" ){
            this->DynamicsMode = int_parse( spl[1] );
        }else if( spl[0] == "PlayMode" ){
            this->PlayMode = int_parse( spl[1] );
        }
        if ( sr->Peek() < 0 ) {
            break;
        }
        *last_line = sr->ReadLine();
    }
}


/// <summary>
/// インスタンスの内容をテキストファイルに出力します
/// </summary>
/// <param name="sw">出力先</param>
void VsqCommon::write( TextMemoryStream *sw ) {
    sw->WriteLine( "[Common]" );
    sw->WriteLine( "Version=" + Version );
    sw->WriteLine( "Name=" + Name );
    sw->WriteLine( "Color=" + Color );
    sw->WriteLine( "DynamicsMode=" + DynamicsMode );
    sw->WriteLine( "PlayMode=" + PlayMode );
}


/// <summary>
/// VsqCommon構造体を構築するテストを行います
/// </summary>
/// <returns>テストに成功すればtrue、そうでなければfalse</returns>
/*bool VsqCommon::test() {
    string fpath = Path.GetTempFileName();
    StreamWriter sw = new StreamWriter( fpath, false, Encoding.Unicode );
    sw.WriteLine( "Version=DSB301" );
    sw.WriteLine( "Name=Voice1" );
    sw.WriteLine( "Color=181,162,123" );
    sw.WriteLine( "DynamicsMode=1" );
    sw.WriteLine( "PlayMode=1" );
    sw.WriteLine( "[Master]" );
    sw.Close();

    VsqCommon vsqCommon;
    string last_line = "";
    using ( TextMemoryStream sr = new TextMemoryStream( fpath, Encoding.Unicode ) ) {
        vsqCommon = new VsqCommon( sr, ref last_line );
    }

    bool result;
    if ( vsqCommon.Version == "DSB301" &&
        vsqCommon.Name == "Voice1" &&
        vsqCommon.Color == "181,162,123" &&
        vsqCommon.DynamicsMode == 1 &&
        vsqCommon.PlayMode == 1 &&
        last_line == "[Master]" ) {
        result = true;
    } else {
        result = false;
    }

    File.Delete( fpath );
    return result;
}*/

} } }
