﻿/*
 * NRPN.cs
 * Copyright (c) 2009 kbinani
 *
 * This file is part of Boare.Lib.Vsq.
 *
 * Boare.Lib.Vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Lib.Vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
namespace Boare.Lib.Vsq {

    public enum NRPN : ushort {
        /// <summary>
        /// (0x5000) Version number(MSB) &amp;, Device number(LSB)
        /// </summary>
        CVM_NM_VERSION_AND_DEVICE = 0x5000,
        /// <summary>
        /// (0x5001) Delay in millisec(MSB, LSB)
        /// </summary>
        CVM_NM_DELAY = 0x5001,
        /// <summary>
        /// (0x5002) Note number(MSB)
        /// </summary>
        CVM_NM_NOTE_NUMBER = 0x5002,
        /// <summary>
        /// (0x5003) Velocity(MSB)
        /// </summary>
        CVM_NM_VELOCITY = 0x5003,
        /// <summary>
        /// (0x5004) Note Duration in millisec(MSB, LSB)
        /// </summary>
        CVM_NM_NOTE_DURATION = 0x5004,
        /// <summary>
        /// (0x5005) Note Location(MSB)
        /// </summary>
        CVM_NM_NOTE_LOCATION = 0x5005,
        /// <summary>
        /// (0x500c) Index of Vibrato DB(MSB: ID_H00, LSB:ID_L00)
        /// </summary>
        CVM_NM_INDEX_OF_VIBRATO_DB = 0x500c,
        /// <summary>
        /// (0x500d) Vibrato configuration(MSB: Index of Vibrato Type, LSB: Duration &amp;, Configuration parameter of vibrato)
        /// </summary>
        CVM_NM_VIBRATO_CONFIG = 0x500d,
        /// <summary>
        /// (0x500e) Vibrato Delay(MSB)
        /// </summary>
        CVM_NM_VIBRATO_DELAY = 0x500e,
        /// <summary>
        /// (0x5012) Number of phonetic symbols in bytes(MSB)
        /// </summary>
        CVM_NM_PHONETIC_SYMBOL_BYTES = 0x5012,
        /// <summary>
        /// (0x5013) Phonetic symbol 1(MSB:Phonetic symbol 1, LSB: Consonant adjustment 1)
        /// </summary>
        CVM_NM_PHONETIC_SYMBOL1 = 0x5013,
        /// <summary>
        /// (0x504f) Phonetic symbol continuation(MSB, 0x7f=end, 0x00=continue)
        /// </summary>
        CVM_NM_PHONETIC_SYMBOL_CONTINUATION = 0x504f,
        /// <summary>
        /// (0x5050) v1mean in Cent/5(MSB)
        /// </summary>
        CVM_NM_V1MEAN = 0x5050,
        /// <summary>
        /// (0x5051) d1mean in millisec/5(MSB)
        /// </summary>
        CVM_NM_D1MEAN = 0x5051,
        /// <summary>
        /// (0x5052) d1meanFirstNote in millisec/5(MSB)
        /// </summary>
        CVM_NM_D1MEAN_FIRST_NOTE = 0x5052,
        /// <summary>
        /// (0x5053) d2mean in millisec/5(MSB)
        /// </summary>
        CVM_NM_D2MEAN = 0x5053,
        /// <summary>
        /// (0x5054) d4mean in millisec/5(MSB)
        /// </summary>
        CVM_NM_D4MEAN = 0x5054,
        /// <summary>
        /// (0x5055) pMeanOnsetFirstNote in Cent/5(MSB)
        /// </summary>
        CVM_NM_PMEAN_ONSET_FIRST_NOTE = 0x5055,
        /// <summary>
        /// (0x5056) vMeanNoteTransition in Cent/5(MSB)
        /// </summary>
        CVM_NM_VMEAN_NOTE_TRNSITION = 0x5056,
        /// <summary>
        /// (0x5057) pMeanEndingNote in Cent/5(MSB)
        /// </summary>
        CVM_NM_PMEAN_ENDING_NOTE = 0x5057,
        /// <summary>
        /// (0x5058) AddScooptoUpIntervals &amp;, AddPortamentoToDownIntervals(MSB)
        /// </summary>
        CVM_NM_ADD_PORTAMENTO = 0x5058,
        /// <summary>
        /// (0x5059) changAfterPeak(MSB)
        /// </summary>
        CVM_NM_CHANGE_AFTER_PEAK = 0x5059,
        /// <summary>
        /// (0x505a) Accent(MSB)
        /// </summary>
        CVM_NM_ACCENT = 0x505a,
        /// <summary>
        /// (0x597f) Note message continuation(MSB)
        /// </summary>
        CVM_NM_NOTE_MESSAGE_CONTINUATION = 0x507f,

        /// <summary>
        /// (0x6000) Version number &amp;, Device number(MSB, LSB)
        /// </summary>
        CC_BS_VERSION_AND_DEVICE = 0x6000,
        /// <summary>
        /// (0x6001) Delay in millisec(MSB, LSB)
        /// </summary>
        CC_BS_DELAY = 0x6001,
        /// <summary>
        /// (0x6002) Laugnage type(MSB, optional LSB)
        /// </summary>
        CC_BS_LANGUAGE_TYPE = 0x6002,

        /// <summary>
        /// (0x6100) Version number &amp;, device number(MSB, LSB)
        /// </summary>
        CC_CV_VERSION_AND_DEVICE = 0x6100,
        /// <summary>
        /// (0x6101) Delay in millisec(MSB, LSB)
        /// </summary>
        CC_CV_DELAY = 0x6101,
        /// <summary>
        /// (0x6102) Volume value(MSB)
        /// </summary>
        CC_CV_VOLUME = 0x6102,

        /// <summary>
        /// (0x6200) Version number &amp;, device number(MSB, LSB)
        /// </summary>
        CC_P_VERSION_AND_DEVICE = 0x6200,
        /// <summary>
        /// (0x6201) Delay in millisec(MSB, LSB)
        /// </summary>
        CC_P_DELAY = 0x6201,
        /// <summary>
        /// (0x6202) Pan value(MSB)
        /// </summary>
        CC_PAN = 0x6202,

        /// <summary>
        /// (0x6300) Version number &amp;, device number(MSB, LSB)
        /// </summary>
        CC_E_VESION_AND_DEVICE = 0x6300,
        /// <summary>
        /// (0x6301) Delay in millisec(MSB, LSB)
        /// </summary>
        CC_E_DELAY = 0x6301,
        /// <summary>
        /// (0x6302) Expression vlaue(MSB)
        /// </summary>
        CC_E_EXPRESSION = 0x6302,

        /// <summary>
        /// (0x6400) Version number &amp;, device number(MSB, LSB)
        /// </summary>
        CC_VR_VERSION_AND_DEVICE = 0x6400,
        /// <summary>
        /// (0x6401) Delay in millisec(MSB, LSB)
        /// </summary>
        CC_VR_DELAY = 0x6401,
        /// <summary>
        /// (0x6402) Vibrato Rate value(MSB)
        /// </summary>
        CC_VR_VIBRATO_RATE = 0x6402,

        /// <summary>
        /// (0x6500) Version number &amp;, device number(MSB, LSB)
        /// </summary>
        CC_VD_VERSION_AND_DEVICE = 0x6500,
        /// <summary>
        /// (0x6501) Delay in millisec(MSB, LSB)
        /// </summary>
        CC_VD_DELAY = 0x6501,
        /// <summary>
        /// (0x6502) Vibrato Depth value(MSB)
        /// </summary>
        CC_VD_VIBRATO_DEPTH = 0x6502,

        /// <summary>
        /// (0x6700) Version number &amp;, device number(MSB, LSB)
        /// </summary>
        CC_PBS_VERSION_AND_DEVICE = 0x6700,
        /// <summary>
        /// (0x6701) Delay in millisec(MSB, LSB)
        /// </summary>
        CC_PBS_DELAY = 0x6701,
        /// <summary>
        /// (0x6702) Pitch Bend Sensitivity(MSB, LSB)
        /// </summary>
        CC_PBS_PITCH_BEND_SENSITIVITY = 0x6702,

        /// <summary>
        /// (0x5300) Version number &amp;, device number(MSB, LSB)
        /// </summary>
        PC_VERSION_AND_DEVICE = 0x5300,
        /// <summary>
        /// (0x5301) Delay in millisec(MSB, LSB)
        /// </summary>
        PC_DELAY = 0x5301,
        /// <summary>
        /// (0x5302) Voice Type(MSB)
        /// </summary>
        PC_VOICE_TYPE = 0x5302,

        /// <summary>
        /// (0x5400) Version number &amp;, device number(MSB, LSB)
        /// </summary>
        PB_VERSION_AND_DEVICE = 0x5400,
        /// <summary>
        /// (0x5401) Delay in millisec(MSB, LSB)
        /// </summary>
        PB_DELAY = 0x5401,
        /// <summary>
        /// (0x5402) Pitch Bend value(MSB, LSB)
        /// </summary>
        PB_PITCH_BEND = 0x5402,

        /// <summary>
        /// (0x5500) Version number &amp;, device number(MSB, LSB)
        /// </summary>
        VCP_VERSION_AND_DEVICE = 0x5500,
        /// <summary>
        /// (0x5501) Delay in millisec(MSB, LSB)
        /// </summary>
        VCP_DELAY = 0x5501,
        /// <summary>
        /// (0x5502) Voice Change Parameter ID(MSB)
        /// </summary>
        VCP_VOICE_CHANGE_PARAMETER_ID = 0x5502,
        /// <summary>
        /// (0x5503) Voice Change Parameter value(MSB)
        /// </summary>
        VCP_VOICE_CHANGE_PARAMETER = 0x5503,
    }

}
