/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is bbs2chreader.
 *
 * The Initial Developer of the Original Code is
 * flyson.
 * Portions created by the Initial Developer are Copyright (C) 2007
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *    flyson <flyson at users.sourceforge.jp>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */


function b2rGlobalHistory(){
	this._init();
}

b2rGlobalHistory.prototype = {

	get database(){
		return this._database;
	},


	_init: function(){
		var storageService = XPC.getService("@mozilla.org/storage/service;1", "mozIStorageService");
		var pref = XPC.getService("@mozilla.org/preferences-service;1", "nsIPrefBranch");

		var dbFile = gGlobalService.io.getDataDir();
		dbFile.appendRelativePath("history.sqlite");
		this._database = storageService.openDatabase(dbFile);

		this._database.beginTransaction();
		try{
			if(!this._database.tableExists("history")){
				var sql = <>
					CREATE TABLE history(
					    id           INTEGER PRIMARY KEY,
					    url          TEXT NOT NULL,
					    title        TEXT NOT NULL,
					    last_visited INTEGER NOT NULL DEFAULT 0,
					    visit_count  INTEGER NOT NULL DEFAULT 1,
					    type         INTEGER NOT NULL DEFAULT 0
					);
				</>.toString().replace(/\t/g, "");
				this._database.executeSimpleSQL(sql);
			}

			var historyExpireDays = pref.getIntPref("extensions.bbs2chreader.history_expire_days");
			if(historyExpireDays > 365) historyExpireDays = 365;
			var sql = "DELETE FROM history WHERE last_visited < strftime('%s', 'now', '-" + historyExpireDays +  " day')";
			this._database.executeSimpleSQL(sql);

		}catch(ex){
			Components.utils.reportError(ex);
		}finally{
			this._database.commitTransaction();
		}
	},


	visitPage: function(aURL, aTitle, aType){
		var pageID = null;

		this._database.beginTransaction();
		try{
			var sql = "SELECT id FROM history WHERE url=?1";
			var statement = this._database.createStatement(sql);
			statement.bindStringParameter(0, aURL.spec);
			if(statement.executeStep()){
				pageID = statement.getInt32(0);
			}
			statement.reset();

			if(pageID){
				sql = "UPDATE history SET title=?1, visit_count=visit_count+1, last_visited=?2 WHERE id=?3;";
				statement = this._database.createStatement(sql);
				statement.bindStringParameter(0, aTitle);
				statement.bindInt32Parameter(1, Date.now() / 1000);
				statement.bindInt32Parameter(2, pageID);
				statement.execute();
			}else{
				sql = "INSERT INTO history(url, title, type, last_visited) VALUES(?1, ?2, ?3, ?4);";
				statement = this._database.createStatement(sql);
				statement.bindStringParameter(0, aURL.spec);
				statement.bindStringParameter(1, aTitle);
				statement.bindInt32Parameter(2, aType);
				statement.bindInt32Parameter(3, Date.now() / 1000);
				statement.execute();
			}
		}catch(ex){
			Components.utils.reportError(ex);
		}finally{
			this._database.commitTransaction();
		}

		var os = XPC.getService("@mozilla.org/observer-service;1", "nsIObserverService");
		os.notifyObservers(aURL.clone(), "b2r-visit-page", aType);

		return true;
	},


	clearAll: function(){
		this._database.beginTransaction();
		try{
			this._database.executeSimpleSQL("DELETE FROM history;");
		}catch(ex){
			Components.utils.reportError(ex);
		}finally{
			this._database.commitTransaction();
		}

		try{
			this._database.executeSimpleSQL("VACUUM");
		}catch(ex){
			Components.utils.reportError(ex);
		}
	}

};