//
//  DatabaseManager-Notifications.m
//  BathyScaphe
//
//  Created by Hori,Masaki on 07/06/26.
//  Copyright 2007-2009 BathyScaphe Project. All rights reserved.
//  encoding="UTF-8"
//

#import "DatabaseManager.h"

#import "ThreadTextDownloader.h"
#import "CMRDocumentFileManager.h"
#import "CMRTrashbox.h"
#import "CMRReplyMessenger.h"

NSString *const DatabaseDidFinishUpdateDownloadedOrDeletedThreadInfoNotification = @"DatabaseDidFinishUpdateDownloadedOrDeletedThreadInfoNotification";

NSString *const DatabaseWillUpdateThreadItemNotification = @"DatabaseWillUpdateThreadItemNotification";
NSString *const DatabaseWillDeleteThreadItemsNotification = @"DatabaseWillDeleteThreadItemsNotification";

@implementation DatabaseManager(Notifications)
-(void)registNotifications
{
	NSNotificationCenter *nc = [NSNotificationCenter defaultCenter];

	[nc addObserver:self
		   selector:@selector(finishWriteMesssage:)
			   name:CMRReplyMessengerDidFinishPostingNotification
			 object:nil];
}

#pragma mark ## Notification (Moved From BSDBThreadList) ##
- (void)makeThreadsListsUpdateCursor
{
	NSNotification *notification = [NSNotification notificationWithName:DatabaseDidFinishUpdateDownloadedOrDeletedThreadInfoNotification object:self];
	[[NSNotificationCenter defaultCenter] performSelectorOnMainThread:@selector(postNotification:) withObject:notification waitUntilDone:NO];
}

- (BOOL)searchBoardID:(int *)outBoardID threadID:(NSString **)outThreadID fromFilePath:(NSString *)inFilePath
{
	CMRDocumentFileManager *dfm = [CMRDocumentFileManager defaultManager];
	
	if (outThreadID) {
		*outThreadID = [dfm datIdentifierWithLogPath:inFilePath];
	}
	
	if (outBoardID) {
		NSString *boardName;
		NSArray *boardIDs;
		id boardID;
		
		boardName = [dfm boardNameWithLogPath:inFilePath];
		if (!boardName) return NO;
		
		boardIDs = [self boardIDsForName:boardName];
		if (!boardIDs || [boardIDs count] == 0) return NO;
		
		boardID = [boardIDs objectAtIndex:0];
		
		*outBoardID = [boardID intValue];
	}
	
	return YES;
}

- (void)threadTextDownloader:(ThreadTextDownloader *)downloader didUpdateWithContents:(NSDictionary *)userInfo
{
	CMRThreadSignature	*signature;
	
	UTILAssertKindOfClass(downloader, ThreadTextDownloader);
	UTILAssertNotNil(userInfo);
	UTILAssertKindOfClass(userInfo, NSDictionary);

	signature = [downloader threadSignature];
	UTILAssertNotNil(signature);

	do {
		SQLiteDB *db;
		NSMutableString *sql;
		NSArray *boardIDs;
		
		NSDate *modDate = [userInfo objectForKey:@"ttd_date"];
		if (!modDate) {
            if ([[NSUserDefaults standardUserDefaults] boolForKey:BSUserDebugEnabledKey]) {
                NSLog(@"** USER DEBUG ** Why? modDate is nil.");
            }
		} else {
            if ([[NSUserDefaults standardUserDefaults] boolForKey:BSUserDebugEnabledKey]) {
                NSLog(@"** USER DEBUG ** OK. modDate is %@.", modDate);
            }
		}
		unsigned int count = [[userInfo objectForKey:@"ttd_count"] unsignedIntValue];
		
		int boardID = 0;
		NSString *threadID;
		
		db = [self databaseForCurrentThread];
		if (!db) break;

		threadID = [signature identifier];
		
		boardIDs = [self boardIDsForName:[signature boardName]];
		if (!boardIDs || [boardIDs count] == 0) break;
		
		boardID = [[boardIDs objectAtIndex:0] intValue];


		sql = [NSMutableString stringWithFormat:@"UPDATE %@ ", ThreadInfoTableName];
		[sql appendFormat:@"SET %@ = %u, %@ = %u, %@ = %u, %@ = %.0lf ",
			NumberOfAllColumn, count,
			NumberOfReadColumn, count,
			ThreadStatusColumn, ThreadLogCachedStatus,
			ModifiedDateColumn, [modDate timeIntervalSince1970]];
		[sql appendFormat:@"WHERE %@ = %u AND %@ = %@",
			BoardIDColumn, boardID, ThreadIDColumn, threadID];
        if ([[NSUserDefaults standardUserDefaults] boolForKey:BSUserDebugEnabledKey]) {
            NSLog(@"** USER DEBUG ** SQL: %@", sql);
        }
		[db cursorForSQL:sql];
		
		if ([db lastErrorID] != 0) {
			NSLog(@"Fail to update. Reason: %@", [db lastError] );
		}

        NSNotification *notification = [NSNotification notificationWithName:DatabaseWillUpdateThreadItemNotification object:self];
        [[NSNotificationCenter defaultCenter] performSelectorOnMainThread:@selector(postNotification:) withObject:notification waitUntilDone:YES];

		[self makeThreadsListsUpdateCursor];
	} while (NO);
}

- (void)cleanUpItemsWhichHasBeenRemoved:(NSArray *)files
{
	SQLiteDB *db = [self databaseForCurrentThread];
	NSString *query;
	
	NSEnumerator *filesEnum;
	NSString *path;
	
	if ([db beginTransaction]) {
		filesEnum = [files objectEnumerator];
		while (path = [filesEnum nextObject]) {
			int boardID = 0;
			NSString *threadID;
			
			if ([self searchBoardID:&boardID threadID:&threadID fromFilePath:path]) {
				query = [NSString stringWithFormat:
						 @"UPDATE %@\n"
						 @"SET %@ = NULL,\n"
						 @"%@ = NULL,\n"
						 @"%@ = %d,\n"
						 @"%@ = NULL,\n"
						 @"%@ = NULL,\n"
						 @"%@ = 0,\n"
						 @"%@ = 0\n"
						 @"WHERE %@ = %d\n"
						 @"AND %@ = %@",
						 ThreadInfoTableName,
						 NumberOfReadColumn,
						 ModifiedDateColumn,
						 ThreadStatusColumn, ThreadNoCacheStatus,
						 ThreadAboneTypeColumn,
						 ThreadLabelColumn,
						 IsDatOchiColumn,
						 IsFavoriteColumn,
						 BoardIDColumn, boardID,
						 ThreadIDColumn, threadID];
				
				[db performQuery:query];
				if([db lastErrorID] != 0) goto abort;
				
				query = [NSMutableString stringWithFormat:
						 @"DELETE FROM %@"
						 @" WHERE %@ = %u"
						 @" AND %@ = %@",
						 FavoritesTableName,
						 BoardIDColumn, boardID,
						 ThreadIDColumn, threadID];
				[db performQuery : query];
				if([db lastErrorID] != 0) goto abort;
			}
			
		}
		[db commitTransaction];
	}
	
    NSNotification *notification = [NSNotification notificationWithName:DatabaseWillDeleteThreadItemsNotification object:self];
    [[NSNotificationCenter defaultCenter] performSelectorOnMainThread:@selector(postNotification:) withObject:notification waitUntilDone:YES];

	[self makeThreadsListsUpdateCursor];
	
	return;
	
abort:
	NSLog(@"FAIL delete threadInfo. Reson : %@", [db lastError]);
	[db rollbackTransaction];
}

- (void)finishWriteMesssage:(NSNotification *)aNotification
{
	id obj = [aNotification object];
	UTILAssertKindOfClass(obj, [CMRReplyMessenger class]);
	
	id boardName = [obj boardName];
	id threadID = [obj datIdentifier];
	id writeDate = [obj modifiedDate];
	
	id boardIDs = [self boardIDsForName:boardName];
	// TODO 二つ以上あった場合
	int boardID = [[boardIDs objectAtIndex:0] intValue];
	
	[self setLastWriteDate:writeDate atBoardID:boardID threadIdentifier:threadID];
}

- (void)doVacuum
{
	UTILDebugWrite(@"START VACUUM");
	[[self databaseForCurrentThread] performQuery:@"VACUUM"];
	UTILDebugWrite(@"END VACUUM");
}
@end
