//
//  SmartBoardListItem.m
//  BathyScaphe
//
//  Created by Hori,Masaki on 05/07/17.
//  Copyright 2005-2011 BathyScaphe Project. All rights reserved.
//

#import "SmartBoardListItem.h"

#import "SmartCondition.h"
#import "SmartConditionTranslator.h"

#import "BSCoreDataManager.h"

#import <SGAppKit/NSImage-SGExtensions.h>


@interface NSPredicate(OptimizeCustomSelector)
- (NSPredicate *)expandCunstomSelector;
@end

@interface SmartBoardListItem(Private)
- (void)setCondition:(id)condition;
@end

@implementation SmartBoardListItem
- (id) initWithName : (NSString *) inName condition : (id) condition
{
	if (self = [super init]) {
		if(!inName || !condition) {
			[self release];
			return nil;
		}
		[self setName : inName];
		[self setCondition:condition];
	}
	
	return self;
}
- (void)dealloc
{
	[mConditions release];
	[super dealloc];
}

- (BOOL)isEqual:(id) other
{
	if(self == other) return YES;
	
	if([self class] != [other class]) return NO;
	if(![[self name] isEqualToString:[other name]]) return NO;
	if(![[self condition] isEqual:[(SmartBoardListItem *)other condition]]) return NO;
	
	return YES;
}
- (NSImage *) icon
{
	return [NSImage imageAppNamed:[self iconBaseName]];
}

- (NSString *)iconBaseName
{
    return @"SmartBoardItem";
}

- (NSArray *)items
{
	BSCoreDataManager *coreDataManager = [BSCoreDataManager defaultManager];
	[coreDataManager refresh];
	NSArray *array = [coreDataManager fetchDataForEntityName:BSCoreDataModelThreadInformationName
												   predicate:[[self condition] expandCunstomSelector]];
	
	return array;
}
- (id) condition
{
	return mConditions;
}
- (NSComparisonPredicate *)replacePredicate:(NSComparisonPredicate *)predicate keypath:(NSString *)keypath toKeyPath:(NSString *)newKeyPath
{
	NSExpression *rhs = [predicate rightExpression];
	NSComparisonPredicate *fixedCondition = nil;
	NSExpression *newLeft = [NSExpression expressionForKeyPath:newKeyPath];
	switch([predicate predicateOperatorType]) {
		case NSCustomSelectorPredicateOperatorType:
		{
			fixedCondition = [[NSComparisonPredicate alloc] initWithLeftExpression:newLeft
																   rightExpression:rhs
																	customSelector:[predicate customSelector]];
			predicate = [fixedCondition autorelease];
			break;
		}
		default:
{
			fixedCondition = [[NSComparisonPredicate alloc] initWithLeftExpression:newLeft
																   rightExpression:rhs
																		  modifier:[predicate comparisonPredicateModifier]
																			  type:[predicate predicateOperatorType]
																		   options:[predicate options]];
			predicate = [fixedCondition autorelease];
			break;
		}
	}
	
	return predicate;
}
- (NSComparisonPredicate *)fixedCondition:(NSComparisonPredicate *)condition
{
	NSExpression *lhs = [condition leftExpression];
	if([lhs expressionType] != NSKeyPathExpressionType) return condition;
	
	NSString *keypath = [lhs keyPath];
	if([keypath isEqualToString:@"LastWrittenDate"]) {
		condition = [self replacePredicate:condition keypath:keypath toKeyPath:@"lastWrittenDate"];
	}
	if([keypath isEqualToString:@"threadID"]) {	
		condition = [self replacePredicate:condition keypath:keypath toKeyPath:@"creationDate"];
	}
	if([keypath isEqualToString:@"boardName"]) {	
		condition = [self replacePredicate:condition keypath:keypath toKeyPath:@"board.boardName"];
}

	return condition;
}
- (void) setCondition:(id)condition
{
	if(![condition isKindOfClass:[NSPredicate class]]) {
		condition = [SmartConditionTranslator predicateFromSmartCondition:condition];
	}
	
	if([condition isKindOfClass:[NSComparisonPredicate class]]) {
		condition = [self fixedCondition:condition];
	}

	if([condition isKindOfClass:[NSCompoundPredicate class]]) {
		NSMutableArray *array = [NSMutableArray array];
		for(NSComparisonPredicate *sub in [condition subpredicates]) {
			NSComparisonPredicate *new = [self fixedCondition:sub];
			[array addObject:new];
		}
		condition = [[NSCompoundPredicate alloc] initWithType:[condition compoundPredicateType]
												subpredicates:array];
		[condition autorelease];
	}
	
	id tmp = mConditions;
	mConditions = [condition retain];
	[tmp release];
	
	[self postUpdateThreadsNotification];
}

#pragma mark## CMRPropertyListCoding protocol ##
static NSString *SmartConditionNameKey = @"Name";
static NSString *SmartConditionConditionKey = @"SmartConditionConditionKey";
static NSString *SmartConditionPredicateKey = @"Predicate";

- (id) propertyListRepresentation
{
	return [NSDictionary dictionaryWithObjectsAndKeys:
		[self name], SmartConditionNameKey,
		[NSKeyedArchiver archivedDataWithRootObject:mConditions], SmartConditionPredicateKey,
		nil];
}
- (id) initWithPropertyListRepresentation : (id) rep
{
	id v;
	id name, cond = nil;
	
	name = [rep objectForKey:SmartConditionNameKey];
	
	v = [rep objectForKey:SmartConditionPredicateKey];
	if(v) {
		cond = [NSKeyedUnarchiver unarchiveObjectWithData:v];
	} else {
		v = [rep objectForKey:SmartConditionConditionKey];
		cond = [NSKeyedUnarchiver unarchiveObjectWithData:v];
	}	
	return [self initWithName:name condition:cond];
}

- (id)plist
{
	return [self propertyListRepresentation];
}
- (id) description
{
	return [[self plist] description];
}

- (BOOL) isHistoryEqual : (id) anObject
{
	if (![super isHistoryEqual : anObject]) return NO;

	if([self class] != [anObject class]) return NO;
	if(![[self name] isEqualToString:[anObject name]]) return NO;
	if(![[self condition] isEqual:[(SmartBoardListItem *)anObject condition]]) return NO;
	
	return YES;
}
@end

@implementation NSCompoundPredicate(OptimizeCustomSelector)
// CoreDataで使えるようにFunctionを展開する
- (NSPredicate *)expandCunstomSelector
{
	NSCompoundPredicate *result = nil;
	
	NSMutableArray *array = [NSMutableArray array];
	for(NSComparisonPredicate *sub in [self subpredicates]) {
		id new = [sub expandCunstomSelector];
		[array addObject:new];
	}
	result = [[NSCompoundPredicate alloc] initWithType:[self compoundPredicateType]
										 subpredicates:array];
	return [result autorelease];
}

@end

@implementation NSComparisonPredicate(OptimizeCustomSelector)
// CoreDataで使えるようにFunctionを展開する
- (NSPredicate *)expandCunstomSelector
{
	NSExpression *rhs = [self rightExpression];
	
	if(NSFunctionExpressionType != [rhs expressionType]) return self;
	
	NSString *function = [rhs function];
	NSArray *args = [rhs arguments];
	
	id obj;
	@try {
		obj = [[rhs operand] constantValue];
	}
	@catch (id ex) {
		return self;
	}
	
	SEL selector = NSSelectorFromString(function);
	NSMethodSignature *sig = [obj methodSignatureForSelector:selector];
	NSInvocation *inv = [NSInvocation invocationWithMethodSignature:sig];
	
	NSInteger i = 2;
	for(id arg in args) {
		if(i >= [sig numberOfArguments]) break;
		id realValue = [arg constantValue];
		[inv setArgument:&realValue atIndex:i++];
	}
	[inv setSelector:selector];
	[inv invokeWithTarget:obj];
	
	id value = nil;
	[inv getReturnValue:&value];
	
	NSExpression *newRight = nil;
	if([value isKindOfClass:[NSArray class]]) {
		NSMutableArray *expressionArray = [NSMutableArray array];
		for(id noarmalValue in value) {
			[expressionArray addObject:[NSExpression expressionForConstantValue:noarmalValue]];
		}
		newRight = [NSExpression expressionForAggregate:expressionArray];
	} else {
		newRight = [NSExpression expressionForConstantValue:value];
	}
	
	id result = [[NSComparisonPredicate alloc]
				 initWithLeftExpression:[self leftExpression]
				 rightExpression:newRight
				 modifier:[self comparisonPredicateModifier]
				 type:[self predicateOperatorType]
				 options:[self options]];
	return [result autorelease];
}

@end


@implementation NSDate(TEST)
- (long long)longLongValue
{
	return [self timeIntervalSince1970];
}
@end
