//
//  BSLPSPreviewerItems.m
//  PreviewerSelector
//
//  Created by Hori,Masaki on 10/09/12.
//  Copyright 2010 masakih. All rights reserved.
//

#import "BSLPSPreviewerItems.h"
#import "BSLPSPreviewerItem.h"

#import "BSLinkPreviewSelector.h"


#define BSLINKPREVIEWSELECTOR_UNLOAD_SUPPORT 0

static NSString *builtInPreviewerName = @"BuiltIn";
static NSString *noarmalImagePreviewerName = @"ImagePreviewer";

@interface NSObject(CMRTrashbox_Dummy)
+ (id)trash;
- (BOOL)performWithFiles:(NSArray *)filenames;
@end
#define CMRTrashbox NSClassFromString(@"CMRTrashbox")


#if BSLINKPREVIEWSELECTOR_UNLOAD_SUPPORT
@interface NSObject (BSLinkPreviewing_NewMethods)
- (BOOL)canUnload;
- (void)willUnload;
@end
#endif

@interface BSLPSPreviewerItems ()
- (void)loadPlugIns;
- (void)awakePreviewers;
@end

@implementation BSLPSPreviewerItems

- (id)init
{
	[super init];
	_previewerItems = [[NSMutableArray alloc] init];
	
	return self;
}

- (NSArray *)previewerItems
{
	return _previewerItems;
}

- (void)addItem:(BSLPSPreviewerItem *)item
{
	@synchronized(_previewerItems) {
		if([_previewerItems containsObject:item]) return;
		
		[self willChangeValueForKey:@"previewerItems"];
		[_previewerItems addObject:item];
		[self didChangeValueForKey:@"previewerItems"];
	}
}
- (void)addItemFromBundle:(NSBundle *)plugin
{
	
}
- (void)addItemFromURL:(NSURL *)fileURL
{
	NSString *plugInDirectory = [[BSLinkPreviewSelector sharedInstance] plugInsDirectory];
	NSURL *plugInDirectoryURL = [NSURL fileURLWithPath:plugInDirectory];
	NSFileManager *fm = [NSFileManager defaultManager];
	
	NSBundle *plugInBundle = [NSBundle bundleWithURL:fileURL];
	if(!plugInBundle) {
		NSLog(@"could not create bundle for %@", fileURL);
		return;
	}
	
	NSString *plugInName = [plugInBundle objectForInfoDictionaryKey:@"BSPreviewerDisplayName"];
	if([plugInBundle isLoaded]) {
		NSLog(@"################ PlugIn has loaded!! #############");
	}
	if(!plugInName) {
		NSLog(@"bundle dose not have BSPreviewerDisplayName.");
		return;
	}
	
	NSString *principalClassName = [plugInBundle objectForInfoDictionaryKey:@"NSPrincipalClass"];
	if([plugInBundle isLoaded]) {
		NSLog(@"################ PlugIn has loaded!! #############");
	}
	if(!principalClassName) {
		NSLog(@"bundle dose not have principal class name.");
		return;
	}
	Class principalClass = NSClassFromString(principalClassName);
	if(principalClass) {
		NSLog(@"Principal class has already loaded.");
		return;
	}
	
	NSError *error = nil;
	NSURL *newURL = [plugInDirectoryURL URLByAppendingPathComponent:[fileURL lastPathComponent]];
	BOOL isOK = [fm copyItemAtURL:fileURL
							toURL:newURL
							error:&error];
	if(!isOK) {
		NSLog(@"plugin could not copy to plug-in Directory");
		[NSApp presentError:error];
		return;
	}
	
	// loading plug-in
	principalClass = [plugInBundle principalClass];
	if(!principalClass) {
		NSLog(@"could not load principal class.");
		return;
	}
	if(![principalClass conformsToProtocol:@protocol(BSImagePreviewerProtocol)]
	   && ![principalClass conformsToProtocol:@protocol(BSLinkPreviewing)]) {
		NSLog(@"Principal class do not comform to require protocol.");
		return;
	}
	id plugin = [[[principalClass alloc] initWithPreferences:[[BSLinkPreviewSelector sharedInstance] preferences]] autorelease];
	if(!plugin) {
		NSLog(@"Principal class can not allocate or initialize.");
		return;
	}
	
	BSLPSPreviewerItem *item = [[[BSLPSPreviewerItem alloc] initWithIdentifier:[plugInBundle bundleIdentifier]] autorelease];
	item.tryCheck = YES;
	item.displayInMenu = YES;
	item.previewer = plugin;
	item.displayName = plugInName;
	item.path = [plugInBundle bundlePath];
	
	id v = [plugInBundle objectForInfoDictionaryKey:@"CFBundleShortVersionString"];
	item.version = v ?: @"";
	
	@synchronized(_previewerItems) {
		if(![_previewerItems containsObject:item]) {
			[self willChangeValueForKey:@"previewerItems"];
			[_previewerItems addObject:item];
			[self didChangeValueForKey:@"previewerItems"];
		}
	}
	
	if([plugin respondsToSelector:@selector(awakeByPreviewerSelector:)]) {
		[plugin performSelector:@selector(awakeByPreviewerSelector:)
					 withObject:[BSLinkPreviewSelector sharedInstance]];
	}
	
	NSLog(@"bundle %@ loaded.", plugInName);
}
- (void)removeItem:(BSLPSPreviewerItem *)item
{
#if BSLINKPREVIEWSELECTOR_UNLOAD_SUPPORT
	[item retain];
#endif
	NSString *path = item.path;
	@synchronized(_previewerItems) {
		[self willChangeValueForKey:@"previewerItems"];
		[_previewerItems removeObject:item];
		[self didChangeValueForKey:@"previewerItems"];
	}
	[[CMRTrashbox trash] performWithFiles:[NSArray arrayWithObject:path]];
	
#if BSLINKPREVIEWSELECTOR_UNLOAD_SUPPORT
	id previewer = item.previewer;
	if(![previewer respondsToSelector:@selector(canUnload)]) {
		[item release];
		return;
	}
	if(![previewer canUnload]) {
		[item release];
		return;
	}
	if([previewer respondsToSelector:@selector(willUnload)]) {
		[previewer willUnload];
	}
	NSBundle *plugInBundle = [NSBundle bundleWithIdentifier:item.identifier];
	[item release];
	[plugInBundle unload];
#endif
}
- (void)moveItem:(BSLPSPreviewerItem *)item toIndex:(NSUInteger)index
{
	@synchronized(_previewerItems) {
		NSUInteger fromIndex = [_previewerItems indexOfObject:item];
		
		[self willChangeValueForKey:@"previewerItems"];
		[_previewerItems insertObject:item atIndex:index];
		if(fromIndex > index) fromIndex++;
		[_previewerItems removeObjectAtIndex:fromIndex];
		[self didChangeValueForKey:@"previewerItems"];
	}
}


- (void)setPreference:(id)pref
{
	[self loadPlugIns];
	[self awakePreviewers];
	
	NSMutableArray *newItems = [NSMutableArray array];
	NSArray *retoredItems = nil;
	
	NSData *itemsData = [[[[BSLinkPreviewSelector sharedInstance] preferences] imagePreviewerPrefsDict] objectForKey:keyPrefPlugInsInfo];
	if(!itemsData) {
		return;
	} else {
		retoredItems = [NSKeyedUnarchiver unarchiveObjectWithData:itemsData];
	}
	
	// リストアされ且つロード済のプラグインを追加
	for(BSLPSPreviewerItem *item in retoredItems) {
		if([_previewerItems containsObject:item]) {
			[newItems addObject:item];
		}
	}
	
	// リストアされていないがロード済のプラグインを追加
	for(BSLPSPreviewerItem *item in _previewerItems) {
		if(![newItems containsObject:item]) {
			[newItems addObject:item];
		} else {
			NSInteger index = [newItems indexOfObject:item];
			BSLPSPreviewerItem *restoredItem = [newItems objectAtIndex:index];
			if(![restoredItem.version isEqualToString:item.version]) {
				[newItems replaceObjectAtIndex:index withObject:item];
			}
		}
	}
	
	[_previewerItems autorelease];
	_previewerItems = [newItems retain];
}

- (void)awakePreviewers
{
	for(BSLPSPreviewerItem *item in _previewerItems) {
		id previewer = [item previewer];
		if([previewer respondsToSelector:@selector(awakeByPreviewerSelector:)]) {
			[previewer performSelector:@selector(awakeByPreviewerSelector:)
							withObject:[BSLinkPreviewSelector sharedInstance]];
		}
	}
}

- (void)registPlugIn:(NSBundle *)pluginBundle name:(NSString *)name path:(NSString *)fullpath
{
	Class pluginClass;
	id plugin;
	BSLPSPreviewerItem *item;
	
	if([pluginBundle isLoaded]) return;
	
	pluginClass = [pluginBundle principalClass];
	if(!pluginClass) return;
	if(![pluginClass conformsToProtocol:@protocol(BSImagePreviewerProtocol)]
	   && ![pluginClass conformsToProtocol:@protocol(BSLinkPreviewing)]) return;
	plugin = [[[pluginClass alloc] initWithPreferences:[[BSLinkPreviewSelector sharedInstance] preferences]] autorelease];
	if(!plugin) return;
	
	item = [[[BSLPSPreviewerItem alloc] initWithIdentifier:[pluginBundle bundleIdentifier]] autorelease];
	item.tryCheck = YES;
	item.displayInMenu = YES;
	item.previewer = plugin;
	item.path = fullpath;
	
	id v = [pluginBundle objectForInfoDictionaryKey:@"CFBundleShortVersionString"];
	item.version = v ?: @"";
	
	v = [pluginBundle objectForInfoDictionaryKey:@"BSPreviewerDisplayName"];
	item.displayName = v ?: name;
	
	if(![_previewerItems containsObject:item]) {
		[_previewerItems addObject:item];
	}
}

BOOL isPreviewerselector(NSBundle *pluginBundle)
{
	NSString *bundleIdentifier = [pluginBundle bundleIdentifier];
	return [bundleIdentifier isEqualToString:@"com.masakih.previewerSelector"];
}
void removePreviewerSelector(NSString *previewerSelectorPath)
{
	NSAlert *alert = [NSAlert alertWithMessageText:PSLocalizedString(@"Remove PreviewerSelector plugin", @"")
									 defaultButton:@"OK"
								   alternateButton:nil
									   otherButton:nil
						 informativeTextWithFormat:PSLocalizedString(@"Remove previewerSelector information", @"")];
	[alert runModal];
	
//	[[CMRTrashbox trash] performWithFiles:[NSArray arrayWithObject:previewerSelectorPath]];
	NSLog(@"Remove PreviewerSelector");
}
- (void)loadDefaultPreviewer
{
	NSBundle *b = [NSBundle mainBundle];
	id pluginDirPath = [b builtInPlugInsPath];
	NSFileManager *dfm = [NSFileManager defaultManager];
	NSArray *files = [dfm contentsOfDirectoryAtPath:pluginDirPath error:NULL];
	
	for(NSString *file in files) {
		NSString *fullpath = [pluginDirPath stringByAppendingPathComponent:file];
		NSBundle *pluginBundle;
		
		pluginBundle = [NSBundle bundleWithPath:fullpath];
		if(!pluginBundle) return;
		
		if(isPreviewerselector(pluginBundle)) {
//			removePreviewerSelector(fullpath);
			continue;
		}
		
		[self registPlugIn:pluginBundle name:builtInPreviewerName path:fullpath];
	}
}

- (void)loadPlugIns
{
	NSString *path = [[BSLinkPreviewSelector sharedInstance] plugInsDirectory];
	NSFileManager *dfm = [NSFileManager defaultManager];
	NSArray *files = [dfm contentsOfDirectoryAtPath:path error:NULL];
	
	[self loadDefaultPreviewer];
	
	for(NSString *file in files) {
		NSString *fullpath = [path stringByAppendingPathComponent:file];
		NSString *name = [file stringByDeletingPathExtension];
		NSBundle *pluginBundle;
				
		pluginBundle = [NSBundle bundleWithPath:fullpath];
		if(!pluginBundle) continue;
		
		if(isPreviewerselector(pluginBundle)) {
			removePreviewerSelector(fullpath);
			continue;
		}
		
		[self registPlugIn:pluginBundle name:name path:fullpath];
	}
}

@end
