//
//  NSEvent-SGExtensions.m
//  SGAppKit
//
//  Created by Tsutomu Sawada on 07/01/21.
//  Copyright 2007-2009 BathyScaphe Project. All rights reserved.
//  encoding="UTF-8"
//

#import "NSEvent-SGExtensions.h"
#import <SGFoundation/SGTemplatesManager.h>
#import <Carbon/Carbon.h>

#if MAC_OS_X_VERSION_MIN_REQUIRED <= MAC_OS_X_VERSION_10_5
@interface NSEvent(SnowLeopardAPIStub)
+ (NSTimeInterval)doubleClickInterval;
@end
#endif

@implementation NSEvent(BSAdditions)
+ (NSUInteger)currentCarbonModifierFlags
{
    NSUInteger    cocoaModFlag = 0;
    UInt32 carbonModFlag = GetCurrentEventKeyModifiers();
    if (carbonModFlag & cmdKey)     cocoaModFlag |= NSCommandKeyMask;
    if (carbonModFlag & optionKey)  cocoaModFlag |= NSAlternateKeyMask;
    if (carbonModFlag & shiftKey)   cocoaModFlag |= NSShiftKeyMask;
    if (carbonModFlag & controlKey) cocoaModFlag |= NSControlKeyMask;
    return cocoaModFlag;
}

+ (NSTimeInterval)bs_doubleClickInterval
{
    static double cachedInterval = 0.0;
    static double cachedKVT = -2.0;
    if (cachedKVT == -2.0) {
        id obj2 = SGTemplateResource(kDoubleClickThresholdKey);
        if (obj2) {
            cachedKVT = [obj2 doubleValue];
        }
    }

    if (cachedKVT == -1.0) { // Use System Value
        if ([self respondsToSelector:@selector(doubleClickInterval)]) {
            return [self doubleClickInterval];
        } else {
            if (cachedInterval == 0.0) {
                NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
                id obj = [defaults objectForKey:@"com.apple.mouse.doubleClickThreshold"];
                if (obj) {
                    cachedInterval = [obj doubleValue];
                }
                if (cachedInterval <= 0.0) {
                    cachedInterval = 1.0;
                }
            }
            return cachedInterval;
        }
    } else if (cachedKVT >= 0) { // Use KeyValueTemplates.plist's value.
        return cachedKVT;
    }

    return 1.0;
}
@end
