//
//  BSBoardListItemHEADCheckTask.m
//  BathyScaphe
//
//  Created by Hori,Masaki on 06/08/13.
//  Copyright 2006-2010 BathyScaphe Project. All rights reserved.
//  encoding="UTF-8"
//

#import "BSBoardListItemHEADCheckTask.h"

#import "BSCoreDataManager.h"
#import "BSThreadInformationObject.h"
#import "BSBoardInformationObject.h"

#import "BoardManager.h"
#import "CMRHostHandler.h"
#import "BSDownloadTask.h"
#import "AppDefaults.h"
#import "CMRFavoritesManager.h"
#import "BSHTMLHEADChecker.h"

static NSString *const BSFavHEADerLMKey	= @"Last-Modified";

static NSURL *datURLForBoardIDStringAndThreadID(NSNumber *boardID, NSString *threadID);
static BOOL shouldCheckItemHeader(BSThreadInformationObject *thread);

@interface BSBoardListItemHEADCheckTask(Private)
- (BSDownloadTask *)sendHEADMethod:(NSURL *)url;
@end

@implementation BSBoardListItemHEADCheckTask
+ (id)taskWithThreadList:(BSDBThreadList *)list
{
	return [[[self alloc] initWithThreadList:list] autorelease];
}

- (id)initWithThreadList:(BSDBThreadList *)list
{
	if (self = [super init]) {
		targetList = list; //[list retain];
		item = [[list boardListItem] retain];
	}
	
	return self;
}

- (void)dealloc
{
//	[targetList release];
	[item release];
	[amountString release];
	[descString release];
	
	[super dealloc];
}

#pragma mark -
- (id)identifier
{
	return [NSString stringWithFormat:@"%@-%p", self, self];
}

- (NSString *)title
{
	NSString *format = NSLocalizedStringFromTable(@"Checking SmartBoard(%@).", @"ThreadsList", @"");
	return [NSString stringWithFormat:format, [item name]];
}

- (void)setAmountString:(NSString *)str
{
	id temp = amountString;
	@synchronized(self) {
		[self willChangeValueForKey:@"message"];
		amountString = [str retain];
		[self didChangeValueForKey:@"message"];
	}
	[temp release];
}

- (NSString *)amountString
{
	id result;
	@synchronized(self) {
		result = [[amountString retain] autorelease];
	}
	return result;
}

- (void)setDescString:(NSString *)str
{
	id temp = descString;
	@synchronized(self) {
		[self willChangeValueForKey:@"message"];
		descString = [str retain];
		[self didChangeValueForKey:@"message"];
	}
	[temp release];
}

- (NSString *)descString
{
	id result;
	@synchronized(self) {
		result = [[descString retain] autorelease];
	}
	return result;
}

- (NSString *)message
{
	NSString *descStr = [self descString];
	NSString *amountStr = [self amountString];
	
	if (descStr && amountStr) {
		return [NSString stringWithFormat:@"%@ (%@)", descStr, amountStr];
	} else if (descStr) {
		return descStr;
	}
	return NSLocalizedStringFromTable(@"ProgressBoardListItemHEADCheck.", @"ThreadsList", @"");
}

- (void)playFinishSoundIsUpdate:(BOOL)isUpDate
{
	NSSound *finishedSound_ = nil;
	NSString *soundName_ = [CMRPref HEADCheckNewArrivedSound];

	if (isUpDate && ![soundName_ isEqualToString:@""]) {
		finishedSound_ = [NSSound soundNamed:soundName_];
	} else {
		soundName_ = [CMRPref HEADCheckNoUpdateSound];
		if (![soundName_ isEqualToString:@""]) {
			finishedSound_ = [NSSound soundNamed:soundName_];
        }
	}
	[finishedSound_ play];
}

- (void)doExecuteWithLayout:(CMRThreadLayout *)layout
{
	NSArray *threads = [item items];
	BOOL updated = NO;
		
	NSInteger numberOfAllTarget = [threads count];
	NSInteger numberOfFinishCheck = 0;
	NSInteger numberOfSkip = 0;
	NSString *amoutFormat = NSLocalizedStringFromTable(@"%ld/%ld (%ld skiped)", @"ThreadsList", @"");

	[self setAmountString:[NSString stringWithFormat:amoutFormat,
						   (long)numberOfFinishCheck, (long)numberOfAllTarget, (long)numberOfSkip]];
	[self setDescString:NSLocalizedStringFromTable(@"Checking thread", @"ThreadsList", @"")];
	
    for (BSThreadInformationObject *thread in threads) {
		id pool = [[NSAutoreleasePool alloc] init];
		
		id dl;
		id response;
		id newMod;
		
		[self checkIsInterrupted];
		[self setAmountString:[NSString stringWithFormat:amoutFormat,
							   ++numberOfFinishCheck, numberOfAllTarget, numberOfSkip]];
		
		if (!shouldCheckItemHeader(thread)) {
			[pool release];
			numberOfSkip++;
			continue;
		}
		
		NSString *threadID = thread.threadID;
		NSDate *modDate = thread.modifiedDate;
        NSNumber *boardID = thread.board.boardID;
		
		NSURL *datURL = datURLForBoardIDStringAndThreadID(boardID, threadID);
        if (!datURL) {
            NSRunLoop *loop = [NSRunLoop currentRunLoop];
            NSUInteger boardIDUI = [boardID unsignedIntegerValue];
            NSUInteger numberOfAll = [thread.numberOfAll unsignedIntegerValue];
            BSHTMLHEADChecker *checker = [[BSHTMLHEADChecker alloc] initWithBoardID:boardIDUI threadID:threadID count:numberOfAll];
            [checker startChecking];
            while ([checker isChecking]) {
                id pool2 = [[NSAutoreleasePool alloc] init];
                @try {
                    [loop runMode:NSDefaultRunLoopMode beforeDate:[NSDate dateWithTimeIntervalSinceNow:0.1]];
                }
                @catch(id ex) {
                    // do nothing.
                    @throw;
                }
                @finally {
                    [pool2 release];
                }
            }
            if (!(checker.lastError) && checker.isUpdated) {
				thread.threadStatus = [NSNumber numberWithUnsignedInteger:ThreadHeadModifiedStatus];
				updated = YES;
            }
            [checker release];
        }
		dl = [self sendHEADMethod:datURL];
		response = [dl response];
		
		if ([response statusCode] == 200) {
			newMod = [[response allHeaderFields] objectForKey:BSFavHEADerLMKey];
			NSDate *dateLastMod = [[BSHTTPDateFormatter sharedHTTPDateFormatter] dateFromString:newMod];
			if ([dateLastMod compare:modDate] == NSOrderedDescending) {
				thread.threadStatus = [NSNumber numberWithUnsignedInteger:ThreadHeadModifiedStatus];
				updated = YES;
			}
		}
		[pool release];
	}
		
	[self playFinishSoundIsUpdate:(updated)];
	if(updated) {
		[[BSCoreDataManager defaultManager] saveAction:nil];
	}
	
	if (numberOfAllTarget - numberOfSkip > 0) {
		[[CMRFavoritesManager defaultManager] decrementHEADCheckCount];
	}
	
	[targetList updateCursor];
	
}
// - (void) finalizeWhenInterrupted;


/*  同一の板に存在するスレッドが 50 以上あれば、 subject.txt での更新作業に切り替えるべきかな？？？ */


static BOOL shouldCheckItemHeader(BSThreadInformationObject *thread)
{
	id obj;
	NSInteger s;
	
	obj = thread.isDatOchi;
	if ([obj boolValue]) return NO;
	
	obj = thread.numberOfAll;
	if ([obj integerValue] > 1000) return NO;
	
	obj = thread.threadStatus;
	if (!obj) return NO;
	
	s = [obj integerValue];
	if ( !(s | ThreadLogCachedStatus)) return NO;
	
	obj = thread.modifiedDate;
	if (!obj) return NO;
	
	return YES;
}

static NSURL *datURLForBoardIDStringAndThreadID(NSNumber *boardID, NSString *threadID)
{
	NSURL *boardURL;
	CMRHostHandler *handler;
	
    boardURL = [NSURL URLWithString:[[BSCoreDataManager defaultManager] urlStringFromBoardID:boardID]];
	handler = [CMRHostHandler hostHandlerForURL:boardURL];
	
	return [handler datURLWithBoard:boardURL datName:[threadID stringByAppendingPathExtension:@"dat"]];
}

- (BSDownloadTask *)sendHEADMethod:(NSURL *)url
{
	BSDownloadTask *dlTask = [[BSDownloadTask alloc] initWithURL:url method:@"HEAD"];
	[dlTask doExecuteWithLayout:nil];
	
	return [dlTask autorelease];
}

@end


@implementation BSBoardListItemHEADCheckTask(Notification)
- (void)dlDidFinishDownloadNotification:(id)notification
{
	id obj = [[notification userInfo] objectForKey:BSDownloadTaskServerResponseKey];
	
	if ([obj isKindOfClass:[NSHTTPURLResponse class]]) {
        //
	}
}

- (void)dlDidAbortDownlocadNotification:(id)notification
{
	//
}

- (void)dlCancelDownloadNotification:(id)notification
{
	//
}
@end
