//
//  script.js
//  Bardiche
//
//  Created by 1024jp on 14/01/05.
//  Copyright 2014 BathyScaphe Project. All rights reserved.
//  encoding="UTF-8"
//

// ----------------------------------------------------------------------------
// settings
// ----------------------------------------------------------------------------

// デフォルトの画像幅
const DEFAULT_WIDTH = 250;

// デフォルトの表示サイズ  { 0:小 1:中 2:大 3:最大 }
const DEFAULT_SIZE_LEVEL = 1;

// 表示サイズの段階名
const SIZE_LABELS = ['小', '中', '大', '最大'];

// リンク先が画像でない時の動作  { 0:何もしない 1:飛ぶかどうか確認する 2:確認なしで飛ぶ }
var jump_confirm = 2;

//リンク先URLに CONDITION_KEYWORDS の要素が含まれていた場合に jump_confirm に代わる動作
const JUMP_CONFIRM_CONDITIONAL = 1;

const CONDITION_KEYWORDS = ['/img', '/upload'];

// ぼかしフィルターの強度 { 0:無効 }   (webkit系ブラウザでのみ有効)
const BLUR = 0;


// ----------------------------------------------------------------------------
// main
// ----------------------------------------------------------------------------

// get target image object
var img = document.images['image'];

// check whether the image URL contains specific keywords
var matches = false;
for (i=0; i<CONDITION_KEYWORDS.length; i++) {
	matches = matches || (img.src.indexOf(CONDITION_KEYWORDS[i]) >= 0);
}
if (matches) { jump_confirm = JUMP_CONFIRM_CONDITIONAL; }

// set filter
if (BLUR) {
	img.style.cssText = '-webkit-filter:blur(' + BLUR + 'px);';
}

// set page title
var paths = img.src.split('/');
var imgFileName = paths[paths.length - 1];
document.title = imgFileName + ' : ' + document.title;

// set size selector
var str = '';
for (i=0; i<SIZE_LABELS.length; i++) {
	var checked = (i == DEFAULT_SIZE_LEVEL) ? ' checked="checked"' : '';
	str += ' <label><input type="radio" name="size" value="' + i +
	       '" onclick="resize(this.value)"' + checked + '> ' + SIZE_LABELS[i] +
	       '</label>';
}
document.getElementById('sizeSelector').innerHTML += str;

// display original image size
img.onload = function() {
	var caption = document.getElementsByTagName('figcaption')[0];
	caption.innerHTML += '<br/>' +
	                     '(' + this.naturalWidth + '×' + this.naturalHeight + ')';
}

// apply default image size
resize(DEFAULT_SIZE_LEVEL);


// functions ------------------------------------------------------------------

function resize(sizeLevel) {
	if (sizeLevel == SIZE_LABELS.length - 1) {
		img.removeAttribute('width');
	} else {
		img.width = DEFAULT_WIDTH * Math.pow(2, sizeLevel - DEFAULT_SIZE_LEVEL);
	}
}

function onImgError() {
	if (jump_confirm == 1 &&
		!confirm('"' + img.src + '" は画像ファイルではないようです。ページに移動しますか?')
	) {
		jump_confirm = 0;
	}
	if (jump_confirm) { location.href = img.src; }
	img.title = 'リンク先のページを開く';
}
