#!/bin/bash -eE
                  #// Content-Type: text/plain; charset=utf-8
                  #// -eE オプションは、エラーが起きたら中断します
                  #// -x オプションは、１行ずつコマンドを表示します

g_AllArguments="$@"
g_FuncName=${1#--*}  #// cut -- from $1
g_MenuPath=""

function  Main_func()
{
  SearchParent_func  "menu" ; g_MenuPath="$g_Ret"
  local  AppKey="$2" ; AppKeyClass.newWritable_method  "$AppKey"  "$PWD"
  if [ "$g_FuncName" == "" ]; then
    echo  "関数一覧："
    echo  T_InputPath_func
    echo  T_InputCommand_func
    echo  T_InputOption_func
    echo  T_NewShFolder_func
    echo  T_NewMenuFolder_func
    echo  T_ColorText_func
    echo  T_Pause_func
    Error_func  "呼び出すスクリプト内の関数を指定してください。例 $BASH_SOURCE --T_Test1_func"
  fi
  $g_FuncName  "$@"
  ColorText_func  "Pass."  "Green" "Bold" ; echo_e_func  "$g_Ret"
}


 
#//*********************************************************************
#// <<< [T_InputPath_func] >>>
#//*********************************************************************
function  T_InputPath_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  local  path

 if true; then  #//(skip)

  #//=== Test Main : ChkFolderExists
  echo  "1. Enter のみを入力して、再入力されることを確認してください。"
  echo  "2. nofile と入力して、警告＆再入力されることを確認してください。"
  echo  "3. Test.sh と入力して、警告＆再入力されることを確認してください。"
  echo  "4. ~ と入力できることを確認してください。"
  InputPath_func  "フォルダーのパス >"  --ChkFolderExists ; path="$g_Ret"
  Assert_func  "$path" == "$HOME"
  echo  "Pass."

 else
   echo "Skipped" ; sleep 1
 fi  #//(skip)


  #//=== Test Main : ChkFileExists
  echo  "1. Enter のみを入力して、再入力されることを確認してください。"
  echo  "2. nofile と入力して、警告＆再入力されることを確認してください。"
  echo  "3. ans と入力して、警告＆再入力されることを確認してください。"
  echo  "4. Test.sh  と入力できることを確認してください。"
  InputPath_func  "ファイルのパス >"  --ChkFileExists ; path="$g_Ret"
  echo  "Pass."


  #//=== Test Main : ChkNotExists
  echo  "1. Test.sh と入力して、警告＆再入力されることを確認してください。"
  echo  "2. ~ と入力して、警告＆再入力されることを確認してください。"
  echo  "3. nofile と入力できることを確認してください。"
  InputPath_func  "何もないパス >"  --ChkNotExists ; path="$g_Ret"
  Assert_func  "$path" == "$g_StartInPath/nofile"
  echo  "Pass."


  #//=== Test Main : AllowEnterOnly
  echo  "Enter のみを入力できることを確認してください。"
  InputPath_func  "入力してください。>"   --AllowEnterOnly  --ChkFileExists ; path="$g_Ret"
  echo  "Pass."

  #//=== Test Main
  InputPath_func  '$HOME/a b.txt と入力してください。>' ; path="$g_Ret"
  Assert_func  '"$path" == "$HOME/a b.txt"'
  echo  "Pass."

  #//=== Test Main
  InputPath_func  '
1. _T_(タブ)(Enter)と入力して、_T_UI subを選んでください。
2. (タブ)(Enter) と入力して、T_UI Sub.sh を選んでください。
3. そのまま Enter を押してください。
>' ; path="$g_Ret"
  Assert_func  '"$path" == "$PWD/_T_UI sub/T_UI Sub.sh"'
  echo  "Pass."

  #//=== Test Main
  InputPath_func  '~/.b(タブ)(Enter) と入力して、.bash_history を選んで Enter を押してください。>'
  path="$g_Ret"
  Assert_func  '"$path" == "$HOME/.bash_history"'
  echo  "Pass."

  #//=== Test Main
  "_T_UI sub/T_UI Sub.sh"  --T_UI_StartInPath_func
  echo  "Pass."
}


 
#//*********************************************************************
#// <<< [T_InputCommand_func] >>>
#//*********************************************************************
if [ "${BASH_VERSINFO[0]}" -ge "4" ];then
  declare_AssociativeArrayClass="declare -A"
else
  declare_AssociativeArrayClass="declare"
fi

$declare_AssociativeArrayClass  g_InputCommandOpt

function  T_InputCommand_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  local  AppKey="$2"
  local  obj="g_InputCommandOpt"

  g_Arguments=( "$BASH_SOURCE" )

  #//=== Catch error
  SetAttr_func  $obj  Class  "InputCommandOpt"

  SetAttr_as_AssociativeArrayName_func  $obj  CommandReplace  \
    "1" "T_InputCommandError_func" \

  SetAttr_as_AssociativeArrayName_func  $obj  MenuCaption  \
    "1" "エラーが発生してもメニューに戻ること [T_InputCommandError_func]" \

  InputCommand_func  $obj  ""  "$1"  "$AppKey"
}


function  T_InputCommandError_func()
{
  Error_func
}


 
#//*********************************************************************
#// <<< [T_InputOption_func] >>>
#//*********************************************************************
function  T_InputOption_func()
{
  local  work="space"
  local  comment="nothing"

  ArrayClass.remove_method  g_Arguments  1

  echo  ""
  echo  "■ work に abc を設定して、設定を完了してください。"
  InputOption_func  work  comment  --comment=" ワーク, コメント"

  echo  "work=$work"
  Assert_func  '"$work" == "abc"'
  Assert_func  '"$comment" == "nothing"'


  ./T_UI_Manually.sh  --T_InputOption_Sub_func  --value="abc"  ?
}


function  T_InputOption_Sub_func()
{
  local  value="default"

  echo_line_func
  echo  "自動入力にエラーがあったときのテスト。オプション入力モードの中に留まること。"
  echo  "オプション入力モードの中では、すぐに設定終了してください。"
  Pause_func

  ArrayClass.remove_method  g_Arguments  1

  InputOption_func  value

  Assert_func  '"$value" == "abc"'
}


 
#//*********************************************************************
#// <<< [T_NewShFolder_func] >>>
#//*********************************************************************
function  T_NewShFolder_func()
{
  T_NewShFolderSub_func  NewSh  "$2"
}


function  T_NewShFolderSub_func()
{
  local  Command="$1"
  local  path

  echo  "新規に sample スクリプト（Pause_funcがあるスクリプト）を生成して実行します。"
  echo  "下記のフォルダーに _T_NewShFolder_func フォルダーを作成してその中でテストを実施します。"
  echo  "Enterのみ：\$HOME"
  InputPath_func  "scriptlib フォルダーが親に無いフォルダーのパス >"  --AllowEnterOnly
  path="$g_Ret"
  if [ "$path" == "" ];then  path="$HOME"  ;fi

  local  AppKey="$2" ; AppKeyClass.newWritable_method  "$AppKey"  "$path/_T_NewShFolder_func"
  if [ -e "$path/_T_NewShFolder_func" ];then  Error_func  "すでにフォルダーがあります" ;fi

  $g_MenuPath  $Command  "$path/_T_NewShFolder_func/b.sh"

  if [ ! -e "$path/_T_NewShFolder_func/scriptlib/bashlib.sh" ];then  Error_func  ;fi
  "$path/_T_NewShFolder_func/b.sh"
  rm_func  "$path/_T_NewShFolder_func"
}


 
#//*********************************************************************
#// <<< [T_NewMenuFolder_func] >>>
#//*********************************************************************
function  T_NewMenuFolder_func()
{
  T_NewShFolderSub_func  NewMenu  "$2"
}


 
#//*********************************************************************
#// <<< [T_ColorText_func] >>>
#//*********************************************************************
function  T_ColorText_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  ColorText_func  "Black"    "Black"   ; echo_e_func  "$g_Ret"
  ColorText_func  "Red"      "Red"     ; echo_e_func  "$g_Ret"
  ColorText_func  "Green"    "Green"   ; echo_e_func  "$g_Ret"
  ColorText_func  "Yellow"   "Yellow"  ; echo_e_func  "$g_Ret"
  ColorText_func  "Blue"     "Blue"    ; echo_e_func  "$g_Ret"
  ColorText_func  "Magenta"  "Magenta" ; echo_e_func  "$g_Ret"
  ColorText_func  "Cyan"     "Cyan"    ; echo_e_func  "$g_Ret"
  ColorText_func  "White"    "White"   ; echo_e_func  "$g_Ret"

  ColorText_func  "White & BlackBack"    "White"  "BlackBack"   ; echo_e_func  "$g_Ret"
  ColorText_func  "Black & RedBack"      "Black"  "RedBack"     ; echo_e_func  "$g_Ret"
  ColorText_func  "Black & GreenBack"    "Black"  "GreenBack"   ; echo_e_func  "$g_Ret"
  ColorText_func  "Black & YellowBack"   "Black"  "YellowBack"  ; echo_e_func  "$g_Ret"
  ColorText_func  "Black & BlueBack"     "Black"  "BlueBack"    ; echo_e_func  "$g_Ret"
  ColorText_func  "Black & MagentaBack"  "Black"  "MagentaBack" ; echo_e_func  "$g_Ret"
  ColorText_func  "Black & CyanBack"     "Black"  "CyanBack"    ; echo_e_func  "$g_Ret"
  ColorText_func  "Black & WhiteBack"    "Black"  "WhiteBack"   ; echo_e_func  "$g_Ret"

  ColorText_func  "Bold & Black"    "Bold"  "Black"   ; echo_e_func  "$g_Ret"
  ColorText_func  "Bold & Red"      "Bold"  "Red"     ; echo_e_func  "$g_Ret"
  ColorText_func  "Bold & Green"    "Bold"  "Green"   ; echo_e_func  "$g_Ret"
  ColorText_func  "Bold & Yellow"   "Bold"  "Yellow"  ; echo_e_func  "$g_Ret"
  ColorText_func  "Bold & Blue"     "Bold"  "Blue"    ; echo_e_func  "$g_Ret"
  ColorText_func  "Bold & Magenta"  "Bold"  "Magenta" ; echo_e_func  "$g_Ret"
  ColorText_func  "Bold & Cyan"     "Bold"  "Cyan"    ; echo_e_func  "$g_Ret"
  ColorText_func  "Bold & White"    "Bold"  "White"   ; echo_e_func  "$g_Ret"

  ColorText_func  "White & Bold & BlackBack"    "White"  "Bold"  "BlackBack"   ; echo_e_func  "$g_Ret"
  ColorText_func  "Black & Bold & RedBack"      "Black"  "Bold"  "RedBack"     ; echo_e_func  "$g_Ret"
  ColorText_func  "Black & Bold & GreenBack"    "Black"  "Bold"  "GreenBack"   ; echo_e_func  "$g_Ret"
  ColorText_func  "Black & Bold & YellowBack"   "Black"  "Bold"  "YellowBack"  ; echo_e_func  "$g_Ret"
  ColorText_func  "Black & Bold & BlueBack"     "Black"  "Bold"  "BlueBack"    ; echo_e_func  "$g_Ret"
  ColorText_func  "Black & Bold & MagentaBack"  "Black"  "Bold"  "MagentaBack" ; echo_e_func  "$g_Ret"
  ColorText_func  "Black & Bold & CyanBack"     "Black"  "Bold"  "CyanBack"    ; echo_e_func  "$g_Ret"
  ColorText_func  "Black & Bold & WhiteBack"    "Black"  "Bold"  "WhiteBack"   ; echo_e_func  "$g_Ret"
  Pause_func
}


 
#//*********************************************************************
#// <<< [T_Pause_func] >>>
#//*********************************************************************
function  T_Pause_func()
{
  echo  "タイムアウトが無い Pause_func"
  Pause_func

  echo  "タイムアウトが５秒の Pause_func。 タイムアウトまで待ってください"
  Pause_func  --time_out=5

  echo  "タイムアウトが５秒の Pause_func。 タイムアウトする前に Enter を押してください"
  Pause_func  --time_out=5
}


 
#//*********************************************************************
#// <<< [T_Debug_func] >>>
#//*********************************************************************
function  T_Debug_func()
{
  echo  "object_a[Attr1]=Value1"
  echo  "object_a[Attr2]=Value2"
  echo  "var[0]=a"
  echo  "var[1]=b"
  echo  "var=aa"
  echo  "以上を es します。"
  Pause_func

  declare -A  object_a
  SetAttr_func  object_a  "Attr1"  "Value1"
  SetAttr_func  object_a  "Attr2"  "Value2"

  es object_a

  var[0]="a"
  var[1]="b"
  es var

  unset var
  unset var


  var="aa"
  es var
}









#//--- start of bashlib include ------------------------------------------------------ 

#// <<< set up bashlib and call Main_func >>> 

#// bashlib is provided under 3-clause BSD license.
#// Copyright (C) 2011 Sofrware Design Gallery "Sage Plaisir 21" All Rights Reserved.

g_BashLibPath="scriptlib/bashlib_inc.sh"; g_Ver="1.0"
g_StartInPath=`pwd`; cd "`dirname "$BASH_SOURCE"`"; g_Arguments=( "$BASH_SOURCE" "$@" )
for (( i = 0; i < 20; i ++ ));do
  if [ -e "$g_BashLibPath" ];then break ;else  g_BashLibPath="../$g_BashLibPath" ;fi ;done
if [ "$i" == "20" ];then  echo "${g_BashLibPath##*../} が見つかりません。
bashlib $g_Ver をダウンロードして scriptlib フォルダーをコピーしてください。"; exit 1 ;fi
source  "$g_BashLibPath"  #// include
CallMain_func
#//--- end of bashlib include --------------------------------------------------------
 
