#!/bin/bash -eE
                  #// Content-Type: text/plain; charset=utf-8
                  #// -eE オプションは、エラーが起きたら中断します
                  #// -x オプションは、１行ずつコマンドを表示します

g_AllArguments="$@"
g_FuncName=${1#--*}  #// cut -- from $1

function  Main_func()
{
  local  AppKey="$2" ; AppKeyClass.newWritable_method  "$AppKey"  "$WORK"
  if [ "$g_FuncName" == "" ];then  Error_func  "関数名を指定してください。例：$BASH_SOURCE --FuncA_func"  ;fi
  $g_FuncName  "$@"
}


 
#//*********************************************************************
#// <<< [T_AssertSub_func] >>> 
#//*********************************************************************
function  T_AssertSub_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  local  var1="abc"

  #// Test Main : Pass to value of variables
  Assert_func  '"$var1" == "abc"'


  #// Test Main : Fail to value of variables
  while TryStart_func; do
    Assert_func  '"$var1" == "ABC"'
  TryEnd1_func; done ;TryEnd2_func $?
  echo  "$g_Err_Desc"
  ErrClass.clear_method


  #// Test Main : Pass to function echo return
  Assert_func  '$( ReturnIt_func "あいう" ) == "あいう"'


  #// Test Main : Fail to function echo return
  while TryStart_func; do
    Assert_func  '$( ReturnIt_func "あいう" ) == "アイウ"'
  TryEnd1_func; done ;TryEnd2_func $?
  echo  "$g_Err_Desc"
  ErrClass.clear_method


  #// Test Main : call count must be 1. Do not call 2 times
  Assert_func  '$( EchoTest_func "あいう" ) == "あいう"'

}


function  ReturnIt_func()
{
  local  ReturnValue="$1"
  echo  "$1"
}


function  EchoTest_func()
{
  echo  "call EchoTest_func"  >&2
  echo  "$1"
}


 
#//*********************************************************************
#// <<< [T_CheckPipeStatusSub_func] >>> 
#//*********************************************************************
function  T_CheckPipeStatusSub_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  echo  "1st"

  while TryStart_func; do
    false | true
    CheckPipeStatus_func  "${PIPESTATUS[@]}"
    echo  "<ERROR msg=\"Do not come here\"/>"
  TryEnd1_func; done ;TryEnd2_func $?
  ErrClass.clear_method
  echo  "This error is OK"


  echo  "2nd"

  false | true
  CheckPipeStatus_func  "${PIPESTATUS[@]}"
  echo  "<ERROR msg=\"Do not come here\"/>"
}


 
#//*********************************************************************
#// <<< [T_CheckPipeStatusSub2_func] >>> 
#//*********************************************************************
function  T_CheckPipeStatusSub2_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  #//===
  echo  "case EchoOn. : DEBUG trap を処理した後で、CheckPipeStatus_func するケース"
  #// ? ? :  false | true
  #// 1 0 :  (DEBUG)  PipeStatusOnDebug_func (catch) ; echo "$LINENO: $BASH_COMMAND" ; false | true
  #// 0   :  CheckPipeStatus_func (error)

  EchoOn_func

  while TryStart_func; do
    false | true
    CheckPipeStatus_func  "${PIPESTATUS[@]}"
    echo  "<ERROR msg=\"Do not come here\"/>"
  TryEnd1_func; done ;TryEnd2_func $?
  ErrClass.clear_method
  echo  "This error is OK"


  #//===
  echo  "case EchoOff."

  EchoOff_func

  while TryStart_func; do
    false | false | true
    CheckPipeStatus_func  "${PIPESTATUS[@]}"
    echo  "<ERROR msg=\"Do not come here\"/>"
  TryEnd1_func; done ;TryEnd2_func $?
  ErrClass.clear_method
  echo  "This error is OK"


  #//===
  echo  "case DEBUG trap の中の関数の、trap しないところで、CheckPipeStatus_func するケース"

  #// ? ? :  (DEBUG) PipeStatusOnDebug_func
  #// ? ? :  if false; then
  #// 1   :  fi
  #// 1   :  (DEBUG) PipeStatusOnDebug_func (catch)
  #// 1   :  FuncA_func
  #// 1   :    true | true
  #// 0 0 :    CheckPipeStatus_func (error)

  if false; then
     echo  "dummy"
  fi  #// $? = 1
  T_CheckPipeStatusSubInFunc_func
  echo  "after T_CheckPipeStatusSubInFunc_func"
}


function  T_CheckPipeStatusSubInFunc_func()
{
  true | true
  CheckPipeStatus_func
  echo  "last of T_CheckPipeStatusSubInFunc_func"
}


 
#//*********************************************************************
#// <<< [T_CheckMaxArgCountSub_func] >>> 
#//*********************************************************************
function  T_CheckMaxArgCountSub_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  T_CheckMaxArgCountSubSub_func  1

  while TryStart_func; do
    T_CheckMaxArgCountSubSub_func  1  "B"
  TryEnd1_func; done ;TryEnd2_func $?
  #// echo  "$g_Err_Desc"  #// no message is ok
  ErrClass.clear_method
  echo  "This error is OK"

  T_CheckMaxArgCountSubSub_func  2  "B"
}


function  T_CheckMaxArgCountSubSub_func()
{
  CheckMaxArgCount_func  "$1"  "$@"
}


 
#//*********************************************************************
#// <<< [T_TryLv0Sub_func] >>> 
#//*********************************************************************
function  T_TryLv0Sub_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  Try_Raise_func
  echo  "<ERROR msg=\"Do not come here\"/>"
}


 
#//*********************************************************************
#// <<< [T_TryLv1Sub_func] >>> 
#//*********************************************************************
function  T_TryLv1Sub_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  while TryStart_func; do
    Try_Raise_func
    echo  "<ERROR msg=\"Do not come here\"/>"
  TryEnd1_func; done ;TryEnd2_func $?
  echo  "exit status = $g_ExitStatus"
  echo  "after try block"
  ErrClass.raiseOverwrite_method
}


 
#//*********************************************************************
#// <<< [T_TryLv1ClearSub_func] >>> 
#//*********************************************************************
function  T_TryLv1ClearSub_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  while TryStart_func; do
    Try_Raise_func
    echo  "<ERROR msg=\"Do not come here\"/>"
  TryEnd1_func; done ;TryEnd2_func $?
  echo  "exit status = $g_ExitStatus"
  echo  "after try block"
  ErrClass.clear_method
}


 
#//*********************************************************************
#// <<< [T_TryLv2Sub_func] >>> 
#//*********************************************************************
function  T_TryLv2Sub_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  while TryStart_func; do
    T_TryLv2SubSub_func
    echo  "<ERROR msg=\"Do not come here Lv1\"/>"
  TryEnd1_func; done ;TryEnd2_func $?
  echo  "exit status = $g_ExitStatus"
  echo  "after try lv1 block"
  ErrClass.raiseOverwrite_method
}


function  T_TryLv2SubSub_func()
{
  while TryStart_func; do
    Try_Raise2_func
    echo  "<ERROR msg=\"Do not come here Lv2\"/>"
  TryEnd1_func; done ;TryEnd2_func $?
  echo  "exit status = $g_ExitStatus"
  echo  "after try lv2 block"
  ErrClass.raiseOverwrite_method
}


 
#//*********************************************************************
#// <<< [T_TryLv2ChangeSub_func] >>> 
#//*********************************************************************
function  T_TryLv2ChangeSub_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  while TryStart_func; do
    T_TryLv2ChangeSubSub_func
    echo  "<ERROR msg=\"Do not come here Lv1\"/>"
  TryEnd1_func; done ;TryEnd2_func $?
  echo  "exit status = $g_ExitStatus"
  echo  "after try lv1 block"
  ErrClass.raiseOverwrite_method
}


function  T_TryLv2ChangeSubSub_func()
{
  while TryStart_func; do
    Error_func  "1st Message"
    echo  "<ERROR msg=\"Do not come here Lv2\"/>"
  TryEnd1_func; done ;TryEnd2_func $?
  echo  "exit status = $g_ExitStatus"
  echo  "after try lv2 block"
  ErrClass.raiseOverwrite_method  "Overwritten Message"
}


 
#//*********************************************************************
#// <<< [T_TryLv1Proc1Sub_func] >>> 
#//*********************************************************************
function  T_TryLv1Proc1Sub_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  while TryStart_func; do
    ./T_Err_Sub.sh  --T_TryLv1Proc1SubSub_func
    echo  "<ERROR msg=\"Do not come here Lv1\"/>"
  TryEnd1_func; done ;TryEnd2_func $?
  echo  "exit status = $g_ExitStatus"
  echo  "after try lv1 block"
  ErrClass.raiseOverwrite_method
}


function  T_TryLv1Proc1SubSub_func()
{
  while TryStart_func; do
    Try_Raise2_func
    echo  "<ERROR msg=\"Do not come here Lv2\"/>"
  TryEnd1_func; done ;TryEnd2_func $?
  echo  "exit status = $g_ExitStatus"
  echo  "after try lv2 block"
  ErrClass.raiseOverwrite_method
}


 
#//*********************************************************************
#// <<< [T_NotTryLoopSub_func] >>> 
#//*********************************************************************
function  T_NotTryLoopSub_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  while true; do
    break
  done ; done_func $?  #// no error

  while true; do
    Error_func  "B"
    break
  done ; done_func $?  #// error
  echo  "<ERROR msg=\"Do not come here\"/>"
}


 
#//*********************************************************************
#// <<< [T_DoneInErrModeSub_func] >>> 
#//*********************************************************************
function  T_DoneInErrModeSub_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  while TryStart_func; do
    Error_func
  TryEnd1_func; done ;TryEnd2_func $?
    #// Finally

    T_DoneInErrModeSubSub_func
    echo  "after done_func"

  if [ "$g_ExitStatus" != "0" ]; then  ErrClass.raiseOverwrite_method  ;fi
}


function  T_DoneInErrModeSubSub_func()
{
  local  num
  for (( num = 0;  $num < 1;  num ++ )) ;do
    echo  $num
  done ; done_func $?  ################ Test Main : Don't error here
}


 
#//*********************************************************************
#// <<< [T_ErrorInErrModeSub_func] >>> 
#//*********************************************************************
function  T_ErrorInErrModeSub_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  while TryStart_func; do
    Error_func  "1st"
  TryEnd1_func; done ;TryEnd2_func $?
    #// Finally

    T_ErrorInErrModeSubSub_func
    echo  "after error in error"

  if [ "$g_ExitStatus" != "0" ]; then  ErrClass.raiseOverwrite_method  ;fi
}


function  T_ErrorInErrModeSubSub_func()
{
  Error_func  "<ERROR msg=\"2nd\" attr=\"1\"/>"  ################ Test Main : show error message
}


 
#//*********************************************************************
#// <<< [T_AnyTypeErrorSub_func] >>> 
#//*********************************************************************
function  T_AnyTypeErrorSub_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  local ret=$( NotDefined_func "a" )
  echo  "<ERROR msg=\"local と同時に関数呼び出しするとエラーが発生しても中断しません\"/>"
  echo  ""

  local ret=`NotDefined "a"`
  echo  "<ERROR msg=\"local と同時に関数呼び出しするとエラーが発生しても中断しません\"/>"
  echo  ""

  while TryStart_func; do
    T_AnyTypeErrorSubSub3_func  #// local 変数の初期化で、エラーが発生することを確認します。
  TryEnd1_func; done ;TryEnd2_func $?
  echo  "$g_Err_Desc"
  ErrClass.clear_method
  echo  ""
}


function  T_AnyTypeErrorSubSub3_func()
{
  local ret; ret=$( NotDefined_func "a" )  #// local 変数の初期化で、エラーが発生します。
  echo  "<ERROR msg=\"Do not come here\"/>"
}


 
#//*********************************************************************
#// <<< [T_WSSub_func] >>> 
#//*********************************************************************
function  T_WSSub_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  local  var="AB  DE"
  es  var

  local  var2=`echo -e "AB\tCD\nE"`
  es  var2
}


 
#//*********************************************************************
#// <<< [Try_Raise_func] >>> 
#//*********************************************************************
function  Try_Raise_func()
{
  echo  "Try_Raise_func (in)"
  Error_func  "in Try_Raise_func"
  echo  "Try_Raise_func (out)"
}


 
#//*********************************************************************
#// <<< [Try_Raise2_func] >>> 
#//*********************************************************************
function  Try_Raise2_func()
{
  echo  "Try_Raise2_func (in)"
  return_func  2
  echo  "Try_Raise2_func (out)"
}







 
#//--- start of bashlib include ------------------------------------------------------ 

#// <<< set up bashlib and call Main_func >>> 

#// bashlib is provided under 3-clause BSD license.
#// Copyright (C) 2011 Sofrware Design Gallery "Sage Plaisir 21" All Rights Reserved.

g_BashLibPath="scriptlib/bashlib_inc.sh"; g_Ver="1.0"
g_StartInPath=`pwd`; cd "`dirname "$BASH_SOURCE"`"; g_Arguments=( "$BASH_SOURCE" "$@" )
for (( i = 0; i < 20; i ++ ));do
  if [ -e "$g_BashLibPath" ];then break ;else  g_BashLibPath="../$g_BashLibPath" ;fi ;done
if [ "$i" == "20" ];then  echo "${g_BashLibPath##*../} が見つかりません。
bashlib $g_Ver をダウンロードして scriptlib フォルダーをコピーしてください。"; exit 1 ;fi
source  "$g_BashLibPath"  #// include
CallMain_func
#//--- end of bashlib include --------------------------------------------------------
 
