﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using CookComputing.XmlRpc;

namespace BTS.Backlog
{
    /// <summary>
    /// 課題の状態
    /// </summary>
    public class Status
    {
        /// <summary>
        /// チケット属性
        /// </summary>
        class AttributeNames
        {
            public const string KEY = "key";                    // 課題キー
            public const string STATUS_ID = "statusId";         // 状態ID
            public const string ASSIGNER_ID = "assignerId";     // 担当者ID
            public const string RESOLUTION_ID = "resolutionId"; // 完了理由ID
            public const string COMMENT = "comment";            // コメント
        }

        /// <summary>
        /// 属性
        /// </summary>
        public XmlRpcAttributes Attributes
        {
            get;
            private set;
        }

        /// <summary>
        /// 課題キー
        /// </summary>
        public string Key
        {
            get
            {
                return Attributes.Get<string>( AttributeNames.KEY );
            }

            set
            {
                Attributes.Set<string>( AttributeNames.KEY, value );
            }
        }

        /// <summary>
        /// 状態ID
        /// </summary>
        public int StatusId
        {
            get
            {
                return Attributes.Get<int>( AttributeNames.STATUS_ID );
            }

            set
            {
                Attributes.Set<int>( AttributeNames.STATUS_ID, value );
            }
        }

        /// <summary>
        /// 担当者ID
        /// </summary>
        public int AssignerId
        {
            get
            {
                return Attributes.Get<int>( AttributeNames.ASSIGNER_ID );
            }

            set
            {
                Attributes.Set<int>( AttributeNames.ASSIGNER_ID, value );
            }
        }

        /// <summary>
        /// 完了理由ID
        /// </summary>
        public int ResolutionId
        {
            get
            {
                return Attributes.Get<int>( AttributeNames.RESOLUTION_ID );
            }

            set
            {
                Attributes.Set<int>( AttributeNames.RESOLUTION_ID, value );
            }
        }

        /// <summary>
        /// コメント
        /// </summary>
        public string Comment
        {
            get
            {
                return Attributes.Get<string>( AttributeNames.COMMENT );
            }

            set
            {
                Attributes.Set<string>( AttributeNames.COMMENT, value );
            }
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public Status()
        {
            Attributes = new XmlRpcAttributes();
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="statusId"></param>
        public Status( int statusId )
            : this()
        {
            StatusId = statusId;
        }

        /// <summary>
        /// XmlRpcStruct に変換
        /// </summary>
        /// <returns></returns>
        public XmlRpcStruct ToXmlRpcStruct()
        {
            return Attributes.Value;
        }
    }
}
