﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;
using System.Reflection;
using System.Drawing;
using System.Windows.Forms;

namespace ImageConverter
{
    sealed public class ImageConverter : AxHost
    {
        private ImageConverter()
            : base(null)
        {
        }

        public static stdole.IPictureDisp Convert(Image img)
        {
            stdole.IPictureDisp pict = (stdole.IPictureDisp)AxHost.GetIPictureDispFromPicture(img);
            if (pict == null)
            {
                throw new Exception("error");
            }

            return pict;
        }

        public static stdole.IPictureDisp getImage(System.Drawing.Icon newIcon)
        {
            stdole.IPictureDisp image = null;
            try
            {
                ImageList newImageList = new ImageList();
                newImageList.Images.Add(newIcon);
                image = Convert(newImageList.Images[0]);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }

            return image;
        }

        public static stdole.IPictureDisp getImage(System.Drawing.Image newImage)
        {
            stdole.IPictureDisp image = null;
            try
            {
                ImageList newImageList = new ImageList();
                newImageList.Images.Add(newImage);
                image = Convert(newImageList.Images[0]);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }

            return image;
        }
    }
}
